/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.optimization.fixStack.LocalVariablesManager;
import org.jetbrains.kotlin.codegen.optimization.fixStack.SavedStackDescriptor;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J<\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J<\u0010\u0019\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010\u001a\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00062\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u001c\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u00112\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010\u001e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J<\u0010\u001f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "analyzeAndTransformBreakContinueGotos", "", "context", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "analyzeAndTransformSaveRestoreStack", "removeAlwaysFalseIfeqMarkers", "removeAlwaysTrueIfeqMarkers", "transform", "transformAfterInlineCallMarker", "actions", "", "Lkotlin/Function0;", "analyzer", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;", "inlineMarker", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "localVariablesManager", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/LocalVariablesManager;", "transformBeforeInlineCallMarker", "transformBreakContinueGotos", "fixStackContext", "transformRestoreStackMarker", "marker", "transformSaveRestoreStackMarkers", "transformSaveStackMarker", "kotlin-compiler"})
public final class FixStackMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(internalClassName, "internalClassName");
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        FixStackContext context = new FixStackContext(methodNode);
        if (!context.hasAnyMarkers()) {
            return;
        }
        if (!context.getConsistentInlineMarkers()) {
            InsnList insnList = methodNode.instructions;
            Intrinsics.checkExpressionValueIsNotNull(insnList, "methodNode.instructions");
            Sequence $receiver$iv = new InsnSequence(insnList);
            Iterator iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                AbstractInsnNode insnNode = (AbstractInsnNode)element$iv;
                if (!InlineCodegenUtilsKt.isInlineMarker(insnNode)) continue;
                methodNode.instructions.remove(insnNode);
            }
        }
        if (context.isAnalysisRequired()) {
            this.analyzeAndTransformBreakContinueGotos(context, internalClassName, methodNode);
            this.removeAlwaysFalseIfeqMarkers(context, methodNode);
            this.analyzeAndTransformSaveRestoreStack(context, internalClassName, methodNode);
        }
        this.removeAlwaysTrueIfeqMarkers(context, methodNode);
        this.removeAlwaysFalseIfeqMarkers(context, methodNode);
    }

    private final void analyzeAndTransformBreakContinueGotos(FixStackContext context, String internalClassName, MethodNode methodNode) {
        FixStackAnalyzer analyzer2 = new FixStackAnalyzer(internalClassName, methodNode, context, false, 8, null);
        analyzer2.analyze();
        methodNode.maxStack += analyzer2.getMaxExtraStackSize();
        ArrayList actions = new ArrayList();
        this.transformBreakContinueGotos(methodNode, context, actions, analyzer2);
        Iterable $receiver$iv = actions;
        for (Object element$iv : $receiver$iv) {
            Function0 it = (Function0)element$iv;
            it.invoke();
        }
    }

    private final void analyzeAndTransformSaveRestoreStack(FixStackContext context, String internalClassName, MethodNode methodNode) {
        FixStackAnalyzer analyzer2 = new FixStackAnalyzer(internalClassName, methodNode, context, false);
        analyzer2.analyze();
        ArrayList actions = new ArrayList();
        this.transformSaveRestoreStackMarkers(methodNode, context, actions, analyzer2);
        Iterable $receiver$iv = actions;
        for (Object element$iv : $receiver$iv) {
            Function0 it = (Function0)element$iv;
            it.invoke();
        }
    }

    private final void removeAlwaysFalseIfeqMarkers(FixStackContext context, MethodNode methodNode) {
        Iterable $receiver$iv = context.getFakeAlwaysFalseIfeqMarkers();
        for (Object element$iv : $receiver$iv) {
            AbstractInsnNode marker = (AbstractInsnNode)element$iv;
            StackTransformationUtilsKt.removeAlwaysFalseIfeq(methodNode, marker);
        }
        context.getFakeAlwaysFalseIfeqMarkers().clear();
    }

    private final void removeAlwaysTrueIfeqMarkers(FixStackContext context, MethodNode methodNode) {
        Iterable $receiver$iv = context.getFakeAlwaysTrueIfeqMarkers();
        for (Object element$iv : $receiver$iv) {
            AbstractInsnNode marker = (AbstractInsnNode)element$iv;
            StackTransformationUtilsKt.replaceAlwaysTrueIfeqWithGoto(methodNode, marker);
        }
        context.getFakeAlwaysTrueIfeqMarkers().clear();
    }

    private final void transformBreakContinueGotos(MethodNode methodNode, FixStackContext fixStackContext, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2) {
        Iterable $receiver$iv = fixStackContext.getBreakContinueGotoNodes();
        for (Object element$iv : $receiver$iv) {
            JumpInsnNode gotoNode = (JumpInsnNode)element$iv;
            int gotoIndex = methodNode.instructions.indexOf(gotoNode);
            int labelIndex = methodNode.instructions.indexOf(gotoNode.label);
            int actualStackSize = analyzer2.getActualStackSize(gotoNode);
            LabelNode labelNode = gotoNode.label;
            Intrinsics.checkExpressionValueIsNotNull(labelNode, "gotoNode.label");
            int expectedStackSize = analyzer2.getExpectedStackSize(labelNode);
            if (actualStackSize >= 0 && expectedStackSize >= 0) {
                List<BasicValue> actualStackContent;
                boolean bl;
                boolean bl2 = bl = expectedStackSize <= actualStackSize;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Label at " + labelIndex + ", jump at " + gotoIndex + ": stack underflow: " + expectedStackSize + " > " + actualStackSize;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (analyzer2.getActualStack(gotoNode) == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Jump at " + gotoIndex + " should be alive")));
                }
                actions.add(new Function0<Unit>(gotoNode, expectedStackSize, actualStackContent, methodNode, analyzer2, actions){
                    final /* synthetic */ JumpInsnNode $gotoNode;
                    final /* synthetic */ int $expectedStackSize;
                    final /* synthetic */ List $actualStackContent;
                    final /* synthetic */ MethodNode $methodNode$inlined;
                    final /* synthetic */ FixStackAnalyzer $analyzer$inlined;
                    final /* synthetic */ List $actions$inlined;
                    {
                        this.$gotoNode = jumpInsnNode;
                        this.$expectedStackSize = n;
                        this.$actualStackContent = list2;
                        this.$methodNode$inlined = methodNode;
                        this.$analyzer$inlined = fixStackAnalyzer;
                        this.$actions$inlined = list3;
                        super(0);
                    }

                    public final void invoke() {
                        AbstractInsnNode abstractInsnNode = this.$gotoNode.getPrevious();
                        Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "gotoNode.previous");
                        StackTransformationUtilsKt.replaceMarkerWithPops(this.$methodNode$inlined, abstractInsnNode, this.$expectedStackSize, this.$actualStackContent);
                    }
                });
                continue;
            }
            if (actualStackSize >= 0 && expectedStackSize < 0) {
                throw (Throwable)((Object)new AssertionError((Object)("Live jump " + gotoIndex + " to dead label " + labelIndex)));
            }
            AbstractInsnNode marker = gotoNode.getPrevious();
            actions.add(new Function0<Unit>(marker, methodNode, analyzer2, actions){
                final /* synthetic */ AbstractInsnNode $marker;
                final /* synthetic */ MethodNode $methodNode$inlined;
                final /* synthetic */ FixStackAnalyzer $analyzer$inlined;
                final /* synthetic */ List $actions$inlined;
                {
                    this.$marker = abstractInsnNode;
                    this.$methodNode$inlined = methodNode;
                    this.$analyzer$inlined = fixStackAnalyzer;
                    this.$actions$inlined = list2;
                    super(0);
                }

                public final void invoke() {
                    this.$methodNode$inlined.instructions.remove(this.$marker);
                }
            });
        }
    }

    private final void transformSaveRestoreStackMarkers(MethodNode methodNode, FixStackContext context, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2) {
        LocalVariablesManager localVariablesManager = new LocalVariablesManager(context, methodNode);
        InsnList insnList = methodNode.instructions;
        Intrinsics.checkExpressionValueIsNotNull(insnList, "methodNode.instructions");
        Sequence $receiver$iv = new InsnSequence(insnList);
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            AbstractInsnNode marker = (AbstractInsnNode)element$iv;
            PseudoInsn pseudoInsn = PseudoInsnsKt.parsePseudoInsnOrNull(marker);
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.SAVE_STACK_BEFORE_TRY)) {
                this.transformSaveStackMarker(methodNode, actions, analyzer2, marker, localVariablesManager);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.RESTORE_STACK_IN_TRY_CATCH)) {
                this.transformRestoreStackMarker(methodNode, actions, marker, localVariablesManager);
                continue;
            }
            if (InlineCodegenUtilsKt.isBeforeInlineMarker(marker)) {
                this.transformBeforeInlineCallMarker(methodNode, actions, analyzer2, marker, localVariablesManager);
                continue;
            }
            if (!InlineCodegenUtilsKt.isAfterInlineMarker(marker)) continue;
            this.transformAfterInlineCallMarker(methodNode, actions, analyzer2, marker, localVariablesManager);
        }
    }

    private final void transformSaveStackMarker(MethodNode methodNode, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2, AbstractInsnNode marker, LocalVariablesManager localVariablesManager) {
        List<BasicValue> savedStackValues = analyzer2.getStackToSpill(marker);
        if (savedStackValues != null) {
            SavedStackDescriptor savedStackDescriptor = localVariablesManager.allocateVariablesForSaveStackMarker(marker, savedStackValues);
            actions.add(new Function0<Unit>(methodNode, marker, savedStackDescriptor){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $marker;
                final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;

                public final void invoke() {
                    StackTransformationUtilsKt.saveStack(this.$methodNode, this.$marker, this.$savedStackDescriptor);
                }
                {
                    this.$methodNode = methodNode;
                    this.$marker = abstractInsnNode;
                    this.$savedStackDescriptor = savedStackDescriptor;
                    super(0);
                }
            });
        } else {
            localVariablesManager.allocateVariablesForSaveStackMarker(marker, CollectionsKt.emptyList());
            actions.add(new Function0<Unit>(methodNode, marker){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $marker;

                public final void invoke() {
                    this.$methodNode.instructions.remove(this.$marker);
                }
                {
                    this.$methodNode = methodNode;
                    this.$marker = abstractInsnNode;
                    super(0);
                }
            });
        }
    }

    private final void transformRestoreStackMarker(MethodNode methodNode, List<Function0<Unit>> actions, AbstractInsnNode marker, LocalVariablesManager localVariablesManager) {
        SavedStackDescriptor savedStackDescriptor = localVariablesManager.getSavedStackDescriptor(marker);
        actions.add(new Function0<Unit>(methodNode, marker, savedStackDescriptor){
            final /* synthetic */ MethodNode $methodNode;
            final /* synthetic */ AbstractInsnNode $marker;
            final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;

            public final void invoke() {
                StackTransformationUtilsKt.restoreStack(this.$methodNode, this.$marker, this.$savedStackDescriptor);
            }
            {
                this.$methodNode = methodNode;
                this.$marker = abstractInsnNode;
                this.$savedStackDescriptor = savedStackDescriptor;
                super(0);
            }
        });
        localVariablesManager.markRestoreStackMarkerEmitted(marker);
    }

    private final void transformAfterInlineCallMarker(MethodNode methodNode, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2, AbstractInsnNode inlineMarker, LocalVariablesManager localVariablesManager) {
        SavedStackDescriptor savedStackDescriptor = localVariablesManager.getBeforeInlineDescriptor(inlineMarker);
        List<BasicValue> stackContentAfterInline = analyzer2.getActualStack(inlineMarker);
        if (stackContentAfterInline != null && savedStackDescriptor.isNotEmpty()) {
            switch (stackContentAfterInline.size()) {
                case 1: {
                    BasicValue returnValue = CollectionsKt.last(stackContentAfterInline);
                    int returnValueLocalVarIndex = localVariablesManager.createReturnValueVariable(returnValue);
                    actions.add(new Function0<Unit>(methodNode, inlineMarker, savedStackDescriptor, returnValue, returnValueLocalVarIndex){
                        final /* synthetic */ MethodNode $methodNode;
                        final /* synthetic */ AbstractInsnNode $inlineMarker;
                        final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;
                        final /* synthetic */ BasicValue $returnValue;
                        final /* synthetic */ int $returnValueLocalVarIndex;

                        public final void invoke() {
                            StackTransformationUtilsKt.restoreStackWithReturnValue(this.$methodNode, this.$inlineMarker, this.$savedStackDescriptor, this.$returnValue, this.$returnValueLocalVarIndex);
                        }
                        {
                            this.$methodNode = methodNode;
                            this.$inlineMarker = abstractInsnNode;
                            this.$savedStackDescriptor = savedStackDescriptor;
                            this.$returnValue = basicValue;
                            this.$returnValueLocalVarIndex = n;
                            super(0);
                        }
                    });
                    break;
                }
                case 0: {
                    actions.add(new Function0<Unit>(methodNode, inlineMarker, savedStackDescriptor){
                        final /* synthetic */ MethodNode $methodNode;
                        final /* synthetic */ AbstractInsnNode $inlineMarker;
                        final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;

                        public final void invoke() {
                            StackTransformationUtilsKt.restoreStack(this.$methodNode, this.$inlineMarker, this.$savedStackDescriptor);
                        }
                        {
                            this.$methodNode = methodNode;
                            this.$inlineMarker = abstractInsnNode;
                            this.$savedStackDescriptor = savedStackDescriptor;
                            super(0);
                        }
                    });
                    break;
                }
                default: {
                    throw (Throwable)((Object)new AssertionError((Object)"Inline method should not leave more than 1 value on stack"));
                }
            }
        } else {
            actions.add(new Function0<Unit>(methodNode, inlineMarker){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $inlineMarker;

                public final void invoke() {
                    this.$methodNode.instructions.remove(this.$inlineMarker);
                }
                {
                    this.$methodNode = methodNode;
                    this.$inlineMarker = abstractInsnNode;
                    super(0);
                }
            });
        }
        localVariablesManager.markAfterInlineMarkerEmitted(inlineMarker);
    }

    private final void transformBeforeInlineCallMarker(MethodNode methodNode, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2, AbstractInsnNode inlineMarker, LocalVariablesManager localVariablesManager) {
        List<BasicValue> savedStackValues = analyzer2.getStackToSpill(inlineMarker);
        if (savedStackValues != null) {
            SavedStackDescriptor savedStackDescriptor = localVariablesManager.allocateVariablesForBeforeInlineMarker(inlineMarker, savedStackValues);
            actions.add(new Function0<Unit>(methodNode, inlineMarker, savedStackDescriptor){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $inlineMarker;
                final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;

                public final void invoke() {
                    StackTransformationUtilsKt.saveStack(this.$methodNode, this.$inlineMarker, this.$savedStackDescriptor);
                }
                {
                    this.$methodNode = methodNode;
                    this.$inlineMarker = abstractInsnNode;
                    this.$savedStackDescriptor = savedStackDescriptor;
                    super(0);
                }
            });
        } else {
            localVariablesManager.allocateVariablesForBeforeInlineMarker(inlineMarker, CollectionsKt.emptyList());
            actions.add(new Function0<Unit>(methodNode, inlineMarker){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $inlineMarker;

                public final void invoke() {
                    this.$methodNode.instructions.remove(this.$inlineMarker);
                }
                {
                    this.$methodNode = methodNode;
                    this.$inlineMarker = abstractInsnNode;
                    super(0);
                }
            });
        }
    }
}

