/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsReifiedNativeChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "kotlin-compiler"})
public final class JsReifiedNativeChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtTypeArgumentList ktTypeArgumentList = resolvedCall2.getCall().getTypeArgumentList();
        List<KtTypeProjection> typeArgumentList = ktTypeArgumentList != null ? ktTypeArgumentList.getArguments() : null;
        Map<TypeParameterDescriptor, KotlinType> map2 = resolvedCall2.getTypeArguments();
        Iterator<Map.Entry<TypeParameterDescriptor, KotlinType>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            ClassifierDescriptor typeArgDescriptor;
            Map.Entry<TypeParameterDescriptor, KotlinType> entry;
            Map.Entry<TypeParameterDescriptor, KotlinType> entry2 = entry = iterator2.next();
            TypeParameterDescriptor typeParam = entry2.getKey();
            entry2 = entry;
            KotlinType typeArg = entry2.getValue();
            if (!typeParam.isReified() || (typeArgDescriptor = typeArg.getConstructor().getDeclarationDescriptor()) == null || !AnnotationsUtils.isNativeInterface(typeArgDescriptor)) continue;
            KtElement typeArgumentPsi = typeArgumentList != null ? (KtElement)typeArgumentList.get(typeParam.getIndex()).getTypeReference() : resolvedCall2.getCall().getCallElement();
            BindingTrace bindingTrace = context.getTrace();
            KtElement ktElement = typeArgumentPsi;
            if (ktElement == null) {
                Intrinsics.throwNpe();
            }
            bindingTrace.report(ErrorsJs.NATIVE_INTERFACE_AS_REIFIED_TYPE_ARGUMENT.on(ktElement, typeArg));
        }
    }
}

