#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: vector-builder
version: 0.3.4
id: vector-builder-0.3.4-4kKrTxdVVTGKSNxi9Douf7
key: vector-builder-0.3.4-4kKrTxdVVTGKSNxi9Douf7
license: MIT
copyright: (c) 2016, Nikita Volkov
maintainer: Nikita Volkov <nikita.y.volkov@mail.ru>
homepage: https://github.com/nikita-volkov/vector-builder
synopsis: Vector builder
description:
    An API for efficient and convenient construction of vectors.
    It provides the composable `Builder` abstraction, which has instances of the `Monoid` and `Semigroup` classes.
    .
    [Usage]
    .
    First you use the `Builder` abstraction to specify the structure of the vector.
    Then you execute the builder to actually produce the vector.
    .
    [Example]
    .
    The following code shows how you can efficiently concatenate different datastructures into a single immutable vector:
    .
    >
    >import qualified Data.Vector as A
    >import qualified VectorBuilder.Builder as B
    >import qualified VectorBuilder.Vector as C
    >
    >
    >myVector :: A.Vector a -> [a] -> a -> A.Vector a
    >myVector vector list element =
    >  C.build builder
    >  where
    >    builder =
    >      B.vector vector <>
    >      foldMap B.singleton list <>
    >      B.singleton element
category: Vector
author: Nikita Volkov <nikita.y.volkov@mail.ru>
exposed: True
indefinite: False
exposed-modules:
    VectorBuilder.Builder VectorBuilder.MVector VectorBuilder.MonadPlus
    VectorBuilder.Vector
hidden-modules: VectorBuilder.Prelude VectorBuilder.Core.Update
                VectorBuilder.Core.Builder
abi: a361f485fedf3213c5fc2cf902aee62b
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/vector-builder-0.3.4
library-dirs: /usr/lib/ghc-8.2.1/site-local/vector-builder-0.3.4
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/vector-builder-0.3.4
hs-libraries: HSvector-builder-0.3.4-4kKrTxdVVTGKSNxi9Douf7
depends:
    vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi
    semigroups-0.18.3-6KPIVJcHqOOBHjBl8WA5LP
    base-prelude-1.2.0.1-GfnST6wywTP6rNqw8BISGT base-4.10.0.0
abi-depends: vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi=12d01284f86dd305f0b2cab827808cc2
             semigroups-0.18.3-6KPIVJcHqOOBHjBl8WA5LP=7bc502c1773a3f628e3db58cb706740b
             base-prelude-1.2.0.1-GfnST6wywTP6rNqw8BISGT=be7241d647b311157e69b90e57b06d24
             base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
haddock-interfaces: /usr/share/doc/haskell-vector-builder/html/vector-builder.haddock
haddock-html: /usr/share/doc/haskell-vector-builder/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

