/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.navigate;

import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolNavigatorInterface;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.thread.JmolThread;
import org.jmol.util.Escape;
import org.jmol.util.GData;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public final class Navigator
extends JmolThread
implements JmolNavigatorInterface {
    private TransformManager tm;
    private int nHits;
    private int multiplier = 1;
    private boolean isPathGuide;
    private P3[] points;
    private P3[] pointGuides;
    private int frameTimeMillis;
    private float floatSecondsTotal;
    private V3 axis;
    private float degrees;
    private P3 center;
    private float depthPercent;
    private float xTrans;
    private float yTrans;
    private float depthStart;
    private float depthDelta;
    private float xTransStart;
    private float xTransDelta;
    private float yTransStart;
    private float yTransDelta;
    private float degreeStep;
    private P3 centerStart;
    private int totalSteps;
    private V3 aaStepCenter;
    private boolean isNavTo;
    private int iStep;
    private Lst<Object[]> navigationList;
    private int iList;
    private boolean isStep;

    @Override
    public void set(TransformManager tm, Viewer vwr) {
        this.tm = tm;
        this.setViewer(vwr, "navigator");
    }

    @Override
    public void navigateList(JmolScriptEvaluator eval, Lst<Object[]> list) {
        this.setEval(eval);
        this.navigationList = list;
        this.iList = 0;
        this.isStep = false;
        this.run();
    }

    private void nextList(int i, P3 ptTemp) {
        Object[] o = (Object[])this.navigationList.get(i);
        float seconds = ((Float)o[1]).floatValue();
        int tok = (Integer)o[0];
        switch (tok) {
            case 134217751: {
                P3 pt = (P3)o[2];
                if (seconds == 0.0f) {
                    this.tm.setNavigatePt(pt);
                    this.vwr.moveUpdate(0.0f);
                    return;
                }
                this.navigateTo(seconds, null, Float.NaN, pt, Float.NaN, Float.NaN, Float.NaN);
                break;
            }
            case 0x40000104: {
                P3[] path = (P3[])o[2];
                float[] theta = (float[])o[3];
                int indexStart = ((int[])o[4])[0];
                int indexEnd = ((int[])o[4])[1];
                this.navigate(seconds, null, path, theta, indexStart, indexEnd);
                break;
            }
            case 1112152078: {
                P3[][] pathGuide = (P3[][])o[2];
                this.navigate(seconds, pathGuide, null, null, 0, Integer.MAX_VALUE);
                break;
            }
            case 528432: {
                V3 rotAxis = (V3)o[2];
                float degrees = ((Float)o[3]).floatValue();
                if (seconds == 0.0f) {
                    this.navigateAxis(rotAxis, degrees);
                    this.vwr.moveUpdate(0.0f);
                    return;
                }
                this.navigateTo(seconds, rotAxis, degrees, null, Float.NaN, Float.NaN, Float.NaN);
                break;
            }
            case 4160: 
            case 268435634: {
                if (tok == 4160) {
                    this.tm.transformPt3f((P3)o[2], ptTemp);
                } else {
                    ptTemp.x = ((Float)o[2]).floatValue();
                    ptTemp.y = ((Float)o[3]).floatValue();
                    this.setNavPercent(ptTemp);
                }
                if (seconds == 0.0f) {
                    this.navTranslatePercentOrTo(-1.0f, ptTemp.x, ptTemp.y);
                    this.vwr.moveUpdate(0.0f);
                    return;
                }
                this.navigateTo(seconds, null, Float.NaN, null, Float.NaN, ptTemp.x, ptTemp.y);
                break;
            }
            case 554176526: {
                float percent = ((Float)o[2]).floatValue();
                this.navigateTo(seconds, null, Float.NaN, null, percent, Float.NaN, Float.NaN);
            }
        }
    }

    private void setNavPercent(P3 pt1) {
        this.tm.transformPt3f(this.tm.navigationCenter, this.tm.navigationOffset);
        float x = pt1.x;
        float y = pt1.y;
        if (!Float.isNaN(x)) {
            x = (float)this.tm.width * x / 100.0f + (Float.isNaN(y) ? this.tm.navigationOffset.x : (float)this.tm.width / 2.0f);
        }
        if (!Float.isNaN(y)) {
            y = (float)this.tm.height * y / 100.0f + (Float.isNaN(x) ? this.tm.navigationOffset.y : this.tm.getNavPtHeight());
        }
        pt1.x = x;
        pt1.y = y;
    }

    @Override
    public void navigateTo(float seconds, V3 axis, float degrees, P3 center, float depthPercent, float xTrans, float yTrans) {
        this.floatSecondsTotal = seconds;
        this.axis = axis;
        this.degrees = degrees;
        this.center = center;
        this.depthPercent = depthPercent;
        this.xTrans = xTrans;
        this.yTrans = yTrans;
        this.setupNavTo();
        this.isStep = true;
        this.run();
    }

    @Override
    public void navigate(float seconds, P3[][] pathGuide, P3[] path, float[] theta, int indexStart, int indexEnd) {
        this.floatSecondsTotal = seconds;
        this.setupNav(seconds, pathGuide, path, indexStart, indexEnd);
        this.isStep = true;
        this.run();
    }

    @Override
    protected void run1(int mode) throws InterruptedException {
        P3 ptTemp = new P3();
        while (this.isJS || this.vwr.isScriptExecuting()) {
            switch (mode) {
                case -1: {
                    if (this.isStep) {
                        this.targetTime = this.startTime;
                        this.iStep = 0;
                        mode = this.totalSteps <= 0 && this.isNavTo ? 1 : 0;
                        break;
                    }
                    mode = 2;
                    break;
                }
                case 2: {
                    this.nextList(this.iList, ptTemp);
                    return;
                }
                case 0: {
                    if (this.stopped || this.iStep >= this.totalSteps) {
                        mode = -2;
                        break;
                    }
                    this.doNavStep(this.iStep++);
                    this.vwr.requestRepaintAndWait("navigatorThread");
                    int sleepTime = (int)(this.targetTime - System.currentTimeMillis());
                    if (!this.runSleep(sleepTime, 0)) {
                        return;
                    }
                    mode = 0;
                    break;
                }
                case 1: {
                    if (!this.runSleep((int)(this.floatSecondsTotal * 1000.0f) - 30, -2)) {
                        return;
                    }
                    mode = -2;
                    break;
                }
                case -2: {
                    if (this.isNavTo) {
                        if (!Float.isNaN(this.xTrans) || !Float.isNaN(this.yTrans)) {
                            this.navTranslatePercentOrTo(-1.0f, this.xTrans, this.yTrans);
                        }
                        if (!Float.isNaN(this.depthPercent)) {
                            this.setNavigationDepthPercent(this.depthPercent);
                        }
                    }
                    this.vwr.setInMotion(false);
                    this.vwr.moveUpdate(this.floatSecondsTotal);
                    if (!this.stopped && ++this.iList < this.navigationList.size()) {
                        mode = 2;
                        break;
                    }
                    this.resumeEval();
                    return;
                }
            }
        }
    }

    private void doNavStep(int iStep) {
        if (!this.isNavTo) {
            this.tm.setNavigatePt(this.points[iStep]);
            if (this.isPathGuide) {
                this.alignZX(this.points[iStep], this.points[iStep + 1], this.pointGuides[iStep]);
            }
            this.targetTime += (long)this.frameTimeMillis;
            return;
        }
        this.tm.navigating = true;
        float fStep = ((float)iStep + 1.0f) / (float)this.totalSteps;
        if (!Float.isNaN(this.degrees)) {
            this.tm.navigateAxis(this.axis, this.degreeStep);
        }
        if (this.center != null) {
            this.centerStart.add(this.aaStepCenter);
            this.tm.setNavigatePt(this.centerStart);
        }
        if (!Float.isNaN(this.xTrans) || !Float.isNaN(this.yTrans)) {
            float x = Float.NaN;
            float y = Float.NaN;
            if (!Float.isNaN(this.xTrans)) {
                x = this.xTransStart + this.xTransDelta * fStep;
            }
            if (!Float.isNaN(this.yTrans)) {
                y = this.yTransStart + this.yTransDelta * fStep;
            }
            this.navTranslatePercentOrTo(-1.0f, x, y);
        }
        if (!Float.isNaN(this.depthPercent)) {
            this.setNavigationDepthPercent(this.depthStart + this.depthDelta * fStep);
        }
        this.tm.navigating = false;
        this.targetTime += (long)this.frameTimeMillis;
    }

    private void setupNavTo() {
        this.isNavTo = true;
        if (!this.vwr.haveDisplay) {
            this.floatSecondsTotal = 0.0f;
        }
        int fps = 30;
        this.totalSteps = (int)(this.floatSecondsTotal * (float)fps) - 1;
        if (this.floatSecondsTotal > 0.0f) {
            this.vwr.setInMotion(true);
        }
        if (this.degrees == 0.0f) {
            this.degrees = Float.NaN;
        }
        if (this.totalSteps > 0) {
            this.frameTimeMillis = 1000 / fps;
            this.depthStart = this.tm.navigationDepthPercent;
            this.depthDelta = this.depthPercent - this.depthStart;
            this.xTransStart = this.tm.navigationOffset.x;
            this.xTransDelta = this.xTrans - this.xTransStart;
            this.yTransStart = this.tm.navigationOffset.y;
            this.yTransDelta = this.yTrans - this.yTransStart;
            this.degreeStep = this.degrees / (float)(this.totalSteps + 1);
            this.aaStepCenter = V3.newVsub(this.center == null ? this.tm.navigationCenter : this.center, this.tm.navigationCenter);
            this.aaStepCenter.scale(1.0f / (float)(this.totalSteps + 1));
            this.centerStart = P3.newP(this.tm.navigationCenter);
        }
    }

    private void setupNav(float seconds, P3[][] pathGuide, P3[] path, int indexStart, int indexEnd) {
        int nSegments;
        this.isNavTo = false;
        if (seconds <= 0.0f) {
            seconds = 2.0f;
        }
        if (!this.vwr.haveDisplay) {
            seconds = 0.0f;
        }
        this.isPathGuide = pathGuide != null;
        if (!this.isPathGuide) {
            for (nSegments = Math.min((this.isPathGuide ? pathGuide.length : path.length) - 1, indexEnd); nSegments > 0 && path[nSegments] == null; --nSegments) {
            }
        }
        if ((nSegments -= indexStart) < 1) {
            return;
        }
        int nPer = (int)Math.floor(10.0f * seconds);
        int nSteps = nSegments * nPer + 1;
        this.points = new P3[nSteps + 2];
        this.pointGuides = new P3[this.isPathGuide ? nSteps + 2 : 0];
        for (int i = 0; i < nSegments; ++i) {
            int iPrev = Math.max(i - 1, 0) + indexStart;
            int pt = i + indexStart;
            int iNext = Math.min(i + 1, nSegments) + indexStart;
            int iNext2 = Math.min(i + 2, nSegments) + indexStart;
            int iNext3 = Math.min(i + 3, nSegments) + indexStart;
            if (this.isPathGuide) {
                GData.getHermiteList(7, pathGuide[iPrev][0], pathGuide[pt][0], pathGuide[iNext][0], pathGuide[iNext2][0], pathGuide[iNext3][0], this.points, i * nPer, nPer + 1, true);
                GData.getHermiteList(7, pathGuide[iPrev][1], pathGuide[pt][1], pathGuide[iNext][1], pathGuide[iNext2][1], pathGuide[iNext3][1], this.pointGuides, i * nPer, nPer + 1, true);
                continue;
            }
            GData.getHermiteList(7, path[iPrev], path[pt], path[iNext], path[iNext2], path[iNext3], this.points, i * nPer, nPer + 1, true);
        }
        this.vwr.setInMotion(true);
        this.frameTimeMillis = (int)(1000.0f / this.tm.navFps);
        this.totalSteps = nSteps;
    }

    private void alignZX(P3 pt0, P3 pt1, P3 ptVectorWing) {
        P3 pt0s = new P3();
        P3 pt1s = new P3();
        M3 m = this.tm.matrixRotate;
        m.rotate2(pt0, pt0s);
        m.rotate2(pt1, pt1s);
        V3 vPath = V3.newVsub(pt0s, pt1s);
        V3 v = V3.new3(0.0f, 0.0f, 1.0f);
        float angle = vPath.angle(v);
        v.cross(vPath, v);
        if (angle != 0.0f) {
            this.tm.navigateAxis(v, (float)((double)angle * 57.29577951308232));
        }
        m.rotate2(pt0, pt0s);
        P3 pt2 = P3.newP(ptVectorWing);
        pt2.add(pt0);
        P3 pt2s = new P3();
        m.rotate2(pt2, pt2s);
        vPath.sub2(pt2s, pt0s);
        vPath.z = 0.0f;
        v.set(-1.0f, 0.0f, 0.0f);
        angle = vPath.angle(v);
        if (vPath.y < 0.0f) {
            angle = -angle;
        }
        v.set(0.0f, 0.0f, 1.0f);
        if (angle != 0.0f) {
            this.tm.navigateAxis(v, (float)((double)angle * 57.29577951308232));
        }
        m.rotate2(pt0, pt0s);
        m.rotate2(pt1, pt1s);
        m.rotate2(ptVectorWing, pt2s);
    }

    @Override
    public void zoomByFactor(float factor, int x, int y) {
        float navZ = this.tm.navZ;
        if (navZ > 0.0f) {
            if ((navZ /= factor) < 5.0f) {
                navZ = -5.0f;
            } else if (navZ > 200.0f) {
                navZ = 200.0f;
            }
        } else if (navZ == 0.0f) {
            navZ = factor < 1.0f ? 5 : -5;
        } else if ((navZ *= factor) > -5.0f) {
            navZ = 5.0f;
        } else if (navZ < -200.0f) {
            navZ = -200.0f;
        }
        this.tm.navZ = navZ;
    }

    @Override
    public void calcNavigationPoint() {
        this.calcNavigationDepthPercent();
        if (!this.tm.navigating && this.tm.navMode != 1) {
            this.tm.navMode = this.tm.navigationDepthPercent < 100.0f && this.tm.navigationDepthPercent > 0.0f && !Float.isNaN(this.tm.previousX) && this.tm.previousX == this.tm.fixedTranslation.x && this.tm.previousY == this.tm.fixedTranslation.y && this.tm.navMode != -1 ? 3 : 0;
        }
        switch (this.tm.navMode) {
            case 1: {
                this.tm.navigationOffset.set((float)this.tm.width / 2.0f, this.tm.getNavPtHeight(), this.tm.referencePlaneOffset);
                this.tm.zoomFactor = Float.MAX_VALUE;
                this.tm.calcCameraFactors();
                this.tm.calcTransformMatrix();
                this.newNavigationCenter();
                break;
            }
            case -1: 
            case 0: {
                this.tm.fixedRotationOffset.setT(this.tm.fixedTranslation);
                this.newNavigationCenter();
                break;
            }
            case 2: {
                this.newNavigationCenter();
                break;
            }
            case -2: 
            case 3: {
                T3 pt1 = this.tm.matrixTransform.rotTrans2(this.tm.navigationCenter, new P3());
                float z = pt1.z;
                this.tm.matrixTransform.rotTrans2(this.tm.fixedRotationCenter, pt1);
                this.tm.modelCenterOffset = this.tm.referencePlaneOffset + (pt1.z - z);
                this.tm.calcCameraFactors();
                this.tm.calcTransformMatrix();
                break;
            }
            case 4: {
                this.tm.navigationOffset.z = this.tm.referencePlaneOffset;
                this.tm.unTransformPoint(this.tm.navigationOffset, this.tm.navigationCenter);
            }
        }
        this.tm.matrixTransform.rotTrans2(this.tm.navigationCenter, this.tm.navigationShiftXY);
        if (this.vwr.getBoolean(603979890)) {
            P3 pt = P3.newP(this.tm.navigationCenter);
            this.vwr.toUnitCell(this.tm.navigationCenter, null);
            if ((double)pt.distance(this.tm.navigationCenter) > 0.01) {
                this.tm.matrixTransform.rotTrans2(this.tm.navigationCenter, pt);
                float dz = this.tm.navigationShiftXY.z - pt.z;
                this.tm.modelCenterOffset += dz;
                this.tm.calcCameraFactors();
                this.tm.calcTransformMatrix();
                this.tm.matrixTransform.rotTrans2(this.tm.navigationCenter, this.tm.navigationShiftXY);
            }
        }
        this.tm.transformPt3f(this.tm.fixedRotationCenter, this.tm.fixedTranslation);
        this.tm.fixedRotationOffset.setT(this.tm.fixedTranslation);
        this.tm.previousX = this.tm.fixedTranslation.x;
        this.tm.previousY = this.tm.fixedTranslation.y;
        this.tm.transformPt3f(this.tm.navigationCenter, this.tm.navigationOffset);
        this.tm.navigationOffset.z = this.tm.referencePlaneOffset;
        this.tm.navMode = 0;
        this.calcNavSlabAndDepthValues();
    }

    private void calcNavSlabAndDepthValues() {
        this.tm.calcSlabAndDepthValues();
        if (this.tm.slabEnabled) {
            this.tm.slabValue = (this.tm.mode == 1 ? -100 : 0) + (int)(this.tm.referencePlaneOffset - this.tm.navigationSlabOffset);
            if (this.tm.zSlabPercentSetting == this.tm.zDepthPercentSetting) {
                this.tm.zSlabValue = this.tm.slabValue;
            }
        }
    }

    private void newNavigationCenter() {
        this.tm.mode = this.tm.defaultMode;
        P3 pt = new P3();
        this.tm.transformPt3f(this.tm.fixedRotationCenter, pt);
        pt.x -= this.tm.navigationOffset.x;
        pt.y -= this.tm.navigationOffset.y;
        float f = -this.tm.getPerspectiveFactor(pt.z);
        pt.x /= f;
        pt.y /= f;
        pt.z = this.tm.referencePlaneOffset;
        this.tm.matrixTransformInv.rotTrans2(pt, this.tm.navigationCenter);
        this.tm.mode = 1;
    }

    @Override
    public void setNavigationOffsetRelative() {
        if (this.tm.navigationDepthPercent < 0.0f && this.tm.navZ > 0.0f || this.tm.navigationDepthPercent > 100.0f && this.tm.navZ < 0.0f) {
            this.tm.navZ = 0.0f;
        }
        this.tm.rotateXRadians(-3.4906584E-4f * this.tm.navY, null);
        this.tm.rotateYRadians(3.4906584E-4f * this.tm.navX, null);
        P3 pt = this.tm.navigationCenter;
        P3 pts = new P3();
        this.tm.transformPt3f(pt, pts);
        pts.z += this.tm.navZ;
        this.tm.unTransformPoint(pts, pt);
        this.tm.setNavigatePt(pt);
    }

    @Override
    public void navigateKey(int keyCode, int modifiers) {
        String key = null;
        float value = 0.0f;
        if (this.tm.mode != 1) {
            return;
        }
        if (keyCode == 0) {
            this.nHits = 0;
            this.multiplier = 1;
            if (!this.tm.navigating) {
                return;
            }
            this.tm.navigating = false;
            return;
        }
        ++this.nHits;
        if (this.nHits % 10 == 0) {
            this.multiplier *= this.multiplier == 4 ? 1 : 2;
        }
        boolean isShiftKey = (modifiers & 1) > 0;
        boolean isAltKey = (modifiers & 8) > 0;
        boolean isCtrlKey = (modifiers & 2) > 0;
        float speed = this.vwr.getFloat(570425374) * (float)(isCtrlKey ? 10 : 1);
        switch (keyCode) {
            case 46: {
                this.tm.navZ = 0.0f;
                this.tm.navY = 0.0f;
                this.tm.navX = 0.0f;
                this.tm.homePosition(true);
                return;
            }
            case 32: {
                if (!this.tm.navOn) {
                    return;
                }
                this.tm.navZ = 0.0f;
                this.tm.navY = 0.0f;
                this.tm.navX = 0.0f;
                return;
            }
            case 38: {
                if (this.tm.navOn) {
                    if (isAltKey) {
                        this.tm.navY += (float)this.multiplier;
                        value = this.tm.navY;
                        key = "navY";
                        break;
                    }
                    this.tm.navZ += (float)this.multiplier;
                    value = this.tm.navZ;
                    key = "navZ";
                    break;
                }
                if (isShiftKey) {
                    this.tm.navigationOffset.y -= (float)(2 * this.multiplier);
                    this.tm.navMode = 2;
                    break;
                }
                if (isAltKey) {
                    this.tm.rotateXRadians(-0.0034906585f * (float)this.multiplier, null);
                    this.tm.navMode = 3;
                    break;
                }
                this.tm.modelCenterOffset = this.tm.modelCenterOffset - speed * (float)(this.vwr.getBoolean(603979890) ? 1 : this.multiplier);
                this.tm.navMode = 4;
                break;
            }
            case 40: {
                if (this.tm.navOn) {
                    if (isAltKey) {
                        this.tm.navY -= (float)this.multiplier;
                        value = this.tm.navY;
                        key = "navY";
                        break;
                    }
                    this.tm.navZ -= (float)this.multiplier;
                    value = this.tm.navZ;
                    key = "navZ";
                    break;
                }
                if (isShiftKey) {
                    this.tm.navigationOffset.y += (float)(2 * this.multiplier);
                    this.tm.navMode = 2;
                    break;
                }
                if (isAltKey) {
                    this.tm.rotateXRadians(0.0034906585f * (float)this.multiplier, null);
                    this.tm.navMode = 3;
                    break;
                }
                this.tm.modelCenterOffset = this.tm.modelCenterOffset + speed * (float)(this.vwr.getBoolean(603979890) ? 1 : this.multiplier);
                this.tm.navMode = 4;
                break;
            }
            case 37: {
                if (this.tm.navOn) {
                    this.tm.navX -= (float)this.multiplier;
                    value = this.tm.navX;
                    key = "navX";
                    break;
                }
                if (isShiftKey) {
                    this.tm.navigationOffset.x -= (float)(2 * this.multiplier);
                    this.tm.navMode = 2;
                    break;
                }
                this.tm.rotateYRadians(-0.010471976f * (float)this.multiplier, null);
                this.tm.navMode = 3;
                break;
            }
            case 39: {
                if (this.tm.navOn) {
                    this.tm.navX += (float)this.multiplier;
                    value = this.tm.navX;
                    key = "navX";
                    break;
                }
                if (isShiftKey) {
                    this.tm.navigationOffset.x += (float)(2 * this.multiplier);
                    this.tm.navMode = 2;
                    break;
                }
                this.tm.rotateYRadians(0.010471976f * (float)this.multiplier, null);
                this.tm.navMode = 3;
                break;
            }
            default: {
                this.tm.navigating = false;
                this.tm.navMode = 0;
                return;
            }
        }
        if (key != null) {
            this.vwr.g.setF(key, value);
        }
        this.tm.navigating = true;
        this.tm.finalizeTransformParameters();
    }

    @Override
    public void setNavigationDepthPercent(float percent) {
        this.vwr.g.setF("navigationDepth", percent);
        this.tm.calcCameraFactors();
        this.tm.modelCenterOffset = this.tm.referencePlaneOffset - (1.0f - percent / 50.0f) * this.tm.modelRadiusPixels;
        this.tm.calcCameraFactors();
        this.tm.navMode = -1;
    }

    private void calcNavigationDepthPercent() {
        this.tm.calcCameraFactors();
        this.tm.navigationDepthPercent = this.tm.modelRadiusPixels == 0.0f ? 50.0f : 50.0f * (1.0f + (this.tm.modelCenterOffset - this.tm.referencePlaneOffset) / this.tm.modelRadiusPixels);
    }

    @Override
    public String getNavigationState() {
        return "# navigation state;\nnavigate 0 center " + Escape.eP(this.tm.navigationCenter) + ";\nnavigate 0 translate " + this.tm.getNavigationOffsetPercent('X') + " " + this.tm.getNavigationOffsetPercent('Y') + ";\nset navigationDepth " + this.tm.navigationDepthPercent + ";\nset navigationSlab " + this.getNavigationSlabOffsetPercent() + ";\n\n";
    }

    private float getNavigationSlabOffsetPercent() {
        this.tm.calcCameraFactors();
        return 50.0f * this.tm.navigationSlabOffset / this.tm.modelRadiusPixels;
    }

    @Override
    public void navigateAxis(V3 rotAxis, float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        this.tm.rotateAxisAngle(rotAxis, (float)((double)degrees / 57.29577951308232));
        this.tm.navMode = 3;
        this.tm.navigating = true;
        this.tm.finalizeTransformParameters();
        this.tm.navigating = false;
    }

    @Override
    public void navTranslatePercentOrTo(float seconds, float x, float y) {
        P3 pt1 = P3.new3(x, y, 0.0f);
        if (seconds >= 0.0f) {
            this.setNavPercent(pt1);
        }
        if (!Float.isNaN(pt1.x)) {
            this.tm.navigationOffset.x = pt1.x;
        }
        if (!Float.isNaN(pt1.y)) {
            this.tm.navigationOffset.y = pt1.y;
        }
        this.tm.navMode = 2;
        this.tm.navigating = true;
        this.tm.finalizeTransformParameters();
        this.tm.navigating = false;
    }

    @Override
    protected void oops(Exception e) {
        super.oops(e);
        this.tm.navigating = false;
    }
}

