/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.DataPoint;
import tim.prune.data.DoubleRange;
import tim.prune.data.Track;
import tim.prune.gui.BaseImageDefinitionPanel;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.WholeNumberField;
import tim.prune.gui.colour.PointColourer;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MapSourceLibrary;
import tim.prune.gui.map.MapUtils;
import tim.prune.load.GenericFileFilter;
import tim.prune.save.BaseImageConfigDialog;
import tim.prune.save.BaseImageConsumer;
import tim.prune.save.GroutedImage;
import tim.prune.save.MapGrouter;
import tim.prune.threedee.ImageDefinition;

public class ImageExporter
extends GenericFunction
implements BaseImageConsumer {
    private JDialog _dialog = null;
    private JCheckBox _drawDataCheckbox = null;
    private JCheckBox _drawTrackPointsCheckbox = null;
    private WholeNumberField _textScaleField = null;
    private BaseImageDefinitionPanel _baseImagePanel = null;
    private JFileChooser _fileChooser = null;
    private JButton _okButton = null;

    public ImageExporter(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.exportimage";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
            this._textScaleField.setValue(100);
        }
        if (!BaseImageConfigDialog.isImagePossible()) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.exportimage.noimagepossible");
            return;
        }
        this._baseImagePanel.updateBaseImageDetails();
        this.baseImageChanged();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(4, 4));
        this._drawDataCheckbox = new JCheckBox(I18nManager.getText("dialog.exportimage.drawtrack"));
        this._drawDataCheckbox.setSelected(true);
        this._drawTrackPointsCheckbox = new JCheckBox(I18nManager.getText("dialog.exportimage.drawtrackpoints"));
        this._drawTrackPointsCheckbox.setSelected(true);
        this._drawDataCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageExporter.this._drawTrackPointsCheckbox.setEnabled(ImageExporter.this._drawDataCheckbox.isSelected());
            }
        });
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        guiGridLayout.add(new JLabel(String.valueOf(I18nManager.getText("dialog.exportimage.textscalepercent")) + ": "));
        this._textScaleField = new WholeNumberField(3);
        this._textScaleField.setText("888");
        guiGridLayout.add(this._textScaleField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageExporter.this.doExport();
                ImageExporter.this._baseImagePanel.getGrouter().clearMapImage();
                ImageExporter.this._dialog.dispose();
            }
        });
        jPanel3.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageExporter.this._baseImagePanel.getGrouter().clearMapImage();
                ImageExporter.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ImageExporter.this._dialog.dispose();
                    ImageExporter.this._baseImagePanel.getGrouter().clearMapImage();
                }
            }
        };
        this._drawDataCheckbox.addKeyListener(keyAdapter);
        this._baseImagePanel = new BaseImageDefinitionPanel(this, this._dialog, this._app.getTrackInfo().getTrack());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(this._drawDataCheckbox);
        jPanel4.add(this._drawTrackPointsCheckbox);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.add((Component)jPanel4, "North");
        jPanel5.add((Component)jPanel2, "Center");
        jPanel5.add((Component)this._baseImagePanel, "South");
        jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add((Component)jPanel5, "North");
        return jPanel;
    }

    private void doExport() {
        this._okButton.setEnabled(false);
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setDialogType(1);
            this._fileChooser.setFileFilter(new GenericFileFilter("filetype.png", new String[]{"png"}));
            this._fileChooser.setAcceptAllFileFilterUsed(false);
            String string = Config.getConfigString("prune.trackdirectory");
            if (string != null) {
                this._fileChooser.setCurrentDirectory(new File(string));
            }
        }
        boolean bl = false;
        do {
            bl = false;
            if (this._fileChooser.showSaveDialog(this._parentFrame) != 0) continue;
            File file = this._fileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".png")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".png");
            }
            Object[] objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file.exists() || JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                if (this.exportFile(file)) continue;
                bl = true;
                continue;
            }
            bl = true;
        } while (bl);
    }

    private boolean exportFile(File file) {
        ImageDefinition imageDefinition = this._baseImagePanel.getImageDefinition();
        MapSource mapSource = MapSourceLibrary.getSource(imageDefinition.getSourceIndex());
        MapGrouter mapGrouter = this._baseImagePanel.getGrouter();
        GroutedImage groutedImage = mapGrouter.getMapImage(this._app.getTrackInfo().getTrack(), mapSource, imageDefinition.getZoom());
        if (groutedImage == null || !groutedImage.isValid()) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.exportpov.cannotmakebaseimage");
            return true;
        }
        try {
            if (this._drawDataCheckbox.isSelected()) {
                this.drawData(groutedImage);
            }
            if (!ImageIO.write((RenderedImage)groutedImage.getImage(), "png", file)) {
                this._app.showErrorMessage(this.getNameKey(), "dialog.exportpov.cannotmakebaseimage");
                return false;
            }
        }
        catch (IOException iOException) {
            System.err.println("Can't write image: " + iOException.getClass().getName());
        }
        return true;
    }

    private void drawData(GroutedImage groutedImage) {
        int n;
        int n2;
        double d;
        int n3;
        int n4;
        DoubleRange doubleRange = groutedImage.getXRange();
        DoubleRange doubleRange2 = groutedImage.getYRange();
        int n5 = 1 << this._baseImagePanel.getImageDefinition().getZoom();
        Graphics graphics = groutedImage.getImage().getGraphics();
        PointColourer pointColourer = this._app.getPointColourer();
        Color color = Config.getColourScheme().getColour(1);
        graphics.setColor(color);
        Track track = this._app.getTrackInfo().getTrack();
        int n6 = track.getNumPoints();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n6) {
            DataPoint dataPoint = track.getPoint(n9);
            if (!dataPoint.isWaypoint()) {
                if (pointColourer != null) {
                    Color color2 = pointColourer.getColour(n9);
                    graphics.setColor(color2 == null ? color : color2);
                }
                double d2 = track.getX(n9) - doubleRange.getMinimum();
                double d3 = track.getY(n9) - doubleRange2.getMinimum();
                n4 = (int)(d2 * (double)n5 * 256.0);
                n3 = (int)(d3 * (double)n5 * 256.0);
                if (!dataPoint.getSegmentStart()) {
                    graphics.drawLine(n7, n8, n4, n3);
                }
                if (this._drawTrackPointsCheckbox.isSelected()) {
                    graphics.drawRect(n4 - 2, n3 - 2, 3, 3);
                }
                n7 = n4;
                n8 = n3;
            }
            ++n9;
        }
        Color color3 = Config.getColourScheme().getColour(3);
        graphics.setColor(color3);
        int n10 = 0;
        while (n10 < n6) {
            DataPoint dataPoint = track.getPoint(n10);
            if (dataPoint.isWaypoint()) {
                double d4 = track.getX(n10) - doubleRange.getMinimum();
                double d5 = track.getY(n10) - doubleRange2.getMinimum();
                n3 = (int)(d4 * (double)n5 * 256.0);
                int n11 = (int)(d5 * (double)n5 * 256.0);
                graphics.fillRect(n3 - 3, n11 - 3, 6, 6);
            }
            ++n10;
        }
        n10 = this._textScaleField.getValue();
        if (n10 > 10 && n10 <= 999) {
            Font font = graphics.getFont();
            graphics.setFont(font.deriveFont((float)((double)font.getSize() * 0.01 * (double)n10)));
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n12 = fontMetrics.getHeight();
        int n13 = groutedImage.getImageSize();
        Color color4 = Config.getColourScheme().getColour(5);
        graphics.setColor(color4);
        n4 = 0;
        while (n4 < n6) {
            DataPoint dataPoint = track.getPoint(n4);
            if (dataPoint.hasMedia()) {
                double d6 = track.getX(n4) - doubleRange.getMinimum();
                d = track.getY(n4) - doubleRange2.getMinimum();
                n2 = (int)(d6 * (double)n5 * 256.0);
                n = (int)(d * (double)n5 * 256.0);
                graphics.fillRect(n2 - 3, n - 3, 6, 6);
            }
            ++n4;
        }
        graphics.setColor(color3);
        n4 = 0;
        while (n4 < n6) {
            DataPoint dataPoint = track.getPoint(n4);
            if (dataPoint.isWaypoint()) {
                double d7 = track.getX(n4) - doubleRange.getMinimum();
                d = track.getY(n4) - doubleRange2.getMinimum();
                n2 = (int)(d7 * (double)n5 * 256.0);
                n = (int)(d * (double)n5 * 256.0);
                String string = dataPoint.getWaypointName();
                int n14 = fontMetrics.stringWidth(string);
                boolean bl = false;
                int[] nArray = new int[]{n2 + 2, n2 - n14 - 2, n2 - n14 / 2, n2 - n14 / 2};
                int[] nArray2 = new int[]{n + n12 / 2, n + n12 / 2, n - 2, n + n12 + 2};
                int n15 = 4;
                while (n15 < 13 && !bl) {
                    nArray[0] = nArray[0] + 2;
                    nArray[1] = nArray[1] - 2;
                    nArray2[2] = nArray2[2] - 2;
                    nArray2[3] = nArray2[3] + 2;
                    int n16 = 0;
                    while (n16 < 4) {
                        if (nArray[n16] > 0 && nArray[n16] + n14 < n13 && nArray2[n16] < n13 && nArray2[n16] - n12 > 0 && !MapUtils.overlapsPoints(groutedImage.getImage(), nArray[n16], nArray2[n16], n14, n12, color3)) {
                            graphics.drawString(string, nArray[n16], nArray2[n16]);
                            bl = true;
                            break;
                        }
                        ++n16;
                    }
                    n15 += 2;
                }
            }
            ++n4;
        }
    }

    public void baseImageChanged() {
        boolean bl = this._baseImagePanel.getImageDefinition().getUseImage();
        int n = this._baseImagePanel.getImageDefinition().getZoom();
        boolean bl2 = bl && this._baseImagePanel.getFoundData() && MapGrouter.isZoomLevelOk(this._app.getTrackInfo().getTrack(), n);
        this._okButton.setEnabled(bl2);
    }
}

