/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.PingPongList;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

public class EncodingsOptionPane
extends AbstractOptionPane {
    private JComboBox<String> defaultEncoding;
    private JCheckBox encodingAutodetect;
    private JTextField encodingDetectors;
    private JTextField fallbackEncodings;
    private JComboBox<String> lineSeparator;
    private PingPongList<String> pingPongList;

    public EncodingsOptionPane() {
        super("encodings");
    }

    @Override
    protected void _init() {
        String[] stringArray = new String[]{jEdit.getProperty("lineSep.unix"), jEdit.getProperty("lineSep.windows"), jEdit.getProperty("lineSep.mac")};
        this.lineSeparator = new JComboBox<String>(stringArray);
        String string = jEdit.getProperty("buffer.lineSeparator", System.getProperty("line.separator"));
        if ("\n".equals(string)) {
            this.lineSeparator.setSelectedIndex(0);
        } else if ("\r\n".equals(string)) {
            this.lineSeparator.setSelectedIndex(1);
        } else if ("\r".equals(string)) {
            this.lineSeparator.setSelectedIndex(2);
        }
        this.addComponent(jEdit.getProperty("options.general.lineSeparator"), this.lineSeparator);
        String[] stringArray2 = MiscUtilities.getEncodings(true);
        Arrays.sort(stringArray2, new StandardUtilities.StringCompare(true));
        this.defaultEncoding = new JComboBox<String>(stringArray2);
        this.defaultEncoding.setEditable(true);
        this.defaultEncoding.setSelectedItem(jEdit.getProperty("buffer.encoding", System.getProperty("file.encoding")));
        this.addComponent(jEdit.getProperty("options.general.encoding"), this.defaultEncoding);
        this.encodingAutodetect = new JCheckBox(jEdit.getProperty("options.general.encodingAutodetect"));
        this.encodingAutodetect.setSelected(jEdit.getBooleanProperty("buffer.encodingAutodetect"));
        this.addComponent((Component)this.encodingAutodetect, 1);
        this.encodingDetectors = new JTextField(jEdit.getProperty("encodingDetectors", ""));
        this.addComponent(jEdit.getProperty("options.general.encodingDetectors"), (Component)this.encodingDetectors);
        this.fallbackEncodings = new JTextField(jEdit.getProperty("fallbackEncodings", ""));
        this.fallbackEncodings.setToolTipText(jEdit.getProperty("options.general.fallbackEncodings.tooltip"));
        this.addComponent(jEdit.getProperty("options.general.fallbackEncodings"), (Component)this.fallbackEncodings);
        stringArray2 = MiscUtilities.getEncodings(false);
        Arrays.sort(stringArray2, new StandardUtilities.StringCompare(true));
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string2 : stringArray2) {
            boolean bl;
            boolean bl2 = bl = !jEdit.getBooleanProperty("encoding.opt-out." + string2, false);
            if (bl) {
                arrayList2.add(string2);
                continue;
            }
            arrayList.add(string2);
        }
        this.pingPongList = new PingPongList(arrayList, arrayList2);
        this.pingPongList.setLeftTitle(jEdit.getProperty("options.encodings.available"));
        this.pingPongList.setRightTitle(jEdit.getProperty("options.encodings.selected"));
        this.pingPongList.setLeftTooltip(jEdit.getProperty("options.encodings.available.tooltip"));
        this.pingPongList.setRightTooltip(jEdit.getProperty("options.encodings.selected.tooltip"));
        this.addComponent(this.pingPongList, 1);
    }

    @Override
    protected void _save() {
        Object object;
        String string = null;
        switch (this.lineSeparator.getSelectedIndex()) {
            case 0: {
                string = "\n";
                break;
            }
            case 1: {
                string = "\r\n";
                break;
            }
            case 2: {
                string = "\r";
            }
        }
        jEdit.setProperty("buffer.lineSeparator", string);
        jEdit.setProperty("buffer.encoding", (String)this.defaultEncoding.getSelectedItem());
        jEdit.setBooleanProperty("buffer.encodingAutodetect", this.encodingAutodetect.isSelected());
        jEdit.setProperty("encodingDetectors", this.encodingDetectors.getText());
        jEdit.setProperty("fallbackEncodings", this.fallbackEncodings.getText());
        Iterator<String> iterator = this.pingPongList.getLeftDataIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            jEdit.setBooleanProperty("encoding.opt-out." + (String)object, true);
        }
        object = this.pingPongList.getRightDataIterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            jEdit.unsetProperty("encoding.opt-out." + string2);
        }
    }
}

