/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaModifierListOwnerImpl;
import org.jetbrains.kotlin.name.FqName;

class JavaElementUtil {
    private JavaElementUtil() {
    }

    public static boolean isAbstract(@NotNull JavaModifierListOwnerImpl owner) {
        if (owner == null) {
            JavaElementUtil.$$$reportNull$$$0(0);
        }
        return owner.getPsi().hasModifierProperty("abstract");
    }

    public static boolean isStatic(@NotNull JavaModifierListOwnerImpl owner) {
        if (owner == null) {
            JavaElementUtil.$$$reportNull$$$0(1);
        }
        return owner.getPsi().hasModifierProperty("static");
    }

    public static boolean isFinal(@NotNull JavaModifierListOwnerImpl owner) {
        if (owner == null) {
            JavaElementUtil.$$$reportNull$$$0(2);
        }
        return owner.getPsi().hasModifierProperty("final");
    }

    @NotNull
    public static Visibility getVisibility(@NotNull JavaModifierListOwnerImpl owner) {
        PsiModifierListOwner psiOwner;
        if (owner == null) {
            JavaElementUtil.$$$reportNull$$$0(3);
        }
        if ((psiOwner = owner.getPsi()).hasModifierProperty("public")) {
            Visibility visibility = Visibilities.PUBLIC;
            if (visibility == null) {
                JavaElementUtil.$$$reportNull$$$0(4);
            }
            return visibility;
        }
        if (psiOwner.hasModifierProperty("private")) {
            Visibility visibility = Visibilities.PRIVATE;
            if (visibility == null) {
                JavaElementUtil.$$$reportNull$$$0(5);
            }
            return visibility;
        }
        if (psiOwner.hasModifierProperty("protected")) {
            Visibility visibility = owner.isStatic() ? JavaVisibilities.PROTECTED_STATIC_VISIBILITY : JavaVisibilities.PROTECTED_AND_PACKAGE;
            if (visibility == null) {
                JavaElementUtil.$$$reportNull$$$0(6);
            }
            return visibility;
        }
        Visibility visibility = JavaVisibilities.PACKAGE_VISIBILITY;
        if (visibility == null) {
            JavaElementUtil.$$$reportNull$$$0(7);
        }
        return visibility;
    }

    @NotNull
    public static Collection<JavaAnnotation> getAnnotations(@NotNull JavaAnnotationOwnerImpl owner) {
        PsiAnnotationOwner annotationOwnerPsi;
        if (owner == null) {
            JavaElementUtil.$$$reportNull$$$0(8);
        }
        if ((annotationOwnerPsi = owner.getAnnotationOwnerPsi()) != null) {
            Collection<JavaAnnotation> collection = JavaElementCollectionFromPsiArrayUtil.annotations(annotationOwnerPsi.getAnnotations());
            if (collection == null) {
                JavaElementUtil.$$$reportNull$$$0(9);
            }
            return collection;
        }
        List<JavaAnnotation> list2 = Collections.emptyList();
        if (list2 == null) {
            JavaElementUtil.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @Nullable
    public static JavaAnnotation findAnnotation(@NotNull JavaAnnotationOwnerImpl owner, @NotNull FqName fqName2) {
        PsiAnnotationOwner annotationOwnerPsi;
        if (owner == null) {
            JavaElementUtil.$$$reportNull$$$0(11);
        }
        if (fqName2 == null) {
            JavaElementUtil.$$$reportNull$$$0(12);
        }
        if ((annotationOwnerPsi = owner.getAnnotationOwnerPsi()) != null) {
            PsiAnnotation psiAnnotation = annotationOwnerPsi.findAnnotation(fqName2.asString());
            return psiAnnotation == null ? null : new JavaAnnotationImpl(psiAnnotation);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/load/java/structure/impl/JavaElementUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/load/java/structure/impl/JavaElementUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAbstract";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isStatic";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFinal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVisibility";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

