/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.DeprecatedCallChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ApiVersionCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "element", "Lcom/intellij/psi/PsiElement;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "kotlin-compiler"})
public final class ApiVersionCallChecker
implements CallChecker {
    public static final ApiVersionCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, "resolvedCall.resultingDescriptor");
        this.check((CallableDescriptor)obj, context, reportOn);
    }

    private final void check(CallableDescriptor targetDescriptor, CallCheckerContext context, PsiElement element) {
        block2: {
            if (targetDescriptor instanceof FakeCallableDescriptorForObject) {
                return;
            }
            boolean accessible2 = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(targetDescriptor, context.getLanguageVersionSettings(), (Function1<? super ApiVersion, Unit>)new Function1<ApiVersion, Unit>(context, element){
                final /* synthetic */ CallCheckerContext $context;
                final /* synthetic */ PsiElement $element;

                public final void invoke(@NotNull ApiVersion version) {
                    Intrinsics.checkParameterIsNotNull(version, "version");
                    this.$context.getTrace().report(Errors.API_NOT_AVAILABLE.on(this.$element, version.getVersionString(), this.$context.getLanguageVersionSettings().getApiVersion().getVersionString()));
                }
                {
                    this.$context = callCheckerContext;
                    this.$element = psiElement;
                    super(1);
                }
            });
            if (!accessible2 || !(targetDescriptor instanceof PropertyDescriptor) || !DeprecatedCallChecker.INSTANCE.shouldCheckPropertyGetter$kotlin_compiler(element)) break block2;
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)targetDescriptor).getGetter();
            if (propertyGetterDescriptor != null) {
                PropertyGetterDescriptor propertyGetterDescriptor2;
                PropertyGetterDescriptor it;
                PropertyGetterDescriptor propertyGetterDescriptor3 = it = (propertyGetterDescriptor2 = propertyGetterDescriptor);
                Intrinsics.checkExpressionValueIsNotNull(propertyGetterDescriptor3, "it");
                INSTANCE.check(propertyGetterDescriptor3, context, element);
            }
        }
    }

    private ApiVersionCallChecker() {
        INSTANCE = this;
    }

    static {
        new ApiVersionCallChecker();
    }
}

