/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintIncorporator;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintInjector$TypeCheckerContext$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeCheckerContextForConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.model.CapturedTypeFromSubtyping;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintKind;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.IncorporationConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.InitialConstraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.MutableVariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewTypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.TypeApproximatorKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.CaptureStatus;
import org.jetbrains.kotlin.types.checker.NewCapturedType;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002&'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J(\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\u0014\u0010\u001e\u001a\u00020\u001f*\u00020\u00102\u0006\u0010 \u001a\u00020\u0012H\u0002J\u001c\u0010!\u001a\u00020\u001f*\u00020\u00102\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector;", "", "constraintIncorporator", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintIncorporator;", "typeApproximator", "Lorg/jetbrains/kotlin/types/TypeApproximator;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintIncorporator;Lorg/jetbrains/kotlin/types/TypeApproximator;)V", "ALLOWED_DEPTH_DELTA_FOR_INCORPORATION", "", "getConstraintIncorporator", "()Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintIncorporator;", "getTypeApproximator", "()Lorg/jetbrains/kotlin/types/TypeApproximator;", "addInitialEqualityConstraint", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector$Context;", "a", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "b", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintPosition;", "addInitialSubtypeConstraint", "lowerType", "upperType", "addSubTypeConstraintAndIncorporateIt", "incorporatePosition", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/IncorporationConstraintPosition;", "updateAllowedTypeDepth", "initialType", "isAllowedType", "", "type", "shouldWeSkipConstraint", "typeVariable", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/NewTypeVariable;", "constraint", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "Context", "TypeCheckerContext", "kotlin-compiler"})
public final class ConstraintInjector {
    private final int ALLOWED_DEPTH_DELTA_FOR_INCORPORATION = 1;
    @NotNull
    private final ConstraintIncorporator constraintIncorporator;
    @NotNull
    private final TypeApproximator typeApproximator;

    public final void addInitialSubtypeConstraint(@NotNull Context c, @NotNull UnwrappedType lowerType, @NotNull UnwrappedType upperType, @NotNull ConstraintPosition position) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(lowerType, "lowerType");
        Intrinsics.checkParameterIsNotNull(upperType, "upperType");
        Intrinsics.checkParameterIsNotNull(position, "position");
        InitialConstraint initialConstraint = new InitialConstraint(lowerType, upperType, ConstraintKind.UPPER, position);
        IncorporationConstraintPosition incorporationPosition = new IncorporationConstraintPosition(position, initialConstraint);
        c.addInitialConstraint(initialConstraint);
        this.updateAllowedTypeDepth(c, lowerType);
        this.updateAllowedTypeDepth(c, upperType);
        this.addSubTypeConstraintAndIncorporateIt(c, lowerType, upperType, incorporationPosition);
    }

    public final void addInitialEqualityConstraint(@NotNull Context c, @NotNull UnwrappedType a, @NotNull UnwrappedType b, @NotNull ConstraintPosition position) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(position, "position");
        InitialConstraint initialConstraint = new InitialConstraint(a, b, ConstraintKind.EQUALITY, position);
        IncorporationConstraintPosition incorporationPosition = new IncorporationConstraintPosition(position, initialConstraint);
        c.addInitialConstraint(initialConstraint);
        this.updateAllowedTypeDepth(c, a);
        this.updateAllowedTypeDepth(c, b);
        this.addSubTypeConstraintAndIncorporateIt(c, a, b, incorporationPosition);
        this.addSubTypeConstraintAndIncorporateIt(c, b, a, incorporationPosition);
    }

    /*
     * WARNING - void declaration
     */
    private final void addSubTypeConstraintAndIncorporateIt(Context c, UnwrappedType lowerType, UnwrappedType upperType, IncorporationConstraintPosition incorporatePosition) {
        Object object;
        Stack possibleNewConstraints = new Stack();
        TypeCheckerContext typeCheckerContext = new TypeCheckerContext(c, incorporatePosition, lowerType, upperType, possibleNewConstraints);
        typeCheckerContext.runIsSubtypeOf(lowerType, upperType);
        while (!(object = (Collection)possibleNewConstraints).isEmpty()) {
            Constraint constraint;
            MutableVariableWithConstraints constraints;
            void typeVariable2;
            Pair pair = (Pair)possibleNewConstraints.pop();
            object = (NewTypeVariable)pair.component1();
            Constraint constraint2 = (Constraint)pair.component2();
            if (this.shouldWeSkipConstraint(c, (NewTypeVariable)typeVariable2, constraint2)) continue;
            if (c.getNotFixedTypeVariables().get(typeVariable2.getFreshTypeConstructor()) == null) {
                Void void_ = typeCheckerContext.fixedTypeVariable((NewTypeVariable)typeVariable2);
                throw null;
            }
            if (constraints.addConstraint(constraint2) == null) continue;
            Constraint it = constraint;
            this.constraintIncorporator.incorporate(typeCheckerContext, (NewTypeVariable)typeVariable2, it);
        }
    }

    private final void updateAllowedTypeDepth(Context c, UnwrappedType initialType) {
        c.setMaxTypeDepthFromInitialConstraints(Math.max(c.getMaxTypeDepthFromInitialConstraints(), TypeApproximatorKt.typeDepth(initialType)));
    }

    private final boolean shouldWeSkipConstraint(@NotNull Context $receiver, NewTypeVariable typeVariable2, Constraint constraint) {
        boolean bl = Intrinsics.areEqual((Object)constraint.getKind(), (Object)ConstraintKind.EQUALITY) ^ true;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        UnwrappedType constraintType = constraint.getType();
        if (!this.isAllowedType($receiver, constraintType)) {
            return true;
        }
        if (Intrinsics.areEqual(constraintType.getConstructor(), typeVariable2.getFreshTypeConstructor())) {
            return !FlexibleTypesKt.lowerIfFlexible(constraintType).isMarkedNullable() || !Intrinsics.areEqual((Object)constraint.getKind(), (Object)ConstraintKind.LOWER);
        }
        if (constraintType instanceof SimpleType) {
            if (Intrinsics.areEqual((Object)constraint.getKind(), (Object)ConstraintKind.UPPER) && TypeUtilsKt.isNullableAny(constraintType)) {
                return true;
            }
            if (Intrinsics.areEqual((Object)constraint.getKind(), (Object)ConstraintKind.LOWER) && TypeUtilsKt.isNothing(constraintType)) {
                return true;
            }
        }
        return false;
    }

    private final boolean isAllowedType(@NotNull Context $receiver, UnwrappedType type2) {
        return TypeApproximatorKt.typeDepth(type2) <= $receiver.getMaxTypeDepthFromInitialConstraints() + this.ALLOWED_DEPTH_DELTA_FOR_INCORPORATION;
    }

    @NotNull
    public final ConstraintIncorporator getConstraintIncorporator() {
        return this.constraintIncorporator;
    }

    @NotNull
    public final TypeApproximator getTypeApproximator() {
        return this.typeApproximator;
    }

    public ConstraintInjector(@NotNull ConstraintIncorporator constraintIncorporator, @NotNull TypeApproximator typeApproximator) {
        Intrinsics.checkParameterIsNotNull(constraintIncorporator, "constraintIncorporator");
        Intrinsics.checkParameterIsNotNull(typeApproximator, "typeApproximator");
        this.constraintIncorporator = constraintIncorporator;
        this.typeApproximator = typeApproximator;
        this.ALLOWED_DEPTH_DELTA_FOR_INCORPORATION = 1;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H&R\u001e\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector$Context;", "", "allTypeVariables", "", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/NewTypeVariable;", "getAllTypeVariables", "()Ljava/util/Map;", "maxTypeDepthFromInitialConstraints", "", "getMaxTypeDepthFromInitialConstraints", "()I", "setMaxTypeDepthFromInitialConstraints", "(I)V", "notFixedTypeVariables", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/MutableVariableWithConstraints;", "getNotFixedTypeVariables", "addError", "", "error", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "addInitialConstraint", "initialConstraint", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/InitialConstraint;", "kotlin-compiler"})
    public static interface Context {
        @NotNull
        public Map<TypeConstructor, NewTypeVariable> getAllTypeVariables();

        public int getMaxTypeDepthFromInitialConstraints();

        public void setMaxTypeDepthFromInitialConstraints(int var1);

        @NotNull
        public Map<TypeConstructor, MutableVariableWithConstraints> getNotFixedTypeVariables();

        public void addInitialConstraint(@NotNull InitialConstraint var1);

        public void addError(@NotNull KotlinCallDiagnostic var1);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000b\u00a2\u0006\u0002\u0010\u000fJ \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\bH\u0016J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bH\u0016J\u0018\u0010+\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020!2\u0006\u0010,\u001a\u00020\bH\u0016J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\rJ\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e012\u0006\u0010&\u001a\u00020\rH\u0016J\u0012\u00102\u001a\u0004\u0018\u00010\r2\u0006\u00103\u001a\u00020!H\u0016J\u0010\u00104\u001a\u0002052\u0006\u0010\"\u001a\u00020\bH\u0002J\u0010\u00106\u001a\u0002052\u0006\u0010\"\u001a\u000207H\u0016J\b\u00108\u001a\u000209H\u0002J\u0016\u0010:\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR#\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector$TypeCheckerContext;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeCheckerContextForConstraintSystem;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintIncorporator$Context;", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector$Context;", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/IncorporationConstraintPosition;", "baseLowerType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "baseUpperType", "possibleNewConstraints", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/NewTypeVariable;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector;Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector$Context;Lorg/jetbrains/kotlin/resolve/calls/inference/model/IncorporationConstraintPosition;Lorg/jetbrains/kotlin/types/UnwrappedType;Lorg/jetbrains/kotlin/types/UnwrappedType;Ljava/util/List;)V", "allTypeVariablesWithConstraints", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "getAllTypeVariablesWithConstraints", "()Ljava/util/Collection;", "getBaseLowerType", "()Lorg/jetbrains/kotlin/types/UnwrappedType;", "getBaseUpperType", "getC", "()Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector$Context;", "getPosition", "()Lorg/jetbrains/kotlin/resolve/calls/inference/model/IncorporationConstraintPosition;", "getPossibleNewConstraints", "()Ljava/util/List;", "addConstraint", "", "typeVariableConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "type", "kind", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintKind;", "addLowerConstraint", "typeVariable", "subType", "addNewIncorporatedConstraint", "lowerType", "upperType", "addUpperConstraint", "superType", "fixedTypeVariable", "", "variable", "getConstraintsForVariable", "", "getTypeVariable", "typeConstructor", "isCapturedTypeFromSubtyping", "", "isMyTypeVariable", "Lorg/jetbrains/kotlin/types/SimpleType;", "renderBaseConstraint", "", "runIsSubtypeOf", "kotlin-compiler"})
    private final class TypeCheckerContext
    extends TypeCheckerContextForConstraintSystem
    implements ConstraintIncorporator.Context {
        @NotNull
        private final Context c;
        @NotNull
        private final IncorporationConstraintPosition position;
        @NotNull
        private final UnwrappedType baseLowerType;
        @NotNull
        private final UnwrappedType baseUpperType;
        @NotNull
        private final List<Pair<NewTypeVariable, Constraint>> possibleNewConstraints;

        public final void runIsSubtypeOf(@NotNull UnwrappedType lowerType, @NotNull UnwrappedType upperType) {
            NewKotlinTypeChecker newKotlinTypeChecker;
            Intrinsics.checkParameterIsNotNull(lowerType, "lowerType");
            Intrinsics.checkParameterIsNotNull(upperType, "upperType");
            NewKotlinTypeChecker $receiver = newKotlinTypeChecker = NewKotlinTypeChecker.INSTANCE;
            if (!$receiver.isSubtypeOf(this, lowerType, upperType)) {
                this.c.addError(new NewConstraintError(lowerType, upperType, this.position));
            }
        }

        @Override
        public boolean isMyTypeVariable(@NotNull SimpleType type2) {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            return this.c.getAllTypeVariables().containsKey(type2.getConstructor());
        }

        @Override
        public void addUpperConstraint(@NotNull TypeConstructor typeVariable2, @NotNull UnwrappedType superType) {
            Intrinsics.checkParameterIsNotNull(typeVariable2, "typeVariable");
            Intrinsics.checkParameterIsNotNull(superType, "superType");
            this.addConstraint(typeVariable2, superType, ConstraintKind.UPPER);
        }

        @Override
        public void addLowerConstraint(@NotNull TypeConstructor typeVariable2, @NotNull UnwrappedType subType) {
            Intrinsics.checkParameterIsNotNull(typeVariable2, "typeVariable");
            Intrinsics.checkParameterIsNotNull(subType, "subType");
            this.addConstraint(typeVariable2, subType, ConstraintKind.LOWER);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isCapturedTypeFromSubtyping(UnwrappedType type2) {
            UnwrappedType unwrappedType = type2;
            if (!(unwrappedType instanceof NewCapturedType)) {
                unwrappedType = null;
            }
            NewCapturedType newCapturedType = (NewCapturedType)unwrappedType;
            if (newCapturedType == null) return false;
            CaptureStatus captureStatus = newCapturedType.getCaptureStatus();
            if (captureStatus == null) return false;
            switch (ConstraintInjector$TypeCheckerContext$WhenMappings.$EnumSwitchMapping$0[captureStatus.ordinal()]) {
                case 1: {
                    return false;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    String string = "Captured type for incorporation shouldn't escape from incorporation: " + type2 + '\n' + this.renderBaseConstraint();
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final void addConstraint(TypeConstructor typeVariableConstructor, UnwrappedType type2, ConstraintKind kind) {
            NewTypeVariable newTypeVariable = this.c.getAllTypeVariables().get(typeVariableConstructor);
            if (newTypeVariable == null) {
                String string = "Should by type variableConstructor: " + typeVariableConstructor + ". " + this.c.getAllTypeVariables().values();
                throw (Throwable)new IllegalStateException(string.toString());
            }
            NewTypeVariable typeVariable2 = newTypeVariable;
            UnwrappedType targetType = type2;
            if (TypeUtilsKt.contains(type2, (Function1<? super UnwrappedType, Boolean>)new Function1<UnwrappedType, Boolean>(this){

                public final boolean invoke(@NotNull UnwrappedType p1) {
                    Intrinsics.checkParameterIsNotNull(p1, "p1");
                    return TypeCheckerContext.access$isCapturedTypeFromSubtyping((TypeCheckerContext)this.receiver, p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(TypeCheckerContext.class);
                }

                public final String getName() {
                    return "isCapturedTypeFromSubtyping";
                }

                public final String getSignature() {
                    return "isCapturedTypeFromSubtyping(Lorg/jetbrains/kotlin/types/UnwrappedType;)Z";
                }
            })) {
                UnwrappedType superType;
                UnwrappedType subType;
                if (Intrinsics.areEqual((Object)kind, (Object)ConstraintKind.UPPER) && (subType = ConstraintInjector.this.getTypeApproximator().approximateToSubType(type2, TypeApproximatorConfiguration.SubtypeCapturedTypesApproximation.INSTANCE)) != null && !KotlinBuiltIns.isNothingOrNullableNothing(subType)) {
                    targetType = subType;
                }
                if (Intrinsics.areEqual((Object)kind, (Object)ConstraintKind.LOWER) && (superType = ConstraintInjector.this.getTypeApproximator().approximateToSuperType(type2, TypeApproximatorConfiguration.SubtypeCapturedTypesApproximation.INSTANCE)) != null && !KotlinBuiltIns.isAnyOrNullableAny(superType)) {
                    targetType = superType;
                }
                if (targetType == type2) {
                    this.c.addError(new CapturedTypeFromSubtyping(typeVariable2, type2, this.position));
                    return;
                }
            }
            this.possibleNewConstraints.add(TuplesKt.to(typeVariable2, new Constraint(kind, targetType, this.position, 0, 8, null)));
        }

        @Override
        public void addNewIncorporatedConstraint(@NotNull UnwrappedType lowerType, @NotNull UnwrappedType upperType) {
            Intrinsics.checkParameterIsNotNull(lowerType, "lowerType");
            Intrinsics.checkParameterIsNotNull(upperType, "upperType");
            if (ConstraintInjector.this.isAllowedType(this.c, lowerType) && ConstraintInjector.this.isAllowedType(this.c, upperType)) {
                this.runIsSubtypeOf(lowerType, upperType);
            }
        }

        @Override
        @NotNull
        public Collection<VariableWithConstraints> getAllTypeVariablesWithConstraints() {
            return this.c.getNotFixedTypeVariables().values();
        }

        @Override
        @Nullable
        public NewTypeVariable getTypeVariable(@NotNull TypeConstructor typeConstructor2) {
            Intrinsics.checkParameterIsNotNull(typeConstructor2, "typeConstructor");
            NewTypeVariable typeVariable2 = this.c.getAllTypeVariables().get(typeConstructor2);
            if (typeVariable2 != null && !this.c.getNotFixedTypeVariables().containsKey(typeConstructor2)) {
                Void void_ = this.fixedTypeVariable(typeVariable2);
                throw null;
            }
            return typeVariable2;
        }

        @NotNull
        public List<Constraint> getConstraintsForVariable(@NotNull NewTypeVariable typeVariable2) {
            Intrinsics.checkParameterIsNotNull(typeVariable2, "typeVariable");
            Object object = this.c.getNotFixedTypeVariables().get(typeVariable2.getFreshTypeConstructor());
            if (object == null || (object = ((MutableVariableWithConstraints)object).getConstraints()) == null) {
                Void void_ = this.fixedTypeVariable(typeVariable2);
                throw null;
            }
            return object;
        }

        @NotNull
        public final Void fixedTypeVariable(@NotNull NewTypeVariable variable2) {
            Intrinsics.checkParameterIsNotNull(variable2, "variable");
            String string = "Type variable " + variable2 + " should not be fixed!\n" + this.renderBaseConstraint();
            throw (Throwable)new IllegalStateException(string.toString());
        }

        private final String renderBaseConstraint() {
            return "Base constraint: " + this.baseLowerType + " <: " + this.baseUpperType + " from position: " + this.position;
        }

        @NotNull
        public final Context getC() {
            return this.c;
        }

        @NotNull
        public final IncorporationConstraintPosition getPosition() {
            return this.position;
        }

        @NotNull
        public final UnwrappedType getBaseLowerType() {
            return this.baseLowerType;
        }

        @NotNull
        public final UnwrappedType getBaseUpperType() {
            return this.baseUpperType;
        }

        @NotNull
        public final List<Pair<NewTypeVariable, Constraint>> getPossibleNewConstraints() {
            return this.possibleNewConstraints;
        }

        public TypeCheckerContext(@NotNull Context c, @NotNull IncorporationConstraintPosition position, @NotNull UnwrappedType baseLowerType, @NotNull UnwrappedType baseUpperType, @NotNull List<Pair<NewTypeVariable, Constraint>> possibleNewConstraints) {
            Intrinsics.checkParameterIsNotNull(c, "c");
            Intrinsics.checkParameterIsNotNull(position, "position");
            Intrinsics.checkParameterIsNotNull(baseLowerType, "baseLowerType");
            Intrinsics.checkParameterIsNotNull(baseUpperType, "baseUpperType");
            Intrinsics.checkParameterIsNotNull(possibleNewConstraints, "possibleNewConstraints");
            this.c = c;
            this.position = position;
            this.baseLowerType = baseLowerType;
            this.baseUpperType = baseUpperType;
            this.possibleNewConstraints = possibleNewConstraints;
        }

        public static final /* synthetic */ boolean access$isCapturedTypeFromSubtyping(TypeCheckerContext $this, @NotNull UnwrappedType type2) {
            return $this.isCapturedTypeFromSubtyping(type2);
        }
    }
}

