/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DelegationResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DelegationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkDescriptor", "classDeclaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "delegatedDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "delegatedToDescriptor", "kotlin-compiler"})
public final class DelegationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration instanceof KtClassOrObject)) {
            return;
        }
        for (KtSuperTypeListEntry specifier : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
            ClassDescriptor superTypeDescriptor;
            KtTypeReference ktTypeReference;
            KtTypeReference it;
            if (!(specifier instanceof KtDelegatedSuperTypeEntry)) continue;
            Object object = ((KtDelegatedSuperTypeEntry)specifier).getTypeReference();
            if (object == null || (object = (KotlinType)bindingContext.get(BindingContext.TYPE, it = (ktTypeReference = object))) == null) {
                continue;
            }
            Object superType = object;
            ClassifierDescriptor classifierDescriptor = ((KotlinType)superType).getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            if ((ClassDescriptor)classifierDescriptor == null) {
                continue;
            }
            Map map2 = DelegationResolver.Companion.getDelegates$default(DelegationResolver.Companion, (ClassDescriptor)descriptor2, superTypeDescriptor, null, 4, null);
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator2.next();
                CallableMemberDescriptor delegated = (CallableMemberDescriptor)entry2.getKey();
                entry2 = entry;
                CallableMemberDescriptor delegatedTo = (CallableMemberDescriptor)entry2.getValue();
                this.checkDescriptor((KtClassOrObject)declaration, delegated, delegatedTo, diagnosticHolder);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDescriptor(KtClassOrObject classDeclaration, CallableMemberDescriptor delegatedDescriptor, CallableMemberDescriptor delegatedToDescriptor, DiagnosticSink diagnosticHolder) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)delegatedDescriptor);
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
            if (!it.getKind().isReal()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set<CallableMemberDescriptor> reachableFromDelegated = SetsKt.minus(OverridingUtil.filterOutOverridden(CollectionsKt.toSet((List)destination$iv$iv)), DescriptorUtils.unwrapFakeOverride(delegatedToDescriptor).getOriginal());
        Iterable $receiver$iv2 = reachableFromDelegated;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getModality(), (Object)Modality.OPEN)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List nonAbstractReachable = (List)destination$iv$iv2;
        iterable = nonAbstractReachable;
        if (!iterable.isEmpty()) {
            diagnosticHolder.report(Errors.DELEGATED_MEMBER_HIDES_SUPERTYPE_OVERRIDE.on((KtClassOrObject)((PsiElement)classDeclaration), delegatedDescriptor, nonAbstractReachable));
        }
    }
}

