# -*- coding: binary -*-
#
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# https://metasploit.com/framework/

require 'msf/core/auxiliary'

module Msf
module Exploit::Remote::BrowserAutopwn

  include Msf::Auxiliary::Report

  # this is the magic
  def self.included(base)
    base.extend(AutopwnClassMethods)
  end

  module AutopwnClassMethods
    def self.extended(base)
      if base.const_defined? "Rank"
        @@autopwn_rank = base.const_get("Rank")
      else
        @@autopwn_rank = RankingName.invert['manual']
      end
    end

    def autopwn_opts
      @autopwn_opts.dup
    end

    def autopwn_info(opts={})
      # prefix_html and postfix_html are only used for noscript exploits
      # vuln_test is only used for javascript exploits
      @autopwn_opts = {}
      @autopwn_opts[:ua_name]      = opts[:ua_name] || nil
      @autopwn_opts[:ua_minver]    = opts[:ua_minver]  || opts[:ua_minversion] || nil
      @autopwn_opts[:ua_maxver]    = opts[:ua_maxver]  || opts[:ua_maxversion] || nil
      @autopwn_opts[:ua_ver]       = opts[:ua_ver]  || opts[:ua_version] || nil
      @autopwn_opts[:classid]      = opts[:classid] || opts[:clsid] || nil
      @autopwn_opts[:method]       = opts[:method]  || opts[:method] || nil
      @autopwn_opts[:javascript]   = (opts[:javascript].nil?) ? true : opts[:javascript]
      @autopwn_opts[:os_name]      = opts[:os_name] || nil
      @autopwn_opts[:os_ver]       = opts[:os_ver]  || opts[:os_version] || nil
      @autopwn_opts[:postfix_html] = opts[:postfix_html] || nil
      @autopwn_opts[:prefix_html]  = opts[:prefix_html]  || nil
      @autopwn_opts[:vuln_test]    = opts[:vuln_test] || opts[:vulntest] || ""

      @autopwn_opts[:rank]         = opts[:rank] || @@autopwn_rank
    end
  end

end
end

