/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.control;

import java.util.List;
import org.parosproxy.paros.core.proxy.CacheProcessingItem;
import org.parosproxy.paros.core.proxy.ConnectRequestProxyListener;
import org.parosproxy.paros.core.proxy.OverrideMessageProxyListener;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.core.proxy.ProxyServerSSL;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.PersistentConnectionListener;
import org.zaproxy.zap.control.ControlOverrides;

public class Proxy {
    private Model model = null;
    private ProxyServer proxyServer = null;
    private ProxyServerSSL proxyServerSSL = null;
    private boolean reverseProxy = false;
    private String reverseProxyHost = "";
    private ControlOverrides overrides = null;

    public Proxy(Model model, ControlOverrides controlOverrides) {
        this.model = model;
        this.overrides = controlOverrides;
        this.proxyServer = new ProxyServer();
        this.proxyServer.setEnableApi(true);
        this.proxyServerSSL = new ProxyServerSSL();
        this.proxyServerSSL.setEnableApi(true);
    }

    public boolean startServer() {
        this.proxyServer.setProxyParam(this.model.getOptionsParam().getProxyParam());
        this.proxyServer.setConnectionParam(this.model.getOptionsParam().getConnectionParam());
        this.proxyServerSSL.setProxyParam(this.model.getOptionsParam().getProxyParam());
        this.proxyServerSSL.setConnectionParam(this.model.getOptionsParam().getConnectionParam());
        if (this.model.getOptionsParam().getProxyParam().isUseReverseProxy()) {
            this.proxyServerSSL.startServer(this.model.getOptionsParam().getProxyParam().getReverseProxyIp(), this.model.getOptionsParam().getProxyParam().getReverseProxyHttpsPort(), false);
            this.proxyServer.startServer(this.model.getOptionsParam().getProxyParam().getReverseProxyIp(), this.model.getOptionsParam().getProxyParam().getReverseProxyHttpPort(), false);
        } else {
            String string = null;
            int n = -1;
            if (this.overrides != null) {
                string = this.overrides.getProxyHost();
                n = this.overrides.getProxyPort();
                this.overrides = null;
            }
            if (string != null) {
                this.model.getOptionsParam().getProxyParam().setProxyIp(string);
            } else {
                string = this.model.getOptionsParam().getProxyParam().getRawProxyIP();
            }
            if (n > 0) {
                this.model.getOptionsParam().getProxyParam().setProxyPort(n);
            } else {
                n = this.model.getOptionsParam().getProxyParam().getProxyPort();
            }
            if (this.proxyServer.startServer(string, n, false) == -1) {
                return false;
            }
        }
        return true;
    }

    public void stopServer() {
        if (this.model.getOptionsParam().getProxyParam().isUseReverseProxy()) {
            this.proxyServerSSL.stopServer();
            this.proxyServer.stopServer();
        } else {
            this.proxyServer.stopServer();
        }
    }

    public void setSerialize(boolean bl) {
        this.proxyServer.setSerialize(bl);
        this.proxyServerSSL.setSerialize(bl);
    }

    public void addProxyListener(ProxyListener proxyListener) {
        this.proxyServer.addProxyListener(proxyListener);
        this.proxyServerSSL.addProxyListener(proxyListener);
    }

    public void removeProxyListener(ProxyListener proxyListener) {
        this.proxyServer.removeProxyListener(proxyListener);
        this.proxyServerSSL.removeProxyListener(proxyListener);
    }

    public void addOverrideMessageProxyListener(OverrideMessageProxyListener overrideMessageProxyListener) {
        this.proxyServer.addOverrideMessageProxyListener(overrideMessageProxyListener);
        this.proxyServerSSL.addOverrideMessageProxyListener(overrideMessageProxyListener);
    }

    public void removeOverrideMessageProxyListener(OverrideMessageProxyListener overrideMessageProxyListener) {
        this.proxyServer.removeOverrideMessageProxyListener(overrideMessageProxyListener);
        this.proxyServerSSL.removeOverrideMessageProxyListener(overrideMessageProxyListener);
    }

    public void addPersistentConnectionListener(PersistentConnectionListener persistentConnectionListener) {
        this.proxyServer.addPersistentConnectionListener(persistentConnectionListener);
        this.proxyServerSSL.addPersistentConnectionListener(persistentConnectionListener);
    }

    public void removePersistentConnectionListener(PersistentConnectionListener persistentConnectionListener) {
        this.proxyServer.removePersistentConnectionListener(persistentConnectionListener);
        this.proxyServerSSL.removePersistentConnectionListener(persistentConnectionListener);
    }

    public void addConnectRequestProxyListener(ConnectRequestProxyListener connectRequestProxyListener) {
        Proxy.validateListenerNotNull(connectRequestProxyListener);
        this.proxyServer.addConnectRequestProxyListener(connectRequestProxyListener);
        this.proxyServerSSL.addConnectRequestProxyListener(connectRequestProxyListener);
    }

    private static void validateListenerNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Parameter listener must not be null.");
        }
    }

    public void removeConnectRequestProxyListener(ConnectRequestProxyListener connectRequestProxyListener) {
        Proxy.validateListenerNotNull(connectRequestProxyListener);
        this.proxyServer.removeConnectRequestProxyListener(connectRequestProxyListener);
        this.proxyServerSSL.removeConnectRequestProxyListener(connectRequestProxyListener);
    }

    public boolean isReverseProxy() {
        return this.reverseProxy;
    }

    public void setReverseProxy(boolean bl) {
        this.reverseProxy = bl;
    }

    public String getReverseProxyHost() {
        return this.reverseProxyHost;
    }

    public void setReverseProxyHost(String string) {
        this.reverseProxyHost = string;
    }

    public void setEnableCacheProcessing(boolean bl) {
        if (this.proxyServer != null) {
            this.proxyServer.setEnableCacheProcessing(bl);
        }
        if (this.proxyServerSSL != null) {
            this.proxyServerSSL.setEnableCacheProcessing(bl);
        }
    }

    public void addCacheProcessingList(CacheProcessingItem cacheProcessingItem) {
        if (this.proxyServer != null) {
            this.proxyServer.addCacheProcessingList(cacheProcessingItem);
        }
        if (this.proxyServerSSL != null) {
            this.proxyServerSSL.addCacheProcessingList(cacheProcessingItem);
        }
    }

    public void setIgnoreList(List<String> list) {
        if (this.proxyServer != null) {
            this.proxyServer.setExcludeList(list);
        }
        if (this.proxyServerSSL != null) {
            this.proxyServerSSL.setExcludeList(list);
        }
    }
}

