/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.parosproxy.paros.core.scanner.VariantAbstractRPCQuery;

public class VariantDirectWebRemotingQuery
extends VariantAbstractRPCQuery {
    public static final String DWR_CONTENT_TYPE = "text/plain";
    private static final Pattern patternIgnoreScriptName = Pattern.compile("c[0-9]+-scriptName", 2);
    private static final Pattern patternIgnoreMethodName = Pattern.compile("c[0-9]+-methodName", 2);
    private static final Pattern patternIgnoreArray = Pattern.compile("Array:\\[.*\\]", 2);
    private static final Pattern patternIgnoreObject = Pattern.compile("Object_Object:\\{.*\\}", 2);
    private static final Pattern patternNumberValue = Pattern.compile("number:.+", 2);
    private static final Pattern patternStringValue = Pattern.compile("string:.*", 2);
    private static final Pattern patternBooleanValue = Pattern.compile("boolean:.+", 2);
    private static final Pattern patternNullValue = Pattern.compile("null:null", 2);

    @Override
    public boolean isValidContentType(String string) {
        return string.startsWith(DWR_CONTENT_TYPE);
    }

    @Override
    public String getEscapedValue(String string, boolean bl) {
        return StringEscapeUtils.escapeJava((String)string);
    }

    @Override
    public String getUnescapedValue(String string) {
        return StringEscapeUtils.unescapeJava((String)string);
    }

    @Override
    public void parseContent(String string) {
        int n = string.indexOf("\n");
        int n2 = 0;
        while (n > 0) {
            String string2 = string.substring(0, n);
            String[] stringArray = string2.split("=", 2);
            if (!patternIgnoreScriptName.matcher(stringArray[0]).matches() && !patternIgnoreMethodName.matcher(stringArray[0]).matches() && stringArray.length == 2) {
                if (stringArray[1] == null) {
                    stringArray[1] = "";
                }
                if (patternIgnoreArray.matcher(stringArray[1]).matches() || patternIgnoreObject.matcher(stringArray[1]).matches()) continue;
                int n3 = 0;
                String string3 = stringArray[1];
                if (patternNumberValue.matcher(stringArray[1]).matches() || patternStringValue.matcher(stringArray[1]).matches() || patternBooleanValue.matcher(stringArray[1]).matches() || patternNullValue.matcher(stringArray[1]).matches()) {
                    n3 = stringArray[1].indexOf(":") + 1;
                    string3 = stringArray[1].substring(n3);
                }
                int n4 = n2 + stringArray[0].length() + 1 + n3;
                int n5 = n2 + n;
                this.addParameter(stringArray[0], n4, n5, false, string3);
            }
            n2 += 1 + n;
            string = string.substring(n + 1);
            n = string.indexOf("\n");
        }
    }
}

