/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;

public class VariantODataFilterQuery
implements Variant {
    private static final Logger log = Logger.getLogger(VariantODataFilterQuery.class);
    private static final Pattern patternFilterParameters = Pattern.compile("\\$filter[ ]*=[ ]*([\\w\\s()',./\\-:]*)");
    private static final Pattern patternParameters = Pattern.compile("([\\w]+)\\s+(eq|ne|gt|ge|lt|le|and|or|not)\\s+([\\w'/]+)");
    private String beforeFilterExpression = null;
    private String afterFilterExpression = null;
    private Map<String, OperationParameter> mapParameters = Collections.emptyMap();

    @Override
    public void setMessage(HttpMessage httpMessage) {
        URI uRI = httpMessage.getRequestHeader().getURI();
        this.parse(uRI);
    }

    private void parse(URI uRI) {
        try {
            String string = uRI.getQuery();
            if (string != null) {
                Matcher matcher = patternFilterParameters.matcher(string);
                if (matcher.find()) {
                    String string2 = "";
                    string2 = matcher.group(1);
                    int n = string.indexOf(string2);
                    int n2 = n + string2.length();
                    this.beforeFilterExpression = string.substring(0, n);
                    this.afterFilterExpression = string.substring(n2);
                    this.mapParameters = new HashMap<String, OperationParameter>();
                    Matcher matcher2 = patternParameters.matcher(string2);
                    while (matcher2.find()) {
                        String string3 = matcher2.group(0);
                        String string4 = matcher2.group(1);
                        String string5 = matcher2.group(2);
                        String string6 = matcher2.group(3);
                        n = string2.indexOf(string3);
                        n2 = n + string3.length();
                        String string7 = string2.substring(0, n);
                        String string8 = string2.substring(n2);
                        OperationParameter operationParameter = new OperationParameter(string4, string5, string6, string7, string8);
                        this.mapParameters.put(operationParameter.getParameterName(), operationParameter);
                    }
                } else {
                    this.beforeFilterExpression = null;
                    this.afterFilterExpression = null;
                    this.mapParameters = Collections.emptyMap();
                }
            } else {
                this.beforeFilterExpression = null;
                this.afterFilterExpression = null;
                this.mapParameters = Collections.emptyMap();
            }
        }
        catch (URIException uRIException) {
            log.error((Object)(uRIException.getMessage() + uRI), (Throwable)uRIException);
        }
    }

    public Vector<NameValuePair> getParamList() {
        Vector<NameValuePair> vector = new Vector<NameValuePair>(this.mapParameters.values().size());
        int n = 1;
        for (OperationParameter operationParameter : this.mapParameters.values()) {
            vector.add(new NameValuePair(1, operationParameter.getParameterName(), operationParameter.getValue(), n++));
        }
        return vector;
    }

    @Override
    public String setParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        OperationParameter operationParameter = this.mapParameters.get(string);
        if (operationParameter != null) {
            String string3 = operationParameter.getModifiedFilter(string2);
            String string4 = this.beforeFilterExpression + string3 + this.afterFilterExpression;
            try {
                httpMessage.getRequestHeader().getURI().setQuery(string4);
            }
            catch (NullPointerException | URIException throwable) {
                log.error((Object)("Exception with the modified query " + string4), throwable);
            }
            return string3;
        }
        return null;
    }

    @Override
    public String setEscapedParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, nameValuePair, string, string2);
    }

    static class OperationParameter {
        private String paramName;
        private String operator;
        private String originalValue;
        private String stringBeforeOperation;
        private String stringAfterOperation;

        public OperationParameter(String string, String string2, String string3, String string4, String string5) {
            this.paramName = string;
            this.operator = string2;
            this.originalValue = string3;
            this.stringBeforeOperation = string4;
            this.stringAfterOperation = string5;
        }

        public String getValue() {
            return this.originalValue;
        }

        public String getParameterName() {
            return this.paramName;
        }

        public String getModifiedFilter(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.stringBeforeOperation).append(this.paramName).append(' ').append(this.operator).append(' ').append(string).append(this.stringAfterOperation);
            return stringBuilder.toString();
        }
    }
}

