/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.eventBus.EventConsumer;
import org.zaproxy.zap.extension.alert.AlertEventPublisher;
import org.zaproxy.zap.view.table.AbstractCustomColumnHistoryReferencesTableModel;
import org.zaproxy.zap.view.table.AbstractHistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.DefaultHistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;

class SpiderMessagesTableModel
extends AbstractCustomColumnHistoryReferencesTableModel<SpiderTableEntry> {
    private static final long serialVersionUID = 1093393768186896931L;
    private static final HistoryReferencesTableModel.Column[] COLUMNS = new HistoryReferencesTableModel.Column[]{HistoryReferencesTableModel.Column.CUSTOM, HistoryReferencesTableModel.Column.HREF_ID, HistoryReferencesTableModel.Column.REQUEST_TIMESTAMP, HistoryReferencesTableModel.Column.RESPONSE_TIMESTAMP, HistoryReferencesTableModel.Column.METHOD, HistoryReferencesTableModel.Column.URL, HistoryReferencesTableModel.Column.STATUS_CODE, HistoryReferencesTableModel.Column.STATUS_REASON, HistoryReferencesTableModel.Column.RTT, HistoryReferencesTableModel.Column.SIZE_REQUEST_HEADER, HistoryReferencesTableModel.Column.SIZE_REQUEST_BODY, HistoryReferencesTableModel.Column.SIZE_RESPONSE_HEADER, HistoryReferencesTableModel.Column.SIZE_RESPONSE_BODY, HistoryReferencesTableModel.Column.HIGHEST_ALERT, HistoryReferencesTableModel.Column.TAGS};
    private static final String[] CUSTOM_COLUMN_NAMES = new String[]{Constant.messages.getString("spider.table.messages.header.processed")};
    private static final ProcessedCellItem SUCCESSFULLY_PROCESSED_CELL_ITEM = new ProcessedCellItem(true, Constant.messages.getString("spider.table.messages.column.processed.successfully"));
    private static final ProcessedCellItem IO_ERROR_CELL_ITEM = new ProcessedCellItem(false, Constant.messages.getString("spider.table.messages.column.processed.ioerror"));
    private final ExtensionHistory extensionHistory;
    private AlertEventConsumer alertEventConsumer;
    private List<SpiderTableEntry> resources = new ArrayList<SpiderTableEntry>();
    private Map<Integer, Integer> idsToRows = new HashMap<Integer, Integer>();

    public SpiderMessagesTableModel() {
        this(true);
    }

    public SpiderMessagesTableModel(boolean bl) {
        super(COLUMNS);
        if (bl) {
            this.alertEventConsumer = new AlertEventConsumer();
            this.extensionHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
            ZAP.getEventBus().registerConsumer(this.alertEventConsumer, AlertEventPublisher.getPublisher().getPublisherName());
        } else {
            this.alertEventConsumer = null;
            this.extensionHistory = null;
        }
    }

    @Override
    public void addEntry(SpiderTableEntry spiderTableEntry) {
    }

    public void addHistoryReference(HistoryReference historyReference, boolean bl) {
        HistoryReference historyReference2 = historyReference;
        if (this.extensionHistory != null) {
            historyReference2 = this.extensionHistory.getHistoryReference(historyReference.getHistoryId());
        }
        final SpiderTableEntry spiderTableEntry = new SpiderTableEntry(historyReference2, bl);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = SpiderMessagesTableModel.this.resources.size();
                SpiderMessagesTableModel.this.idsToRows.put(Integer.valueOf(spiderTableEntry.getHistoryId()), n);
                SpiderMessagesTableModel.this.resources.add(spiderTableEntry);
                SpiderMessagesTableModel.this.fireTableRowsInserted(n, n);
            }
        });
    }

    @Override
    public void clear() {
        this.resources = new ArrayList<SpiderTableEntry>();
        this.idsToRows = new HashMap<Integer, Integer>();
        this.fireTableDataChanged();
        if (this.alertEventConsumer != null) {
            ZAP.getEventBus().unregisterConsumer(this.alertEventConsumer, AlertEventPublisher.getPublisher().getPublisherName());
            this.alertEventConsumer = null;
        }
    }

    @Override
    public void refreshEntryRow(int n) {
        SpiderTableEntry spiderTableEntry = this.getEntryWithHistoryId(n);
        if (spiderTableEntry != null) {
            int n2 = this.getEntryRowIndex(n);
            this.getEntryWithHistoryId(n).refreshCachedValues();
            this.fireTableRowsUpdated(n2, n2);
        }
    }

    @Override
    public void removeEntry(int n) {
    }

    @Override
    public SpiderTableEntry getEntry(int n) {
        return this.resources.get(n);
    }

    @Override
    public SpiderTableEntry getEntryWithHistoryId(int n) {
        int n2 = this.getEntryRowIndex(n);
        if (n2 != -1) {
            return this.resources.get(n2);
        }
        return null;
    }

    @Override
    public int getEntryRowIndex(int n) {
        Integer n2 = this.idsToRows.get(n);
        if (n2 != null) {
            return n2;
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        return this.resources.size();
    }

    @Override
    protected Class<?> getColumnClass(HistoryReferencesTableModel.Column column) {
        return AbstractHistoryReferencesTableEntry.getColumnClass(column);
    }

    @Override
    protected Object getPrototypeValue(HistoryReferencesTableModel.Column column) {
        return AbstractHistoryReferencesTableEntry.getPrototypeValue(column);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == -1) {
            return this.getEntry(n);
        }
        return super.getValueAt(n, n2);
    }

    @Override
    protected Object getCustomValueAt(SpiderTableEntry spiderTableEntry, int n) {
        if (this.getCustomColumnIndex(n) == 0) {
            return spiderTableEntry.isIoError() ? IO_ERROR_CELL_ITEM : SUCCESSFULLY_PROCESSED_CELL_ITEM;
        }
        return null;
    }

    @Override
    protected String getCustomColumnName(int n) {
        return CUSTOM_COLUMN_NAMES[this.getCustomColumnIndex(n)];
    }

    @Override
    protected Class<?> getCustomColumnClass(int n) {
        if (this.getCustomColumnIndex(n) == 0) {
            return ProcessedCellItem.class;
        }
        return null;
    }

    @Override
    protected Object getCustomPrototypeValue(int n) {
        if (this.getCustomColumnIndex(n) == 0) {
            return "Successful";
        }
        return null;
    }

    private void refreshEntryRows() {
        if (this.resources.isEmpty()) {
            return;
        }
        for (SpiderTableEntry spiderTableEntry : this.resources) {
            spiderTableEntry.refreshCachedValues();
        }
        this.fireTableChanged(new TableModelEvent(this, 0, this.resources.size() - 1, this.getColumnIndex(HistoryReferencesTableModel.Column.HIGHEST_ALERT), 0));
    }

    private class AlertEventConsumer
    implements EventConsumer {
        private AlertEventConsumer() {
        }

        @Override
        public void eventReceived(Event event) {
            switch (event.getEventType()) {
                case "alert.added": 
                case "alert.changed": 
                case "alert.removed": {
                    this.refreshEntry(Integer.valueOf(event.getParameters().get("historyId")));
                    break;
                }
                default: {
                    this.refreshEntries();
                }
            }
        }

        private void refreshEntry(final int n) {
            if (EventQueue.isDispatchThread()) {
                SpiderMessagesTableModel.this.refreshEntryRow(n);
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlertEventConsumer.this.refreshEntry(n);
                }
            });
        }

        private void refreshEntries() {
            if (EventQueue.isDispatchThread()) {
                SpiderMessagesTableModel.this.refreshEntryRows();
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlertEventConsumer.this.refreshEntries();
                }
            });
        }
    }

    static class ProcessedCellItem
    implements Comparable<ProcessedCellItem> {
        private final boolean successful;
        private final String label;

        public ProcessedCellItem(boolean bl, String string) {
            this.successful = bl;
            this.label = string;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label;
        }

        public int hashCode() {
            return 31 * (this.successful ? 1231 : 1237);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ProcessedCellItem processedCellItem = (ProcessedCellItem)object;
            return this.successful == processedCellItem.successful;
        }

        @Override
        public int compareTo(ProcessedCellItem processedCellItem) {
            if (processedCellItem == null) {
                return 1;
            }
            if (this.successful && !processedCellItem.successful) {
                return 1;
            }
            if (!this.successful && processedCellItem.successful) {
                return -1;
            }
            return this.label.compareTo(processedCellItem.label);
        }
    }

    static class SpiderTableEntry
    extends DefaultHistoryReferencesTableEntry {
        private final boolean ioError;

        public SpiderTableEntry(HistoryReference historyReference, boolean bl) {
            super(historyReference, COLUMNS);
            this.ioError = bl;
        }

        public boolean isIoError() {
            return this.ioError;
        }
    }
}

