/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http.spnego;

import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import sun.net.www.protocol.http.HttpCallerInfo;

public class NegotiateCallbackHandler
implements CallbackHandler {
    private String username;
    private char[] password;
    private boolean answered;
    private final HttpCallerInfo hci;

    public NegotiateCallbackHandler(HttpCallerInfo hci) {
        this.hci = hci;
    }

    private void getAnswer() {
        if (!this.answered) {
            this.answered = true;
            PasswordAuthentication passAuth = Authenticator.requestPasswordAuthentication(this.hci.host, this.hci.addr, this.hci.port, this.hci.protocol, this.hci.prompt, this.hci.scheme, this.hci.url, this.hci.authType);
            if (passAuth != null) {
                this.username = passAuth.getUserName();
                this.password = passAuth.getPassword();
            }
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException, IOException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callBack = callbacks[i];
            if (callBack instanceof NameCallback) {
                this.getAnswer();
                ((NameCallback)callBack).setName(this.username);
                continue;
            }
            if (callBack instanceof PasswordCallback) {
                this.getAnswer();
                ((PasswordCallback)callBack).setPassword(this.password);
                if (this.password == null) continue;
                Arrays.fill(this.password, ' ');
                continue;
            }
            throw new UnsupportedCallbackException(callBack, "Call back not supported");
        }
    }
}

