/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.bib2gls.GroupTitle;
import com.dickimawbooks.bib2gls.OtherGroupTitle;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.util.Comparator;
import java.util.Vector;

public class Bib2GlsEntryLetterComparator
implements Comparator<Bib2GlsEntry> {
    private String sortField;
    private Bib2Gls bib2gls;
    private Vector<Bib2GlsEntry> entries;
    private boolean ignoreCase;
    private boolean reverse;

    public Bib2GlsEntryLetterComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, String string, String string2, boolean bl, boolean bl2) {
        this.sortField = string2;
        this.bib2gls = bib2Gls;
        this.entries = vector;
        this.ignoreCase = bl;
        this.reverse = bl2;
    }

    private String updateSortValue(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector) {
        int n;
        Object object;
        String string = bib2GlsEntry.getId();
        String string2 = null;
        if (this.sortField.equals("id")) {
            string2 = string;
        } else {
            string2 = bib2GlsEntry.getFieldValue(this.sortField);
            object = bib2GlsEntry.getField(this.sortField);
            if (string2 == null) {
                string2 = bib2GlsEntry.getFallbackValue(this.sortField);
                object = bib2GlsEntry.getFallbackContents(this.sortField);
            }
            if (string2 == null) {
                string2 = string;
                this.bib2gls.debug(this.bib2gls.getMessage("warning.no.default.sort", string));
            } else if (this.bib2gls.useInterpreter() && object != null && string2.matches(".*[\\\\\\$\\{\\}].*")) {
                string2 = this.bib2gls.interpret(string2, (BibValueList)object);
            }
        }
        if (this.ignoreCase) {
            string2 = string2.toLowerCase();
        }
        bib2GlsEntry.putField("sort", string2);
        object = null;
        if (this.bib2gls.useGroupField() && string2.length() > 0) {
            int n2 = string2.codePointAt(0);
            String string3 = n2 > 65535 ? String.format("%c%c", Character.valueOf(Character.highSurrogate(n2)), Character.valueOf(Character.lowSurrogate(n2))) : String.format("%c", n2);
            if (bib2GlsEntry.getFieldValue("group") == null) {
                String string4;
                Object object2;
                Object object3;
                if (Character.isAlphabetic(n2)) {
                    object = this.ignoreCase ? string3.toUpperCase() : string3;
                    n = ((String)object).codePointAt(0);
                    object3 = this.bib2gls.getCurrentResource();
                    object2 = ((GlsResource)object3).getGroupTitle(bib2GlsEntry, n);
                    if (object2 == null) {
                        object2 = new GroupTitle((String)object, string3, n, ((GlsResource)object3).getType(bib2GlsEntry));
                        ((GlsResource)object3).putGroupTitle((GroupTitle)object2);
                        string4 = ((GroupTitle)object2).toString();
                    } else {
                        String string5 = ((GlsResource)object3).getType(bib2GlsEntry);
                        string4 = ((GroupTitle)object2).format(string3);
                    }
                    bib2GlsEntry.putField("group", String.format("\\%s%s", ((GroupTitle)object2).getCsLabelName(), string4));
                } else {
                    GlsResource glsResource;
                    if (string3.equals("\\") || string3.equals("{") || string3.equals("}")) {
                        string3 = "\\char`\\" + string3;
                    }
                    if ((object3 = (glsResource = this.bib2gls.getCurrentResource()).getGroupTitle(bib2GlsEntry, n2)) == null) {
                        string4 = glsResource.getType(bib2GlsEntry);
                        object3 = new OtherGroupTitle(string3, n2, string4);
                        glsResource.putGroupTitle((GroupTitle)object3);
                        object2 = ((GroupTitle)object3).toString();
                    } else {
                        object2 = ((GroupTitle)object3).format(string3);
                    }
                    bib2GlsEntry.putField("group", String.format("\\%s%s", ((GroupTitle)object3).getCsLabelName(), object2));
                }
            }
        }
        if (this.bib2gls.getVerboseLevel() > 0) {
            int n3;
            StringBuilder stringBuilder = new StringBuilder();
            n = string2.length();
            for (int i = 0; i < n; i += Character.charCount(n3)) {
                n3 = string2.codePointAt(i);
                if (stringBuilder.length() == 0) {
                    stringBuilder.append(n3);
                    continue;
                }
                stringBuilder.append(' ');
                stringBuilder.append(n3);
            }
            if (object == null) {
                this.bib2gls.verbose(String.format("%s -> '%s' [%s]", string, string2, stringBuilder));
            } else {
                this.bib2gls.verbose(String.format("%s -> '%s' (%s) [%s]", string, string2, object, stringBuilder));
            }
        }
        return string2;
    }

    @Override
    protected int compare(String string, String string2) {
        int n;
        int n2;
        int n3 = string.length();
        int n4 = string2.length();
        int n5 = 0;
        for (int i = 0; n5 < n3 && i < n4; n5 += Character.charCount(n2), i += Character.charCount(n)) {
            n2 = string.codePointAt(n5);
            n = string2.codePointAt(i);
            if (n2 >= n) continue;
            return this.reverse ? 1 : -1;
        }
        if (n3 < n4) {
            return this.reverse ? 1 : -1;
        }
        if (n4 > n3) {
            return this.reverse ? -1 : 1;
        }
        return 0;
    }

    @Override
    public int compare(Bib2GlsEntry bib2GlsEntry, Bib2GlsEntry bib2GlsEntry2) {
        if (this.bib2gls.getCurrentResource().flattenSort()) {
            return this.compare(bib2GlsEntry.getFieldValue("sort"), bib2GlsEntry2.getFieldValue("sort"));
        }
        int n = bib2GlsEntry.getHierarchyCount();
        int n2 = bib2GlsEntry2.getHierarchyCount();
        int n3 = Integer.min(n, n2);
        if (n == n2 && bib2GlsEntry.getId().equals(bib2GlsEntry2.getId())) {
            return 0;
        }
        for (int i = 0; i < n3; ++i) {
            Bib2GlsEntry bib2GlsEntry3 = bib2GlsEntry.getHierarchyElement(i);
            Bib2GlsEntry bib2GlsEntry4 = bib2GlsEntry2.getHierarchyElement(i);
            int n4 = this.compare(bib2GlsEntry3.getFieldValue("sort"), bib2GlsEntry4.getFieldValue("sort"));
            if (n4 == 0) continue;
            return n4;
        }
        if (n == n2) {
            return 0;
        }
        if (this.reverse) {
            return n < n2 ? 1 : -1;
        }
        return n < n2 ? -1 : 1;
    }

    public void sortEntries() throws Bib2GlsException {
        for (Bib2GlsEntry bib2GlsEntry : this.entries) {
            bib2GlsEntry.updateHierarchy(this.entries);
            this.updateSortValue(bib2GlsEntry, this.entries);
        }
        this.entries.sort(this);
    }
}

