/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.Hashtable;
import java.util.Vector;

class ACLWindow
extends FixedFrame
implements CbButtonCallback,
MultiColumnCallback {
    FileManager filemgr;
    RemoteFile file;
    Vector acllist = new Vector();
    Hashtable edmap = new Hashtable();
    CbButton ok;
    CbButton cancel;
    CbButton add;
    Choice addtype;
    MultiColumn acltable;
    String[] acltypes = new String[]{"user", "group", "mask", "default user", "default group", "default other", "default mask"};

    ACLWindow(FileManager fileManager, RemoteFile remoteFile) {
        super(400, 300);
        this.setTitle(fileManager.text("eacl_title", remoteFile.path));
        this.filemgr = fileManager;
        this.file = remoteFile;
        String[] stringArray = this.filemgr.get_text("getfacl.cgi?file=" + FileManager.urlize(this.file.path));
        if (stringArray[0].length() != 0) {
            new ErrorWindow(this.filemgr.text("eacl_eacls", stringArray[0]));
            return;
        }
        this.setLayout(new BorderLayout());
        String[] stringArray2 = new String[]{this.filemgr.text("eacl_acltype"), this.filemgr.text("eacl_aclname"), this.filemgr.text("eacl_aclperms")};
        this.acltable = new MultiColumn(stringArray2, this);
        for (int i = 1; i < stringArray.length; ++i) {
            ACLEntry aCLEntry = new ACLEntry(stringArray[i], this);
            this.acllist.addElement(aCLEntry);
            this.acltable.addItem(aCLEntry.getRow());
        }
        this.add("Center", this.acltable);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.add = new CbButton(this.filemgr.get_image("add.gif"), this.filemgr.text("eacl_add"), 0, this);
        panel.add(this.add);
        int n = this.file.type == 0 ? this.acltypes.length : 3;
        this.addtype = new Choice();
        panel.add(this.addtype);
        for (int i = 0; i < n; ++i) {
            String string = "acltype_" + this.acltypes[i].replace(' ', '_');
            this.addtype.addItem(this.filemgr.text(string));
        }
        panel.add(new Label(" "));
        this.ok = new CbButton(this.filemgr.get_image("save.gif"), this.filemgr.text("save"), 0, this);
        panel.add(this.ok);
        this.cancel = new CbButton(this.filemgr.get_image("cancel.gif"), this.filemgr.text("cancel"), 0, this);
        panel.add(this.cancel);
        this.add("South", panel);
        Util.recursiveBody(this);
        this.pack();
        this.show();
    }

    public void click(CbButton cbButton) {
        if (cbButton == this.ok) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            for (int i = 0; i < this.acllist.size(); ++i) {
                ACLEntry aCLEntry = (ACLEntry)this.acllist.elementAt(i);
                if (aCLEntry.def) {
                    bl = true;
                }
                if (!aCLEntry.def || aCLEntry.owner != null) continue;
                if (aCLEntry.type.equals("user")) {
                    bl2 = true;
                }
                if (aCLEntry.type.equals("group")) {
                    bl3 = true;
                }
                if (!aCLEntry.type.equals("other")) continue;
                bl4 = true;
            }
            if (!(!bl || bl2 && bl3 && bl4)) {
                new ErrorWindow(this.filemgr.text("eacl_edefaults"));
                return;
            }
            String string = "";
            for (int i = 0; i < this.acllist.size(); ++i) {
                string = string + (ACLEntry)this.acllist.elementAt(i) + "\n";
            }
            String[] stringArray = this.filemgr.get_text("setfacl.cgi?file=" + FileManager.urlize(this.file.path) + "&acl=" + FileManager.urlize(string));
            if (stringArray[0].length() > 0) {
                new ErrorWindow(this.filemgr.text("eacl_efailed", this.file.path, stringArray[0]));
            } else {
                this.dispose();
            }
        } else if (cbButton == this.add) {
            int n;
            String string;
            String string2 = this.acltypes[this.addtype.getSelectedIndex()];
            boolean bl = string2.startsWith(string = "default ");
            if (bl) {
                string2 = string2.substring(string.length());
            }
            if (string2.equals("mask")) {
                for (n = 0; n < this.acllist.size(); ++n) {
                    ACLEntry aCLEntry = (ACLEntry)this.acllist.elementAt(n);
                    if (!aCLEntry.type.equals(string2) || aCLEntry.def != bl) continue;
                    new ErrorWindow(this.filemgr.text(bl ? "eacl_edefmask" : "eacl_emask"));
                    return;
                }
            }
            n = 0;
            for (int i = 0; i < this.acllist.size(); ++i) {
                ACLEntry aCLEntry = (ACLEntry)this.acllist.elementAt(i);
                if (!aCLEntry.type.equals("mask") && !aCLEntry.type.equals("other") || !aCLEntry.empty_owner) continue;
                n = 1;
            }
            new ACLEditor(this, string2, bl, n != 0);
        } else if (cbButton == this.cancel) {
            this.dispose();
        }
    }

    public void doubleClick(MultiColumn multiColumn, int n) {
        int n2 = multiColumn.selected();
        if (n2 >= 0) {
            ACLEntry aCLEntry = (ACLEntry)this.acllist.elementAt(n2);
            ACLEditor aCLEditor = (ACLEditor)this.edmap.get(aCLEntry);
            if (aCLEditor == null) {
                this.edmap.put(aCLEntry, new ACLEditor(this, aCLEntry));
            } else {
                aCLEditor.toFront();
                aCLEditor.requestFocus();
            }
        }
    }

    public void singleClick(MultiColumn multiColumn, int n) {
    }

    public void headingClicked(MultiColumn multiColumn, int n) {
    }
}

