/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.lucene.spatial3d.geom.GeoBBox;
import org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.apache.lucene.spatial3d.geom.GeoBaseBBox;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.Membership;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.lucene.spatial3d.geom.Vector;

class GeoNorthLatitudeZone
extends GeoBaseBBox {
    protected final double bottomLat;
    protected final double cosBottomLat;
    protected final SidedPlane bottomPlane;
    protected final GeoPoint interiorPoint;
    protected static final GeoPoint[] planePoints = new GeoPoint[0];
    protected final GeoPoint bottomBoundaryPoint;
    protected final GeoPoint[] edgePoints;

    public GeoNorthLatitudeZone(PlanetModel planetModel, double bottomLat) {
        super(planetModel);
        this.bottomLat = bottomLat;
        double sinBottomLat = Math.sin(bottomLat);
        this.cosBottomLat = Math.cos(bottomLat);
        double middleLat = (1.5707963267948966 + bottomLat) * 0.5;
        double sinMiddleLat = Math.sin(middleLat);
        this.interiorPoint = new GeoPoint(planetModel, sinMiddleLat, 0.0, Math.sqrt(1.0 - sinMiddleLat * sinMiddleLat), 1.0);
        this.bottomBoundaryPoint = new GeoPoint(planetModel, sinBottomLat, 0.0, Math.sqrt(1.0 - sinBottomLat * sinBottomLat), 1.0);
        this.bottomPlane = new SidedPlane((Vector)this.interiorPoint, planetModel, sinBottomLat);
        this.edgePoints = new GeoPoint[]{this.bottomBoundaryPoint};
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = 1.5707963267948966;
        double newBottomLat = this.bottomLat - angle;
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, 1.5707963267948966, newBottomLat, -Math.PI, Math.PI);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.bottomPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        if (this.bottomLat < 0.0) {
            return Math.PI;
        }
        double maxCosLat = this.cosBottomLat;
        return maxCosLat * Math.PI;
    }

    @Override
    public GeoPoint getCenter() {
        return this.interiorPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.bottomPlane, notablePoints, planePoints, bounds, new Membership[0]);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.addHorizontalPlane(this.planetModel, this.bottomLat, this.bottomPlane, new Membership[0]);
    }

    @Override
    public int getRelationship(GeoShape path) {
        int insideRectangle = this.isShapeInsideBBox(path);
        if (insideRectangle == 1) {
            return 2;
        }
        boolean insideShape = path.isWithin(this.bottomBoundaryPoint);
        if (insideRectangle == 0 && insideShape) {
            return 2;
        }
        if (path.intersects(this.bottomPlane, planePoints, new Membership[0])) {
            return 2;
        }
        if (insideShape) {
            return 0;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        return 3;
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        return distanceStyle.computeDistance(this.planetModel, (Plane)this.bottomPlane, x, y, z, new Membership[0]);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoNorthLatitudeZone)) {
            return false;
        }
        GeoNorthLatitudeZone other = (GeoNorthLatitudeZone)o;
        return super.equals(other) && other.bottomBoundaryPoint.equals(this.bottomBoundaryPoint);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.bottomBoundaryPoint.hashCode();
        return result;
    }

    public String toString() {
        return "GeoNorthLatitudeZone: {planetmodel=" + this.planetModel + ", bottomlat=" + this.bottomLat + "(" + this.bottomLat * 180.0 / Math.PI + ")}";
    }
}

