/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.percolator.PercolateQuery;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightPhase;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.SubSearchContext;

final class PercolatorHighlightSubFetchPhase
implements FetchSubPhase {
    private final HighlightPhase highlightPhase;

    PercolatorHighlightSubFetchPhase(Settings settings, Map<String, Highlighter> highlighters) {
        this.highlightPhase = new HighlightPhase(settings, highlighters);
    }

    boolean hitsExecutionNeeded(SearchContext context) {
        return context.highlight() != null && PercolatorHighlightSubFetchPhase.locatePercolatorQuery(context.query()) != null;
    }

    public void hitsExecute(SearchContext context, SearchHit[] hits) {
        if (!this.hitsExecutionNeeded(context)) {
            return;
        }
        PercolateQuery percolateQuery = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(context.query());
        if (percolateQuery == null) {
            throw new IllegalStateException("couldn't locate percolator query");
        }
        List ctxs = context.searcher().getIndexReader().leaves();
        IndexSearcher percolatorIndexSearcher = percolateQuery.getPercolatorIndexSearcher();
        PercolateQuery.QueryStore queryStore = percolateQuery.getQueryStore();
        LeafReaderContext percolatorLeafReaderContext = (LeafReaderContext)percolatorIndexSearcher.getIndexReader().leaves().get(0);
        FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext();
        SubSearchContext subSearchContext = this.createSubSearchContext(context, percolatorLeafReaderContext, percolateQuery.getDocumentSource());
        for (SearchHit hit : hits) {
            Query query;
            try {
                LeafReaderContext ctx = (LeafReaderContext)ctxs.get(ReaderUtil.subIndex((int)hit.docId(), (List)ctxs));
                int segmentDocId = hit.docId() - ctx.docBase;
                query = (Query)queryStore.getQueries(ctx).apply((Object)segmentDocId);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (query == null) continue;
            subSearchContext.parsedQuery(new ParsedQuery(query));
            hitContext.reset(new SearchHit(0, "unknown", new Text(percolateQuery.getDocumentType()), Collections.emptyMap()), percolatorLeafReaderContext, 0, percolatorIndexSearcher);
            hitContext.cache().clear();
            this.highlightPhase.hitExecute((SearchContext)subSearchContext, hitContext);
            hit.getHighlightFields().putAll(hitContext.hit().getHighlightFields());
        }
    }

    static PercolateQuery locatePercolatorQuery(Query query) {
        if (query instanceof PercolateQuery) {
            return (PercolateQuery)query;
        }
        if (query instanceof BooleanQuery) {
            for (BooleanClause clause : ((BooleanQuery)query).clauses()) {
                PercolateQuery result = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(clause.getQuery());
                if (result == null) continue;
                return result;
            }
        } else if (query instanceof DisjunctionMaxQuery) {
            for (Query disjunct : ((DisjunctionMaxQuery)query).getDisjuncts()) {
                PercolateQuery result = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(disjunct);
                if (result == null) continue;
                return result;
            }
        } else {
            if (query instanceof ConstantScoreQuery) {
                return PercolatorHighlightSubFetchPhase.locatePercolatorQuery(((ConstantScoreQuery)query).getQuery());
            }
            if (query instanceof BoostQuery) {
                return PercolatorHighlightSubFetchPhase.locatePercolatorQuery(((BoostQuery)query).getQuery());
            }
            if (query instanceof FunctionScoreQuery) {
                return PercolatorHighlightSubFetchPhase.locatePercolatorQuery(((FunctionScoreQuery)query).getSubQuery());
            }
        }
        return null;
    }

    private SubSearchContext createSubSearchContext(SearchContext context, LeafReaderContext leafReaderContext, BytesReference source) {
        SubSearchContext subSearchContext = new SubSearchContext(context);
        subSearchContext.highlight(new SearchContextHighlight(context.highlight().fields()));
        subSearchContext.highlight().globalForceSource(true);
        subSearchContext.lookup().source().setSegmentAndDocument(leafReaderContext, 0);
        subSearchContext.lookup().source().setSource(source);
        return subSearchContext;
    }
}

