/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.tasks.TaskId;

public class DeleteByQueryRequest
extends AbstractBulkByScrollRequest<DeleteByQueryRequest>
implements IndicesRequest.Replaceable {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(DeleteByQueryRequest.class));

    public DeleteByQueryRequest() {
    }

    public DeleteByQueryRequest(SearchRequest search) {
        this(search, true);
    }

    private DeleteByQueryRequest(SearchRequest search, boolean setDefaults) {
        super(search, setDefaults);
        if (setDefaults) {
            search.source().fetchSource(false);
        }
    }

    @Override
    protected DeleteByQueryRequest self() {
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException e = super.validate();
        if (this.getSearchRequest().indices() == null || this.getSearchRequest().indices().length == 0) {
            e = ValidateActions.addValidationError("use _all if you really want to delete from all existing indexes", e);
        }
        if (this.getSearchRequest() == null || this.getSearchRequest().source() == null) {
            e = ValidateActions.addValidationError("source is missing", e);
        } else if (this.getSearchRequest().source().query() == null) {
            DEPRECATION_LOGGER.deprecated("A request to _delete_by_query without an explicit query is deprecated. Specify a query explicitly instead.", new Object[0]);
        }
        return e;
    }

    @Override
    public DeleteByQueryRequest forSlice(TaskId slicingTask, SearchRequest slice) {
        return this.doForSlice(new DeleteByQueryRequest(slice, false), slicingTask);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("delete-by-query ");
        this.searchToString(b);
        return b.toString();
    }

    @Override
    public IndicesRequest indices(String ... indices) {
        assert (this.getSearchRequest() != null);
        this.getSearchRequest().indices(indices);
        return this;
    }

    @Override
    public String[] indices() {
        assert (this.getSearchRequest() != null);
        return this.getSearchRequest().indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        assert (this.getSearchRequest() != null);
        return this.getSearchRequest().indicesOptions();
    }

    public String[] types() {
        assert (this.getSearchRequest() != null);
        return this.getSearchRequest().types();
    }

    public DeleteByQueryRequest types(String ... types) {
        assert (this.getSearchRequest() != null);
        this.getSearchRequest().types(types);
        return this;
    }
}

