

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:MiniHomer, a skyTraq Venus 6 based logger (download tracks, waypoints and get/set POI) (miniHomer){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">MiniHomer, a skyTraq Venus 6 based logger (download tracks, waypoints and get/set POI) (miniHomer)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="fmt_s_and_t.html">Prev</a> </td><th width="60%" align="center">Chapter 3. The Formats</th><td width="20%" align="right"> <a accesskey="n" href="fmt_garmin_xt.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="fmt_miniHomer"></a>MiniHomer, a skyTraq Venus 6 based logger (download tracks, waypoints and get/set POI) (miniHomer)</h2></div></div></div><p class="fmtcapshdr">
    This format can...
    </p><div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p class="fmtcapsitem">
          read waypoints
        </p></li><li class="listitem"><p class="fmtcapsitem">
          read tracks
        </p></li></ul></div><p>This format has the following options: <a class="link" href="fmt_miniHomer.html#fmt_miniHomer_o_baud" title="baud option">baud</a>, <a class="link" href="fmt_miniHomer.html#fmt_miniHomer_o_dump-file" title="dump-file option">dump-file</a>, <a class="link" href="fmt_miniHomer.html#fmt_miniHomer_o_erase" title="erase option">erase</a>, <a class="link" href="fmt_miniHomer.html#fmt_miniHomer_o_first-sector" title="first-sector option">first-sector</a>, <a class="link" href="fmt_miniHomer.html#fmt_miniHomer_o_initbaud" title="initbaud option">initbaud</a>, <a class="link" href="fmt_miniHomer.html#fmt_miniHomer_o_last-sector" title="last-sector option">last-sector</a>, <a class="link" href="fmt_miniHomer.html#fmt_miniHomer_o_no-output" title="no-output option">no-output</a>, <a class="link" href="fmt_miniHomer.html#fmt_miniHomer_o_read-at-once" title="read-at-once option">read-at-once</a>, <a class="link" href="fmt_miniHomer.html#fmt_miniHomer_o_Home" title="Home option">Home</a>, <a class="link" href="fmt_miniHomer.html#fmt_miniHomer_o_Car" title="Car option">Car</a>, <a class="link" href="fmt_miniHomer.html#fmt_miniHomer_o_Boat" title="Boat option">Boat</a>, <a class="link" href="fmt_miniHomer.html#fmt_miniHomer_o_Heart" title="Heart option">Heart</a>, <a class="link" href="fmt_miniHomer.html#fmt_miniHomer_o_Bar" title="Bar option">Bar</a> .</p><p>
Serial download protocol for GPS data loggers called "miniHomer". 
These loggers are based on Skytraq Venus 5 and Venus 6 chipsets, but with modified firmware.
The miniHomer logger has five POI (or better: Point-to-Return, PTR?), which can be set programatically. The miniHomer module in gpsbabel is an extension of the skytraq module. 
</p><p>
Following a list of devices which should be supported by this module
(Note that not all of them have actually been tested, so if you can confirm that additional models work, please mail the gpsbabel-misc group with your success, tips, and any pertinent links for your model.)
</p><div class="table"><a id="miniHomer_devices"></a><p class="title"><strong>Table 3.5. Devices supported by miniHomer module</strong></p><div class="table-contents"><table class="table" summary="Devices supported by miniHomer module" border="1"><colgroup><col /><col /><col /><col /></colgroup><thead><tr><th>Manufacturer</th><th>Model</th><th>USB (baud)</th><th>Bluetooth (baud)</th></tr></thead><tbody><tr><td>
  	<a class="ulink" href="http://navin.com.tw/miniHomer.htm" target="_top"> Navin </a>
  	<a class="ulink" href="http://www.znex.de/minihomer-details.html" target="_top">Z:NEX</a>
  </td><td>miniHomer</td><td>up to 230400</td><td>this device does not have bluetooth</td></tr></tbody></table></div></div><br class="table-break" /><div class="example"><a id="miniHomer-on-linux"></a><p class="title"><strong>Example 3.20. Command showing miniHomer download of tracks and erasing the logger on Linux</strong></p><div class="example-contents"><p><strong class="userinput"><code>gpsbabel -i miniHomer,erase -f /dev/ttyUSB0 -o gpx -F out.gpx</code></strong></p></div></div><br class="example-break" /><div class="example"><a id="miniHomer-erase"></a><p class="title"><strong>Example 3.21. Command showing miniHomer erasing the logger without download on Linux</strong></p><div class="example-contents"><p><strong class="userinput"><code>gpsbabel -i miniHomer,erase,no-output -f /dev/ttyUSB0</code></strong></p></div></div><br class="example-break" /><p>miniHomer has five POI called Home, <span class="emphasis"><em>Car</em></span>, <span class="emphasis"><em>Boat</em></span>, <span class="emphasis"><em>Heart</em></span>, <span class="emphasis"><em>Bar</em></span>. You can set the lla 
(Latitude, Longitude, Altitude) for each of the POI. The format is 
<span class="emphasis"><em>&lt;name&gt;=&lt;lat&gt;:&lt;lng&gt;[:&lt;alt&gt;]</em></span>
Once the according POI symbol is selected on miniHomer, the display shows you the direction and distance to the POI.
</p><div class="example"><a id="miniHomer-on-linux-poi"></a><p class="title"><strong>Example 3.22. Command showing miniHomer setting Car and Home POI</strong></p><div class="example-contents"><p>
  	<strong class="userinput"><code>
  	   gpsbabel -i miniHomer,Car=36.790145:-6.352898,Home=-3.066667:37.359167:5895 -f /dev/ttyUSB0 -o gpx -F out.gpx
  	</code></strong>
       Sets the Car/Home symbols' latitude longitude and altitude.
       If you select the Car/Home symbol on miniHomer, the display will show the direction and distance to 
       this location as soon as it has a satellite fix.
	</p></div></div><br class="example-break" /><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_miniHomer_o_baud"></a><code class="option">baud</code> option</h3></div></div></div><p>
      Baud rate used for download.
    </p><p>The following baud rates can be used: 4800, 9600, 19200, 38400, 57600, 115200, 230400.
Note that your logger might not support all of them (especially 230400 which isn't documented
in the chipset manual, though there are known devices that are capable of this speed).
</p><p>If <strong class="userinput"><code>baud=0</code></strong> (zero) download takes place at the baud rate the
device is currently set to. This is especially useful for Bluetooth connections (if available) since they
often don't allow changing the baud rate.</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_miniHomer_o_dump-file"></a><code class="option">dump-file</code> option</h3></div></div></div><p>
      Dump raw data to this file.
    </p><p>
This function is identical to the dump-file function of skytraq module:
Writes raw data as it is read from the logger to the file given as this option's argument
(additional to decoding it as usual). The resulting binary files can be read and decoded by the skytraq-bin format.
Mainly useful for debugging/development purposes.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_miniHomer_o_erase"></a><code class="option">erase</code> option</h3></div></div></div><p>
      Erase device data after download.
    </p><p>
Erase log buffer.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_miniHomer_o_first-sector"></a><code class="option">first-sector</code> option</h3></div></div></div><p>
      First sector to be read from the device.
    </p><p>
This function is identical to the first-sector function of skytraq module.
</p><p>The logger's memory is organized in sectors, serially numbered starting at 0. Each sector takes 4096 bytes of data.
Typical devices hold about 250 sectors. The memory is always filled from sector 0 on, until it is full or the device being
erased again by the user.</p><p>Normally you can safely omit this option. However, it might be useful to read data from erased devices: we observed
that on erase, only the first two sectors are actually cleared. The following example shows how to read the remaining data:
</p><div class="example"><a id="miniHomer-restore-erased"></a><p class="title"><strong>Example 3.23. Command showing how to read data from an erased device</strong></p><div class="example-contents"><p><strong class="userinput"><code>gpsbabel -i miniHomer,first-sector=2 -f /dev/ttyUSB0 -o gpx -F out.gpx</code></strong></p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_miniHomer_o_initbaud"></a><code class="option">initbaud</code> option</h3></div></div></div><p>
      Baud rate used to init device (0=autodetect).
    </p><p>
This function is identical to the init-baud file function of skytraq module. 
</p><p>The "initbaud" option might be helpful if autodetection fails or takes too long. With this option you
can tell GPSBabel the baud rate the device is currently set to. In contrast, the option "baud" specifies
the rate at which the actual download should take place. If it is different than "initbaud" (or the autodetected
rate, if initbaud wasn't given), the initial setting will be restored after finishing the download.
</p><p>
Please note that miniHomer by default uses 38400bps and does not autodetect the port speed. If you need autodetect, start as
<strong class="userinput"><code>gpsbabel -i miniHomer,initbaud=0 -f /dev/ttyUSB0 -o gpx -F out.gpx</code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_miniHomer_o_last-sector"></a><code class="option">last-sector</code> option</h3></div></div></div><p>
      Last sector to be read from the device (-1: smart read everything).
    </p><p>A value of -1 (the default) enables automatic mode, i.e. reading is stopped when an empty sector is
encountered.
We observed that sometimes the device doesn't report the correct number of used sectors, which confuses the Windows
software, so that it might not get all trackpoints.
In contrast, our algorithm ensures that everything is being read (please report if it doesn't work for you).</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_miniHomer_o_no-output"></a><code class="option">no-output</code> option</h3></div></div></div><p>
      Disable output (useful with erase).
    </p><p>If this option is given, no GPS log data will be read from the device
(unless "dump-file" is given too; in that case only decoding will be disabled).</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_miniHomer_o_read-at-once"></a><code class="option">read-at-once</code> option</h3></div></div></div><p>
      Number of sectors to read at once (0=use single sector mode).
    </p><p>If <strong class="userinput"><code>read-at-once</code></strong> &gt;= 1, batch mode is enabled with that many sectors being read at a time.
A value of zero disables batch mode and switches to single read mode. Not all devices support batch mode; in that case
gpsbabel automatically switches to single read mode.</p><p>Under normal circumstances, the larger this number the faster the transfer.
Reducing <strong class="userinput"><code>read-at-once</code></strong> or even switching to single sector mode might help when you get
transmission errors/aborts.</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_miniHomer_o_Home"></a><code class="option">Home</code> option</h3></div></div></div><p>
      POI for Home Symbol as lat:lng[:alt].
    </p><p>
  The device provides a location finder display supporting five locations "Home", "Car", "Boat", "Heart", "Bar". 
  You can program the location of each either by a keypress on the device (which uses the actual position) 
  or with GPSBabel (which lets you use any position)
  You can set the location of "Home" with the 'Home' option.  Use ':' as the delimiter between latitude, longitude and altitude. 
  You can leave altitude out, in which case it is assumed to be zero.
  Note that GPSBabel terminates after writing the location info to the device, i.e. no logging data will be read from it.
</p><div class="example"><a id="miniHomer-Home"></a><p class="title"><strong>Example 3.24. Set the target location of the miniHomer Home POI</strong></p><div class="example-contents"><p>
       <strong class="userinput"><code>gpsbabel -i miniHomer,Home=-3.066667:37.359167:5895 -f /dev/ttyUSB0 -o unicsv -F -</code></strong>
  </p><p>
       Sets the Home symbols' latitude to 3.066667S longitude to 37.359167E and altitude to 5895m.
       If you select the Home symbol on miniHomer, the display will show the direction and distance to 
       this location as soon as it has a satellite fix.
 </p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_miniHomer_o_Car"></a><code class="option">Car</code> option</h3></div></div></div><p>
      POI for Car Symbol as lat:lng[:alt].
    </p><p>
  The device provides a location finder display supporting five locations "Home", "Car", "Boat", "Heart", "Bar". 
  You can program the location of each either by a keypress on the device (which uses the actual position) 
  or with GPSBabel (which lets you use any position)
  You can set the location of "Car" with the 'Car' option.  Use ':' as the delimiter between latitude, longitude and altitude. 
  You can leave altitude out, in which case it is assumed to be zero.
  Note that GPSBabel terminates after writing the location info to the device, i.e. no logging data will be read from it.
</p><div class="example"><a id="miniHomer-Car"></a><p class="title"><strong>Example 3.25. Set the target location of the miniHomer Car POI</strong></p><div class="example-contents"><p>
       <strong class="userinput"><code>gpsbabel -i miniHomer,Car=-25.272309:153.235330 -f /dev/ttyUSB0 -o unicsv -F -</code></strong>
  </p><p>
       Sets the Car symbols' latitude to 25.272309S longitude to 153.235330E and altitude to 0m.
       If you select the Car symbol on miniHomer, the display will show the direction and distance to 
       this location as soon as it has a satellite fix.
 </p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_miniHomer_o_Boat"></a><code class="option">Boat</code> option</h3></div></div></div><p>
      POI for Boat Symbol as lat:lng[:alt].
    </p><p>
  The device provides a location finder display supporting five locations "Home", "Car", "Boat", "Heart", "Bar". 
  You can program the location of each either by a keypress on the device (which uses the actual position) 
  or with GPSBabel (which lets you use any position)
  You can set the location of "Boat" with the 'Boat' option.  Use ':' as the delimiter between latitude, longitude and altitude. 
  You can leave altitude out, in which case it is assumed to be zero.
  Note that GPSBabel terminates after writing the location info to the device, i.e. no logging data will be read from it.
</p><div class="example"><a id="miniHomer-Boat"></a><p class="title"><strong>Example 3.26. Set the target location of the miniHomer Boat POI</strong></p><div class="example-contents"><p>
       <strong class="userinput"><code>gpsbabel -i miniHomer,Boat=32.29287:-64.77527 -f /dev/ttyUSB0 -o unicsv -F -</code></strong>
  </p><p>
       Sets the Boat symbols' latitude to 32.29287N longitude to 64.77527E and altitude to 0m.
       If you select the Home symbol on miniHomer, the display will show the direction and distance to 
       this location as soon as it has a satellite fix.
 </p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_miniHomer_o_Heart"></a><code class="option">Heart</code> option</h3></div></div></div><p>
      POI for Heart Symbol as lat:lng[:alt].
    </p><p>
  The device provides a location finder display supporting five locations "Home", "Car", "Boat", "Heart", "Bar". 
  You can program the location of each either by a keypress on the device (which uses the actual position) 
  or with GPSBabel (which lets you use any position)
  You can set the location of "Heart" with the 'Heart' option.  Use ':' as the delimiter between latitude, longitude and altitude. 
  You can leave altitude out, in which case it is assumed to be zero.
  Note that GPSBabel terminates after writing the location info to the device, i.e. no logging data will be read from it.
</p><div class="example"><a id="miniHomer-Heart"></a><p class="title"><strong>Example 3.27. Set the target location of the miniHomer Heart POI</strong></p><div class="example-contents"><p>
       <strong class="userinput"><code>gpsbabel -i miniHomer,Heart=36.1269:-115.1698 -f /dev/ttyUSB0 -o unicsv -F -</code></strong>
  </p><p>
       Sets the Heart symbols' latitude to 36.1269N longitude to 115.1698W and altitude to 0m.
       If you select the Heart symbol on miniHomer, the display will show the direction and distance to 
       this location as soon as it has a satellite fix.
 </p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_miniHomer_o_Bar"></a><code class="option">Bar</code> option</h3></div></div></div><p>
      POI for Bar Symbol as lat:lng[:alt].
    </p><p>
  The device provides a location finder display supporting five locations "Home", "Car", "Boat", "Heart", "Bar". 
  You can program the location of each either by a keypress on the device (which uses the actual position) 
  or with GPSBabel (which lets you use any position)
  You can set the location of "Bar" with the 'Bar' option.  Use ':' as the delimiter between latitude, longitude and altitude. 
  You can leave altitude out, in which case it is assumed to be zero.
  Note that GPSBabel terminates after writing the location info to the device, i.e. no logging data will be read from it.
</p><div class="example"><a id="miniHomer-Bar"></a><p class="title"><strong>Example 3.28. Set the target location of the miniHomer Bar POI</strong></p><div class="example-contents"><p>
       <strong class="userinput"><code>gpsbabel -i miniHomer,Bar=38.99809:-86.34662 -f /dev/ttyUSB0 -o unicsv -F -</code></strong>
  </p><p>
       Sets the Bar symbols' latitude to 38.99809N longitude to 86.34662W and altitude to 0m.
       If you select the Bar symbol on miniHomer, the display will show the direction and distance to 
       this location as soon as it has a satellite fix.
 </p></div></div><br class="example-break" /></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="fmt_s_and_t.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="The_Formats.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="fmt_garmin_xt.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Microsoft Streets and Trips 2002-2007 (s_and_t) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Mobile Garmin XT Track files (garmin_xt)</td></tr></table></div>
  
      {/literal}{/block}
  