#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: dbus
version: 0.10.13
id: dbus-0.10.13-8TjcxfAG8wk5j6htQb95U
key: dbus-0.10.13-8TjcxfAG8wk5j6htQb95U
license: GPL-3
maintainer: Andrey Sverdlichenko <blaze@ruddy.ru>, John Millikin <john@john-millikin.com>
stability: experimental
homepage: https://github.com/rblaze/haskell-dbus#readme
synopsis: A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.
    .
    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.
    .
    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.
    .
    Example: connect to the session bus, and get a list of active names.
    .
    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
    .
    import Data.List (sort)
    import DBus
    import DBus.Client
    .
    main = do
    &#x20;   client <- connectSession
    &#x20;   //
    &#x20;   \-- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;   //
    &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   \-- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;   //
    &#x20;   \-- Print each name on a line, sorted so reserved names are below
    &#x20;   \-- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @
    .
    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <john@john-millikin.com>
exposed: True
indefinite: False
exposed-modules:
    DBus DBus.Client DBus.Internal.Address DBus.Internal.Message
    DBus.Internal.Types DBus.Internal.Wire DBus.Introspection
    DBus.Socket DBus.Transport
abi: caee27a3c8189d5697ec9d30d864525a
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/dbus-0.10.13
library-dirs: /usr/lib/ghc-8.2.1/site-local/dbus-0.10.13
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/dbus-0.10.13
hs-libraries: HSdbus-0.10.13-8TjcxfAG8wk5j6htQb95U
depends:
    base-4.10.0.0 bytestring-0.10.8.2
    cereal-0.5.4.0-AV9aAoAC3OtC6kJvAolohE containers-0.5.10.2
    libxml-sax-0.7.5-33NgxTMLOyhCDrhgX2UeOr
    network-2.6.3.2-8o5F7G3DMrLGgmHkPzZYJx
    parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh
    random-1.1-DtLcP2Z2iOOC0RwcSmXjBK
    text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz transformers-0.5.2.0
    unix-2.7.2.2 vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi
    xml-types-0.3.6-JMA6F2EZctJ1CgZnvNtSRm
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             cereal-0.5.4.0-AV9aAoAC3OtC6kJvAolohE=7bc02437e77f59917ed10938dea3d025
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             libxml-sax-0.7.5-33NgxTMLOyhCDrhgX2UeOr=744f7c3664e5976bfd09c401fc3f0918
             network-2.6.3.2-8o5F7G3DMrLGgmHkPzZYJx=ef2cd2ee3956583f4f4dc001b18e6763
             parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh=ec025cd9e2938e26fbdb8853642eb58e
             random-1.1-DtLcP2Z2iOOC0RwcSmXjBK=4de0c0628e95d26e613f423e1634f42a
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             unix-2.7.2.2=7af8630098b53e228272ffaea5bacf62
             vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi=12d01284f86dd305f0b2cab827808cc2
             xml-types-0.3.6-JMA6F2EZctJ1CgZnvNtSRm=58a25c3831913db6d5817f7738b523a3
haddock-interfaces: /usr/share/doc/haskell-dbus/html/dbus.haddock
haddock-html: /usr/share/doc/haskell-dbus/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

