#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: lens
version: 4.15.4
id: lens-4.15.4-BVNSGosFkEc34U2t4uFumn
key: lens-4.15.4-BVNSGosFkEc34U2t4uFumn
license: BSD2
copyright: Copyright (C) 2012-2016 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/lens/
synopsis: Lenses, Folds and Traversals
description:
    This package comes \"Batteries Included\" with many useful lenses for the types
    commonly used from the Haskell Platform, and with tools for automatically
    generating lenses and isomorphisms for user-supplied data types.
    .
    The combinators in @Control.Lens@ provide a highly generic toolbox for composing
    families of getters, folds, isomorphisms, traversals, setters and lenses and their
    indexed variants.
    .
    An overview, with a large number of examples can be found in the <https://github.com/ekmett/lens#lens-lenses-folds-and-traversals README>.
    .
    An introductory video on the style of code used in this library by Simon Peyton Jones is available from <http://skillsmatter.com/podcast/scala/lenses-compositional-data-access-and-manipulation Skills Matter>.
    .
    A video on how to use lenses and how they are constructed is available on <http://youtu.be/cefnmjtAolY?hd=1 youtube>.
    .
    Slides for that second talk can be obtained from <http://comonad.com/haskell/Lenses-Folds-and-Traversals-NYC.pdf comonad.com>.
    .
    More information on the care and feeding of lenses, including a brief tutorial and motivation
    for their types can be found on the <https://github.com/ekmett/lens/wiki lens wiki>.
    .
    A small game of @pong@ and other more complex examples that manage their state using lenses can be found in the <https://github.com/ekmett/lens/blob/master/examples/ example folder>.
    .
    /Lenses, Folds and Traversals/
    .
    With some signatures simplified, the core of the hierarchy of lens-like constructions looks like:
    .
    .
    <<http://i.imgur.com/ALlbPRa.png>>
    .
    <Hierarchy.png (Local Copy)>
    .
    You can compose any two elements of the hierarchy above using @(.)@ from the @Prelude@, and you can
    use any element of the hierarchy as any type it linked to above it.
    .
    The result is their lowest upper bound in the hierarchy (or an error if that bound doesn'\''t exist).
    .
    For instance:
    .
    * You can use any '\''Traversal'\'' as a '\''Fold'\'' or as a '\''Setter'\''.
    .
    * The composition of a '\''Traversal'\'' and a '\''Getter'\'' yields a '\''Fold'\''.
    .
    /Minimizing Dependencies/
    .
    If you want to provide lenses and traversals for your own types in your own libraries, then you
    can do so without incurring a dependency on this (or any other) lens package at all.
    .
    /e.g./ for a data type:
    .
    > data Foo a = Foo Int Int a
    .
    You can define lenses such as
    .
    > -- bar :: Lens'\'' (Foo a) Int
    > bar :: Functor f => (Int -> f Int) -> Foo a -> f (Foo a)
    > bar f (Foo a b c) = fmap (\a'\'' -> Foo a'\'' b c) (f a)
    .
    > -- quux :: Lens (Foo a) (Foo b) a b
    > quux :: Functor f => (a -> f b) -> Foo a -> f (Foo b)
    > quux f (Foo a b c) = fmap (Foo a b) (f c)
    .
    without the need to use any type that isn'\''t already defined in the @Prelude@.
    .
    And you can define a traversal of multiple fields with '\''Control.Applicative.Applicative'\'':
    .
    > -- traverseBarAndBaz :: Traversal'\'' (Foo a) Int
    > traverseBarAndBaz :: Applicative f => (Int -> f Int) -> Foo a -> f (Foo a)
    > traverseBarAndBaz f (Foo a b c) = Foo <$> f a <*> f b <*> pure c
    .
    What is provided in this library is a number of stock lenses and traversals for
    common haskell types, a wide array of combinators for working them, and more
    exotic functionality, (/e.g./ getters, setters, indexed folds, isomorphisms).
category: Data, Lenses, Generics
author: Edward A. Kmett
exposed: True
indefinite: False
exposed-modules:
    Control.Exception.Lens Control.Lens Control.Lens.At
    Control.Lens.Combinators Control.Lens.Cons Control.Lens.Each
    Control.Lens.Empty Control.Lens.Equality Control.Lens.Extras
    Control.Lens.Fold Control.Lens.Getter Control.Lens.Indexed
    Control.Lens.Internal Control.Lens.Internal.Bazaar
    Control.Lens.Internal.ByteString Control.Lens.Internal.CTypes
    Control.Lens.Internal.Coerce Control.Lens.Internal.Context
    Control.Lens.Internal.Deque Control.Lens.Internal.Exception
    Control.Lens.Internal.FieldTH Control.Lens.Internal.Fold
    Control.Lens.Internal.Getter Control.Lens.Internal.Indexed
    Control.Lens.Internal.Instances Control.Lens.Internal.Iso
    Control.Lens.Internal.Level Control.Lens.Internal.List
    Control.Lens.Internal.Magma Control.Lens.Internal.Prism
    Control.Lens.Internal.PrismTH Control.Lens.Internal.Review
    Control.Lens.Internal.Setter Control.Lens.Internal.TH
    Control.Lens.Internal.Zoom Control.Lens.Iso Control.Lens.Lens
    Control.Lens.Level Control.Lens.Operators Control.Lens.Plated
    Control.Lens.Prism Control.Lens.Reified Control.Lens.Review
    Control.Lens.Setter Control.Lens.TH Control.Lens.Traversal
    Control.Lens.Tuple Control.Lens.Type Control.Lens.Wrapped
    Control.Lens.Zoom Control.Monad.Error.Lens
    Control.Parallel.Strategies.Lens Control.Seq.Lens Data.Array.Lens
    Data.Bits.Lens Data.ByteString.Lazy.Lens Data.ByteString.Lens
    Data.ByteString.Strict.Lens Data.Complex.Lens Data.Data.Lens
    Data.Dynamic.Lens Data.HashSet.Lens Data.IntSet.Lens Data.List.Lens
    Data.Map.Lens Data.Sequence.Lens Data.Set.Lens Data.Text.Lazy.Lens
    Data.Text.Lens Data.Text.Strict.Lens Data.Tree.Lens
    Data.Typeable.Lens Data.Vector.Generic.Lens Data.Vector.Lens
    GHC.Generics.Lens Language.Haskell.TH.Lens Numeric.Lens
    System.Exit.Lens System.FilePath.Lens System.IO.Error.Lens
hidden-modules: Paths_lens
abi: 09df9ebd42f546ab4bf6120bba6d71c5
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/lens-4.15.4
library-dirs: /usr/lib/ghc-8.2.1/site-local/lens-4.15.4
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/lens-4.15.4
hs-libraries: HSlens-4.15.4-BVNSGosFkEc34U2t4uFumn
depends:
    array-0.5.2.0 base-4.10.0.0 base-orphans-0.6-9iPDLrUqQ5yHb9fb9OUZ9L
    bifunctors-5.4.2-EkvLHEGusmL2QBUCGZ7PSE bytestring-0.10.8.2
    call-stack-0.1.0-9jal1kz08FU8PWnIBPoZ86
    comonad-5.0.2-AAFyIh6Dm39islDxts6T3
    contravariant-1.4-1lqq0vqix8Y43XZ7Q5hTLe containers-0.5.10.2
    distributive-0.5.3-99ryfobDi0e5qzYasSVH5G filepath-1.4.1.2
    free-4.12.4-Jg96zolWYJa3X3zzp8DnHv ghc-prim-0.5.1.0
    hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk
    kan-extensions-5.0.2-58eqXniYEEvAZKI0q8zVEZ
    exceptions-0.8.3-BkxQoXHQAbWGd28nf3VeZ6
    mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3
    parallel-3.2.1.1-BDA8bigzIyf7HfOpmZ9w2K
    profunctors-5.2.1-tcGHrJuwpB2Qib1uMFFo0
    reflection-2.1.2-HPYmHAmlpRJ9gRQTzfKOSy
    semigroupoids-5.2.1-BrFpsm3Xb4SLTmLSosQvtp
    semigroups-0.18.3-6KPIVJcHqOOBHjBl8WA5LP
    tagged-0.8.5-7Kuk6etyDBjGPRKMYpsbFG template-haskell-2.12.0.0
    th-abstraction-0.2.6.0-HOzElmEPaB0LxMlcRCgfSl
    text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz transformers-0.5.2.0
    transformers-compat-0.5.1.4-8ofY1OHzPhX5dvYk512o2v
    unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN
    vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi
    void-0.7.2-KNNEd7XG9bDRysTndgnf2
abi-depends: array-0.5.2.0=5abf025fb7bf60079ec1f42bab285152
             base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             base-orphans-0.6-9iPDLrUqQ5yHb9fb9OUZ9L=80bc3cbc1a27ff088178ac694da5ed41
             bifunctors-5.4.2-EkvLHEGusmL2QBUCGZ7PSE=3c661fc7707c57e8dca3d6cba12d1535
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             call-stack-0.1.0-9jal1kz08FU8PWnIBPoZ86=074cd9d4520ab1fa3869b4e9283eb803
             comonad-5.0.2-AAFyIh6Dm39islDxts6T3=2e229087fcf32b235bcf466fea4261ee
             contravariant-1.4-1lqq0vqix8Y43XZ7Q5hTLe=893af150e87a363f17ac42bee5d29045
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             distributive-0.5.3-99ryfobDi0e5qzYasSVH5G=696e7055a26e1c2a28fbdde9c9afe158
             filepath-1.4.1.2=30ad74f2069d36b2d0af3972630d4ac4
             free-4.12.4-Jg96zolWYJa3X3zzp8DnHv=ba4589e60d946c865ed0b45113d4c7b9
             ghc-prim-0.5.1.0=557c7fce76ef13c2417583cc28848f14
             hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk=90545b19a76e197f153fb1577996b718
             kan-extensions-5.0.2-58eqXniYEEvAZKI0q8zVEZ=88d357726b998b143ac17d934c172963
             exceptions-0.8.3-BkxQoXHQAbWGd28nf3VeZ6=62278cb6808dfdd4ea4dbd9b537b44e9
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             parallel-3.2.1.1-BDA8bigzIyf7HfOpmZ9w2K=d3c5e50fff73217cc80d767e7d27ed7e
             profunctors-5.2.1-tcGHrJuwpB2Qib1uMFFo0=a7e80b9d748c8bf1db214fda1cbc5e33
             reflection-2.1.2-HPYmHAmlpRJ9gRQTzfKOSy=a2c942b5f5621900f149e66cf4940734
             semigroupoids-5.2.1-BrFpsm3Xb4SLTmLSosQvtp=4a7eb4dea61c6f90c822c8a91f086fa5
             semigroups-0.18.3-6KPIVJcHqOOBHjBl8WA5LP=7bc502c1773a3f628e3db58cb706740b
             tagged-0.8.5-7Kuk6etyDBjGPRKMYpsbFG=fee9dd37afd44fe7a6a3e8c00aaf438e
             template-haskell-2.12.0.0=612ee923b47f5e11502cef08338c9f82
             th-abstraction-0.2.6.0-HOzElmEPaB0LxMlcRCgfSl=0a9752555517848a9057dba98bc18236
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             transformers-compat-0.5.1.4-8ofY1OHzPhX5dvYk512o2v=e48d0ae1a0338f5c9f46149b634d1da7
             unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN=c3a6cf2eb5dea0a9b852305436978b94
             vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi=12d01284f86dd305f0b2cab827808cc2
             void-0.7.2-KNNEd7XG9bDRysTndgnf2=17ec282264751cc765759d5ebe13c331
haddock-interfaces: /usr/share/doc/haskell-lens/html/lens.haddock
haddock-html: /usr/share/doc/haskell-lens/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

