#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tasty-rerun
version: 1.1.7
id: tasty-rerun-1.1.7-LUQbUyolVHk17F97uZblIQ
key: tasty-rerun-1.1.7-LUQbUyolVHk17F97uZblIQ
license: BSD3
copyright: Oliver Charles (c) 2014
maintainer: ollie@ocharles.org.uk
homepage: http://github.com/ocharles/tasty-rerun
synopsis: Run tests by filtering the test tree depending on the result of previous test
          runs
description:
    This ingredient adds the ability to run tests by first filtering the test tree
    based on the result of a previous test run. For example, you can use this to
    run only those tests that failed in the last run, or to run only tests that
    have been added since tests were last ran.
    .
    This ingredient is specifically an ingredient *transformer* - given a list of
    '\''Tasty.Ingredient'\''s, '\''rerunningTests'\'' adds the ability for all of these
    ingredients to run against a filtered test tree. This transformer can be
    applied as follows:
    .
    > import Test.Tasty
    > import Test.Tasty.Runners
    >
    > main :: IO ()
    > main =
    >   defaultMainWithIngredients
    >     [ rerunningTests [ listingTests, consoleTestReporter ] ]
    >     tests
    >
    > tests :: TestTree
    > tests = undefined
    .
    This ingredient adds three command line parameters:
    .
    [@--rerun-update@] If specified the results of this test run will be saved to
    the log file at @--rerun-log-file@. If the ingredient does not execute tests
    (for example, @--list-tests@ is used) then the log file will not be
    updated. This option is not enabled by default.  This option does not require
    a value.
    .
    [@--rerun-log-file@] The path to the log file to read previous test
    information from, and where to write new information to (if @--rerun-update@
    is specified). This option defaults to @.tasty-rerun-log@.
    .
    [@--rerun-filter@] Which filters to apply to the '\''Tasty.TestTree'\'' based on
    previous test runs. The value of this option is a comma separated list of the
    following options:
    .
    * @failures@: Only run tests that failed on the previous run.
    .
    * @exceptions@: Only run tests that threw an exception on the previous run.
    .
    * @new@: Only run tests that are new since the previous test run.
    .
    * @successful@: Only run tests that were successful in the previous run.
    .
    Multiple options can be combined and will be taken under disjunction - so
    @--rerun-filter=failures,exceptions@ will run only tests that failed *or*
    threw an exception on the last run.
    .
    Defaults to all filters, which means all tests will be ran.
category: Testing
author: Oliver Charles
exposed: True
indefinite: False
exposed-modules:
    Test.Tasty.Ingredients.Rerun
abi: 64b7e2d3c5c1684c45d96c43a23c5d0d
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/tasty-rerun-1.1.7
library-dirs: /usr/lib/ghc-8.2.1/site-local/tasty-rerun-1.1.7
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/tasty-rerun-1.1.7
hs-libraries: HStasty-rerun-1.1.7-LUQbUyolVHk17F97uZblIQ
depends:
    base-4.10.0.0 containers-0.5.10.2 mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3
    optparse-applicative-0.14.0.0-CJtbqXiElwvHJ8bj23xDw2
    reducers-3.12.2-HW55ShFARh099g7XIgpiLZ
    split-0.2.3.2-89BHvn20PlL73pGr1SBIHj
    stm-2.4.4.1-4JDnVtQYo787gU0ccBstsJ
    tagged-0.8.5-7Kuk6etyDBjGPRKMYpsbFG
    tasty-0.11.3-6R1Q5OcX2q3HPVtlsImNKo transformers-0.5.2.0
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             optparse-applicative-0.14.0.0-CJtbqXiElwvHJ8bj23xDw2=9137170527362bcbf66dd39b0705c132
             reducers-3.12.2-HW55ShFARh099g7XIgpiLZ=f42b20a4d036f7fb3cd6228301215ed1
             split-0.2.3.2-89BHvn20PlL73pGr1SBIHj=c51f43c3e91d41531ae5282d108271a0
             stm-2.4.4.1-4JDnVtQYo787gU0ccBstsJ=a88f5bbac4be96a38c5ca2a658c158a0
             tagged-0.8.5-7Kuk6etyDBjGPRKMYpsbFG=fee9dd37afd44fe7a6a3e8c00aaf438e
             tasty-0.11.3-6R1Q5OcX2q3HPVtlsImNKo=c2e2d037718d5b03935d425e3527c3ca
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
haddock-interfaces: /usr/share/doc/haskell-tasty-rerun/html/tasty-rerun.haddock
haddock-html: /usr/share/doc/haskell-tasty-rerun/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

