/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.RadiusData;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.CubeIterator;
import org.jmol.c.PAL;
import org.jmol.c.STR;
import org.jmol.c.VDW;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.AtomIteratorWithinModel;
import org.jmol.modelset.AtomIteratorWithinModelSet;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondCollection;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.HBond;
import org.jmol.modelset.Model;
import org.jmol.modelset.Orientation;
import org.jmol.modelset.StateScript;
import org.jmol.modelsetbio.BioModel;
import org.jmol.script.ScriptCompiler;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.util.Rectangle;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;
import org.jmol.viewer.JC;
import org.jmol.viewer.JmolAsyncException;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

public class ModelSet
extends BondCollection {
    public boolean haveBioModels;
    protected BS bsSymmetry;
    public String modelSetName;
    public Model[] am;
    public int mc;
    public SymmetryInterface[] unitCells;
    public boolean haveUnitCells;
    protected final Atom[] closest;
    protected int[] modelNumbers;
    public int[] modelFileNumbers;
    public String[] modelNumbersForAtomLabel;
    public String[] modelNames;
    public String[] frameTitles;
    protected BS[] elementsPresent;
    protected boolean isXYZ;
    public Properties modelSetProperties;
    public Map<String, Object> msInfo;
    protected boolean someModelsHaveSymmetry;
    protected boolean someModelsHaveAromaticBonds;
    protected boolean someModelsHaveFractionalCoordinates;
    private boolean isBbcageDefault;
    public BS bboxModels;
    private BS bboxAtoms;
    private final BoxInfo boxInfo;
    public Lst<StateScript> stateScripts;
    private int thisStateModel;
    protected Lst<V3[]> vibrationSteps;
    private BS selectedMolecules;
    boolean showRebondTimes = true;
    protected BS bsAll;
    public ShapeManager sm;
    private static float hbondMinRasmol = 2.5f;
    private static float hbondMaxReal = 3.5f;
    public boolean proteinStructureTainted;
    public Hashtable<String, BS> htPeaks;
    private Quat[] vOrientations;
    private final P3 ptTemp;
    private final P3 ptTemp1;
    private final P3 ptTemp2;
    private final M3 matTemp;
    private final M3 matInv;
    private final M4 mat4;
    private final M4 mat4t;
    private final V3 vTemp;
    private boolean echoShapeActive = false;
    protected String modelSetTypeName;
    public P3[] translations;
    private SymmetryInterface pointGroup;
    private BoxInfo defaultBBox;
    private boolean maxBondWarned;

    public BoxInfo getBoxInfo() {
        return this.boxInfo;
    }

    public ModelSet(Viewer vwr, String name) {
        this.vwr = vwr;
        this.modelSetName = name;
        this.selectedMolecules = new BS();
        this.stateScripts = new Lst();
        this.boxInfo = new BoxInfo();
        this.boxInfo.addBoundBoxPoint(P3.new3(-10.0f, -10.0f, -10.0f));
        this.boxInfo.addBoundBoxPoint(P3.new3(10.0f, 10.0f, 10.0f));
        this.am = new Model[1];
        this.modelNumbers = new int[1];
        this.modelFileNumbers = new int[1];
        this.modelNumbersForAtomLabel = new String[1];
        this.modelNames = new String[1];
        this.frameTitles = new String[1];
        this.closest = new Atom[1];
        this.ptTemp = new P3();
        this.ptTemp1 = new P3();
        this.ptTemp2 = new P3();
        this.matTemp = new M3();
        this.matInv = new M3();
        this.mat4 = new M4();
        this.mat4t = new M4();
        this.vTemp = new V3();
        this.setupBC();
    }

    protected void releaseModelSet() {
        this.am = null;
        this.closest[0] = null;
        this.am = null;
        this.bsSymmetry = null;
        this.bsAll = null;
        this.unitCells = null;
        this.releaseModelSetBC();
    }

    public boolean getEchoStateActive() {
        return this.echoShapeActive;
    }

    public void setEchoStateActive(boolean TF) {
        this.echoShapeActive = TF;
    }

    public String getModelSetTypeName() {
        return this.modelSetTypeName;
    }

    public int getModelNumberIndex(int modelNumber, boolean useModelNumber, boolean doSetTrajectory) {
        if (useModelNumber) {
            for (int i = 0; i < this.mc; ++i) {
                if (this.modelNumbers[i] != modelNumber && (modelNumber >= 1000000 || this.modelNumbers[i] != 1000000 + modelNumber)) continue;
                return i;
            }
            return -1;
        }
        if (modelNumber < 1000000) {
            return modelNumber;
        }
        for (int i = 0; i < this.mc; ++i) {
            if (this.modelFileNumbers[i] != modelNumber) continue;
            if (doSetTrajectory && this.isTrajectory(i)) {
                this.setTrajectory(i);
            }
            return i;
        }
        return -1;
    }

    public String getModelDataBaseName(BS bsAtoms) {
        for (int i = 0; i < this.mc; ++i) {
            if (!bsAtoms.equals(this.am[i].bsAtoms)) continue;
            return (String)this.getInfo(i, "dbName");
        }
        return null;
    }

    public void setTrajectory(int modelIndex) {
        if (modelIndex >= 0 && this.isTrajectory(modelIndex) && this.at[this.am[modelIndex].firstAtomIndex].mi != modelIndex) {
            this.trajectory.setModel(modelIndex);
        }
    }

    public BS getBitSetTrajectories() {
        return this.trajectory == null ? null : this.trajectory.getModelsSelected();
    }

    public void setTrajectoryBs(BS bsModels) {
        if (this.trajectory != null) {
            for (int i = 0; i < this.mc; ++i) {
                if (!bsModels.get(i)) continue;
                this.setTrajectory(i);
            }
        }
    }

    public void morphTrajectories(int m1, int m2, float f) {
        if (m1 >= 0 && m2 >= 0 && this.isTrajectory(m1) && this.isTrajectory(m2)) {
            this.trajectory.morph(m1, m2, f);
        }
    }

    public P3 getTranslation(int iModel) {
        return this.translations == null || iModel >= this.translations.length ? null : this.translations[iModel];
    }

    public void translateModel(int iModel, T3 pt) {
        if (pt == null) {
            P3 t = this.getTranslation(iModel);
            if (t == null) {
                return;
            }
            pt = P3.newP(t);
            pt.scale(-1.0f);
            this.translateModel(iModel, pt);
            this.translations[iModel] = null;
            return;
        }
        if (this.translations == null || this.translations.length <= iModel) {
            this.translations = new P3[this.mc];
        }
        if (this.translations[iModel] == null) {
            this.translations[iModel] = new P3();
        }
        this.translations[iModel].add(pt);
        BS bs = this.am[iModel].bsAtoms;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            this.at[i].add(pt);
            i = bs.nextSetBit(i + 1);
        }
    }

    public P3[] getFrameOffsets(BS bsAtoms, boolean isFull) {
        if (bsAtoms == null) {
            if (isFull) {
                int i = this.mc;
                while (--i >= 0) {
                    Model m = this.am[i];
                    if (m.isJmolDataFrame || m.isTrajectory) continue;
                    this.translateModel(m.modelIndex, null);
                }
            }
            return null;
        }
        int i0 = bsAtoms.nextSetBit(0);
        if (i0 < 0) {
            return null;
        }
        if (isFull) {
            BS bs = BSUtil.copy(bsAtoms);
            P3 pt = null;
            P3 pdiff = new P3();
            for (int i = 0; i < this.mc; ++i) {
                int j;
                Model m = this.am[i];
                if (!m.isJmolDataFrame && !m.isTrajectory && m.bsAtoms.get(j = bs.nextSetBit(0))) {
                    if (pt == null) {
                        pt = P3.newP(this.at[j]);
                    } else {
                        pdiff.sub2(pt, this.at[j]);
                        this.translateModel(i, pdiff);
                    }
                }
                bs.andNot(m.bsAtoms);
            }
            return null;
        }
        P3[] offsets = new P3[this.mc];
        int i = this.mc;
        while (--i >= 0) {
            offsets[i] = new P3();
        }
        short lastModel = 0;
        int n = 0;
        P3 offset = offsets[0];
        boolean asTrajectory = this.trajectory != null && this.trajectory.steps.size() == this.mc;
        int m1 = asTrajectory ? this.mc : 1;
        offsets[0].set(0.0f, 0.0f, 0.0f);
        block3: for (int m = 0; m < m1; ++m) {
            if (asTrajectory) {
                this.setTrajectory(m);
            }
            for (int i2 = 0; i2 <= this.ac; ++i2) {
                if (i2 == this.ac || this.at[i2].mi != lastModel) {
                    if (n > 0) {
                        offset.scale(-1.0f / (float)n);
                        if (lastModel != 0) {
                            offset.sub(offsets[0]);
                        }
                        n = 0;
                    }
                    if (i2 == this.ac) continue block3;
                    lastModel = this.at[i2].mi;
                    offset = offsets[lastModel];
                }
                if (!bsAtoms.get(i2)) continue;
                offset.add(this.at[i2]);
                ++n;
            }
        }
        return offsets;
    }

    public BS getAtoms(int tokType, Object specInfo) {
        switch (tokType) {
            default: {
                return BSUtil.andNot(this.getAtomBitsMaybeDeleted(tokType, specInfo), this.vwr.slm.bsDeleted);
            }
            case 1073742358: {
                int modelNumber = (Integer)specInfo;
                int modelIndex = this.getModelNumberIndex(modelNumber, true, true);
                return modelIndex < 0 && modelNumber > 0 ? new BS() : this.vwr.getModelUndeletedAtomsBitSet(modelIndex);
            }
            case 1275203608: 
        }
        Object[] data = new Object[]{null, null, null};
        this.vwr.shm.getShapePropertyData(21, "getCenters", data);
        return data[1] == null ? new BS() : (BS)data[1];
    }

    public int findNearestAtomIndex(int x, int y, BS bsNot, int min) {
        if (this.ac == 0) {
            return -1;
        }
        this.closest[0] = null;
        if (this.g3d.isAntialiased()) {
            x <<= 1;
            y <<= 1;
        }
        this.findNearest2(x, y, this.closest, bsNot, min);
        this.sm.findNearestShapeAtomIndex(x, y, this.closest, bsNot);
        int closestIndex = this.closest[0] == null ? -1 : this.closest[0].i;
        this.closest[0] = null;
        return closestIndex;
    }

    public String calculatePointGroup(BS bsAtoms) {
        return (String)this.calculatePointGroupForFirstModel(bsAtoms, false, false, null, 0, 0.0f, null, null, null);
    }

    public Map<String, Object> getPointGroupInfo(BS bsAtoms) {
        return (Map)this.calculatePointGroupForFirstModel(bsAtoms, false, true, null, 0, 0.0f, null, null, null);
    }

    public String getPointGroupAsString(BS bsAtoms, String type, int index, float scale, P3[] pts, P3 center, String id) {
        return (String)this.calculatePointGroupForFirstModel(bsAtoms, true, false, type, index, scale, pts, center, id);
    }

    private Object calculatePointGroupForFirstModel(BS bsAtoms, boolean doAll, boolean asInfo, String type, int index, float scale, T3[] pts, P3 center, String id) {
        SymmetryInterface pointGroup = this.pointGroup;
        SymmetryInterface symmetry = Interface.getSymmetry(this.vwr, "ms");
        BS bs = null;
        boolean haveVibration = false;
        boolean isPolyhedron = false;
        boolean localEnvOnly = false;
        boolean isPoints = pts != null;
        int modelIndex = this.vwr.am.cmi;
        if (!isPoints) {
            Object obj;
            int iAtom;
            int n = iAtom = bsAtoms == null ? -1 : bsAtoms.nextSetBit(0);
            if (modelIndex < 0 && iAtom >= 0) {
                modelIndex = this.at[iAtom].mi;
            }
            if (modelIndex < 0) {
                modelIndex = this.vwr.getVisibleFramesBitSet().nextSetBit(0);
                bsAtoms = null;
            }
            bs = this.vwr.getModelUndeletedAtomsBitSet(modelIndex);
            boolean bl = localEnvOnly = bsAtoms != null && bs.cardinality() != bsAtoms.cardinality();
            if (bsAtoms != null) {
                bs.and(bsAtoms);
            }
            if ((iAtom = bs.nextSetBit(0)) < 0) {
                bs = this.vwr.getModelUndeletedAtomsBitSet(modelIndex);
                iAtom = bs.nextSetBit(0);
            }
            haveVibration = (obj = this.vwr.shm.getShapePropertyIndex(18, "mad", iAtom)) != null && (Integer)obj != 0 || this.vwr.tm.vibrationOn;
            boolean bl2 = isPolyhedron = type != null && type.toUpperCase().indexOf(":POLY") >= 0;
            if (isPolyhedron) {
                Object[] data = new Object[]{iAtom, null};
                this.vwr.shm.getShapePropertyData(21, "points", data);
                pts = (T3[])data[1];
                if (pts == null) {
                    return null;
                }
                bs = null;
                haveVibration = false;
                pointGroup = null;
            } else {
                pts = this.at;
            }
        }
        if (type != null && type.indexOf(":") >= 0) {
            type = type.substring(0, type.indexOf(":"));
        }
        pointGroup = symmetry.setPointGroup(pointGroup, center, pts, bs, haveVibration, isPoints ? 0.0f : this.vwr.getFloat(0x22000026), this.vwr.getFloat(0x22000028), localEnvOnly);
        if (!isPolyhedron && !isPoints) {
            this.pointGroup = pointGroup;
        }
        if (!doAll && !asInfo) {
            return pointGroup.getPointGroupName();
        }
        Object ret = pointGroup.getPointGroupInfo(modelIndex, id, asInfo, type, index, scale);
        return asInfo ? ret : (this.mc > 1 ? "frame " + this.getModelNumberDotted(modelIndex) + "; " : "") + ret;
    }

    public String getDefaultStructure(BS bsAtoms, BS bsModified) {
        return this.haveBioModels ? this.bioModelset.getAllDefaultStructures(bsAtoms, bsModified) : "";
    }

    public void deleteModelBonds(int modelIndex) {
        BS bsAtoms = this.getModelAtomBitSetIncludingDeleted(modelIndex, false);
        this.makeConnections(0.0f, Float.MAX_VALUE, 131071, 12291, bsAtoms, bsAtoms, null, false, false, 0.0f);
    }

    public int[] makeConnections(float minDistance, float maxDistance, int order, int connectOperation, BS bsA, BS bsB, BS bsBonds, boolean isBonds, boolean addGroup, float energy) {
        if (connectOperation == 1073741852 && order != 2048) {
            String stateScript = "connect ";
            if (minDistance != 0.1f) {
                stateScript = stateScript + minDistance + " ";
            }
            if (maxDistance != 1.0E8f) {
                stateScript = stateScript + maxDistance + " ";
            }
            this.addStateScript(stateScript, isBonds ? bsA : null, isBonds ? null : bsA, isBonds ? null : bsB, " auto", false, true);
        }
        this.moleculeCount = 0;
        return this.makeConnections2(minDistance, maxDistance, order, connectOperation, bsA, bsB, bsBonds, isBonds, addGroup, energy);
    }

    public void setPdbConectBonding(int baseAtomIndex, int baseModelIndex, BS bsExclude) {
        short mad = this.vwr.getMadBond();
        for (int i = baseModelIndex; i < this.mc; ++i) {
            Lst vConnect = (Lst)this.getInfo(i, "PDB_CONECT_bonds");
            if (vConnect == null) continue;
            int nConnect = vConnect.size();
            this.setInfo(i, "initialBondCount", nConnect);
            int[] atomInfo = (int[])this.getInfo(i, "PDB_CONECT_firstAtom_count_max");
            int firstAtom = atomInfo[0] + baseAtomIndex;
            int atomMax = firstAtom + atomInfo[1];
            int max = atomInfo[2];
            int[] serialMap = new int[max + 1];
            for (int iAtom = firstAtom; iAtom < atomMax; ++iAtom) {
                int iSerial = this.atomSerials[iAtom];
                if (iSerial <= 0) continue;
                serialMap[iSerial] = iAtom + 1;
            }
            for (int iConnect = 0; iConnect < nConnect; ++iConnect) {
                int[] pair = (int[])vConnect.get(iConnect);
                int sourceSerial = pair[0];
                int targetSerial = pair[1];
                short order = (short)pair[2];
                if (sourceSerial < 0 || targetSerial < 0 || sourceSerial > max || targetSerial > max) continue;
                int sourceIndex = serialMap[sourceSerial] - 1;
                int targetIndex = serialMap[targetSerial] - 1;
                if (sourceIndex < 0 || targetIndex < 0) continue;
                Atom atomA = this.at[sourceIndex];
                Atom atomB = this.at[targetIndex];
                if (bsExclude != null) {
                    if (atomA.isHetero()) {
                        bsExclude.set(sourceIndex);
                    }
                    if (atomB.isHetero()) {
                        bsExclude.set(targetIndex);
                    }
                }
                if (atomA.altloc != atomB.altloc && atomA.altloc != '\u0000' && atomB.altloc != '\u0000') continue;
                this.getOrAddBond(atomA, atomB, order, order == 2048 ? (short)1 : mad, null, 0.0f, false);
            }
        }
    }

    public void deleteAllBonds() {
        this.moleculeCount = 0;
        int i = this.stateScripts.size();
        while (--i >= 0) {
            if (!((StateScript)this.stateScripts.get(i)).isConnect()) continue;
            this.stateScripts.removeItemAt(i);
        }
        this.deleteAllBonds2();
    }

    private void includeAllRelatedFrames(BS bsModels) {
        int baseModel = 0;
        for (int i = 0; i < this.mc; ++i) {
            boolean isBase;
            boolean isTraj = this.isTrajectory(i);
            boolean bl = isBase = isTraj && bsModels.get(baseModel = this.am[i].trajectoryBaseIndex);
            if (bsModels.get(i)) {
                if (!isTraj || isBase) continue;
                bsModels.set(baseModel);
                this.includeAllRelatedFrames(bsModels);
                return;
            }
            if (!isTraj && (!this.isJmolDataFrameForModel(i) || !bsModels.get(this.am[i].dataSourceFrame))) continue;
            bsModels.set(i);
        }
    }

    public BS deleteModels(BS bsModels) {
        int i;
        this.includeAllRelatedFrames(bsModels);
        int nModelsDeleted = bsModels.cardinality();
        if (nModelsDeleted == 0) {
            return null;
        }
        this.moleculeCount = 0;
        if (this.msInfo != null) {
            this.msInfo.remove("models");
        }
        int i2 = bsModels.nextSetBit(0);
        while (i2 >= 0) {
            this.clearDataFrameReference(i2);
            i2 = bsModels.nextSetBit(i2 + 1);
        }
        if (nModelsDeleted == this.mc) {
            BS bsDeleted = this.getModelAtomBitSetIncludingDeleted(-1, true);
            this.vwr.zap(true, false, false);
            return bsDeleted;
        }
        this.validateBspf(false);
        Model[] newModels = new Model[this.mc - nModelsDeleted];
        Model[] oldModels = this.am;
        BS bsDeleted = new BS();
        int mpt = 0;
        for (int i3 = 0; i3 < this.mc; ++i3) {
            if (bsModels.get(i3)) {
                this.getAtomCountInModel(i3);
                bsDeleted.or(this.getModelAtomBitSetIncludingDeleted(i3, false));
                continue;
            }
            this.am[i3].modelIndex = mpt;
            newModels[mpt++] = this.am[i3];
        }
        this.am = newModels;
        int oldModelCount = this.mc;
        BS bsBonds = this.getBondsForSelectedAtoms(bsDeleted, true);
        this.deleteBonds(bsBonds, true);
        int mpt2 = 0;
        for (i = 0; i < oldModelCount; ++i) {
            if (!bsModels.get(i)) {
                ++mpt2;
                continue;
            }
            int nAtoms = oldModels[i].act;
            if (nAtoms == 0) continue;
            BS bsModelAtoms = oldModels[i].bsAtoms;
            int firstAtomIndex = oldModels[i].firstAtomIndex;
            BSUtil.deleteBits(this.bsSymmetry, bsModelAtoms);
            this.deleteModel(mpt2, firstAtomIndex, nAtoms, bsModelAtoms, bsBonds);
            int j = oldModelCount;
            while (--j > i) {
                oldModels[j].fixIndices(mpt2, nAtoms, bsModelAtoms);
            }
            this.vwr.shm.deleteShapeAtoms(new Object[]{newModels, this.at, new int[]{mpt2, firstAtomIndex, nAtoms}}, bsModelAtoms);
            --this.mc;
        }
        this.haveBioModels = false;
        i = this.mc;
        while (--i >= 0) {
            if (!this.am[i].isBioModel) continue;
            this.haveBioModels = true;
            this.bioModelset.set(this.vwr, this);
        }
        this.validateBspf(false);
        this.bsAll = null;
        this.resetMolecules();
        this.isBbcageDefault = false;
        this.calcBoundBoxDimensions(null, 1.0f);
        return bsDeleted;
    }

    public void resetMolecules() {
        this.molecules = null;
        this.moleculeCount = 0;
        this.resetChirality();
    }

    private void resetChirality() {
        if (this.haveChirality) {
            short modelIndex = -1;
            int i = this.ac;
            while (--i >= 0) {
                Atom a = this.at[i];
                a.setCIPChirality(0);
                if (a.mi == modelIndex) continue;
                modelIndex = a.mi;
                this.am[a.mi].hasChirality = false;
            }
        }
    }

    private void deleteModel(int modelIndex, int firstAtomIndex, int nAtoms, BS bsModelAtoms, BS bsBonds) {
        int i;
        if (modelIndex < 0) {
            return;
        }
        this.modelNumbers = (int[])AU.deleteElements(this.modelNumbers, modelIndex, 1);
        this.modelFileNumbers = (int[])AU.deleteElements(this.modelFileNumbers, modelIndex, 1);
        this.modelNumbersForAtomLabel = (String[])AU.deleteElements(this.modelNumbersForAtomLabel, modelIndex, 1);
        this.modelNames = (String[])AU.deleteElements(this.modelNames, modelIndex, 1);
        this.frameTitles = (String[])AU.deleteElements(this.frameTitles, modelIndex, 1);
        this.thisStateModel = -1;
        String[] group3Lists = (String[])this.getInfoM("group3Lists");
        int[][] group3Counts = (int[][])this.getInfoM("group3Counts");
        int ptm = modelIndex + 1;
        if (group3Lists != null && group3Lists[ptm] != null) {
            i = group3Lists[ptm].length() / 6;
            while (--i >= 0) {
                if (group3Counts[ptm][i] <= 0) continue;
                int[] nArray = group3Counts[0];
                int n = i;
                nArray[n] = nArray[n] - group3Counts[ptm][i];
                if (group3Counts[0][i] != 0) continue;
                group3Lists[0] = group3Lists[0].substring(0, i * 6) + ",[" + group3Lists[0].substring(i * 6 + 2);
            }
        }
        if (group3Lists != null) {
            this.msInfo.put("group3Lists", AU.deleteElements(group3Lists, modelIndex, 1));
            this.msInfo.put("group3Counts", AU.deleteElements(group3Counts, modelIndex, 1));
        }
        if (this.unitCells != null) {
            this.unitCells = (SymmetryInterface[])AU.deleteElements(this.unitCells, modelIndex, 1);
        }
        i = this.stateScripts.size();
        while (--i >= 0) {
            if (((StateScript)this.stateScripts.get(i)).deleteAtoms(modelIndex, bsBonds, bsModelAtoms)) continue;
            this.stateScripts.removeItemAt(i);
        }
        this.deleteModelAtoms(firstAtomIndex, nAtoms, bsModelAtoms);
        this.vwr.deleteModelAtoms(modelIndex, firstAtomIndex, nAtoms, bsModelAtoms);
    }

    public void setAtomProperty(BS bs, int tok, int iValue, float fValue, String sValue, float[] values, String[] list) {
        switch (tok) {
            case 1112152066: 
            case 1112152071: 
            case 1112152073: 
            case 1112152074: 
            case 1112152078: 
            case 1114249217: 
            case 1649022989: {
                if (fValue > 4.0f) {
                    fValue = 4.0f;
                }
                if (values != null) {
                    float[] newValues = new float[this.ac];
                    try {
                        int i = bs.nextSetBit(0);
                        int ii = 0;
                        while (i >= 0) {
                            newValues[i] = values[ii++];
                            i = bs.nextSetBit(i + 1);
                        }
                    }
                    catch (Exception e) {
                        return;
                    }
                    values = newValues;
                }
            }
            case 1112152070: 
            case 1112152076: {
                RadiusData rd = null;
                int mar = 0;
                if (values == null) {
                    if (fValue > 16.0f) {
                        fValue = 16.1f;
                    }
                    if (fValue < 0.0f) {
                        fValue = 0.0f;
                    }
                    mar = (int)Math.floor(fValue * 2000.0f);
                } else {
                    rd = new RadiusData(values, 0.0f, null, null);
                }
                this.sm.setShapeSizeBs(JC.shapeTokenIndex(tok), mar, rd, bs);
                return;
            }
        }
        this.setAPm(bs, tok, iValue, fValue, sValue, values, list);
    }

    public Object getFileData(int modelIndex) {
        if (modelIndex < 0) {
            return "";
        }
        Map<String, Object> fileData = (Map<String, Object>)this.getInfo(modelIndex, "fileData");
        if (fileData != null) {
            return fileData;
        }
        if (!this.getInfoB(modelIndex, "isCIF")) {
            return this.getPDBHeader(modelIndex);
        }
        fileData = this.vwr.getCifData(modelIndex);
        this.setInfo(modelIndex, "fileData", fileData);
        return fileData;
    }

    public BS addHydrogens(Lst<Atom> vConnections, P3[] pts) {
        int modelIndex = this.mc - 1;
        BS bs = new BS();
        if (this.isTrajectory(modelIndex) || this.am[modelIndex].getGroupCount() > 1) {
            return bs;
        }
        this.growAtomArrays(this.ac + pts.length);
        RadiusData rd = this.vwr.rd;
        short mad = this.getDefaultMadFromOrder(1);
        this.am[modelIndex].resetDSSR(false);
        int i = 0;
        int n = this.am[modelIndex].act + 1;
        while (i < vConnections.size()) {
            Atom atom1 = (Atom)vConnections.get(i);
            Atom atom2 = this.addAtom(modelIndex, atom1.group, 1, "H" + n, null, n, atom1.getSeqID(), n, pts[i], Float.NaN, null, 0, 0.0f, 100.0f, Float.NaN, null, false, (byte)0, null);
            atom2.setMadAtom(this.vwr, rd);
            bs.set(atom2.i);
            this.bondAtoms(atom1, atom2, 1, mad, null, 0.0f, false, false);
            ++i;
            ++n;
        }
        this.sm.loadDefaultShapes(this);
        return bs;
    }

    protected void mergeModelArrays(ModelSet mergeModelSet) {
        this.at = mergeModelSet.at;
        this.bo = mergeModelSet.bo;
        this.stateScripts = mergeModelSet.stateScripts;
        this.proteinStructureTainted = mergeModelSet.proteinStructureTainted;
        this.thisStateModel = -1;
        this.bsSymmetry = mergeModelSet.bsSymmetry;
        this.modelFileNumbers = mergeModelSet.modelFileNumbers;
        this.modelNumbersForAtomLabel = mergeModelSet.modelNumbersForAtomLabel;
        this.modelNames = mergeModelSet.modelNames;
        this.modelNumbers = mergeModelSet.modelNumbers;
        this.frameTitles = mergeModelSet.frameTitles;
        this.haveChirality = mergeModelSet.haveChirality;
        if (this.msInfo != null) {
            this.msInfo.remove("models");
        }
        this.mergeAtomArrays(mergeModelSet);
    }

    public SymmetryInterface getUnitCell(int modelIndex) {
        if (modelIndex < 0 || modelIndex >= this.mc) {
            return null;
        }
        if (this.am[modelIndex].simpleCage != null) {
            return this.am[modelIndex].simpleCage;
        }
        if (this.unitCells != null && modelIndex < this.unitCells.length && this.unitCells[modelIndex].haveUnitCell()) {
            return this.unitCells[modelIndex];
        }
        if (this.getInfo(modelIndex, "unitCellParams") != null) {
            if (this.unitCells == null) {
                this.unitCells = new SymmetryInterface[this.mc];
            }
            this.haveUnitCells = true;
            this.unitCells[modelIndex] = this.vwr.getSymTemp().setSymmetryInfo(modelIndex, this.am[modelIndex].auxiliaryInfo, null);
            return this.unitCells[modelIndex];
        }
        return null;
    }

    public void setModelCage(int modelIndex, SymmetryInterface simpleCage) {
        if (modelIndex >= 0 && modelIndex < this.mc) {
            this.am[modelIndex].simpleCage = simpleCage;
            this.haveUnitCells = true;
        }
    }

    public String getModelName(int modelIndex) {
        return this.mc < 1 ? "" : (modelIndex >= 0 ? this.modelNames[modelIndex] : this.modelNumbersForAtomLabel[-1 - modelIndex]);
    }

    public String getModelTitle(int modelIndex) {
        return (String)this.getInfo(modelIndex, "title");
    }

    public String getModelFileName(int modelIndex) {
        return (String)this.getInfo(modelIndex, "fileName");
    }

    public String getModelFileType(int modelIndex) {
        return (String)this.getInfo(modelIndex, "fileType");
    }

    public void setFrameTitle(BS bsFrames, Object title) {
        if (title instanceof String) {
            int i = bsFrames.nextSetBit(0);
            while (i >= 0) {
                this.frameTitles[i] = (String)title;
                i = bsFrames.nextSetBit(i + 1);
            }
        } else {
            String[] list = (String[])title;
            int i = bsFrames.nextSetBit(0);
            int n = 0;
            while (i >= 0) {
                if (n < list.length) {
                    this.frameTitles[i] = list[n++];
                }
                i = bsFrames.nextSetBit(i + 1);
            }
        }
    }

    public String getFrameTitle(int modelIndex) {
        return modelIndex >= 0 && modelIndex < this.mc ? this.frameTitles[modelIndex] : "";
    }

    public String getModelNumberForAtomLabel(int modelIndex) {
        return this.modelNumbersForAtomLabel[modelIndex];
    }

    Group[] getGroups() {
        int n = 0;
        for (int i = 0; i < this.mc; ++i) {
            n += this.am[i].getGroupCount();
        }
        Group[] groups = new Group[n];
        int iGroup = 0;
        for (int i = 0; i < this.mc; ++i) {
            for (int j = 0; j < this.am[i].chainCount; ++j) {
                for (int k = 0; k < this.am[i].chains[j].groupCount; ++k) {
                    groups[iGroup] = this.am[i].chains[j].groups[k];
                    groups[iGroup].groupIndex = iGroup;
                    ++iGroup;
                }
            }
        }
        return groups;
    }

    public float[] getUnitCellParams() {
        SymmetryInterface c = this.getUnitCell(0);
        return c == null ? null : c.getUnitCellParams();
    }

    public boolean setCrystallographicDefaults() {
        return !this.haveBioModels && this.someModelsHaveSymmetry && this.someModelsHaveFractionalCoordinates;
    }

    public P3 getBoundBoxCenter(int modelIndex) {
        return this.isJmolDataFrameForModel(modelIndex) ? new P3() : (this.getDefaultBoundBox() == null ? this.boxInfo : this.defaultBBox).getBoundBoxCenter();
    }

    public V3 getBoundBoxCornerVector() {
        return this.boxInfo.getBoundBoxCornerVector();
    }

    public Point3fi[] getBBoxVertices() {
        return this.boxInfo.getBoundBoxVertices();
    }

    public void setBoundBox(T3 pt1, T3 pt2, boolean byCorner, float scale) {
        this.isBbcageDefault = false;
        this.bboxModels = null;
        this.bboxAtoms = null;
        this.boxInfo.setBoundBox(pt1, pt2, byCorner, scale);
    }

    public String getBoundBoxCommand(boolean withOptions) {
        if (!withOptions && this.bboxAtoms != null) {
            return "boundbox " + Escape.eBS(this.bboxAtoms);
        }
        this.ptTemp.setT(this.boxInfo.getBoundBoxCenter());
        V3 bbVector = this.boxInfo.getBoundBoxCornerVector();
        String s = withOptions ? "boundbox " + Escape.eP(this.ptTemp) + " " + Escape.eP(bbVector) + "\n#or\n" : "";
        this.ptTemp.sub(bbVector);
        s = s + "boundbox corners " + Escape.eP(this.ptTemp) + " ";
        this.ptTemp.scaleAdd2(2.0f, bbVector, this.ptTemp);
        float v = Math.abs(8.0f * bbVector.x * bbVector.y * bbVector.z);
        s = s + Escape.eP(this.ptTemp) + " # volume = " + v;
        return s;
    }

    public BS findAtomsInRectangle(Rectangle rect) {
        BS bsModels = this.vwr.getVisibleFramesBitSet();
        BS bs = new BS();
        int i = this.ac;
        while (--i >= 0) {
            Atom atom = this.at[i];
            if (!bsModels.get(atom.mi)) {
                i = this.am[atom.mi].firstAtomIndex;
                continue;
            }
            if (!atom.checkVisible() || !rect.contains(atom.sX, atom.sY)) continue;
            bs.set(i);
        }
        return bs;
    }

    public VDW getDefaultVdwType(int modelIndex) {
        return !this.am[modelIndex].isBioModel ? VDW.AUTO_BABEL : (this.am[modelIndex].hydrogenCount == 0 ? VDW.AUTO_JMOL : VDW.AUTO_BABEL);
    }

    public boolean setRotationRadius(int modelIndex, float angstroms) {
        if (this.isJmolDataFrameForModel(modelIndex)) {
            this.am[modelIndex].defaultRotationRadius = angstroms;
            return false;
        }
        return true;
    }

    public float calcRotationRadius(int modelIndex, P3 center, boolean useBoundBox) {
        if (this.isJmolDataFrameForModel(modelIndex)) {
            float r = this.am[modelIndex].defaultRotationRadius;
            return r == 0.0f ? 10.0f : r;
        }
        if (useBoundBox && this.getDefaultBoundBox() != null) {
            return this.defaultBBox.getMaxDim() / 2.0f * 1.2f;
        }
        float maxRadius = 0.0f;
        int i = this.ac;
        while (--i >= 0) {
            if (this.isJmolDataFrameForAtom(this.at[i])) {
                modelIndex = this.at[i].mi;
                while (i >= 0 && this.at[i].mi == modelIndex) {
                    --i;
                }
                continue;
            }
            Atom atom = this.at[i];
            float distAtom = center.distance(atom);
            float outerVdw = distAtom + this.getRadiusVdwJmol(atom);
            if (!(outerVdw > maxRadius)) continue;
            maxRadius = outerVdw;
        }
        return maxRadius == 0.0f ? 10.0f : maxRadius;
    }

    public void calcBoundBoxDimensions(BS bs, float scale) {
        if (bs != null && bs.nextSetBit(0) < 0) {
            bs = null;
        }
        if (bs == null && this.isBbcageDefault || this.ac == 0) {
            return;
        }
        if (this.getDefaultBoundBox() == null) {
            this.bboxAtoms = BSUtil.copy(bs);
            this.bboxModels = this.getModelBS(this.bboxAtoms, false);
            if (this.calcAtomsMinMax(bs, this.boxInfo) == this.ac) {
                this.isBbcageDefault = true;
            }
            if (bs == null && this.unitCells != null) {
                this.calcUnitCellMinMax();
            }
        } else {
            Point3fi[] vertices = this.defaultBBox.getBoundBoxVertices();
            this.boxInfo.reset();
            for (int j = 0; j < 8; ++j) {
                this.boxInfo.addBoundBoxPoint(vertices[j]);
            }
        }
        this.boxInfo.setBbcage(scale);
    }

    private BoxInfo getDefaultBoundBox() {
        T3[] bbox = (T3[])this.getInfoM("boundbox");
        if (bbox == null) {
            this.defaultBBox = null;
        } else {
            if (this.defaultBBox == null) {
                this.defaultBBox = new BoxInfo();
            }
            this.defaultBBox.setBoundBoxFromOABC(bbox);
        }
        return this.defaultBBox;
    }

    public BoxInfo getBoxInfo(BS bs, float scale) {
        if (bs == null) {
            return this.boxInfo;
        }
        BoxInfo bi = new BoxInfo();
        this.calcAtomsMinMax(bs, bi);
        bi.setBbcage(scale);
        return bi;
    }

    public int calcAtomsMinMax(BS bs, BoxInfo boxInfo) {
        int i0;
        boxInfo.reset();
        int nAtoms = 0;
        boolean isAll = bs == null;
        int i = i0 = isAll ? this.ac - 1 : bs.nextSetBit(0);
        while (i >= 0) {
            ++nAtoms;
            if (!this.isJmolDataFrameForAtom(this.at[i])) {
                boxInfo.addBoundBoxPoint(this.at[i]);
            }
            i = isAll ? i - 1 : bs.nextSetBit(i + 1);
        }
        return nAtoms;
    }

    private void calcUnitCellMinMax() {
        P3 pt = new P3();
        for (int i = 0; i < this.mc; ++i) {
            if (!this.unitCells[i].getCoordinatesAreFractional()) continue;
            P3[] vertices = this.unitCells[i].getUnitCellVerticesNoOffset();
            P3 offset = this.unitCells[i].getCartesianOffset();
            for (int j = 0; j < 8; ++j) {
                pt.add2(offset, vertices[j]);
                this.boxInfo.addBoundBoxPoint(pt);
            }
        }
    }

    public float calcRotationRadiusBs(BS bs) {
        P3 center = this.getAtomSetCenter(bs);
        float maxRadius = 0.0f;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            Atom atom = this.at[i];
            float distAtom = center.distance(atom);
            float outerVdw = distAtom + this.getRadiusVdwJmol(atom);
            if (outerVdw > maxRadius) {
                maxRadius = outerVdw;
            }
            i = bs.nextSetBit(i + 1);
        }
        return maxRadius == 0.0f ? 10.0f : maxRadius;
    }

    public P3[][] getCenterAndPoints(Lst<Object[]> vAtomSets, boolean addCenters) {
        BS bsAtoms2;
        BS bsAtoms1;
        int n = addCenters ? 1 : 0;
        int ii = vAtomSets.size();
        while (--ii >= 0) {
            Object[] bss = (Object[])vAtomSets.get(ii);
            bsAtoms1 = (BS)bss[0];
            if (bss[1] instanceof BS) {
                bsAtoms2 = (BS)bss[1];
                n += Math.min(bsAtoms1.cardinality(), bsAtoms2.cardinality());
                continue;
            }
            n += Math.min(bsAtoms1.cardinality(), ((P3[])bss[1]).length);
        }
        P3[][] points = new P3[2][n];
        if (addCenters) {
            points[0][0] = new P3();
            points[1][0] = new P3();
        }
        int ii2 = vAtomSets.size();
        while (--ii2 >= 0) {
            Object[] bss = (Object[])vAtomSets.get(ii2);
            bsAtoms1 = (BS)bss[0];
            if (bss[1] instanceof BS) {
                bsAtoms2 = (BS)bss[1];
                int i = bsAtoms1.nextSetBit(0);
                int j = bsAtoms2.nextSetBit(0);
                while (i >= 0 && j >= 0) {
                    points[0][--n] = this.at[i];
                    points[1][n] = this.at[j];
                    if (addCenters) {
                        points[0][0].add(this.at[i]);
                        points[1][0].add(this.at[j]);
                    }
                    i = bsAtoms1.nextSetBit(i + 1);
                    j = bsAtoms2.nextSetBit(j + 1);
                }
                continue;
            }
            P3[] coords = (P3[])bss[1];
            int i = bsAtoms1.nextSetBit(0);
            for (int j = 0; i >= 0 && j < coords.length; ++j) {
                points[0][--n] = this.at[i];
                points[1][n] = coords[j];
                if (addCenters) {
                    points[0][0].add(this.at[i]);
                    points[1][0].add(coords[j]);
                }
                i = bsAtoms1.nextSetBit(i + 1);
            }
        }
        if (addCenters) {
            points[0][0].scale(1.0f / (float)(points[0].length - 1));
            points[1][0].scale(1.0f / (float)(points[1].length - 1));
        }
        return points;
    }

    public P3 getAtomSetCenter(BS bs) {
        P3 ptCenter = new P3();
        int nPoints = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            if (!this.isJmolDataFrameForAtom(this.at[i])) {
                ++nPoints;
                ptCenter.add(this.at[i]);
            }
            i = bs.nextSetBit(i + 1);
        }
        if (nPoints > 1) {
            ptCenter.scale(1.0f / (float)nPoints);
        }
        return ptCenter;
    }

    public P3 getAverageAtomPoint() {
        if (this.averageAtomPoint == null) {
            this.averageAtomPoint = this.getAtomSetCenter(this.vwr.getAllAtoms());
        }
        return this.averageAtomPoint;
    }

    protected void setAPm(BS bs, int tok, int iValue, float fValue, String sValue, float[] values, String[] list) {
        this.setAPa(bs, tok, iValue, fValue, sValue, values, list);
        switch (tok) {
            case 1094715417: 
            case 1631586315: {
                if (!this.vwr.getBoolean(603979944)) break;
                this.assignAromaticBondsBs(true, null);
            }
        }
    }

    public StateScript addStateScript(String script1, BS bsBonds, BS bsAtoms1, BS bsAtoms2, String script2, boolean addFrameNumber, boolean postDefinitions) {
        int iModel = this.vwr.am.cmi;
        if (addFrameNumber) {
            if (this.thisStateModel != iModel) {
                script1 = "frame " + (iModel < 0 ? "all #" + iModel : this.getModelNumberDotted(iModel)) + ";\n  " + script1;
            }
            this.thisStateModel = iModel;
        } else {
            this.thisStateModel = -1;
        }
        StateScript stateScript = new StateScript(this.thisStateModel, script1, bsBonds, bsAtoms1, bsAtoms2, script2, postDefinitions);
        if (stateScript.isValid()) {
            this.stateScripts.addLast(stateScript);
        }
        return stateScript;
    }

    void freezeModels() {
        this.haveBioModels = false;
        int iModel = this.mc;
        while (--iModel >= 0) {
            this.haveBioModels |= this.am[iModel].freeze();
        }
    }

    public Map<STR, float[]> getStructureList() {
        return this.vwr.getStructureList();
    }

    public Object getInfoM(String keyName) {
        return this.msInfo == null ? null : this.msInfo.get(keyName);
    }

    public boolean getMSInfoB(String keyName) {
        Object val = this.getInfoM(keyName);
        return val instanceof Boolean && (Boolean)val != false;
    }

    public boolean isTrajectory(int modelIndex) {
        return this.am[modelIndex].isTrajectory;
    }

    public boolean isTrajectorySubFrame(int i) {
        return this.am[i].trajectoryBaseIndex != i;
    }

    public boolean isTrajectoryMeasurement(int[] countPlusIndices) {
        return this.trajectory != null && this.trajectory.hasMeasure(countPlusIndices);
    }

    public BS getModelBS(BS atomList, boolean allTrajectories) {
        int i0;
        BS bs = new BS();
        short modelIndex = 0;
        boolean isAll = atomList == null;
        allTrajectories &= this.trajectory != null;
        int i = i0 = isAll ? 0 : atomList.nextSetBit(0);
        while (i >= 0 && i < this.ac) {
            modelIndex = this.at[i].mi;
            bs.set(modelIndex);
            if (allTrajectories) {
                this.trajectory.getModelBS(modelIndex, bs);
            }
            i = this.am[modelIndex].firstAtomIndex + this.am[modelIndex].act - 1;
            i = isAll ? i + 1 : atomList.nextSetBit(i + 1);
        }
        return bs;
    }

    public BS getIterativeModels(boolean allowJmolData) {
        BS bs = new BS();
        for (int i = 0; i < this.mc; ++i) {
            if (!allowJmolData && this.isJmolDataFrameForModel(i) || this.isTrajectorySubFrame(i)) continue;
            bs.set(i);
        }
        return bs;
    }

    public void fillAtomData(AtomData atomData, int mode) {
        if ((mode & 4) != 0) {
            this.getMolecules();
            atomData.bsMolecules = new BS[this.molecules.length];
            atomData.atomMolecule = new int[this.ac];
            for (int i = 0; i < this.molecules.length; ++i) {
                BS bs = atomData.bsMolecules[i] = this.molecules[i].atomList;
                int iAtom = bs.nextSetBit(0);
                while (iAtom >= 0) {
                    atomData.atomMolecule[iAtom] = i;
                    iAtom = bs.nextSetBit(iAtom + 1);
                }
            }
        }
        if ((mode & 8) != 0) {
            int[] nH = new int[1];
            atomData.hAtomRadius = (float)this.vwr.getVanderwaalsMar(1) / 1000.0f;
            atomData.hAtoms = this.calculateHydrogens(atomData.bsSelected, nH, false, true, null);
            atomData.hydrogenAtomCount = nH[0];
            return;
        }
        atomData.firstAtomIndex = atomData.modelIndex < 0 ? (atomData.bsSelected == null ? 0 : Math.max(0, atomData.bsSelected.nextSetBit(0))) : this.am[atomData.modelIndex].firstAtomIndex;
        atomData.firstModelIndex = this.ac == 0 ? 0 : (int)this.at[atomData.firstAtomIndex].mi;
        atomData.lastModelIndex = atomData.firstModelIndex;
        atomData.modelName = this.getModelNumberDotted(atomData.firstModelIndex);
        this.fillADa(atomData, mode);
    }

    public String getModelNumberDotted(int modelIndex) {
        return this.mc < 1 || modelIndex >= this.mc || modelIndex < 0 ? "" : Escape.escapeModelFileNumber(this.modelFileNumbers[modelIndex]);
    }

    public int getModelNumber(int modelIndex) {
        return this.modelNumbers[modelIndex == Integer.MAX_VALUE ? this.mc - 1 : modelIndex];
    }

    public String getModelProperty(int modelIndex, String property) {
        Properties props = this.am[modelIndex].properties;
        return props == null ? null : props.getProperty(property);
    }

    public Map<String, Object> getModelAuxiliaryInfo(int modelIndex) {
        return modelIndex < 0 ? null : this.am[modelIndex].auxiliaryInfo;
    }

    public void setInfo(int modelIndex, Object key, Object value) {
        if (modelIndex >= 0 && modelIndex < this.mc) {
            this.am[modelIndex].auxiliaryInfo.put((String)key, value);
        }
    }

    public Object getInfo(int modelIndex, String key) {
        return modelIndex < 0 ? null : this.am[modelIndex].auxiliaryInfo.get(key);
    }

    protected boolean getInfoB(int modelIndex, String keyName) {
        Map<String, Object> info = this.am[modelIndex].auxiliaryInfo;
        return info != null && info.containsKey(keyName) && (Boolean)info.get(keyName) != false;
    }

    protected int getInfoI(int modelIndex, String keyName) {
        Map<String, Object> info = this.am[modelIndex].auxiliaryInfo;
        if (info != null && info.containsKey(keyName)) {
            return (Integer)info.get(keyName);
        }
        return Integer.MIN_VALUE;
    }

    public int getInsertionCountInModel(int modelIndex) {
        return this.am[modelIndex].insertionCount;
    }

    public static int modelFileNumberFromFloat(float fDotM) {
        int model;
        int file = (int)Math.floor(fDotM);
        for (model = (int)Math.floor(((double)(fDotM - (float)file) + 1.0E-5) * 10000.0); model != 0 && model % 10 == 0; model /= 10) {
        }
        return file * 1000000 + model;
    }

    public int getChainCountInModelWater(int modelIndex, boolean countWater) {
        if (modelIndex < 0) {
            int chainCount = 0;
            int i = this.mc;
            while (--i >= 0) {
                chainCount += this.am[i].getChainCount(countWater);
            }
            return chainCount;
        }
        return this.am[modelIndex].getChainCount(countWater);
    }

    public int getGroupCountInModel(int modelIndex) {
        if (modelIndex < 0) {
            int groupCount = 0;
            int i = this.mc;
            while (--i >= 0) {
                groupCount += this.am[i].getGroupCount();
            }
            return groupCount;
        }
        return this.am[modelIndex].getGroupCount();
    }

    public void calcSelectedGroupsCount() {
        BS bsSelected = this.vwr.bsA();
        int i = this.mc;
        while (--i >= 0) {
            this.am[i].calcSelectedGroupsCount(bsSelected);
        }
    }

    public boolean isJmolDataFrameForModel(int modelIndex) {
        return modelIndex >= 0 && modelIndex < this.mc && this.am[modelIndex].isJmolDataFrame;
    }

    private boolean isJmolDataFrameForAtom(Atom atom) {
        return this.am[atom.mi].isJmolDataFrame;
    }

    public void setJmolDataFrame(String type, int modelIndex, int modelDataIndex) {
        Model model = this.am[type == null ? this.am[modelDataIndex].dataSourceFrame : modelIndex];
        if (type == null) {
            type = this.am[modelDataIndex].jmolFrameType;
        }
        if (modelIndex >= 0) {
            if (model.dataFrames == null) {
                model.dataFrames = new Hashtable<String, Integer>();
            }
            this.am[modelDataIndex].dataSourceFrame = modelIndex;
            this.am[modelDataIndex].jmolFrameType = type;
            model.dataFrames.put(type, modelDataIndex);
        }
        if (type.startsWith("quaternion") && type.indexOf("deriv") < 0) {
            type = type.substring(0, type.indexOf(" "));
            model.dataFrames.put(type, modelDataIndex);
        }
    }

    public int getJmolDataFrameIndex(int modelIndex, String type) {
        if (this.am[modelIndex].dataFrames == null) {
            return -1;
        }
        Integer index = this.am[modelIndex].dataFrames.get(type);
        return index == null ? -1 : index;
    }

    protected void clearDataFrameReference(int modelIndex) {
        for (int i = 0; i < this.mc; ++i) {
            Map<String, Integer> df = this.am[i].dataFrames;
            if (df == null) continue;
            Iterator<Integer> e = df.values().iterator();
            while (e.hasNext()) {
                if (e.next() != modelIndex) continue;
                e.remove();
            }
        }
    }

    public String getJmolFrameType(int modelIndex) {
        return modelIndex >= 0 && modelIndex < this.mc ? this.am[modelIndex].jmolFrameType : "modelSet";
    }

    public int getJmolDataSourceFrame(int modelIndex) {
        return modelIndex >= 0 && modelIndex < this.mc ? this.am[modelIndex].dataSourceFrame : -1;
    }

    public void saveModelOrientation(int modelIndex, Orientation orientation) {
        this.am[modelIndex].orientation = orientation;
    }

    public Orientation getModelOrientation(int modelIndex) {
        return this.am[modelIndex].orientation;
    }

    public String getPDBHeader(int modelIndex) {
        return this.am[modelIndex].isBioModel ? ((BioModel)this.am[modelIndex]).getFullPDBHeader() : this.getFileHeader(modelIndex);
    }

    public String getFileHeader(int modelIndex) {
        if (modelIndex < 0) {
            return "";
        }
        if (this.am[modelIndex].isBioModel) {
            return this.getPDBHeader(modelIndex);
        }
        String info = (String)this.getInfo(modelIndex, "fileHeader");
        if (info == null) {
            info = this.modelSetName;
        }
        if (info != null) {
            return info;
        }
        return "no header information found";
    }

    public int getAltLocCountInModel(int modelIndex) {
        return this.am[modelIndex].altLocCount;
    }

    public int getAltLocIndexInModel(int modelIndex, char alternateLocationID) {
        if (alternateLocationID == '\u0000') {
            return 0;
        }
        String altLocList = this.getAltLocListInModel(modelIndex);
        if (altLocList.length() == 0) {
            return 0;
        }
        return altLocList.indexOf(alternateLocationID) + 1;
    }

    public int getInsertionCodeIndexInModel(int modelIndex, char insertionCode) {
        if (insertionCode == '\u0000') {
            return 0;
        }
        String codeList = this.getInsertionListInModel(modelIndex);
        if (codeList.length() == 0) {
            return 0;
        }
        return codeList.indexOf(insertionCode) + 1;
    }

    public String getAltLocListInModel(int modelIndex) {
        String str = (String)this.getInfo(modelIndex, "altLocs");
        return str == null ? "" : str;
    }

    private String getInsertionListInModel(int modelIndex) {
        String str = (String)this.getInfo(modelIndex, "insertionCodes");
        return str == null ? "" : str;
    }

    public int getModelSymmetryCount(int modelIndex) {
        return this.am[modelIndex].biosymmetryCount > 0 ? this.am[modelIndex].biosymmetryCount : (this.unitCells == null || this.unitCells[modelIndex] == null ? 0 : this.unitCells[modelIndex].getSpaceGroupOperationCount());
    }

    public int[] getModelCellRange(int modelIndex) {
        return this.unitCells == null ? null : this.unitCells[modelIndex].getCellRange();
    }

    public int getLastVibrationVector(int modelIndex, int tok) {
        if (this.vibrations != null) {
            int a1 = modelIndex < 0 || this.isTrajectory(modelIndex) || modelIndex >= this.mc - 1 ? this.ac : this.am[modelIndex + 1].firstAtomIndex;
            int a0 = modelIndex <= 0 ? 0 : this.am[modelIndex].firstAtomIndex;
            int i = a1;
            while (--i >= a0) {
                Vibration v;
                if (modelIndex >= 0 && this.at[i].mi != modelIndex || (tok != 1275072532 && tok != 0 || (v = (Vibration)((Object)this.getModulation(i))) == null) && (tok != 4166 && tok != 0 || (v = this.getVibration(i, false)) == null) || !v.isNonzero()) continue;
                return i;
            }
        }
        return -1;
    }

    public Lst<Object> getModulationList(BS bs, char type, P3 t456) {
        Lst<Object> list = new Lst<Object>();
        if (this.vibrations != null) {
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                if (this.vibrations[i] instanceof JmolModulationSet) {
                    list.addLast(((JmolModulationSet)((Object)this.vibrations[i])).getModulation(type, t456));
                } else {
                    list.addLast(Float.valueOf(type == 'O' ? Float.NaN : -1.0f));
                }
                i = bs.nextSetBit(i + 1);
            }
        }
        return list;
    }

    public BS getElementsPresentBitSet(int modelIndex) {
        if (modelIndex >= 0) {
            return this.elementsPresent[modelIndex];
        }
        BS bs = new BS();
        for (int i = 0; i < this.mc; ++i) {
            bs.or(this.elementsPresent[i]);
        }
        return bs;
    }

    public int getMoleculeIndex(int atomIndex, boolean inModel) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(atomIndex)) continue;
            return inModel ? this.molecules[i].indexInModel : i;
        }
        return 0;
    }

    public BS getMoleculeBitSet(BS bs) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        BS bsResult = BSUtil.copy(bs);
        BS bsInitial = BSUtil.copy(bs);
        int i = 0;
        BS bsTemp = new BS();
        while ((i = bsInitial.length() - 1) >= 0) {
            bsTemp = this.getMoleculeBitSetForAtom(i);
            if (bsTemp == null) {
                bsInitial.clear(i);
                bsResult.clear(i);
                continue;
            }
            bsInitial.andNot(bsTemp);
            bsResult.or(bsTemp);
        }
        return bsResult;
    }

    public BS getMoleculeBitSetForAtom(int atomIndex) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(atomIndex)) continue;
            return this.molecules[i].atomList;
        }
        return null;
    }

    public V3 getModelDipole(int modelIndex) {
        if (modelIndex < 0) {
            return null;
        }
        V3 dipole = (V3)this.getInfo(modelIndex, "dipole");
        if (dipole == null) {
            dipole = (V3)this.getInfo(modelIndex, "DIPOLE_VEC");
        }
        return dipole;
    }

    public V3 calculateMolecularDipole(int modelIndex, BS bsAtoms) throws JmolAsyncException {
        if (bsAtoms != null) {
            int ia = bsAtoms.nextSetBit(0);
            if (ia < 0) {
                return null;
            }
            modelIndex = this.at[ia].mi;
        }
        if (modelIndex < 0) {
            return null;
        }
        int nPos = 0;
        int nNeg = 0;
        float cPos = 0.0f;
        float cNeg = 0.0f;
        V3 pos = new V3();
        V3 neg = new V3();
        if (bsAtoms == null) {
            bsAtoms = this.getModelAtomBitSetIncludingDeleted(-1, false);
        }
        this.vwr.getOrCalcPartialCharges(this.am[modelIndex].bsAtoms, null);
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            if (this.at[i].mi == modelIndex && !this.at[i].isDeleted()) {
                float c = this.partialCharges[i];
                if (c < 0.0f) {
                    ++nNeg;
                    cNeg += c;
                    neg.scaleAdd2(c, this.at[i], neg);
                } else if (c > 0.0f) {
                    ++nPos;
                    cPos += c;
                    pos.scaleAdd2(c, this.at[i], pos);
                }
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        if ((double)Math.abs(cPos + cNeg) > 0.015) {
            Logger.info("Dipole calculation requires balanced charges: " + cPos + " " + cNeg);
            return null;
        }
        if (nNeg == 0 || nPos == 0) {
            return null;
        }
        pos.add(neg);
        pos.scale(4.8f);
        return pos;
    }

    public int getMoleculeCountInModel(int modelIndex) {
        int n = 0;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        if (modelIndex < 0) {
            return this.moleculeCount;
        }
        for (int i = 0; i < this.mc; ++i) {
            if (modelIndex != i) continue;
            n += this.am[i].moleculeCount;
        }
        return n;
    }

    public void calcSelectedMoleculesCount() {
        BS bsSelected = this.vwr.bsA();
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        this.selectedMolecules.xor(this.selectedMolecules);
        BS bsTemp = new BS();
        for (int i = 0; i < this.moleculeCount; ++i) {
            BSUtil.copy2(bsSelected, bsTemp);
            bsTemp.and(this.molecules[i].atomList);
            if (bsTemp.length() <= 0) continue;
            this.selectedMolecules.set(i);
        }
    }

    public void setCentroid(BS bs, int[] minmax) {
        BS bsDelete = this.getNotInCentroid(bs, minmax);
        if (bsDelete != null && bsDelete.nextSetBit(0) >= 0) {
            this.vwr.deleteAtoms(bsDelete, false);
        }
    }

    private BS getNotInCentroid(BS bs, int[] minmax) {
        int iAtom0 = bs.nextSetBit(0);
        if (iAtom0 < 0) {
            return null;
        }
        SymmetryInterface uc = this.getUnitCell(this.at[iAtom0].mi);
        return uc == null ? null : uc.notInCentroid(this, bs, minmax);
    }

    public JmolMolecule[] getMolecules() {
        int i;
        if (this.moleculeCount > 0) {
            return this.molecules;
        }
        if (this.molecules == null) {
            this.molecules = new JmolMolecule[4];
        }
        this.moleculeCount = 0;
        Model m = null;
        BS[] bsModelAtoms = new BS[this.mc];
        Lst<BS> biobranches = null;
        for (i = 0; i < this.mc; ++i) {
            bsModelAtoms[i] = this.vwr.getModelUndeletedAtomsBitSet(i);
            m = this.am[i];
            m.moleculeCount = 0;
            biobranches = m.isBioModel ? ((BioModel)m).getBioBranches(biobranches) : null;
        }
        this.molecules = JmolMolecule.getMolecules(this.at, bsModelAtoms, biobranches, null);
        i = this.moleculeCount = this.molecules.length;
        while (--i >= 0) {
            m = this.am[this.molecules[i].modelIndex];
            m.firstMoleculeIndex = i;
            ++m.moleculeCount;
        }
        return this.molecules;
    }

    protected void initializeBspf() {
        if (this.bspf != null && this.bspf.isValid) {
            return;
        }
        if (this.showRebondTimes) {
            Logger.startTimer("build bspf");
        }
        Bspf bspf = new Bspf(3);
        if (Logger.debugging) {
            Logger.debug("sequential bspt order");
        }
        BS bsNew = BS.newN(this.mc);
        int i = this.ac;
        while (--i >= 0) {
            Atom atom = this.at[i];
            if (atom.isDeleted() || this.isTrajectorySubFrame(atom.mi)) continue;
            bspf.addTuple(this.am[atom.mi].trajectoryBaseIndex, atom);
            bsNew.set(atom.mi);
        }
        if (this.showRebondTimes) {
            Logger.checkTimer("build bspf", false);
            bspf.stats();
        }
        i = bsNew.nextSetBit(0);
        while (i >= 0) {
            bspf.validateModel(i, true);
            i = bsNew.nextSetBit(i + 1);
        }
        bspf.isValid = true;
        this.bspf = bspf;
    }

    protected void initializeBspt(int modelIndex) {
        this.initializeBspf();
        if (this.bspf.isInitializedIndex(modelIndex)) {
            return;
        }
        this.bspf.initialize(modelIndex, this.at, this.vwr.getModelUndeletedAtomsBitSet(modelIndex));
    }

    public void setIteratorForPoint(AtomIndexIterator iterator, int modelIndex, T3 pt, float distance) {
        if (modelIndex < 0) {
            iterator.setCenter(pt, distance);
            return;
        }
        this.initializeBspt(modelIndex);
        iterator.setModel(this, modelIndex, this.am[modelIndex].firstAtomIndex, Integer.MAX_VALUE, pt, distance, null);
    }

    public void setIteratorForAtom(AtomIndexIterator iterator, int modelIndex, int atomIndex, float distance, RadiusData rd) {
        if (modelIndex < 0) {
            modelIndex = this.at[atomIndex].mi;
        }
        modelIndex = this.am[modelIndex].trajectoryBaseIndex;
        this.initializeBspt(modelIndex);
        iterator.setModel(this, modelIndex, this.am[modelIndex].firstAtomIndex, atomIndex, this.at[atomIndex], distance, rd);
    }

    public AtomIndexIterator getSelectedAtomIterator(BS bsSelected, boolean isGreaterOnly, boolean modelZeroBased, boolean hemisphereOnly, boolean isMultiModel) {
        AtomIteratorWithinModel iter;
        this.initializeBspf();
        if (isMultiModel) {
            BS bsModels = this.getModelBS(bsSelected, false);
            int i = bsModels.nextSetBit(0);
            while (i >= 0) {
                this.initializeBspt(i);
                i = bsModels.nextSetBit(i + 1);
            }
            iter = new AtomIteratorWithinModelSet(bsModels);
        } else {
            iter = new AtomIteratorWithinModel();
        }
        iter.initialize(this.bspf, bsSelected, isGreaterOnly, modelZeroBased, hemisphereOnly, this.vwr.isParallel());
        return iter;
    }

    @Override
    public int getBondCountInModel(int modelIndex) {
        return modelIndex < 0 ? this.bondCount : this.am[modelIndex].getBondCount();
    }

    public int getAtomCountInModel(int modelIndex) {
        return modelIndex < 0 ? this.ac : this.am[modelIndex].act;
    }

    public BS getModelAtomBitSetIncludingDeletedBs(BS bsModels) {
        BS bs = new BS();
        if (bsModels == null && this.bsAll == null) {
            this.bsAll = BSUtil.setAll(this.ac);
        }
        if (bsModels == null) {
            bs.or(this.bsAll);
        } else {
            int i = bsModels.nextSetBit(0);
            while (i >= 0) {
                bs.or(this.getModelAtomBitSetIncludingDeleted(i, false));
                i = bsModels.nextSetBit(i + 1);
            }
        }
        return bs;
    }

    public BS getModelAtomBitSetIncludingDeleted(int modelIndex, boolean asCopy) {
        BS bs;
        BS bS = bs = modelIndex < 0 ? this.bsAll : this.am[modelIndex].bsAtoms;
        if (bs == null) {
            bs = this.bsAll = BSUtil.setAll(this.ac);
        }
        return asCopy ? BSUtil.copy(bs) : bs;
    }

    protected BS getAtomBitsMaybeDeleted(int tokType, Object specInfo) {
        switch (tokType) {
            default: {
                BS bs = new BS();
                return this.getAtomBitsMDa(tokType, specInfo, bs);
            }
            case 1073741863: 
            case 1073741925: 
            case 1073742128: 
            case 1073742189: 
            case 1086324744: 
            case 1111490587: {
                BS bs = new BS();
                return this.haveBioModels ? this.bioModelset.getAtomBitsStr(tokType, (String)specInfo, bs) : bs;
            }
            case 1073742331: 
            case 1677721602: {
                return this.getAtomBitsMDb(tokType, specInfo);
            }
            case 1678381065: {
                BoxInfo boxInfo = this.getBoxInfo((BS)specInfo, 1.0f);
                BS bs = this.getAtomsWithin(boxInfo.getBoundBoxCornerVector().length() + 1.0E-4f, boxInfo.getBoundBoxCenter(), null, -1);
                int i = bs.nextSetBit(0);
                while (i >= 0) {
                    if (!boxInfo.isWithin(this.at[i])) {
                        bs.clear(i);
                    }
                    i = bs.nextSetBit(i + 1);
                }
                return bs;
            }
            case 1094713349: {
                BS bs = new BS();
                int[] info = (int[])specInfo;
                this.ptTemp1.set((float)info[0] / 1000.0f, (float)info[1] / 1000.0f, (float)info[2] / 1000.0f);
                boolean ignoreOffset = false;
                int i = this.ac;
                while (--i >= 0) {
                    if (!this.isInLatticeCell(i, this.ptTemp1, this.ptTemp2, ignoreOffset)) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 1094713350: {
                BS bs = BSUtil.newBitSet2(0, this.ac);
                int[] info = (int[])specInfo;
                int[] minmax = new int[]{info[0] / 1000 - 1, info[1] / 1000 - 1, info[2] / 1000 - 1, info[0] / 1000, info[1] / 1000, info[2] / 1000, 0};
                int i = this.mc;
                while (--i >= 0) {
                    SymmetryInterface uc = this.getUnitCell(i);
                    if (uc == null) {
                        BSUtil.andNot(bs, this.am[i].bsAtoms);
                        continue;
                    }
                    bs.andNot(uc.notInCentroid(this, this.am[i].bsAtoms, minmax));
                }
                return bs;
            }
            case 0x41400010: {
                return this.getMoleculeBitSet((BS)specInfo);
            }
            case 1073742363: {
                return this.getSelectCodeRange((int[])specInfo);
            }
            case 0x20002C: {
                BS bs = BS.newN(this.ac);
                short modelIndex = -1;
                int nOps = 0;
                int i = this.ac;
                block15: while (--i >= 0) {
                    Atom atom = this.at[i];
                    BS bsSym = atom.atomSymmetry;
                    if (bsSym == null) continue;
                    if (atom.mi != modelIndex) {
                        modelIndex = atom.mi;
                        if (this.getModelCellRange(modelIndex) == null) continue;
                        nOps = this.getModelSymmetryCount(modelIndex);
                    }
                    int n = 0;
                    int j = nOps;
                    while (--j >= 0) {
                        if (!bsSym.get(j) || ++n <= 1) continue;
                        bs.set(i);
                        continue block15;
                    }
                }
                return bs;
            }
            case 1088421903: {
                return BSUtil.copy(this.bsSymmetry == null ? (this.bsSymmetry = BS.newN(this.ac)) : this.bsSymmetry);
            }
            case 1814695966: 
        }
        BS bs = new BS();
        SymmetryInterface unitcell = this.vwr.getCurrentUnitCell();
        if (unitcell == null) {
            return bs;
        }
        this.ptTemp1.set(1.0f, 1.0f, 1.0f);
        int i = this.ac;
        while (--i >= 0) {
            if (!this.isInLatticeCell(i, this.ptTemp1, this.ptTemp2, false)) continue;
            bs.set(i);
        }
        return bs;
    }

    private BS getSelectCodeRange(int[] info) {
        BS bs = new BS();
        int seqcodeA = info[0];
        int seqcodeB = info[1];
        int chainID = info[2];
        boolean caseSensitive = this.vwr.getBoolean(603979823);
        if (chainID >= 0 && chainID < 300 && !caseSensitive) {
            chainID = this.chainToUpper(chainID);
        }
        int iModel = this.mc;
        while (--iModel >= 0) {
            if (!this.am[iModel].isBioModel) continue;
            BioModel m = (BioModel)this.am[iModel];
            int i = m.chainCount;
            while (--i >= 0) {
                int id;
                Chain chain = m.chains[i];
                if (chainID != -1 && chainID != (id = chain.chainID) && (caseSensitive || id <= 0 || id >= 300 || chainID != this.chainToUpper(id))) continue;
                Group[] groups = chain.groups;
                int n = chain.groupCount;
                int index = 0;
                while (index >= 0) {
                    index = ModelSet.selectSeqcodeRange(groups, n, index, seqcodeA, seqcodeB, bs);
                }
            }
        }
        return bs;
    }

    private static int selectSeqcodeRange(Group[] groups, int n, int index, int seqcodeA, int seqcodeB, BS bs) {
        int indexB;
        int seqcode;
        int i;
        int minDiff;
        int indexA;
        boolean isInexact = false;
        for (indexA = index; indexA < n && groups[indexA].seqcode != seqcodeA; ++indexA) {
        }
        if (indexA == n) {
            if (index > 0) {
                return -1;
            }
            isInexact = true;
            minDiff = Integer.MAX_VALUE;
            i = n;
            while (--i >= 0) {
                seqcode = groups[i].seqcode;
                if (seqcode <= seqcodeA || seqcode - seqcodeA >= minDiff) continue;
                indexA = i;
                minDiff = seqcode - seqcodeA;
            }
            if (minDiff == Integer.MAX_VALUE) {
                return -1;
            }
        }
        if (seqcodeB == Integer.MAX_VALUE) {
            indexB = n - 1;
            isInexact = true;
        } else {
            for (indexB = indexA; indexB < n && groups[indexB].seqcode != seqcodeB; ++indexB) {
            }
            if (indexB == n) {
                if (index > 0) {
                    return -1;
                }
                isInexact = true;
                minDiff = Integer.MAX_VALUE;
                for (i = indexA; i < n; ++i) {
                    seqcode = groups[i].seqcode;
                    if (seqcode >= seqcodeB || seqcodeB - seqcode >= minDiff) continue;
                    indexB = i;
                    minDiff = seqcodeB - seqcode;
                }
                if (minDiff == Integer.MAX_VALUE) {
                    return -1;
                }
            }
        }
        for (i = indexA; i <= indexB; ++i) {
            groups[i].setAtomBits(bs);
        }
        return isInexact ? -1 : indexB + 1;
    }

    private boolean isInLatticeCell(int i, P3 cell, P3 ptTemp, boolean isAbsolute) {
        short iModel = this.at[i].mi;
        SymmetryInterface uc = this.getUnitCell(iModel);
        ptTemp.setT(this.at[i]);
        return uc != null && uc.checkUnitCell(uc, cell, ptTemp, isAbsolute);
    }

    public BS getAtomsWithinRadius(float distance, BS bs, boolean withinAllModels, RadiusData rd) {
        BS bsResult = new BS();
        BS bsCheck = this.getIterativeModels(false);
        bs = BSUtil.andNot(bs, this.vwr.slm.bsDeleted);
        AtomIndexIterator iter = this.getSelectedAtomIterator(null, false, false, false, false);
        if (withinAllModels) {
            boolean fixJavaFloat = !this.vwr.g.legacyJavaFloat;
            P3 ptTemp = new P3();
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                int iModel = this.mc;
                while (--iModel >= 0) {
                    if (!bsCheck.get(iModel)) continue;
                    if (distance < 0.0f) {
                        this.getAtomsWithin(distance, this.at[i].getFractionalUnitCoordPt(fixJavaFloat, true, ptTemp), bsResult, -1);
                        continue;
                    }
                    this.setIteratorForAtom(iter, iModel, i, distance, rd);
                    iter.addAtoms(bsResult);
                }
                i = bs.nextSetBit(i + 1);
            }
        } else {
            bsResult.or(bs);
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                if (distance < 0.0f) {
                    this.getAtomsWithin(distance, this.at[i], bsResult, this.at[i].mi);
                } else {
                    this.setIteratorForAtom(iter, -1, i, distance, rd);
                    iter.addAtoms(bsResult);
                }
                i = bs.nextSetBit(i + 1);
            }
        }
        iter.release();
        return bsResult;
    }

    public BS getAtomsWithin(float distance, T3 coord, BS bsResult, int modelIndex) {
        if (bsResult == null) {
            bsResult = new BS();
        }
        if (distance < 0.0f) {
            distance = -distance;
            int i = this.ac;
            while (--i >= 0) {
                Atom atom = this.at[i];
                if (modelIndex >= 0 && this.at[i].mi != modelIndex || bsResult.get(i) || !(atom.getFractionalUnitDistance(coord, this.ptTemp1, this.ptTemp2) <= distance)) continue;
                bsResult.set(atom.i);
            }
            return bsResult;
        }
        BS bsCheck = this.getIterativeModels(true);
        AtomIndexIterator iter = this.getSelectedAtomIterator(null, false, false, false, false);
        int iModel = this.mc;
        while (--iModel >= 0) {
            if (!bsCheck.get(iModel) || this.am[iModel].bsAtoms.isEmpty()) continue;
            this.setIteratorForAtom(iter, -1, this.am[iModel].firstAtomIndex, -1.0f, null);
            iter.setCenter(coord, distance);
            iter.addAtoms(bsResult);
        }
        iter.release();
        return bsResult;
    }

    public void deleteBonds(BS bsBonds, boolean isFullModel) {
        if (!isFullModel) {
            BS bsA = new BS();
            BS bsB = new BS();
            int i = bsBonds.nextSetBit(0);
            while (i >= 0) {
                Atom atom1 = this.bo[i].atom1;
                if (!this.am[atom1.mi].isModelKit) {
                    bsA.clearAll();
                    bsB.clearAll();
                    bsA.set(atom1.i);
                    bsB.set(this.bo[i].getAtomIndex2());
                    this.addStateScript("connect ", null, bsA, bsB, "delete", false, true);
                }
                i = bsBonds.nextSetBit(i + 1);
            }
        }
        this.dBb(bsBonds, isFullModel);
    }

    public int[] makeConnections2(float minD, float maxD, int order, int connectOperation, BS bsA, BS bsB, BS bsBonds, boolean isBonds, boolean addGroup, float energy) {
        boolean checkDistance;
        boolean isAtrop;
        if (bsBonds == null) {
            bsBonds = new BS();
        }
        boolean matchAny = order == 65535;
        boolean matchNull = order == 131071;
        boolean bl = isAtrop = order == 65537;
        if (matchNull) {
            order = 1;
        }
        boolean matchHbond = Edge.isOrderH(order);
        boolean identifyOnly = false;
        boolean idOrModifyOnly = false;
        boolean createOnly = false;
        boolean autoAromatize = false;
        switch (connectOperation) {
            case 12291: {
                return this.deleteConnections(minD, maxD, order, bsA, bsB, isBonds, matchNull);
            }
            case 603979873: 
            case 1073741852: {
                if (order != 515) {
                    if (isBonds) {
                        BS bs = bsA;
                        bsA = new BS();
                        bsB = new BS();
                        int i = bs.nextSetBit(0);
                        while (i >= 0) {
                            bsA.set(this.bo[i].atom1.i);
                            bsB.set(this.bo[i].atom2.i);
                            i = bs.nextSetBit(i + 1);
                        }
                    }
                    return new int[]{matchHbond ? this.autoHbond(bsA, bsB, false) : this.autoBondBs4(bsA, bsB, null, bsBonds, this.vwr.getMadBond(), connectOperation == 603979873), 0};
                }
                autoAromatize = true;
                idOrModifyOnly = true;
                break;
            }
            case 1086324745: {
                idOrModifyOnly = true;
                identifyOnly = true;
                break;
            }
            case 1073742025: {
                idOrModifyOnly = true;
                break;
            }
            case 0x40000050: {
                createOnly = true;
            }
        }
        boolean anyOrNoId = !identifyOnly || matchAny;
        boolean notAnyAndNoId = !identifyOnly && !matchAny;
        this.defaultCovalentMad = this.vwr.getMadBond();
        boolean minDIsFrac = minD < 0.0f;
        boolean maxDIsFrac = maxD < 0.0f;
        boolean isFractional = minDIsFrac || maxDIsFrac;
        boolean bl2 = checkDistance = !isBonds || minD != 0.1f || maxD != 1.0E8f;
        if (checkDistance) {
            minD = this.fixD(minD, minDIsFrac);
            maxD = this.fixD(maxD, maxDIsFrac);
        }
        short mad = this.getDefaultMadFromOrder(order);
        int nNew = 0;
        int nModified = 0;
        Bond bondAB = null;
        Atom atomA = null;
        Atom atomB = null;
        char altloc = '\u0000';
        short newOrder = (short)(order | 0x20000);
        boolean isAromatic = (order & 0x200) != 0;
        try {
            int i = bsA.nextSetBit(0);
            while (i >= 0) {
                block31: {
                    int j;
                    block30: {
                        block29: {
                            if (!isBonds) break block29;
                            bondAB = this.bo[i];
                            atomA = bondAB.atom1;
                            atomB = bondAB.atom2;
                            break block30;
                        }
                        atomA = this.at[i];
                        if (atomA.isDeleted()) break block31;
                        altloc = this.isModulated(i) ? (char)'\u0000' : atomA.altloc;
                    }
                    int n = j = isBonds ? 0 : bsB.nextSetBit(0);
                    while (j >= 0) {
                        block34: {
                            block33: {
                                block32: {
                                    if (!isBonds) break block32;
                                    j = 0x7FFFFFFE;
                                    break block33;
                                }
                                if (j == i) break block34;
                                atomB = this.at[j];
                                if (atomA.mi != atomB.mi || atomB.isDeleted() || altloc != '\u0000' && altloc != atomB.altloc && atomB.altloc != '\u0000') break block34;
                                bondAB = atomA.getBond(atomB);
                            }
                            if (!(bondAB != null ? createOnly : idOrModifyOnly)) {
                                if (!(checkDistance && !this.isInRange(atomA, atomB, minD, maxD, minDIsFrac, maxDIsFrac, isFractional) || isAromatic && !this.allowAromaticBond(bondAB))) {
                                    if (bondAB == null) {
                                        bsBonds.set(this.bondAtoms((Atom)atomA, (Atom)atomB, (int)order, (short)mad, (BS)bsBonds, (float)energy, (boolean)addGroup, (boolean)true).index);
                                        ++nNew;
                                    } else {
                                        if (notAnyAndNoId) {
                                            bondAB.setOrder(order);
                                            if (isAtrop) {
                                                bondAB.setAtropisomerOptions(bsA, bsB);
                                            }
                                            this.bsAromatic.clear(bondAB.index);
                                        }
                                        if (anyOrNoId || order == bondAB.order || newOrder == bondAB.order || matchHbond && bondAB.isHydrogen()) {
                                            bsBonds.set(bondAB.index);
                                            ++nModified;
                                        }
                                    }
                                }
                            }
                        }
                        j = bsB.nextSetBit(j + 1);
                    }
                }
                i = bsA.nextSetBit(i + 1);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (autoAromatize) {
            this.assignAromaticBondsBs(true, bsBonds);
        }
        if (!identifyOnly) {
            this.sm.setShapeSizeBs(1, Integer.MIN_VALUE, null, bsBonds);
        }
        return new int[]{nNew, nModified};
    }

    /*
     * Enabled aggressive block sorting
     */
    public int autoBondBs4(BS bsA, BS bsB, BS bsExclude, BS bsBonds, short mad, boolean preJmol11_9_24) {
        BS bsCheck;
        int i0;
        boolean isAll;
        if (preJmol11_9_24) {
            return this.autoBond_Pre_11_9_24(bsA, bsB, bsExclude, bsBonds, mad);
        }
        if (this.ac == 0) {
            return 0;
        }
        if (mad == 0) {
            mad = 1;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float bondTolerance = this.vwr.getFloat(0x22000004);
        float minBondDistance = this.vwr.getFloat(570425364);
        float minBondDistance2 = minBondDistance * minBondDistance;
        int nNew = 0;
        if (this.showRebondTimes) {
            Logger.startTimer("autobond");
        }
        short lastModelIndex = -1;
        boolean bl = isAll = bsA == null;
        if (isAll) {
            i0 = 0;
            bsCheck = null;
        } else {
            if (bsA.equals(bsB)) {
                bsCheck = bsA;
            } else {
                bsCheck = BSUtil.copy(bsA);
                bsCheck.or(bsB);
            }
            i0 = bsCheck.nextSetBit(0);
        }
        AtomIndexIterator iter = this.getSelectedAtomIterator(null, false, false, true, false);
        boolean useOccupation = false;
        int i = i0;
        while (true) {
            block13: {
                boolean isFirstExcluded;
                float myBondingRadius;
                Atom atom;
                boolean isAtomInSetB;
                boolean isAtomInSetA;
                block16: {
                    block12: {
                        block14: {
                            short modelIndex;
                            block15: {
                                if (i < 0 || i >= this.ac) break block12;
                                isAtomInSetA = isAll || bsA.get(i);
                                isAtomInSetB = isAll || bsB.get(i);
                                atom = this.at[i];
                                if (atom.isDeleted()) break block13;
                                modelIndex = atom.mi;
                                if (modelIndex == lastModelIndex) break block14;
                                lastModelIndex = modelIndex;
                                if (!this.isJmolDataFrameForModel(modelIndex)) break block15;
                                i = this.am[modelIndex].firstAtomIndex + this.am[modelIndex].act - 1;
                                break block13;
                            }
                            useOccupation = this.getInfoB(modelIndex, "autoBondUsingOccupation");
                        }
                        if ((myBondingRadius = atom.getBondingRadius()) == 0.0f) break block13;
                        isFirstExcluded = bsExclude != null && bsExclude.get(i);
                        float searchRadius = myBondingRadius + this.maxBondingRadius + bondTolerance;
                        this.setIteratorForAtom(iter, -1, i, searchRadius, null);
                        break block16;
                    }
                    if (this.showRebondTimes) {
                        Logger.checkTimer("autoBond", false);
                    }
                    return nNew;
                }
                while (iter.hasNext()) {
                    int order;
                    boolean isNearInSetB;
                    Atom atomNear = this.at[iter.next()];
                    if (atomNear.isDeleted()) continue;
                    int j = atomNear.i;
                    boolean isNearInSetA = isAll || bsA.get(j);
                    boolean bl2 = isNearInSetB = isAll || bsB.get(j);
                    if (!isNearInSetA && !isNearInSetB || (!isAtomInSetA || !isNearInSetB) && (!isAtomInSetB || !isNearInSetA) || isFirstExcluded && bsExclude.get(j) || useOccupation && this.occupancies != null && this.occupancies[i] < 50.0f != this.occupancies[j] < 50.0f || (order = this.isBondable(myBondingRadius, atomNear.getBondingRadius(), iter.foundDistance2(), minBondDistance2, bondTolerance) ? 1 : 0) <= 0 || !this.autoBondCheck(atom, atomNear, order, mad, bsBonds)) continue;
                    ++nNew;
                }
                iter.release();
            }
            i = isAll ? i + 1 : bsCheck.nextSetBit(i + 1);
        }
    }

    public boolean isBondable(float bondingRadiusA, float bondingRadiusB, float distance2, float minBondDistance2, float bondTolerance) {
        if (bondingRadiusA == 0.0f || bondingRadiusB == 0.0f || distance2 < minBondDistance2) {
            return false;
        }
        float maxAcceptable = bondingRadiusA + bondingRadiusB + bondTolerance;
        float maxAcceptable2 = maxAcceptable * maxAcceptable;
        return distance2 <= maxAcceptable2;
    }

    private boolean autoBondCheck(Atom atomA, Atom atomB, int order, short mad, BS bsBonds) {
        if (atomA.getCurrentBondCount() > 20 || atomB.getCurrentBondCount() > 20) {
            if (!this.maxBondWarned) {
                Logger.warn("maximum auto bond count reached");
            }
            this.maxBondWarned = true;
            return false;
        }
        int formalChargeA = atomA.getFormalCharge();
        if (formalChargeA != 0) {
            int formalChargeB = atomB.getFormalCharge();
            if (formalChargeA < 0 && formalChargeB < 0 || formalChargeA > 0 && formalChargeB > 0) {
                return false;
            }
        }
        if (atomA.altloc != atomB.altloc && atomA.altloc != '\u0000' && atomB.altloc != '\u0000' && this.getModulation(atomA.i) == null) {
            return false;
        }
        this.getOrAddBond(atomA, atomB, order, mad, bsBonds, 0.0f, false);
        return true;
    }

    private int autoBond_Pre_11_9_24(BS bsA, BS bsB, BS bsExclude, BS bsBonds, short mad) {
        if (this.ac == 0) {
            return 0;
        }
        if (mad == 0) {
            mad = 1;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float bondTolerance = this.vwr.getFloat(0x22000004);
        float minBondDistance = this.vwr.getFloat(570425364);
        float minBondDistance2 = minBondDistance * minBondDistance;
        int nNew = 0;
        this.initializeBspf();
        short lastModelIndex = -1;
        int i = this.ac;
        while (--i >= 0) {
            float myBondingRadius;
            Atom atom;
            boolean isAtomInSetB;
            boolean isAtomInSetA = bsA == null || bsA.get(i);
            boolean bl = isAtomInSetB = bsB == null || bsB.get(i);
            if (!isAtomInSetA && !isAtomInSetB || (atom = this.at[i]).isDeleted()) continue;
            short modelIndex = atom.mi;
            if (modelIndex != lastModelIndex) {
                lastModelIndex = modelIndex;
                if (this.isJmolDataFrameForModel(modelIndex)) {
                    while (--i >= 0 && this.at[i].mi == modelIndex) {
                    }
                    ++i;
                    continue;
                }
            }
            if ((myBondingRadius = atom.getBondingRadius()) == 0.0f) continue;
            float searchRadius = myBondingRadius + this.maxBondingRadius + bondTolerance;
            this.initializeBspt(modelIndex);
            CubeIterator iter = this.bspf.getCubeIterator(modelIndex);
            iter.initialize(atom, searchRadius, true);
            while (iter.hasMoreElements()) {
                int order;
                boolean isNearInSetB;
                Atom atomNear = (Atom)iter.nextElement();
                if (atomNear == atom || atomNear.isDeleted()) continue;
                int atomIndexNear = atomNear.i;
                boolean isNearInSetA = bsA == null || bsA.get(atomIndexNear);
                boolean bl2 = isNearInSetB = bsB == null || bsB.get(atomIndexNear);
                if (!isNearInSetA && !isNearInSetB || bsExclude != null && bsExclude.get(atomIndexNear) && bsExclude.get(i) || (!isAtomInSetA || !isNearInSetB) && (!isAtomInSetB || !isNearInSetA) || (order = this.isBondable(myBondingRadius, atomNear.getBondingRadius(), iter.foundDistance2(), minBondDistance2, bondTolerance) ? 1 : 0) <= 0 || !this.autoBondCheck(atom, atomNear, order, mad, bsBonds)) continue;
                ++nNew;
            }
            iter.release();
        }
        return nNew;
    }

    public int autoHbond(BS bsA, BS bsB, boolean onlyIfHaveCalculated) {
        int i;
        if (onlyIfHaveCalculated) {
            BS bsModels = this.getModelBS(bsA, false);
            i = bsModels.nextSetBit(0);
            while (i >= 0 && onlyIfHaveCalculated) {
                onlyIfHaveCalculated = !this.am[i].hasRasmolHBonds;
                i = bsModels.nextSetBit(i + 1);
            }
            if (onlyIfHaveCalculated) {
                return 0;
            }
        }
        boolean haveHAtoms = false;
        i = bsA.nextSetBit(0);
        while (i >= 0) {
            if (this.at[i].getElementNumber() == 1) {
                haveHAtoms = true;
                break;
            }
            i = bsA.nextSetBit(i + 1);
        }
        BS bsHBonds = new BS();
        boolean useRasMol = this.vwr.getBoolean(603979853);
        if (bsB == null || useRasMol && !haveHAtoms) {
            Logger.info((bsB == null ? "DSSP/DSSR " : "RasMol") + " pseudo-hbond calculation");
            this.calcRasmolHydrogenBonds(bsA, bsB, null, false, Integer.MAX_VALUE, false, bsHBonds);
            return -bsHBonds.cardinality();
        }
        Logger.info(haveHAtoms ? "Standard Hbond calculation" : "Jmol pseudo-hbond calculation");
        BS bsCO = null;
        if (!haveHAtoms) {
            bsCO = new BS();
            int i2 = bsA.nextSetBit(0);
            while (i2 >= 0) {
                byte atomID = this.at[i2].atomID;
                switch (atomID) {
                    case 4: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 64: {
                        bsCO.set(i2);
                    }
                }
                i2 = bsA.nextSetBit(i2 + 1);
            }
        }
        float maxXYDistance = this.vwr.getFloat(0x22000011);
        float minAttachedAngle = (float)((double)this.vwr.getFloat(0x22000010) * Math.PI / 180.0);
        float hbondMax2 = maxXYDistance * maxXYDistance;
        float hbondMin2 = hbondMinRasmol * hbondMinRasmol;
        float hxbondMin2 = 1.0f;
        float hxbondMax2 = maxXYDistance > hbondMaxReal ? hbondMaxReal * hbondMaxReal : hbondMax2;
        float hxbondMax = maxXYDistance > hbondMaxReal ? hbondMaxReal : maxXYDistance;
        int nNew = 0;
        float d2 = 0.0f;
        V3 v1 = new V3();
        V3 v2 = new V3();
        if (this.showRebondTimes && Logger.debugging) {
            Logger.startTimer("hbond");
        }
        T3 C2 = null;
        P3 D = null;
        AtomIndexIterator iter = this.getSelectedAtomIterator(bsB, false, false, false, false);
        int i3 = bsA.nextSetBit(0);
        while (i3 >= 0) {
            block19: {
                boolean firstIsCO;
                float max2;
                float min2;
                float dmax;
                boolean isH;
                Atom atom;
                block21: {
                    block20: {
                        atom = this.at[i3];
                        int elementNumber = atom.getElementNumber();
                        boolean bl = isH = elementNumber == 1;
                        if (!isH && (haveHAtoms || elementNumber != 7 && elementNumber != 8) || isH && !haveHAtoms) break block19;
                        if (!isH) break block20;
                        Bond[] b = atom.bonds;
                        if (b == null) break block19;
                        boolean isOK = false;
                        for (int j = 0; j < b.length && !isOK; ++j) {
                            Atom a2 = b[j].getOtherAtom(atom);
                            int element = a2.getElementNumber();
                            isOK = element == 7 || element == 8;
                        }
                        if (!isOK) break block19;
                        dmax = hxbondMax;
                        min2 = hxbondMin2;
                        max2 = hxbondMax2;
                        firstIsCO = false;
                        break block21;
                    }
                    dmax = maxXYDistance;
                    min2 = hbondMin2;
                    max2 = hbondMax2;
                    firstIsCO = bsCO.get(i3);
                }
                this.setIteratorForAtom(iter, -1, atom.i, dmax, null);
                while (iter.hasNext()) {
                    int bo;
                    Atom atomNear = this.at[iter.next()];
                    int elementNumberNear = atomNear.getElementNumber();
                    if (atomNear == atom || !isH && elementNumberNear != 7 && elementNumberNear != 8 || isH && elementNumberNear == 1 || (d2 = iter.foundDistance2()) < min2 || d2 > max2 || firstIsCO && bsCO.get(atomNear.i) || atom.isBonded(atomNear)) continue;
                    if (minAttachedAngle > 0.0f) {
                        v1.sub2(atom, atomNear);
                        D = ModelSet.checkMinAttachedAngle(atom, minAttachedAngle, v1, v2, haveHAtoms);
                        if (D == null) continue;
                        v1.scale(-1.0f);
                        C2 = ModelSet.checkMinAttachedAngle(atomNear, minAttachedAngle, v1, v2, haveHAtoms);
                        if (C2 == null) continue;
                    }
                    float energy = 0.0f;
                    if (isH && !Float.isNaN(((P3)C2).x) && !Float.isNaN(D.x)) {
                        bo = 4096;
                        energy = (float)HBond.getEnergy((float)Math.sqrt(d2), C2.distance(atom), C2.distance(D), atomNear.distance(D)) / 1000.0f;
                    } else {
                        bo = 2048;
                    }
                    bsHBonds.set(this.addHBond(atom, atomNear, bo, energy));
                    ++nNew;
                }
            }
            i3 = bsA.nextSetBit(i3 + 1);
        }
        iter.release();
        this.sm.setShapeSizeBs(1, Integer.MIN_VALUE, null, bsHBonds);
        if (this.showRebondTimes) {
            Logger.checkTimer("hbond", false);
        }
        return haveHAtoms ? nNew : -nNew;
    }

    private static P3 checkMinAttachedAngle(Atom atom1, float minAngle, V3 v1, V3 v2, boolean haveHAtoms) {
        Bond[] bonds = atom1.bonds;
        if (bonds == null || bonds.length == 0) {
            return P3.new3(Float.NaN, 0.0f, 0.0f);
        }
        Atom X = null;
        float dMin = Float.MAX_VALUE;
        int i = bonds.length;
        while (--i >= 0) {
            if (!bonds[i].isCovalent()) continue;
            Atom atomA = bonds[i].getOtherAtom(atom1);
            if (!haveHAtoms && atomA.getElementNumber() == 1) continue;
            v2.sub2(atom1, atomA);
            float d = v2.angle(v1);
            if (d < minAngle) {
                return null;
            }
            if (!(d < dMin)) continue;
            X = atomA;
            dMin = d;
        }
        return X;
    }

    public void setStructureIndexes() {
        int idnew = 0;
        int lastid = -1;
        int imodel = -1;
        int lastmodel = -1;
        for (int i = 0; i < this.ac; ++i) {
            int id;
            int n = this.at[i].mi;
            imodel = n;
            if (n != lastmodel) {
                idnew = 0;
                lastmodel = imodel;
                lastid = -1;
            }
            if ((id = this.at[i].group.getStrucNo()) == lastid || id == 0) continue;
            this.at[i].group.setStrucNo(++idnew);
            lastid = idnew;
        }
    }

    public String getModelInfoAsString() {
        SB sb = new SB().append("<models count=\"");
        sb.appendI(this.mc).append("\" modelSetHasVibrationVectors=\"").append(this.modelSetHasVibrationVectors() + "\">\n<properties>");
        if (this.modelSetProperties != null) {
            Enumeration<?> e = this.modelSetProperties.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                sb.append("\n <property name=\"").append(propertyName).append("\" value=").append(PT.esc(this.modelSetProperties.getProperty(propertyName))).append(" />");
            }
            sb.append("\n</properties>");
        }
        for (int i = 0; i < this.mc; ++i) {
            sb.append("\n<model index=\"").appendI(i).append("\" n=\"").append(this.getModelNumberDotted(i)).append("\" id=").append(PT.esc("" + this.getInfo(i, "modelID")));
            int ib = this.vwr.getJDXBaseModelIndex(i);
            if (ib != i) {
                sb.append(" baseModelId=").append(PT.esc((String)this.getInfo(ib, "jdxModelID")));
            }
            sb.append(" name=").append(PT.esc(this.getModelName(i))).append(" title=").append(PT.esc(this.getModelTitle(i))).append(" hasVibrationVectors=\"").appendB(this.vwr.modelHasVibrationVectors(i)).append("\" />");
        }
        sb.append("\n</models>");
        return sb.toString();
    }

    public String getSymmetryInfoAsString() {
        SB sb = new SB().append("Symmetry Information:");
        for (int i = 0; i < this.mc; ++i) {
            sb.append("\nmodel #").append(this.getModelNumberDotted(i)).append("; name=").append(this.getModelName(i)).append("\n");
            SymmetryInterface unitCell = this.getUnitCell(i);
            sb.append(unitCell == null ? "no symmetry information" : unitCell.getSymmetryInfoStr());
        }
        return sb.toString();
    }

    public void createModels(int n) {
        int newModelCount = this.mc + n;
        Model[] newModels = (Model[])AU.arrayCopyObject(this.am, newModelCount);
        this.validateBspf(false);
        this.modelNumbers = AU.arrayCopyI(this.modelNumbers, newModelCount);
        this.modelFileNumbers = AU.arrayCopyI(this.modelFileNumbers, newModelCount);
        this.modelNumbersForAtomLabel = AU.arrayCopyS(this.modelNumbersForAtomLabel, newModelCount);
        this.modelNames = AU.arrayCopyS(this.modelNames, newModelCount);
        this.frameTitles = AU.arrayCopyS(this.frameTitles, newModelCount);
        int f = this.modelFileNumbers[this.mc - 1] / 1000000 + 1;
        int pt = 0;
        for (int i = this.mc; i < newModelCount; ++i) {
            this.modelNumbers[i] = i + this.mc;
            this.modelFileNumbers[i] = f * 1000000 + ++pt;
            this.modelNumbersForAtomLabel[i] = this.modelNames[i] = f + "." + pt;
        }
        this.thisStateModel = -1;
        String[] group3Lists = (String[])this.getInfoM("group3Lists");
        if (group3Lists != null) {
            int[][] group3Counts = (int[][])this.getInfoM("group3Counts");
            group3Lists = AU.arrayCopyS(group3Lists, newModelCount);
            group3Counts = AU.arrayCopyII(group3Counts, newModelCount);
            this.msInfo.put("group3Lists", group3Lists);
            this.msInfo.put("group3Counts", group3Counts);
        }
        this.unitCells = (SymmetryInterface[])AU.arrayCopyObject(this.unitCells, newModelCount);
        for (int i = this.mc; i < newModelCount; ++i) {
            newModels[i] = new Model().set(this, i, -1, null, null, null);
            newModels[i].loadState = " model create #" + i + ";";
        }
        this.am = newModels;
        this.mc = newModelCount;
    }

    public void assignAtom(int atomIndex, String type, boolean autoBond) {
        this.clearDB(atomIndex);
        if (type == null) {
            type = "C";
        }
        Atom atom = this.at[atomIndex];
        BS bs = new BS();
        boolean wasH = atom.getElementNumber() == 1;
        int atomicNumber = Elements.elementNumberFromSymbol(type, true);
        boolean isDelete = false;
        if (atomicNumber > 0) {
            this.setElement(atom, atomicNumber, false);
            this.vwr.shm.setShapeSizeBs(0, 0, this.vwr.rd, BSUtil.newAndSetBit(atomIndex));
            this.setAtomName(atomIndex, type + atom.getAtomNumber(), false);
            if (this.vwr.getBoolean(603979883)) {
                this.am[atom.mi].isModelKit = true;
            }
            if (!this.am[atom.mi].isModelKit) {
                this.taintAtom(atomIndex, 0);
            }
        } else if (type.equals("Pl")) {
            atom.setFormalCharge(atom.getFormalCharge() + 1);
        } else if (type.equals("Mi")) {
            atom.setFormalCharge(atom.getFormalCharge() - 1);
        } else if (type.equals("X")) {
            isDelete = true;
        } else if (!type.equals(".")) {
            return;
        }
        this.removeUnnecessaryBonds(atom, isDelete);
        float dx = 0.0f;
        if (atom.getCovalentBondCount() == 1) {
            if (wasH) {
                dx = 1.5f;
            } else if (!wasH && atomicNumber == 1) {
                dx = 1.0f;
            }
        }
        if (dx != 0.0f) {
            V3 v = V3.newVsub(atom, this.at[atom.getBondedAtomIndex(0)]);
            float d = v.length();
            v.normalize();
            v.scale(dx - d);
            this.setAtomCoordRelative(atomIndex, v.x, v.y, v.z);
        }
        BS bsA = BSUtil.newAndSetBit(atomIndex);
        if (atomicNumber != 1 && autoBond) {
            this.validateBspf(false);
            bs = this.getAtomsWithinRadius(1.0f, bsA, false, null);
            bs.andNot(bsA);
            if (bs.nextSetBit(0) >= 0) {
                this.vwr.deleteAtoms(bs, false);
            }
            bs = this.vwr.getModelUndeletedAtomsBitSet(atom.mi);
            bs.andNot(this.getAtomBitsMDa(1612709900, null, new BS()));
            this.makeConnections2(0.1f, 1.8f, 1, 0x40000050, bsA, bs, null, false, false, 0.0f);
        }
        this.vwr.addHydrogens(bsA, false, true);
    }

    public void deleteAtoms(BS bs) {
        this.averageAtomPoint = null;
        if (bs == null) {
            return;
        }
        BS bsBonds = new BS();
        int i = bs.nextSetBit(0);
        while (i >= 0 && i < this.ac) {
            this.at[i].delete(bsBonds);
            i = bs.nextSetBit(i + 1);
        }
        for (i = 0; i < this.mc; ++i) {
            this.am[i].bsAtomsDeleted.or(bs);
            this.am[i].bsAtomsDeleted.and(this.am[i].bsAtoms);
            this.am[i].resetDSSR(false);
        }
        this.deleteBonds(bsBonds, false);
        this.validateBspf(false);
    }

    public void clearDB(int atomIndex) {
        this.getModelAuxiliaryInfo(this.at[atomIndex].mi).remove("dbName");
    }

    public void adjustAtomArrays(int[] map, int i0, int ac) {
        int i;
        this.ac = ac;
        for (i = i0; i < ac; ++i) {
            this.at[i] = this.at[map[i]];
            this.at[i].i = i;
            Model m = this.am[this.at[i].mi];
            if (m.firstAtomIndex == map[i]) {
                m.firstAtomIndex = i;
            }
            m.bsAtoms.set(i);
        }
        if (this.vibrations != null) {
            for (i = i0; i < ac; ++i) {
                this.vibrations[i] = this.vibrations[map[i]];
            }
        }
        if (this.atomTensorList != null) {
            for (i = i0; i < ac; ++i) {
                this.atomTensorList[i] = this.atomTensorList[map[i]];
                Object[] list = this.atomTensorList[i];
                if (list == null) continue;
                int j = list.length;
                while (--j >= 0) {
                    Tensor t = (Tensor)list[j];
                    if (t == null) continue;
                    t.atomIndex1 = i;
                }
            }
        }
        if (this.atomNames != null) {
            for (i = i0; i < ac; ++i) {
                this.atomNames[i] = this.atomNames[map[i]];
            }
        }
        if (this.atomTypes != null) {
            for (i = i0; i < ac; ++i) {
                this.atomTypes[i] = this.atomTypes[map[i]];
            }
        }
        if (this.atomResnos != null) {
            for (i = i0; i < ac; ++i) {
                this.atomResnos[i] = this.atomResnos[map[i]];
            }
        }
        if (this.atomSerials != null) {
            for (i = i0; i < ac; ++i) {
                this.atomSerials[i] = this.atomSerials[map[i]];
            }
        }
        if (this.atomSeqIDs != null) {
            for (i = i0; i < ac; ++i) {
                this.atomSeqIDs[i] = this.atomSeqIDs[map[i]];
            }
        }
        if (this.bfactor100s != null) {
            for (i = i0; i < ac; ++i) {
                this.bfactor100s[i] = this.bfactor100s[map[i]];
            }
        }
        if (this.occupancies != null) {
            for (i = i0; i < ac; ++i) {
                this.occupancies[i] = this.occupancies[map[i]];
            }
        }
        if (this.partialCharges != null) {
            for (i = i0; i < ac; ++i) {
                this.partialCharges[i] = this.partialCharges[map[i]];
            }
        }
    }

    protected void growAtomArrays(int newLength) {
        this.at = (Atom[])AU.arrayCopyObject(this.at, newLength);
        if (this.vibrations != null) {
            this.vibrations = (Vibration[])AU.arrayCopyObject(this.vibrations, newLength);
        }
        if (this.occupancies != null) {
            this.occupancies = AU.arrayCopyF(this.occupancies, newLength);
        }
        if (this.bfactor100s != null) {
            this.bfactor100s = AU.arrayCopyShort(this.bfactor100s, newLength);
        }
        if (this.partialCharges != null) {
            this.partialCharges = AU.arrayCopyF(this.partialCharges, newLength);
        }
        if (this.atomTensorList != null) {
            this.atomTensorList = (Object[][])AU.arrayCopyObject(this.atomTensorList, newLength);
        }
        if (this.atomNames != null) {
            this.atomNames = AU.arrayCopyS(this.atomNames, newLength);
        }
        if (this.atomTypes != null) {
            this.atomTypes = AU.arrayCopyS(this.atomTypes, newLength);
        }
        if (this.atomResnos != null) {
            this.atomResnos = AU.arrayCopyI(this.atomResnos, newLength);
        }
        if (this.atomSerials != null) {
            this.atomSerials = AU.arrayCopyI(this.atomSerials, newLength);
        }
        if (this.atomSeqIDs != null) {
            this.atomSeqIDs = AU.arrayCopyI(this.atomSeqIDs, newLength);
        }
    }

    public Atom addAtom(int modelIndex, Group group, int atomicAndIsotopeNumber, String atomName, String atomType, int atomSerial, int atomSeqID, int atomSite, P3 xyz, float radius, V3 vib, int formalCharge, float partialCharge, float occupancy, float bfactor, Lst<Object> tensors, boolean isHetero, byte specialAtomID, BS atomSymmetry) {
        Atom atom = new Atom().setAtom(modelIndex, this.ac, xyz, radius, atomSymmetry, atomSite, (short)atomicAndIsotopeNumber, formalCharge, isHetero);
        ++this.am[modelIndex].act;
        this.am[modelIndex].bsAtoms.set(this.ac);
        if (Elements.isElement(atomicAndIsotopeNumber, 1)) {
            ++this.am[modelIndex].hydrogenCount;
        }
        if (this.ac >= this.at.length) {
            this.growAtomArrays(this.ac + 100);
        }
        this.at[this.ac] = atom;
        this.setBFactor(this.ac, bfactor, false);
        this.setOccupancy(this.ac, occupancy, false);
        this.setPartialCharge(this.ac, partialCharge, false);
        if (tensors != null) {
            this.setAtomTensors(this.ac, tensors);
        }
        atom.group = group;
        atom.colixAtom = this.vwr.cm.getColixAtomPalette(atom, PAL.CPK.id);
        if (atomName != null) {
            if (atomType != null) {
                if (this.atomTypes == null) {
                    this.atomTypes = new String[this.at.length];
                }
                this.atomTypes[this.ac] = atomType;
            }
            atom.atomID = specialAtomID;
            if (specialAtomID == 0) {
                if (this.atomNames == null) {
                    this.atomNames = new String[this.at.length];
                }
                this.atomNames[this.ac] = atomName.intern();
            }
        }
        if (atomSerial != Integer.MIN_VALUE) {
            if (this.atomSerials == null) {
                this.atomSerials = new int[this.at.length];
            }
            this.atomSerials[this.ac] = atomSerial;
        }
        if (atomSeqID != 0) {
            if (this.atomSeqIDs == null) {
                this.atomSeqIDs = new int[this.at.length];
            }
            this.atomSeqIDs[this.ac] = atomSeqID;
        }
        if (vib != null) {
            this.setVibrationVector(this.ac, vib);
        }
        ++this.ac;
        return atom;
    }

    public String getInlineData(int modelIndex) {
        SB data = null;
        if (modelIndex >= 0) {
            data = this.am[modelIndex].loadScript;
        } else {
            modelIndex = this.mc;
            while (--modelIndex >= 0 && (data = this.am[modelIndex].loadScript).length() <= 0) {
            }
        }
        int pt = data.lastIndexOf("data \"");
        if (pt < 0) {
            String s = PT.getQuotedStringAt(data.toString(), 0);
            return ScriptCompiler.unescapeString(s, 0, s.length());
        }
        pt = data.indexOf2("\"", pt + 7);
        int pt2 = data.lastIndexOf("end \"");
        if (pt2 < pt || pt < 0) {
            return null;
        }
        return data.substring2(pt + 2, pt2);
    }

    public boolean isAtomPDB(int i) {
        return i >= 0 && this.am[this.at[i].mi].isBioModel;
    }

    public boolean isAtomAssignable(int i) {
        return i >= 0 && this.at[i].mi == this.mc - 1;
    }

    public boolean haveModelKit() {
        for (int i = 0; i < this.mc; ++i) {
            if (!this.am[i].isModelKit) continue;
            return true;
        }
        return false;
    }

    public BS getModelKitStateBitset(BS bs, BS bsDeleted) {
        BS bs1 = BSUtil.copy(bsDeleted);
        for (int i = 0; i < this.mc; ++i) {
            if (this.am[i].isModelKit) continue;
            bs1.andNot(this.am[i].bsAtoms);
        }
        return BSUtil.deleteBits(bs, bs1);
    }

    public void setAtomNamesAndNumbers(int iFirst, int baseAtomIndex, AtomCollection mergeSet) {
        if (baseAtomIndex < 0) {
            iFirst = this.am[this.at[iFirst].mi].firstAtomIndex;
        }
        if (this.atomSerials == null) {
            this.atomSerials = new int[this.ac];
        }
        if (this.atomNames == null) {
            this.atomNames = new String[this.ac];
        }
        boolean isZeroBased = this.isXYZ && this.vwr.getBoolean(603979978);
        int n = Integer.MAX_VALUE;
        int atomNo = 1;
        for (int i = iFirst; i < this.ac; ++i) {
            short s;
            Atom atom = this.at[i];
            if (atom.mi != s) {
                s = atom.mi;
                int n2 = atomNo = isZeroBased ? 0 : 1;
            }
            if (i >= -baseAtomIndex) {
                if (this.atomSerials[i] == 0 || baseAtomIndex < 0) {
                    int n3 = this.atomSerials[i] = i < baseAtomIndex ? mergeSet.atomSerials[i] : atomNo;
                }
                if (this.atomNames[i] == null || baseAtomIndex < 0) {
                    this.atomNames[i] = (atom.getElementSymbol() + this.atomSerials[i]).intern();
                }
            }
            if (this.am[s].isModelKit && (atom.getElementNumber() <= 0 || atom.isDeleted())) continue;
            ++atomNo;
        }
    }

    public void setUnitCellOffset(SymmetryInterface unitCell, T3 pt, int ijk) {
        if (unitCell == null) {
            return;
        }
        if (pt == null) {
            unitCell.setOffset(ijk);
        } else {
            unitCell.setOffsetPt(pt);
        }
    }

    public void connect(float[][] connections) {
        this.resetMolecules();
        BS bsDelete = new BS();
        for (int i = 0; i < connections.length; ++i) {
            short mad;
            int order;
            int index2;
            boolean addGroup;
            float[] f = connections[i];
            if (f == null || f.length < 2) continue;
            int index1 = (int)f[0];
            boolean bl = addGroup = index1 < 0;
            if (addGroup) {
                index1 = -1 - index1;
            }
            if ((index2 = (int)f[1]) < 0 || index1 >= this.ac || index2 >= this.ac) continue;
            int n = order = f.length > 2 ? (int)f[2] : 1;
            if (order < 0) {
                order &= 0xFFFF;
            }
            short s = mad = f.length > 3 ? (short)(1000.0f * connections[i][3]) : this.getDefaultMadFromOrder(order);
            if (order == 0 || mad == 0 && order != 32768 && !Edge.isOrderH(order)) {
                Bond b = this.at[index1].getBond(this.at[index2]);
                if (b == null) continue;
                bsDelete.set(b.index);
                continue;
            }
            float energy = f.length > 4 ? f[4] : 0.0f;
            this.bondAtoms(this.at[index1], this.at[index2], order, mad, null, energy, addGroup, true);
        }
        if (bsDelete.nextSetBit(0) >= 0) {
            this.deleteBonds(bsDelete, false);
        }
    }

    public void setFrameDelayMs(long millis, BS bsModels) {
        int i = bsModels.nextSetBit(0);
        while (i >= 0) {
            this.am[this.am[i].trajectoryBaseIndex].frameDelay = millis;
            i = bsModels.nextSetBit(i + 1);
        }
    }

    public long getFrameDelayMs(int i) {
        return i < this.am.length && i >= 0 ? this.am[this.am[i].trajectoryBaseIndex].frameDelay : 0L;
    }

    public int getModelIndexFromId(String id) {
        boolean haveFile = id.indexOf("#") >= 0;
        boolean isBaseModel = id.toLowerCase().endsWith(".basemodel");
        if (isBaseModel) {
            id = id.substring(0, id.length() - 10);
        }
        int errCode = -1;
        String fname = null;
        for (int i = 0; i < this.mc; ++i) {
            String mnum;
            String mid = (String)this.getInfo(i, "modelID");
            String string = mnum = id.startsWith("~") ? "~" + this.getModelNumberDotted(i) : null;
            if (mnum == null && mid == null && (mid = this.getModelTitle(i)) == null) continue;
            if (haveFile) {
                fname = this.getModelFileName(i);
                if (fname.endsWith("#molfile")) {
                    mid = fname;
                } else {
                    fname = fname + "#";
                    mid = fname + mid;
                }
            }
            if (id.equalsIgnoreCase(mid) || id.equalsIgnoreCase(mnum)) {
                return isBaseModel ? this.vwr.getJDXBaseModelIndex(i) : i;
            }
            if (fname == null || !id.startsWith(fname)) continue;
            errCode = -2;
        }
        return fname == null && !haveFile ? -2 : errCode;
    }

    public Map<String, Object> getAuxiliaryInfo(BS bsModels) {
        Map<String, Object> info = this.msInfo;
        if (info == null) {
            info = new Hashtable<String, Object>();
        }
        if (bsModels != null || !info.containsKey("models")) {
            Lst<Map<String, Object>> minfo = new Lst<Map<String, Object>>();
            for (int i = 0; i < this.mc; ++i) {
                if (bsModels != null && !bsModels.get(i)) continue;
                Map<String, Object> m = this.getModelAuxiliaryInfo(i);
                m.put("modelIndex", i);
                minfo.addLast(m);
            }
            info.put("models", minfo);
        }
        return info;
    }

    public int[][] getDihedralMap(int[] alist) {
        Lst<int[]> list = new Lst<int[]>();
        int n = alist.length;
        Atom ai = null;
        Atom aj = null;
        Atom ak = null;
        Atom al = null;
        int i = n - 1;
        while (--i >= 0) {
            int j = n;
            while (--j > i) {
                ai = this.at[alist[i]];
                aj = this.at[alist[j]];
                if (!ai.isBonded(aj)) continue;
                int k = n;
                while (--k >= 0) {
                    if (k == i || k == j || !(ak = this.at[alist[k]]).isBonded(ai)) continue;
                    int l = n;
                    while (--l >= 0) {
                        if (l == i || l == j || l == k || !(al = this.at[alist[l]]).isBonded(aj)) continue;
                        int[] a = new int[]{ak.i, ai.i, aj.i, al.i};
                        list.addLast(a);
                    }
                }
            }
        }
        n = list.size();
        int[][] ilist = AU.newInt2(n);
        int i2 = n;
        while (--i2 >= 0) {
            ilist[n - i2 - 1] = (int[])list.get(i2);
        }
        return ilist;
    }

    public void setModulation(BS bs, boolean isOn, P3 qtOffset, boolean isQ) {
        if (this.bsModulated == null) {
            if (isOn) {
                this.bsModulated = new BS();
            } else if (bs == null) {
                return;
            }
        }
        if (bs == null) {
            bs = this.getModelAtomBitSetIncludingDeleted(-1, false);
        }
        float scale = this.vwr.getFloat(1275072532);
        boolean haveMods = false;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            JmolModulationSet ms = this.getModulation(i);
            if (ms != null) {
                ms.setModTQ(this.at[i], isOn, qtOffset, isQ, scale);
                if (this.bsModulated != null) {
                    this.bsModulated.setBitTo(i, isOn);
                }
                haveMods = true;
            }
            i = bs.nextSetBit(i + 1);
        }
        if (!haveMods) {
            this.bsModulated = null;
        }
    }

    public Object getBoundBoxOrientation(int type, BS bsAtoms) {
        float dx = 0.0f;
        float dy = 0.0f;
        float dz = 0.0f;
        Quat q = null;
        Quat qBest = null;
        int j0 = bsAtoms.nextSetBit(0);
        float vMin = 0.0f;
        if (j0 >= 0) {
            int n;
            int n2 = n = this.vOrientations == null ? 0 : this.vOrientations.length;
            if (n == 0) {
                int i;
                V3[] av = new V3[3375];
                n = 0;
                P4 p4 = new P4();
                for (i = -7; i <= 7; ++i) {
                    for (int j = -7; j <= 7; ++j) {
                        int k = 0;
                        while (k <= 14) {
                            V3 v3;
                            av[n] = V3.new3((float)i / 7.0f, (float)j / 7.0f, (float)k / 14.0f);
                            if (v3.length() > 1.0f) {
                                --n;
                            }
                            ++k;
                            ++n;
                        }
                    }
                }
                this.vOrientations = new Quat[n];
                i = n;
                while (--i >= 0) {
                    float cos = (float)Math.sqrt(1.0f - av[i].lengthSquared());
                    if (Float.isNaN(cos)) {
                        cos = 0.0f;
                    }
                    p4.set4(av[i].x, av[i].y, av[i].z, cos);
                    this.vOrientations[i] = Quat.newP4(p4);
                }
            }
            P3 pt = new P3();
            vMin = Float.MAX_VALUE;
            BoxInfo bBest = null;
            BoxInfo b = new BoxInfo();
            b.setMargin(type == 1312817669 ? 0.0f : 0.1f);
            for (int i = 0; i < n; ++i) {
                float v;
                q = this.vOrientations[i];
                b.reset();
                int j = j0;
                while (j >= 0) {
                    b.addBoundBoxPoint(q.transform2(this.at[j], pt));
                    j = bsAtoms.nextSetBit(j + 1);
                }
                switch (type) {
                    default: {
                        v = (b.bbCorner1.x - b.bbCorner0.x) * (b.bbCorner1.y - b.bbCorner0.y) * (b.bbCorner1.z - b.bbCorner0.z);
                        break;
                    }
                    case 1111492629: {
                        v = b.bbCorner1.x - b.bbCorner0.x;
                        break;
                    }
                    case 1111492630: {
                        v = b.bbCorner1.y - b.bbCorner0.y;
                        break;
                    }
                    case 1111492631: {
                        v = b.bbCorner1.z - b.bbCorner0.z;
                    }
                }
                if (!(v < vMin)) continue;
                qBest = q;
                bBest = b;
                b = new BoxInfo();
                b.setMargin(0.1f);
                vMin = v;
            }
            switch (type) {
                default: {
                    return qBest;
                }
                case 1814695966: {
                    P3[] pts = bBest.getBoundBoxVertices();
                    pts = new P3[]{pts[0], pts[4], pts[2], pts[1]};
                    qBest = qBest.inv();
                    for (int i = 0; i < 4; ++i) {
                        qBest.transform2(pts[i], pts[i]);
                        if (i <= 0) continue;
                        pts[i].sub(pts[0]);
                    }
                    return pts;
                }
                case 1073741864: 
                case 1312817669: 
            }
            q = Quat.newQ(qBest);
            dx = bBest.bbCorner1.x - bBest.bbCorner0.x;
            dy = bBest.bbCorner1.y - bBest.bbCorner0.y;
            dz = bBest.bbCorner1.z - bBest.bbCorner0.z;
            if (dx < dy) {
                pt.set(0.0f, 0.0f, 1.0f);
                q = Quat.newVA(pt, 90.0f).mulQ(q);
                float f = dx;
                dx = dy;
                dy = f;
            }
            if (dy < dz) {
                if (dz > dx) {
                    pt.set(0.0f, 1.0f, 0.0f);
                    q = Quat.newVA(pt, 90.0f).mulQ(q);
                    float f = dx;
                    dx = dz;
                    dz = f;
                }
                pt.set(1.0f, 0.0f, 0.0f);
                q = Quat.newVA(pt, 90.0f).mulQ(q);
                float f = dy;
                dy = dz;
                dz = f;
            }
        }
        return type == 1312817669 ? vMin + "\t{" + dx + " " + dy + " " + dz + "}\t" + bsAtoms : (type == 1814695966 ? null : (q == null || q.getTheta() == 0.0f ? new Quat() : q));
    }

    public SymmetryInterface getUnitCellForAtom(int index) {
        if (index < 0 || index > this.ac) {
            return null;
        }
        if (this.bsModulated != null) {
            SymmetryInterface uc;
            JmolModulationSet ms = this.getModulation(index);
            SymmetryInterface symmetryInterface = uc = ms == null ? null : ms.getSubSystemUnitCell();
            if (uc != null) {
                return uc;
            }
        }
        return this.getUnitCell(this.at[index].mi);
    }

    public void clearCache() {
        int i = this.mc;
        while (--i >= 0) {
            this.am[i].resetDSSR(false);
        }
    }

    public M4[] getSymMatrices(int modelIndex) {
        int n = this.getModelSymmetryCount(modelIndex);
        if (n == 0) {
            return null;
        }
        M4[] ops = new M4[n];
        SymmetryInterface unitcell = this.am[modelIndex].biosymmetry;
        if (unitcell == null) {
            unitcell = this.getUnitCell(modelIndex);
        }
        int i = n;
        while (--i >= 0) {
            ops[i] = unitcell.getSpaceGroupOperation(i);
        }
        return ops;
    }

    public BS[] getBsBranches(float[] dihedralList) {
        int n = dihedralList.length / 6;
        BS[] bsBranches = new BS[n];
        Hashtable<String, Boolean> map = new Hashtable<String, Boolean>();
        int i = 0;
        int pt = 0;
        while (i < n) {
            float dv = dihedralList[pt + 5] - dihedralList[pt + 4];
            if (!(Math.abs(dv) < 1.0f)) {
                int i0 = (int)dihedralList[pt + 1];
                int i1 = (int)dihedralList[pt + 2];
                String s = "" + i0 + "_" + i1;
                if (!map.containsKey(s)) {
                    map.put(s, Boolean.TRUE);
                    BS bs = this.vwr.getBranchBitSet(i1, i0, true);
                    Bond[] bonds = this.at[i0].bonds;
                    Atom a0 = this.at[i0];
                    for (int j = 0; j < bonds.length; ++j) {
                        int i2;
                        Bond b = bonds[j];
                        if (!b.isCovalent() || (i2 = b.getOtherAtom((Atom)a0).i) == i1 || !bs.get(i2)) continue;
                        bs = null;
                        break;
                    }
                    bsBranches[i] = bs;
                }
            }
            ++i;
            pt += 6;
        }
        return bsBranches;
    }

    public void recalculatePositionDependentQuantities(BS bs, M4 mat) {
        if (this.vwr.shm.getShape(21) != null) {
            this.vwr.shm.getShapePropertyData(21, "move", new Object[]{bs, mat});
        }
        if (this.haveStraightness) {
            this.calculateStraightnessAll();
        }
        this.recalculateLeadMidpointsAndWingVectors(-1);
        BS bsModels = this.getModelBS(bs, false);
        int i = bsModels.nextSetBit(0);
        while (i >= 0) {
            Model m;
            this.sm.notifyAtomPositionsChanged(i, bs, mat);
            if (mat != null && (m = this.am[i]).isContainedIn(bs)) {
                if (m.mat4 == null) {
                    m.mat4 = M4.newM4(null);
                }
                m.mat4.mul2(mat, m.mat4);
            }
            i = bsModels.nextSetBit(i + 1);
        }
        this.averageAtomPoint = null;
    }

    public void moveAtoms(M4 m4, M3 mNew, M3 rotation, V3 translation, BS bs, P3 center, boolean isInternal, boolean translationOnly) {
        int i;
        if (m4 != null) {
            i = bs.nextSetBit(0);
            while (i >= 0) {
                m4.rotTrans(this.at[i]);
                this.taintAtom(i, 2);
                i = bs.nextSetBit(i + 1);
            }
            this.mat4.setM4(m4);
            translation = null;
        } else if (!translationOnly) {
            if (mNew == null) {
                this.matTemp.setM3(rotation);
            } else {
                this.ptTemp.set(0.0f, 0.0f, 0.0f);
                this.matInv.setM3(rotation);
                this.matInv.invert();
                this.matTemp.mul2(mNew, rotation);
                this.matTemp.mul2(this.matInv, this.matTemp);
            }
            if (isInternal) {
                this.vTemp.setT(center);
                this.mat4.setIdentity();
                this.mat4.setTranslation(this.vTemp);
                this.mat4t.setToM3(this.matTemp);
                this.mat4.mul(this.mat4t);
                this.mat4t.setIdentity();
                this.vTemp.scale(-1.0f);
                this.mat4t.setTranslation(this.vTemp);
                this.mat4.mul(this.mat4t);
            } else {
                this.mat4.setToM3(this.matTemp);
            }
            i = bs.nextSetBit(0);
            while (i >= 0) {
                if (isInternal) {
                    this.mat4.rotTrans(this.at[i]);
                } else {
                    this.ptTemp.add(this.at[i]);
                    this.mat4.rotTrans(this.at[i]);
                    this.ptTemp.sub(this.at[i]);
                }
                this.taintAtom(i, 2);
                i = bs.nextSetBit(i + 1);
            }
            if (!isInternal) {
                this.ptTemp.scale(1.0f / (float)bs.cardinality());
                if (translation == null) {
                    translation = new V3();
                }
                translation.add(this.ptTemp);
            }
        }
        if (translation != null) {
            i = bs.nextSetBit(0);
            while (i >= 0) {
                this.at[i].add(translation);
                this.taintAtom(i, 2);
                i = bs.nextSetBit(i + 1);
            }
            if (!translationOnly) {
                this.mat4t.setIdentity();
                this.mat4t.setTranslation(translation);
                this.mat4.mul2(this.mat4t, this.mat4);
            }
        }
        this.recalculatePositionDependentQuantities(bs, this.mat4);
    }

    public void setDihedrals(float[] dihedralList, BS[] bsBranches, float f) {
        int n = dihedralList.length / 6;
        if (f > 1.0f) {
            f = 1.0f;
        }
        int j = 0;
        int pt = 0;
        while (j < n) {
            BS bs = bsBranches[j];
            if (bs != null && !bs.isEmpty()) {
                Atom a1 = this.at[(int)dihedralList[pt + 1]];
                V3 v = V3.newVsub(this.at[(int)dihedralList[pt + 2]], a1);
                float angle = (dihedralList[pt + 5] - dihedralList[pt + 4]) * f;
                A4 aa = A4.newVA(v, (float)((double)(-angle) / 57.29577951308232));
                this.matTemp.setAA(aa);
                this.ptTemp.setT(a1);
                int i = bs.nextSetBit(0);
                while (i >= 0) {
                    this.at[i].sub(this.ptTemp);
                    this.matTemp.rotate(this.at[i]);
                    this.at[i].add(this.ptTemp);
                    this.taintAtom(i, 2);
                    i = bs.nextSetBit(i + 1);
                }
            }
            ++j;
            pt += 6;
        }
    }

    public void setAtomCoordsRelative(T3 offset, BS bs) {
        this.setAtomsCoordRelative(bs, offset.x, offset.y, offset.z);
        this.mat4.setIdentity();
        this.vTemp.setT(offset);
        this.mat4.setTranslation(this.vTemp);
        this.recalculatePositionDependentQuantities(bs, this.mat4);
    }

    public void setAtomCoords(BS bs, int tokType, Object xyzValues) {
        this.setAtomCoord2(bs, tokType, xyzValues);
        switch (tokType) {
            case 1111492626: 
            case 1111492627: 
            case 1111492628: 
            case 1145047055: {
                break;
            }
            default: {
                this.recalculatePositionDependentQuantities(bs, null);
            }
        }
    }

    public void invertSelected(P3 pt, P4 plane, int iAtom, BS bsAtoms) {
        this.resetChirality();
        if (pt != null) {
            int i = bsAtoms.nextSetBit(0);
            while (i >= 0) {
                float x = (pt.x - this.at[i].x) * 2.0f;
                float y = (pt.y - this.at[i].y) * 2.0f;
                float z = (pt.z - this.at[i].z) * 2.0f;
                this.setAtomCoordRelative(i, x, y, z);
                i = bsAtoms.nextSetBit(i + 1);
            }
            return;
        }
        if (plane != null) {
            V3 norm = V3.new3(plane.x, plane.y, plane.z);
            norm.normalize();
            float d = (float)Math.sqrt(plane.x * plane.x + plane.y * plane.y + plane.z * plane.z);
            int i = bsAtoms.nextSetBit(0);
            while (i >= 0) {
                float twoD = -Measure.distanceToPlaneD(plane, d, this.at[i]) * 2.0f;
                float x = norm.x * twoD;
                float y = norm.y * twoD;
                float z = norm.z * twoD;
                this.setAtomCoordRelative(i, x, y, z);
                i = bsAtoms.nextSetBit(i + 1);
            }
            return;
        }
        if (iAtom >= 0) {
            Atom thisAtom = this.at[iAtom];
            Bond[] bonds = thisAtom.bonds;
            if (bonds == null) {
                return;
            }
            BS bsToMove = new BS();
            Lst<P3> vNot = new Lst<P3>();
            BS bsModel = this.vwr.getModelUndeletedAtomsBitSet(thisAtom.mi);
            for (int i = 0; i < bonds.length; ++i) {
                Atom a = bonds[i].getOtherAtom(thisAtom);
                if (bsAtoms.get(a.i)) {
                    bsToMove.or(JmolMolecule.getBranchBitSet(this.at, a.i, bsModel, null, iAtom, true, true));
                    continue;
                }
                vNot.addLast(a);
            }
            if (vNot.size() == 0) {
                return;
            }
            pt = Measure.getCenterAndPoints(vNot)[0];
            V3 v = V3.newVsub(thisAtom, pt);
            Quat q = Quat.newVA(v, 180.0f);
            this.moveAtoms(null, null, q.getMatrix(), null, bsToMove, thisAtom, true, false);
        }
    }

    public float[] getCellWeights(BS bsAtoms) {
        float[] wts = null;
        int i = bsAtoms.nextSetBit(0);
        int iModel = -1;
        if (i >= 0) {
            short s = this.at[i].mi;
            iModel = s;
            if (this.getUnitCell(s) != null) {
                P3 pt = new P3();
                BS bs = this.getModelAtomBitSetIncludingDeleted(iModel, true);
                bs.and(bsAtoms);
                wts = new float[bsAtoms.cardinality()];
                int p = 0;
                while (i >= 0) {
                    wts[p++] = SimpleUnitCell.getCellWeight(this.at[i].getFractionalUnitCoordPt(true, false, pt));
                    i = bsAtoms.nextSetBit(i + 1);
                }
            }
        }
        return wts;
    }

    public Quat[] getAtomGroupQuaternions(BS bsAtoms, int nMax, char qtype) {
        int n = 0;
        Lst<Quat> v = new Lst<Quat>();
        bsAtoms = BSUtil.copy(bsAtoms);
        BS bsDone = new BS();
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0 && n < nMax) {
            block6: {
                Quat q;
                block5: {
                    Group g = this.at[i].group;
                    g.setAtomBits(bsDone);
                    bsAtoms.andNot(bsDone);
                    q = g.getQuaternion(qtype);
                    if (q != null) break block5;
                    if (!this.am[this.at[i].mi].isBioModel) {
                        q = g.getQuaternionFrame(this.at);
                    }
                    if (q == null) break block6;
                }
                ++n;
                v.addLast(q);
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        return v.toArray(new Quat[v.size()]);
    }

    public BS getConformation(int modelIndex, int conformationIndex, boolean doSet, BS bsSelected) {
        BS bs = new BS();
        if (conformationIndex >= 0) {
            int i = this.mc;
            while (--i >= 0) {
                if (i != modelIndex && modelIndex >= 0) continue;
                Model m = this.am[i];
                BS bsAtoms = this.vwr.getModelUndeletedAtomsBitSet(modelIndex);
                if (bsSelected != null) {
                    bsAtoms.and(bsSelected);
                }
                if (bsAtoms.nextSetBit(0) < 0) continue;
                if (conformationIndex >= m.altLocCount) {
                    if (conformationIndex != 0) continue;
                    bs.or(bsAtoms);
                    continue;
                }
                if (this.am[i].isBioModel && ((BioModel)this.am[i]).getConformation(conformationIndex, doSet, bsAtoms, bs)) continue;
                int nAltLocs = this.getAltLocCountInModel(i);
                String altLocs = this.getAltLocListInModel(i);
                BS bsTemp = new BS();
                int c = nAltLocs;
                while (--c >= 0) {
                    if (c == conformationIndex) continue;
                    bsAtoms.andNot(this.getAtomBitsMDa(1073742355, altLocs.substring(c, c + 1), bsTemp));
                }
                if (bsAtoms.nextSetBit(0) < 0) continue;
                bs.or(bsAtoms);
            }
        }
        return bs;
    }

    public BS getSequenceBits(String specInfo, BS bsAtoms, BS bsResult) {
        return this.haveBioModels ? this.bioModelset.getAllSequenceBits(specInfo, bsAtoms, bsResult) : bsResult;
    }

    public int getBioPolymerCountInModel(int modelIndex) {
        return this.haveBioModels ? this.bioModelset.getBioPolymerCountInModel(modelIndex) : 0;
    }

    public void getPolymerPointsAndVectors(BS bs, Lst<P3[]> vList, boolean isTraceAlpha, float sheetSmoothing) {
        if (this.haveBioModels) {
            this.bioModelset.getAllPolymerPointsAndVectors(bs, vList, isTraceAlpha, sheetSmoothing);
        }
    }

    public void recalculateLeadMidpointsAndWingVectors(int modelIndex) {
        if (this.haveBioModels) {
            this.bioModelset.recalculatePoints(modelIndex);
        }
    }

    public void calcRasmolHydrogenBonds(BS bsA, BS bsB, Lst<Bond> vHBonds, boolean nucleicOnly, int nMax, boolean dsspIgnoreHydrogens, BS bsHBonds) {
        if (this.haveBioModels) {
            this.bioModelset.calcAllRasmolHydrogenBonds(bsA, bsB, vHBonds, nucleicOnly, nMax, dsspIgnoreHydrogens, bsHBonds, 2);
        }
    }

    public void calculateStraightnessAll() {
        if (this.haveBioModels && !this.haveStraightness) {
            this.bioModelset.calculateStraightnessAll();
        }
    }

    public int calculateStruts(BS bs1, BS bs2) {
        return this.haveBioModels ? this.bioModelset.calculateStruts(bs1, bs2) : 0;
    }

    public BS getGroupsWithin(int nResidues, BS bs) {
        return this.haveBioModels ? this.bioModelset.getGroupsWithinAll(nResidues, bs) : new BS();
    }

    public String getProteinStructureState(BS bsAtoms, int mode) {
        return this.haveBioModels ? this.bioModelset.getFullProteinStructureState(bsAtoms, mode) : "";
    }

    public String calculateStructures(BS bsAtoms, boolean asDSSP, boolean doReport, boolean dsspIgnoreHydrogen, boolean setStructure, int version) {
        return this.haveBioModels ? this.bioModelset.calculateAllStuctures(bsAtoms, asDSSP, doReport, dsspIgnoreHydrogen, setStructure, version) : "";
    }

    public String calculateStructuresAllExcept(BS alreadyDefined, boolean asDSSP, boolean doReport, boolean dsspIgnoreHydrogen, boolean setStructure, boolean includeAlpha, int version) {
        this.freezeModels();
        return this.haveBioModels ? this.bioModelset.calculateAllStructuresExcept(alreadyDefined, asDSSP, doReport, dsspIgnoreHydrogen, setStructure, includeAlpha, version) : "";
    }

    public void recalculatePolymers(BS bsModelsExcluded) {
        this.bioModelset.recalculateAllPolymers(bsModelsExcluded, this.getGroups());
    }

    protected void calculatePolymers(Group[] groups, int groupCount, int baseGroupIndex, BS modelsExcluded) {
        if (this.bioModelset != null) {
            this.bioModelset.calculateAllPolymers(groups, groupCount, baseGroupIndex, modelsExcluded);
        }
    }

    public void calcSelectedMonomersCount() {
        if (this.haveBioModels) {
            this.bioModelset.calcSelectedMonomersCount();
        }
    }

    public void setProteinType(BS bs, STR type) {
        if (this.haveBioModels) {
            this.bioModelset.setAllProteinType(bs, type);
        }
    }

    public void setStructureList(Map<STR, float[]> structureList) {
        if (this.haveBioModels) {
            this.bioModelset.setAllStructureList(structureList);
        }
    }

    public BS setConformation(BS bsAtoms) {
        if (this.haveBioModels) {
            this.bioModelset.setAllConformation(bsAtoms);
        }
        return bsAtoms;
    }

    public Map<String, String> getHeteroList(int modelIndex) {
        Map<String, String> o = this.haveBioModels ? this.bioModelset.getAllHeteroList(modelIndex) : null;
        return o == null ? this.getInfoM("hetNames") : o;
    }

    public Object getUnitCellPointsWithin(float distance, BS bs, P3 pt, boolean asMap) {
        SymmetryInterface unitCell;
        Lst<P3> lst = new Lst<P3>();
        Hashtable map = null;
        Lst<Integer> lstI = null;
        if (asMap) {
            map = new Hashtable();
            lstI = new Lst<Integer>();
            map.put("atoms", lstI);
            map.put("points", lst);
        }
        int iAtom = bs == null ? -1 : bs.nextSetBit(0);
        bs = this.vwr.getModelUndeletedAtomsBitSet(iAtom < 0 ? this.vwr.am.cmi : (int)this.at[iAtom].mi);
        if (iAtom < 0) {
            iAtom = bs.nextSetBit(0);
        }
        if (iAtom >= 0 && (unitCell = this.getUnitCellForAtom(iAtom)) != null) {
            AtomIndexIterator iter = unitCell.getIterator(this.vwr, this.at[iAtom], this.at, bs, distance);
            if (pt != null) {
                iter.setCenter(pt, distance);
            }
            while (iter.hasNext()) {
                iAtom = iter.next();
                pt = iter.getPosition();
                lst.addLast(pt);
                if (!asMap) continue;
                lstI.addLast(iAtom);
            }
        }
        return asMap ? map : lst;
    }

    public void calculateDssrProperty(String dataType) {
        int i;
        if (dataType == null) {
            return;
        }
        if (this.dssrData == null || this.dssrData.length < this.ac) {
            this.dssrData = new float[this.ac];
        }
        for (i = 0; i < this.ac; ++i) {
            this.dssrData[i] = Float.NaN;
        }
        i = this.mc;
        while (--i >= 0) {
            if (!this.am[i].isBioModel) continue;
            ((BioModel)this.am[i]).getAtomicDSSRData(this.dssrData, dataType);
        }
    }

    public float getAtomicDSSRData(int i) {
        return this.dssrData == null || this.dssrData.length <= i ? Float.NaN : this.dssrData[i];
    }

    public int getAtomCIPChiralityCode(Atom atom) {
        this.haveChirality = true;
        Model m = this.am[atom.mi];
        if (!m.hasChirality) {
            this.calculateChiralityForAtoms(m.bsAtoms, false);
            m.hasChirality = true;
        }
        return atom.getCIPChiralityCode();
    }

    public String calculateChiralityForAtoms(BS bsAtoms, boolean withReturn) {
        this.haveChirality = true;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            this.at[i].setCIPChirality(0);
            i = bsAtoms.nextSetBit(i + 1);
        }
        Interface.getSymmetry(this.vwr, "ms").calculateCIPChiralityForAtoms(this.vwr, bsAtoms);
        if (!withReturn) {
            return null;
        }
        String s = "";
        int i2 = bsAtoms.nextSetBit(0);
        while (i2 >= 0) {
            s = s + this.at[i2].getCIPChirality(false);
            i2 = bsAtoms.nextSetBit(i2 + 1);
        }
        return s;
    }
}

