/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.GestureType;
import com.sparshui.common.Event;
import com.sparshui.gestures.Gesture;
import com.sparshui.server.GestureFactory;
import com.sparshui.server.ServerToClientProtocol;
import com.sparshui.server.TouchPoint;
import java.io.IOException;
import java.util.List;
import javajs.util.Lst;

public class Group {
    private int _id;
    private Lst<GestureType> _gestureTypes;
    private Lst<Gesture> _gestures;
    private Lst<TouchPoint> _touchPoints;
    private ServerToClientProtocol _clientProtocol;

    public Group(int id, Lst<GestureType> gestureTypes, ServerToClientProtocol clientProtocol) {
        this._id = id;
        this._gestureTypes = gestureTypes;
        this._gestures = new Lst();
        this._touchPoints = new Lst();
        this._clientProtocol = clientProtocol;
        for (int i = 0; i < this._gestureTypes.size(); ++i) {
            Gesture gesture = GestureFactory.createGesture((GestureType)this._gestureTypes.get(i));
            if (gesture == null) continue;
            this._gestures.addLast((Object)gesture);
        }
    }

    public int getID() {
        return this._id;
    }

    public synchronized void update(TouchPoint changedPoint) {
        Lst events = new Lst();
        int state = changedPoint.getState();
        if (state == 0) {
            this._touchPoints.addLast((Object)changedPoint);
        }
        for (int i = 0; i < this._gestures.size(); ++i) {
            Gesture gesture = (Gesture)this._gestures.get(i);
            events.addAll(gesture.processChange((List<TouchPoint>)this._touchPoints, changedPoint));
        }
        if (state == 1) {
            this._touchPoints.removeObj((Object)changedPoint);
        }
        try {
            this._clientProtocol.processEvents(this._id, (Lst<Event>)events);
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

