/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.Util;
import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class TryFinally
extends Transform {
    private final MethodHandle post;
    private static final MethodHandle tryFinallyJava9 = Util.isJava9() ? Binder.from(MethodHandle.class, MethodHandle.class, MethodHandle.class).invokeStaticQuiet(MethodHandles.lookup(), MethodHandles.class, "tryFinally") : null;

    public TryFinally(MethodHandle post) {
        this.post = post;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        if (Util.isJava9()) {
            return this.nativeTryFinally(target, this.post);
        }
        MethodHandle exceptionHandler = Binder.from(target.type().insertParameterTypes(0, Throwable.class).changeReturnType(Void.TYPE)).drop(0).invoke(this.post);
        MethodHandle rethrow = Binder.from(target.type().insertParameterTypes(0, Throwable.class)).fold(exceptionHandler).drop(1, target.type().parameterCount()).throwException();
        target = MethodHandles.catchException(target, Throwable.class, rethrow);
        MethodHandle realPost = this.post;
        if (target.type().returnType() != Void.TYPE) {
            MethodHandle newPost = Binder.from(target.type().insertParameterTypes(0, new Class[]{target.type().returnType()}).changeReturnType(Void.TYPE)).drop(0).invoke(this.post);
            realPost = Binder.from(target.type().insertParameterTypes(0, new Class[]{target.type().returnType()})).fold(newPost).drop(1, target.type().parameterCount()).identity();
        }
        return MethodHandles.foldArguments(realPost, target);
    }

    private MethodHandle nativeTryFinally(MethodHandle target, MethodHandle post) {
        MethodType targetType = target.type();
        boolean voidReturn = targetType.returnType() == Void.TYPE;
        MethodType finallyType = targetType.insertParameterTypes(0, Throwable.class);
        int dropCount = 1;
        if (!voidReturn) {
            finallyType = finallyType.insertParameterTypes(1, new Class[]{targetType.returnType()});
            dropCount = 2;
        }
        MethodHandle wrapPost = Binder.from(finallyType).drop(0, dropCount).invoke(post);
        if (!voidReturn) {
            wrapPost = Binder.from(finallyType).foldVoid(wrapPost).permute(1).identity();
        }
        try {
            return tryFinallyJava9.invokeExact(target, wrapPost);
        }
        catch (Throwable t) {
            throw new RuntimeException("Java 9 detected but MethodHandles.tryFinally missing", t);
        }
    }

    @Override
    public MethodType down(MethodType type2) {
        return type2;
    }

    @Override
    public String toString() {
        return "try/finally with " + this.post;
    }
}

