/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callsite;

import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

public abstract class CachingCallSite
extends CallSite {
    protected CacheEntry cache = CacheEntry.NULL_CACHE;

    public CachingCallSite(String methodName, CallType callType) {
        super(methodName, callType);
    }

    public final CacheEntry getCache() {
        return this.cache;
    }

    public boolean isOptimizable() {
        return this.getCache() != CacheEntry.NULL_CACHE;
    }

    public int getCachedClassIndex() {
        CacheEntry cacheEntry = this.getCache();
        if (cacheEntry != CacheEntry.NULL_CACHE) {
            return cacheEntry.method.getImplementationClass().getClassIndex().ordinal();
        }
        return ClassIndex.NO_INDEX.ordinal();
    }

    public final String getMethodName() {
        return this.methodName;
    }

    public long getCachedMethodSerial() {
        CacheEntry cacheEntry = this.getCache();
        if (cacheEntry != CacheEntry.NULL_CACHE) {
            return cacheEntry.method.getSerialNumber();
        }
        return -1L;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, long fixnum) {
        return this.call(context, caller, self2, (IRubyObject)RubyFixnum.newFixnum(context.runtime, fixnum));
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, double flote) {
        return this.call(context, caller, self2, (IRubyObject)RubyFloat.newFloat(context.runtime, flote));
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject ... args2) {
        CacheEntry cache = this.cache;
        RubyClass selfType = CachingCallSite.getClass(self2);
        if (CacheEntry.typeOk(cache, selfType)) {
            return cache.method.call(context, self2, (RubyModule)selfType, this.methodName, args2);
        }
        return this.cacheAndCall(caller, selfType, args2, context, self2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = CachingCallSite.getClass(self2);
        if (CacheEntry.typeOk(cache, selfType)) {
            return cache.method.call(context, self2, (RubyModule)selfType, this.methodName, args2, block);
        }
        return this.cacheAndCall(caller, selfType, block, args2, context, self2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller, self2, args2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject callVarargs(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject ... args2) {
        switch (args2.length) {
            case 0: {
                return this.call(context, caller, self2);
            }
            case 1: {
                return this.call(context, caller, self2, args2[0]);
            }
            case 2: {
                return this.call(context, caller, self2, args2[0], args2[1]);
            }
            case 3: {
                return this.call(context, caller, self2, args2[0], args2[1], args2[2]);
            }
        }
        return this.call(context, caller, self2, args2);
    }

    @Override
    public IRubyObject callVarargs(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.call(context, caller, self2, block);
            }
            case 1: {
                return this.call(context, caller, self2, args2[0], block);
            }
            case 2: {
                return this.call(context, caller, self2, args2[0], args2[1], block);
            }
            case 3: {
                return this.call(context, caller, self2, args2[0], args2[1], args2[2], block);
            }
        }
        return this.call(context, caller, self2, args2, block);
    }

    @Override
    public IRubyObject callVarargsIter(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.callIter(context, caller, self2, block);
            }
            case 1: {
                return this.callIter(context, caller, self2, args2[0], block);
            }
            case 2: {
                return this.callIter(context, caller, self2, args2[0], args2[1], block);
            }
            case 3: {
                return this.callIter(context, caller, self2, args2[0], args2[1], args2[2], block);
            }
        }
        return this.callIter(context, caller, self2, args2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2) {
        CacheEntry cache = this.cache;
        RubyClass selfType = CachingCallSite.getClass(self2);
        if (CacheEntry.typeOk(cache, selfType)) {
            return cache.method.call(context, self2, selfType, this.methodName);
        }
        return this.cacheAndCall(caller, selfType, context, self2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = CachingCallSite.getClass(self2);
        if (CacheEntry.typeOk(cache, selfType)) {
            return cache.method.call(context, self2, (RubyModule)selfType, this.methodName, block);
        }
        return this.cacheAndCall(caller, selfType, block, context, self2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self2, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller, self2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1) {
        CacheEntry cache = this.cache;
        RubyClass selfType = CachingCallSite.getClass(self2);
        if (CacheEntry.typeOk(cache, selfType)) {
            return cache.method.call(context, self2, (RubyModule)selfType, this.methodName, arg1);
        }
        return this.cacheAndCall(caller, selfType, context, self2, arg1);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = CachingCallSite.getClass(self2);
        if (CacheEntry.typeOk(cache, selfType)) {
            return cache.method.call(context, self2, (RubyModule)selfType, this.methodName, arg1, block);
        }
        return this.cacheAndCall(caller, selfType, block, context, self2, arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller, self2, arg1, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry cache = this.cache;
        RubyClass selfType = CachingCallSite.getClass(self2);
        if (CacheEntry.typeOk(cache, selfType)) {
            return cache.method.call(context, self2, (RubyModule)selfType, this.methodName, arg1, arg2);
        }
        return this.cacheAndCall(caller, selfType, context, self2, arg1, arg2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = CachingCallSite.getClass(self2);
        if (CacheEntry.typeOk(cache, selfType)) {
            return cache.method.call(context, self2, (RubyModule)selfType, this.methodName, arg1, arg2, block);
        }
        return this.cacheAndCall(caller, selfType, block, context, self2, arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller, self2, arg1, arg2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry cache = this.cache;
        RubyClass selfType = CachingCallSite.getClass(self2);
        if (CacheEntry.typeOk(cache, selfType)) {
            return cache.method.call(context, self2, (RubyModule)selfType, this.methodName, arg1, arg2, arg3);
        }
        return this.cacheAndCall(caller, selfType, context, self2, arg1, arg2, arg3);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = CachingCallSite.getClass(self2);
        if (CacheEntry.typeOk(cache, selfType)) {
            return cache.method.call(context, self2, selfType, this.methodName, arg1, arg2, arg3, block);
        }
        return this.cacheAndCall(caller, selfType, block, context, self2, arg1, arg2, arg3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller, self2, arg1, arg2, arg3, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    public CacheEntry retrieveCache(RubyClass selfType) {
        CacheEntry cache = this.cache;
        if (CacheEntry.typeOk(cache, selfType)) {
            return cache;
        }
        return this.cacheAndGet(selfType, this.methodName);
    }

    public CacheEntry retrieveCache(RubyClass selfType, String methodName) {
        CacheEntry cache = this.cache;
        if (CacheEntry.typeOk(cache, selfType)) {
            return cache;
        }
        return this.cacheAndGet(selfType, methodName);
    }

    public boolean isBuiltin(RubyClass selfType) {
        CacheEntry cache = this.cache;
        if (CacheEntry.typeOk(cache, selfType)) {
            return cache.method.isBuiltin();
        }
        return this.cacheAndGetBuiltin(selfType, this.methodName);
    }

    private CacheEntry cacheAndGet(RubyClass selfType, String methodName) {
        CacheEntry entry = selfType.searchWithCache(methodName);
        if (!entry.method.isUndefined()) {
            this.cache = entry;
        }
        return entry;
    }

    private boolean cacheAndGetBuiltin(RubyClass selfType, String methodName) {
        CacheEntry entry = selfType.searchWithCache(methodName);
        if (!entry.method.isUndefined()) {
            return false;
        }
        return entry.method.isBuiltin();
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, IRubyObject[] args2, ThreadContext context, IRubyObject self2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, method, args2, block);
        }
        this.updateCache(entry);
        return method.call(context, self2, (RubyModule)selfType, this.methodName, args2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, IRubyObject[] args2, ThreadContext context, IRubyObject self2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, method, args2);
        }
        this.updateCache(entry);
        return method.call(context, self2, (RubyModule)selfType, this.methodName, args2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, ThreadContext context, IRubyObject self2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, method);
        }
        this.updateCache(entry);
        return method.call(context, self2, selfType, this.methodName);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, method, block);
        }
        this.updateCache(entry);
        return method.call(context, self2, (RubyModule)selfType, this.methodName, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, method, arg2);
        }
        this.updateCache(entry);
        return method.call(context, self2, (RubyModule)selfType, this.methodName, arg2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, method, arg2, block);
        }
        this.updateCache(entry);
        return method.call(context, self2, (RubyModule)selfType, this.methodName, arg2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, ThreadContext context, IRubyObject self2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, method, arg1, arg2);
        }
        this.updateCache(entry);
        return method.call(context, self2, (RubyModule)selfType, this.methodName, arg1, arg2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, method, arg1, arg2, block);
        }
        this.updateCache(entry);
        return method.call(context, self2, (RubyModule)selfType, this.methodName, arg1, arg2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, ThreadContext context, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, method, arg1, arg2, arg3);
        }
        this.updateCache(entry);
        return method.call(context, self2, (RubyModule)selfType, this.methodName, arg1, arg2, arg3);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, method, arg1, arg2, arg3, block);
        }
        this.updateCache(entry);
        return method.call(context, self2, selfType, this.methodName, arg1, arg2, arg3, block);
    }

    protected void updateCache(CacheEntry newEntry) {
        this.cache = newEntry;
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, DynamicMethod method, IRubyObject[] args2) {
        return Helpers.selectMethodMissing(context, self2, method.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)self2.getMetaClass(), this.methodName, args2, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, DynamicMethod method) {
        return Helpers.selectMethodMissing(context, self2, method.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)self2.getMetaClass(), this.methodName, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, DynamicMethod method, Block block) {
        return Helpers.selectMethodMissing(context, self2, method.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)self2.getMetaClass(), this.methodName, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, DynamicMethod method, IRubyObject arg2) {
        return Helpers.selectMethodMissing(context, self2, method.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)self2.getMetaClass(), this.methodName, arg2, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, DynamicMethod method, IRubyObject[] args2, Block block) {
        return Helpers.selectMethodMissing(context, self2, method.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)self2.getMetaClass(), this.methodName, args2, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, DynamicMethod method, IRubyObject arg0, Block block) {
        return Helpers.selectMethodMissing(context, self2, method.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)self2.getMetaClass(), this.methodName, arg0, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, DynamicMethod method, IRubyObject arg0, IRubyObject arg1) {
        return Helpers.selectMethodMissing(context, self2, method.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)self2.getMetaClass(), this.methodName, arg0, arg1, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, DynamicMethod method, IRubyObject arg0, IRubyObject arg1, Block block) {
        return Helpers.selectMethodMissing(context, self2, method.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)self2.getMetaClass(), this.methodName, arg0, arg1, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, DynamicMethod method, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return Helpers.selectMethodMissing(context, self2, method.getVisibility(), this.methodName, this.callType).call(context, self2, self2.getMetaClass(), this.methodName, arg0, arg1, arg2, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, DynamicMethod method, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return Helpers.selectMethodMissing(context, self2, method.getVisibility(), this.methodName, this.callType).call(context, self2, self2.getMetaClass(), this.methodName, arg0, arg1, arg2, block);
    }

    protected abstract boolean methodMissing(DynamicMethod var1, IRubyObject var2);

    protected static RubyClass getClass(IRubyObject self2) {
        return ((RubyBasicObject)self2).getMetaClass();
    }
}

