/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.BinaryRangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.BinaryRangeAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public final class IpRangeAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.Bytes, IpRangeAggregationBuilder> {
    public static final String NAME = "ip_range";
    private static final ParseField MASK_FIELD = new ParseField("mask", new String[0]);
    private static final ObjectParser<IpRangeAggregationBuilder, Void> PARSER = new ObjectParser("ip_range");
    private boolean keyed = false;
    private List<Range> ranges = new ArrayList<Range>();

    public static AggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new IpRangeAggregationBuilder(aggregationName), null);
    }

    private static Range parseRange(XContentParser parser) throws IOException {
        String key = null;
        String from = null;
        String to = null;
        String mask = null;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[ranges] must contain objects, but hit a " + (Object)((Object)parser.currentToken()), new Object[0]);
        }
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            if (parser.currentToken() == XContentParser.Token.FIELD_NAME) continue;
            if (RangeAggregator.Range.KEY_FIELD.match(parser.currentName())) {
                key = parser.text();
                continue;
            }
            if (RangeAggregator.Range.FROM_FIELD.match(parser.currentName())) {
                from = parser.textOrNull();
                continue;
            }
            if (RangeAggregator.Range.TO_FIELD.match(parser.currentName())) {
                to = parser.textOrNull();
                continue;
            }
            if (MASK_FIELD.match(parser.currentName())) {
                mask = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected ip range parameter: [" + parser.currentName() + "]", new Object[0]);
        }
        if (mask != null) {
            if (key == null) {
                key = mask;
            }
            return new Range(key, mask);
        }
        return new Range(key, from, to);
    }

    public IpRangeAggregationBuilder(String name) {
        super(name, ValuesSourceType.BYTES, ValueType.IP);
    }

    @Override
    public String getType() {
        return NAME;
    }

    public IpRangeAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    public List<Range> getRanges() {
        return Collections.unmodifiableList(this.ranges);
    }

    public IpRangeAggregationBuilder addRange(Range range) {
        this.ranges.add(range);
        return this;
    }

    public IpRangeAggregationBuilder addRange(String key, String from, String to) {
        this.addRange(new Range(key, from, to));
        return this;
    }

    public IpRangeAggregationBuilder addMaskRange(String key, String mask) {
        return this.addRange(new Range(key, mask));
    }

    public IpRangeAggregationBuilder addMaskRange(String mask) {
        return this.addRange(new Range(mask, mask));
    }

    public IpRangeAggregationBuilder addRange(String from, String to) {
        return this.addRange(null, from, to);
    }

    public IpRangeAggregationBuilder addUnboundedTo(String key, String to) {
        this.addRange(new Range(key, null, to));
        return this;
    }

    public IpRangeAggregationBuilder addUnboundedTo(String to) {
        return this.addUnboundedTo(null, to);
    }

    public IpRangeAggregationBuilder addUnboundedFrom(String key, String from) {
        this.addRange(new Range(key, from, null));
        return this;
    }

    @Override
    public IpRangeAggregationBuilder script(Script script) {
        throw new IllegalArgumentException("[ip_range] does not support scripts");
    }

    public IpRangeAggregationBuilder addUnboundedFrom(String from) {
        return this.addUnboundedFrom(null, from);
    }

    public IpRangeAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.BYTES, ValueType.IP);
        int numRanges = in.readVInt();
        for (int i = 0; i < numRanges; ++i) {
            this.addRange(new Range(in));
        }
        this.keyed = in.readBoolean();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ranges.size());
        for (Range range : this.ranges) {
            range.writeTo(out);
        }
        out.writeBoolean(this.keyed);
    }

    private static BytesRef toBytesRef(String ip) {
        if (ip == null) {
            return null;
        }
        InetAddress address = InetAddresses.forString(ip);
        byte[] bytes = InetAddressPoint.encode((InetAddress)address);
        return new BytesRef(bytes);
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.Bytes, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.Bytes> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        ArrayList<BinaryRangeAggregator.Range> ranges = new ArrayList<BinaryRangeAggregator.Range>();
        if (this.ranges.size() == 0) {
            throw new IllegalArgumentException("No [ranges] specified for the [" + this.getName() + "] aggregation");
        }
        for (Range range : this.ranges) {
            ranges.add(new BinaryRangeAggregator.Range(range.key, IpRangeAggregationBuilder.toBytesRef(range.from), IpRangeAggregationBuilder.toBytesRef(range.to)));
        }
        return new BinaryRangeAggregatorFactory(this.name, config, ranges, this.keyed, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RangeAggregator.RANGES_FIELD.getPreferredName(), this.ranges);
        builder.field(RangeAggregator.KEYED_FIELD.getPreferredName(), this.keyed);
        return builder;
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.keyed, this.ranges);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        IpRangeAggregationBuilder that = (IpRangeAggregationBuilder)obj;
        return this.keyed == that.keyed && this.ranges.equals(that.ranges);
    }

    static {
        ValuesSourceParserHelper.declareBytesFields(PARSER, false, false);
        PARSER.declareBoolean(IpRangeAggregationBuilder::keyed, RangeAggregator.KEYED_FIELD);
        PARSER.declareObjectArray((agg, ranges) -> {
            for (Range range : ranges) {
                agg.addRange(range);
            }
        }, (p, c) -> IpRangeAggregationBuilder.parseRange(p), RangeAggregator.RANGES_FIELD);
    }

    public static class Range
    implements ToXContentObject {
        private final String key;
        private final String from;
        private final String to;

        Range(String key, String from, String to) {
            if (from != null) {
                InetAddresses.forString(from);
            }
            if (to != null) {
                InetAddresses.forString(to);
            }
            this.key = key;
            this.from = from;
            this.to = to;
        }

        Range(String key, String mask) {
            String[] splits = mask.split("/");
            if (splits.length != 2) {
                throw new IllegalArgumentException("Expected [ip/prefix_length] but got [" + mask + "], which contains zero or more than one [/]");
            }
            InetAddress value = InetAddresses.forString(splits[0]);
            int prefixLength = Integer.parseInt(splits[1]);
            if (prefixLength < 0 || prefixLength > 8 * value.getAddress().length) {
                throw new IllegalArgumentException("illegal prefixLength [" + prefixLength + "] in [" + mask + "]. Must be 0-32 for IPv4 ranges, 0-128 for IPv6 ranges");
            }
            byte[] lower = value.getAddress();
            byte[] upper = value.getAddress();
            for (int i = prefixLength; i < 8 * lower.length; ++i) {
                int m = 1 << 7 - (i & 7);
                int n = i >> 3;
                lower[n] = (byte)(lower[n] & ~m);
                int n2 = i >> 3;
                upper[n2] = (byte)(upper[n2] | m);
            }
            this.key = key;
            try {
                InetAddress fromAddress = InetAddress.getByAddress(lower);
                this.from = fromAddress.equals(InetAddressPoint.MIN_VALUE) ? null : InetAddresses.toAddrString(fromAddress);
                InetAddress inclusiveToAddress = InetAddress.getByAddress(upper);
                this.to = inclusiveToAddress.equals(InetAddressPoint.MAX_VALUE) ? null : InetAddresses.toAddrString(InetAddressPoint.nextUp((InetAddress)inclusiveToAddress));
            }
            catch (UnknownHostException bogus) {
                throw new AssertionError((Object)bogus);
            }
        }

        private Range(StreamInput in) throws IOException {
            this.key = in.readOptionalString();
            this.from = in.readOptionalString();
            this.to = in.readOptionalString();
        }

        void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.key);
            out.writeOptionalString(this.from);
            out.writeOptionalString(this.to);
        }

        public String getKey() {
            return this.key;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Range that = (Range)obj;
            return Objects.equals(this.key, that.key) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.key, this.from, this.to);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.key != null) {
                builder.field(RangeAggregator.Range.KEY_FIELD.getPreferredName(), this.key);
            }
            if (this.from != null) {
                builder.field(RangeAggregator.Range.FROM_FIELD.getPreferredName(), this.from);
            }
            if (this.to != null) {
                builder.field(RangeAggregator.Range.TO_FIELD.getPreferredName(), this.to);
            }
            builder.endObject();
            return builder;
        }
    }
}

