/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SBlock;
import org.objectweb.asm.Label;

final class SSubEachArray
extends AStatement {
    private final Locals.Variable variable;
    private AExpression expression;
    private final SBlock block;
    private Definition.Cast cast = null;
    private Locals.Variable array = null;
    private Locals.Variable index = null;
    private Definition.Type indexed = null;

    SSubEachArray(Location location, Locals.Variable variable, AExpression expression, SBlock block) {
        super(location);
        this.variable = Objects.requireNonNull(variable);
        this.expression = Objects.requireNonNull(expression);
        this.block = block;
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(Locals locals) {
        this.array = locals.addVariable(this.location, this.expression.actual, "#array" + this.location.getOffset(), true);
        this.index = locals.addVariable(this.location, Definition.INT_TYPE, "#index" + this.location.getOffset(), true);
        this.indexed = locals.getDefinition().getType(this.expression.actual.struct, this.expression.actual.dimensions - 1);
        this.cast = AnalyzerCaster.getLegalCast(this.location, this.indexed, this.variable.type, true, true);
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeStatementOffset(this.location);
        this.expression.write(writer, globals);
        writer.visitVarInsn(this.array.type.type.getOpcode(54), this.array.getSlot());
        writer.push(-1);
        writer.visitVarInsn(this.index.type.type.getOpcode(54), this.index.getSlot());
        Label begin = new Label();
        Label end = new Label();
        writer.mark(begin);
        writer.visitIincInsn(this.index.getSlot(), 1);
        writer.visitVarInsn(this.index.type.type.getOpcode(21), this.index.getSlot());
        writer.visitVarInsn(this.array.type.type.getOpcode(21), this.array.getSlot());
        writer.arrayLength();
        writer.ifICmp(156, end);
        writer.visitVarInsn(this.array.type.type.getOpcode(21), this.array.getSlot());
        writer.visitVarInsn(this.index.type.type.getOpcode(21), this.index.getSlot());
        writer.arrayLoad(this.indexed.type);
        writer.writeCast(this.cast);
        writer.visitVarInsn(this.variable.type.type.getOpcode(54), this.variable.getSlot());
        if (this.loopCounter != null) {
            writer.writeLoopCounter(this.loopCounter.getSlot(), this.statementCount, this.location);
        }
        this.block.continu = begin;
        this.block.brake = end;
        this.block.write(writer, globals);
        writer.goTo(begin);
        writer.mark(end);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.variable.type.name, this.variable.name, this.expression, this.block);
    }
}

