/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanWeight;
import org.apache.lucene.search.ConjunctionScorer;
import org.apache.lucene.search.DisjunctionSumScorer;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.MinShouldMatchSumScorer;
import org.apache.lucene.search.ReqExclScorer;
import org.apache.lucene.search.ReqOptSumScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.util.PriorityQueue;

final class Boolean2ScorerSupplier
extends ScorerSupplier {
    private final BooleanWeight weight;
    private final Map<BooleanClause.Occur, Collection<ScorerSupplier>> subs;
    private final boolean needsScores;
    private final int minShouldMatch;
    private long cost = -1L;

    Boolean2ScorerSupplier(BooleanWeight weight, Map<BooleanClause.Occur, Collection<ScorerSupplier>> subs, boolean needsScores, int minShouldMatch) {
        if (minShouldMatch < 0) {
            throw new IllegalArgumentException("minShouldMatch must be positive, but got: " + minShouldMatch);
        }
        if (minShouldMatch != 0 && minShouldMatch >= subs.get((Object)BooleanClause.Occur.SHOULD).size()) {
            throw new IllegalArgumentException("minShouldMatch must be strictly less than the number of SHOULD clauses");
        }
        if (!needsScores && minShouldMatch == 0 && subs.get((Object)BooleanClause.Occur.SHOULD).size() > 0 && subs.get((Object)BooleanClause.Occur.MUST).size() + subs.get((Object)BooleanClause.Occur.FILTER).size() > 0) {
            throw new IllegalArgumentException("Cannot pass purely optional clauses if scores are not needed");
        }
        if (subs.get((Object)BooleanClause.Occur.SHOULD).size() + subs.get((Object)BooleanClause.Occur.MUST).size() + subs.get((Object)BooleanClause.Occur.FILTER).size() == 0) {
            throw new IllegalArgumentException("There should be at least one positive clause");
        }
        this.weight = weight;
        this.subs = subs;
        this.needsScores = needsScores;
        this.minShouldMatch = minShouldMatch;
    }

    private long computeCost() {
        OptionalLong minRequiredCost = Stream.concat(this.subs.get((Object)BooleanClause.Occur.MUST).stream(), this.subs.get((Object)BooleanClause.Occur.FILTER).stream()).mapToLong(ScorerSupplier::cost).min();
        if (minRequiredCost.isPresent() && this.minShouldMatch == 0) {
            return minRequiredCost.getAsLong();
        }
        Collection<ScorerSupplier> optionalScorers = this.subs.get((Object)BooleanClause.Occur.SHOULD);
        long shouldCost = MinShouldMatchSumScorer.cost(optionalScorers.stream().mapToLong(ScorerSupplier::cost), optionalScorers.size(), this.minShouldMatch);
        return Math.min(minRequiredCost.orElse(Long.MAX_VALUE), shouldCost);
    }

    @Override
    public long cost() {
        if (this.cost == -1L) {
            this.cost = this.computeCost();
        }
        return this.cost;
    }

    @Override
    public Scorer get(boolean randomAccess) throws IOException {
        if (this.subs.get((Object)BooleanClause.Occur.SHOULD).isEmpty()) {
            return this.excl(this.req(this.subs.get((Object)BooleanClause.Occur.FILTER), this.subs.get((Object)BooleanClause.Occur.MUST), randomAccess), this.subs.get((Object)BooleanClause.Occur.MUST_NOT));
        }
        if (this.subs.get((Object)BooleanClause.Occur.FILTER).isEmpty() && this.subs.get((Object)BooleanClause.Occur.MUST).isEmpty()) {
            return this.excl(this.opt(this.subs.get((Object)BooleanClause.Occur.SHOULD), this.minShouldMatch, this.needsScores, randomAccess), this.subs.get((Object)BooleanClause.Occur.MUST_NOT));
        }
        if (this.minShouldMatch > 0) {
            boolean reqRandomAccess = true;
            boolean msmRandomAccess = true;
            if (!randomAccess) {
                long msmCost;
                long reqCost = Stream.concat(this.subs.get((Object)BooleanClause.Occur.MUST).stream(), this.subs.get((Object)BooleanClause.Occur.FILTER).stream()).mapToLong(ScorerSupplier::cost).min().getAsLong();
                reqRandomAccess = reqCost > (msmCost = MinShouldMatchSumScorer.cost(this.subs.get((Object)BooleanClause.Occur.SHOULD).stream().mapToLong(ScorerSupplier::cost), this.subs.get((Object)BooleanClause.Occur.SHOULD).size(), this.minShouldMatch));
                msmRandomAccess = msmCost > reqCost;
            }
            Scorer req = this.excl(this.req(this.subs.get((Object)BooleanClause.Occur.FILTER), this.subs.get((Object)BooleanClause.Occur.MUST), reqRandomAccess), this.subs.get((Object)BooleanClause.Occur.MUST_NOT));
            Scorer opt = this.opt(this.subs.get((Object)BooleanClause.Occur.SHOULD), this.minShouldMatch, this.needsScores, msmRandomAccess);
            return new ConjunctionScorer(this.weight, Arrays.asList(req, opt), Arrays.asList(req, opt));
        }
        assert (this.needsScores);
        return new ReqOptSumScorer(this.excl(this.req(this.subs.get((Object)BooleanClause.Occur.FILTER), this.subs.get((Object)BooleanClause.Occur.MUST), randomAccess), this.subs.get((Object)BooleanClause.Occur.MUST_NOT)), this.opt(this.subs.get((Object)BooleanClause.Occur.SHOULD), this.minShouldMatch, this.needsScores, true));
    }

    private Scorer req(Collection<ScorerSupplier> requiredNoScoring, Collection<ScorerSupplier> requiredScoring, boolean randomAccess) throws IOException {
        if (requiredNoScoring.size() + requiredScoring.size() == 1) {
            Scorer req = (requiredNoScoring.isEmpty() ? requiredScoring : requiredNoScoring).iterator().next().get(randomAccess);
            if (!this.needsScores) {
                return req;
            }
            if (requiredScoring.isEmpty()) {
                return new FilterScorer(req){

                    @Override
                    public float score() throws IOException {
                        return 0.0f;
                    }

                    @Override
                    public int freq() throws IOException {
                        return 0;
                    }
                };
            }
            return req;
        }
        long minCost = Math.min(requiredNoScoring.stream().mapToLong(ScorerSupplier::cost).min().orElse(Long.MAX_VALUE), requiredScoring.stream().mapToLong(ScorerSupplier::cost).min().orElse(Long.MAX_VALUE));
        ArrayList<Scorer> requiredScorers = new ArrayList<Scorer>();
        ArrayList<Scorer> scoringScorers = new ArrayList<Scorer>();
        for (ScorerSupplier s : requiredNoScoring) {
            requiredScorers.add(s.get(randomAccess || s.cost() > minCost));
        }
        for (ScorerSupplier s : requiredScoring) {
            Scorer scorer = s.get(randomAccess || s.cost() > minCost);
            requiredScorers.add(scorer);
            scoringScorers.add(scorer);
        }
        return new ConjunctionScorer(this.weight, requiredScorers, scoringScorers);
    }

    private Scorer excl(Scorer main, Collection<ScorerSupplier> prohibited) throws IOException {
        if (prohibited.isEmpty()) {
            return main;
        }
        return new ReqExclScorer(main, this.opt(prohibited, 1, false, true));
    }

    private Scorer opt(Collection<ScorerSupplier> optional, int minShouldMatch, boolean needsScores, boolean randomAccess) throws IOException {
        if (optional.size() == 1) {
            return optional.iterator().next().get(randomAccess);
        }
        if (minShouldMatch > 1) {
            ArrayList<Scorer> optionalScorers = new ArrayList<Scorer>();
            PriorityQueue<ScorerSupplier> pq = new PriorityQueue<ScorerSupplier>(this.subs.get((Object)BooleanClause.Occur.SHOULD).size() - minShouldMatch + 1){

                @Override
                protected boolean lessThan(ScorerSupplier a, ScorerSupplier b) {
                    return a.cost() > b.cost();
                }
            };
            for (ScorerSupplier scorer : this.subs.get((Object)BooleanClause.Occur.SHOULD)) {
                ScorerSupplier overflow = pq.insertWithOverflow(scorer);
                if (overflow == null) continue;
                optionalScorers.add(overflow.get(true));
            }
            for (ScorerSupplier scorer : pq) {
                optionalScorers.add(scorer.get(randomAccess));
            }
            return new MinShouldMatchSumScorer(this.weight, optionalScorers, minShouldMatch);
        }
        ArrayList<Scorer> optionalScorers = new ArrayList<Scorer>();
        for (ScorerSupplier scorer : optional) {
            optionalScorers.add(scorer.get(randomAccess));
        }
        return new DisjunctionSumScorer(this.weight, optionalScorers, needsScores);
    }
}

