/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.i18n.Messages;

public final class LoadDialog
extends FreeColDialog<File> {
    private static final File cancelFile = new File("");

    public LoadDialog(FreeColClient freeColClient, JFrame frame, File directory, FileFilter[] fileFilters) {
        super(freeColClient, frame);
        JFileChooser fileChooser = new JFileChooser(directory);
        if (fileFilters.length > 0) {
            for (FileFilter fileFilter : fileFilters) {
                fileChooser.addChoosableFileFilter(fileFilter);
            }
            fileChooser.setFileFilter(fileFilters[0]);
            fileChooser.setAcceptAllFileFilterUsed(false);
        }
        fileChooser.setControlButtonsAreShown(true);
        fileChooser.setApproveButtonText(Messages.message("ok"));
        fileChooser.setDialogType(0);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileHidingEnabled(false);
        fileChooser.addActionListener(ae -> {
            String cmd = ae.getActionCommand();
            File value = "ApproveSelection".equals(cmd) ? ((JFileChooser)ae.getSource()).getSelectedFile() : cancelFile;
            this.setValue(value);
        });
        List c = LoadDialog.choices();
        this.initializeDialog(frame, FreeColDialog.DialogType.QUESTION, true, fileChooser, null, c);
    }

    @Override
    public File getResponse() {
        File value = (File)this.getValue();
        return value == cancelFile ? null : value;
    }
}

