/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.project.api.Workspace;
import org.gephi.ui.utils.ColorUtils;
import org.gephi.visualization.GraphLimits;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.GraphDrawable;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.text.TextModelImpl;
import org.openide.util.Lookup;

public class VizModel {
    protected VizConfig config;
    protected GraphLimits limits;
    protected float[] cameraPosition;
    protected float[] cameraTarget;
    protected TextModelImpl textModel;
    protected Color backgroundColor;
    protected float[] backgroundColorComponents = new float[4];
    protected boolean showEdges;
    protected boolean lightenNonSelectedAuto;
    protected boolean autoSelectNeighbor;
    protected boolean hideNonSelectedEdges;
    protected boolean uniColorSelected;
    protected boolean edgeHasUniColor;
    protected float[] edgeUniColor;
    protected boolean edgeSelectionColor;
    protected float[] edgeInSelectionColor;
    protected float[] edgeOutSelectionColor;
    protected float[] edgeBothSelectionColor;
    protected boolean adjustByText;
    protected float edgeScale;
    protected List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private boolean defaultModel = false;

    public VizModel(Workspace workspace) {
        this.defaultValues();
        this.limits = VizController.getInstance().getLimits();
        GraphModel gm = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        this.textModel.setTextColumns(new Column[]{gm.getNodeTable().getColumn("label")}, new Column[]{gm.getEdgeTable().getColumn("label")});
    }

    public VizModel(boolean defaultModel) {
        this.defaultModel = defaultModel;
        this.defaultValues();
        this.limits = VizController.getInstance().getLimits();
    }

    public void init() {
        final PropertyChangeEvent evt = new PropertyChangeEvent(this, "init", null, null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (VizModel.this.listeners != null) {
                    for (PropertyChangeListener l : VizModel.this.listeners) {
                        l.propertyChange(evt);
                    }
                }
            }
        });
    }

    public boolean isDefaultModel() {
        return this.defaultModel;
    }

    public List<PropertyChangeListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<PropertyChangeListener> listeners) {
        this.listeners = listeners;
    }

    private void defaultValues() {
        this.config = VizController.getInstance().getVizConfig();
        this.cameraPosition = Arrays.copyOf(this.config.getDefaultCameraPosition(), 3);
        this.cameraTarget = Arrays.copyOf(this.config.getDefaultCameraTarget(), 3);
        this.textModel = new TextModelImpl();
        this.backgroundColor = this.config.getDefaultBackgroundColor();
        this.backgroundColorComponents = this.backgroundColor.getRGBComponents(this.backgroundColorComponents);
        this.showEdges = this.config.isDefaultShowEdges();
        this.lightenNonSelectedAuto = this.config.isDefaultLightenNonSelectedAuto();
        this.autoSelectNeighbor = this.config.isDefaultAutoSelectNeighbor();
        this.hideNonSelectedEdges = this.config.isDefaultHideNonSelectedEdges();
        this.uniColorSelected = this.config.isDefaultUniColorSelected();
        this.edgeHasUniColor = this.config.isDefaultEdgeHasUniColor();
        this.edgeUniColor = this.config.getDefaultEdgeUniColor().getRGBComponents(null);
        this.adjustByText = this.config.isDefaultAdjustByText();
        this.edgeSelectionColor = this.config.isDefaultEdgeSelectionColor();
        this.edgeInSelectionColor = this.config.getDefaultEdgeInSelectedColor().getRGBComponents(null);
        this.edgeOutSelectionColor = this.config.getDefaultEdgeOutSelectedColor().getRGBComponents(null);
        this.edgeBothSelectionColor = this.config.getDefaultEdgeBothSelectedColor().getRGBComponents(null);
        this.edgeScale = this.config.getDefaultEdgeScale();
    }

    public boolean isAdjustByText() {
        return this.adjustByText;
    }

    public boolean isAutoSelectNeighbor() {
        return this.autoSelectNeighbor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public float[] getBackgroundColorComponents() {
        return this.backgroundColorComponents;
    }

    public float[] getCameraPosition() {
        return this.cameraPosition;
    }

    public float[] getCameraTarget() {
        return this.cameraTarget;
    }

    public boolean isShowEdges() {
        return this.showEdges;
    }

    public boolean isEdgeHasUniColor() {
        return this.edgeHasUniColor;
    }

    public float[] getEdgeUniColor() {
        return this.edgeUniColor;
    }

    public boolean isHideNonSelectedEdges() {
        return this.hideNonSelectedEdges;
    }

    public boolean isLightenNonSelectedAuto() {
        return this.lightenNonSelectedAuto;
    }

    public TextModelImpl getTextModel() {
        return this.textModel;
    }

    public boolean isUniColorSelected() {
        return this.uniColorSelected;
    }

    public VizConfig getConfig() {
        return this.config;
    }

    public boolean isEdgeSelectionColor() {
        return this.edgeSelectionColor;
    }

    public float[] getEdgeInSelectionColor() {
        return this.edgeInSelectionColor;
    }

    public float[] getEdgeOutSelectionColor() {
        return this.edgeOutSelectionColor;
    }

    public float[] getEdgeBothSelectionColor() {
        return this.edgeBothSelectionColor;
    }

    public float getEdgeScale() {
        return this.edgeScale;
    }

    public void setAdjustByText(boolean adjustByText) {
        this.adjustByText = adjustByText;
        this.fireProperyChange("adjustByText", null, adjustByText);
    }

    public void setAutoSelectNeighbor(boolean autoSelectNeighbor) {
        this.autoSelectNeighbor = autoSelectNeighbor;
        this.fireProperyChange("autoSelectNeighbor", null, autoSelectNeighbor);
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.backgroundColorComponents = backgroundColor.getRGBComponents(this.backgroundColorComponents);
        this.fireProperyChange("backgroundColor", null, backgroundColor);
    }

    public void setShowEdges(boolean showEdges) {
        this.showEdges = showEdges;
        this.fireProperyChange("showEdges", null, showEdges);
    }

    public void setEdgeHasUniColor(boolean edgeHasUniColor) {
        this.edgeHasUniColor = edgeHasUniColor;
        this.fireProperyChange("edgeHasUniColor", null, edgeHasUniColor);
    }

    public void setEdgeUniColor(float[] edgeUniColor) {
        this.edgeUniColor = edgeUniColor;
        this.fireProperyChange("edgeUniColor", null, edgeUniColor);
    }

    public void setHideNonSelectedEdges(boolean hideNonSelectedEdges) {
        this.hideNonSelectedEdges = hideNonSelectedEdges;
        this.fireProperyChange("hideNonSelectedEdges", null, hideNonSelectedEdges);
    }

    public void setLightenNonSelectedAuto(boolean lightenNonSelectedAuto) {
        this.lightenNonSelectedAuto = lightenNonSelectedAuto;
        this.fireProperyChange("lightenNonSelectedAuto", null, lightenNonSelectedAuto);
    }

    public void setUniColorSelected(boolean uniColorSelected) {
        this.uniColorSelected = uniColorSelected;
        this.fireProperyChange("uniColorSelected", null, uniColorSelected);
    }

    public void setEdgeSelectionColor(boolean edgeSelectionColor) {
        this.edgeSelectionColor = edgeSelectionColor;
        this.fireProperyChange("edgeSelectionColor", null, edgeSelectionColor);
    }

    public void setEdgeInSelectionColor(float[] edgeInSelectionColor) {
        this.edgeInSelectionColor = edgeInSelectionColor;
        this.fireProperyChange("edgeInSelectionColor", null, edgeInSelectionColor);
    }

    public void setEdgeOutSelectionColor(float[] edgeOutSelectionColor) {
        this.edgeOutSelectionColor = edgeOutSelectionColor;
        this.fireProperyChange("edgeOutSelectionColor", null, edgeOutSelectionColor);
    }

    public void setEdgeBothSelectionColor(float[] edgeBothSelectionColor) {
        this.edgeBothSelectionColor = edgeBothSelectionColor;
        this.fireProperyChange("edgeBothSelectionColor", null, edgeBothSelectionColor);
    }

    public void setEdgeScale(float edgeScale) {
        this.edgeScale = edgeScale;
        this.fireProperyChange("edgeScale", null, Float.valueOf(edgeScale));
    }

    public GraphLimits getLimits() {
        return this.limits;
    }

    public float getCameraDistance() {
        GraphDrawable drawable = VizController.getInstance().getDrawable();
        return drawable.getCameraVector().length();
    }

    public void setCameraDistance(float distance) {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireProperyChange(String propertyName, Object oldvalue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldvalue, newValue);
        for (PropertyChangeListener l : this.listeners) {
            l.propertyChange(evt);
        }
    }

    public void readXML(XMLStreamReader reader, Workspace workspace) throws XMLStreamException {
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if ("textmodel".equalsIgnoreCase(name)) {
                        this.textModel.readXML(reader, workspace);
                        break;
                    }
                    if ("cameraposition".equalsIgnoreCase(name)) {
                        this.cameraPosition[0] = Float.parseFloat(reader.getAttributeValue(null, "x"));
                        this.cameraPosition[1] = Float.parseFloat(reader.getAttributeValue(null, "y"));
                        this.cameraPosition[2] = Float.parseFloat(reader.getAttributeValue(null, "z"));
                        break;
                    }
                    if ("cameratarget".equalsIgnoreCase(name)) {
                        this.cameraTarget[0] = Float.parseFloat(reader.getAttributeValue(null, "x"));
                        this.cameraTarget[1] = Float.parseFloat(reader.getAttributeValue(null, "y"));
                        this.cameraTarget[2] = Float.parseFloat(reader.getAttributeValue(null, "z"));
                        break;
                    }
                    if ("showedges".equalsIgnoreCase(name)) {
                        this.setShowEdges(Boolean.parseBoolean(reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("lightennonselectedauto".equalsIgnoreCase(name)) {
                        this.setLightenNonSelectedAuto(Boolean.parseBoolean(reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("autoselectneighbor".equalsIgnoreCase(name)) {
                        this.setAutoSelectNeighbor(Boolean.parseBoolean(reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("hidenonselectededges".equalsIgnoreCase(name)) {
                        this.setHideNonSelectedEdges(Boolean.parseBoolean(reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("unicolorselected".equalsIgnoreCase(name)) {
                        this.setUniColorSelected(Boolean.parseBoolean(reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("edgehasunicolor".equalsIgnoreCase(name)) {
                        this.setEdgeHasUniColor(Boolean.parseBoolean(reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("adjustbytext".equalsIgnoreCase(name)) {
                        this.setAdjustByText(Boolean.parseBoolean(reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("edgeSelectionColor".equalsIgnoreCase(name)) {
                        this.setEdgeSelectionColor(Boolean.parseBoolean(reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("backgroundcolor".equalsIgnoreCase(name)) {
                        this.setBackgroundColor(ColorUtils.decode((String)reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("edgeunicolor".equalsIgnoreCase(name)) {
                        this.setEdgeUniColor(ColorUtils.decode((String)reader.getAttributeValue(null, "value")).getRGBComponents(null));
                        break;
                    }
                    if ("edgeInSelectionColor".equalsIgnoreCase(name)) {
                        this.setEdgeInSelectionColor(ColorUtils.decode((String)reader.getAttributeValue(null, "value")).getRGBComponents(null));
                        break;
                    }
                    if ("edgeOutSelectionColor".equalsIgnoreCase(name)) {
                        this.setEdgeOutSelectionColor(ColorUtils.decode((String)reader.getAttributeValue(null, "value")).getRGBComponents(null));
                        break;
                    }
                    if ("edgeBothSelectionColor".equalsIgnoreCase(name)) {
                        this.setEdgeBothSelectionColor(ColorUtils.decode((String)reader.getAttributeValue(null, "value")).getRGBComponents(null));
                        break;
                    }
                    if (!"edgeScale".equalsIgnoreCase(name)) break;
                    this.setEdgeScale(Float.parseFloat(reader.getAttributeValue(null, "value")));
                    break;
                }
                case 2: {
                    if (!"vizmodel".equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    public void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        GraphDrawable drawable = VizController.getInstance().getDrawable();
        this.cameraPosition = Arrays.copyOf(drawable.getCameraLocation(), 3);
        this.cameraTarget = Arrays.copyOf(drawable.getCameraTarget(), 3);
        this.textModel.writeXML(writer);
        writer.writeStartElement("cameraposition");
        writer.writeAttribute("x", Float.toString(this.cameraPosition[0]));
        writer.writeAttribute("y", Float.toString(this.cameraPosition[1]));
        writer.writeAttribute("z", Float.toString(this.cameraPosition[2]));
        writer.writeEndElement();
        writer.writeStartElement("cameratarget");
        writer.writeAttribute("x", Float.toString(this.cameraTarget[0]));
        writer.writeAttribute("y", Float.toString(this.cameraTarget[1]));
        writer.writeAttribute("z", Float.toString(this.cameraTarget[2]));
        writer.writeEndElement();
        writer.writeStartElement("showedges");
        writer.writeAttribute("value", String.valueOf(this.showEdges));
        writer.writeEndElement();
        writer.writeStartElement("lightennonselectedauto");
        writer.writeAttribute("value", String.valueOf(this.lightenNonSelectedAuto));
        writer.writeEndElement();
        writer.writeStartElement("autoselectneighbor");
        writer.writeAttribute("value", String.valueOf(this.autoSelectNeighbor));
        writer.writeEndElement();
        writer.writeStartElement("hidenonselectededges");
        writer.writeAttribute("value", String.valueOf(this.hideNonSelectedEdges));
        writer.writeEndElement();
        writer.writeStartElement("unicolorselected");
        writer.writeAttribute("value", String.valueOf(this.uniColorSelected));
        writer.writeEndElement();
        writer.writeStartElement("edgehasunicolor");
        writer.writeAttribute("value", String.valueOf(this.edgeHasUniColor));
        writer.writeEndElement();
        writer.writeStartElement("adjustbytext");
        writer.writeAttribute("value", String.valueOf(this.adjustByText));
        writer.writeEndElement();
        writer.writeStartElement("edgeSelectionColor");
        writer.writeAttribute("value", String.valueOf(this.edgeSelectionColor));
        writer.writeEndElement();
        writer.writeStartElement("backgroundcolor");
        writer.writeAttribute("value", ColorUtils.encode((Color)this.backgroundColor));
        writer.writeEndElement();
        writer.writeStartElement("edgeunicolor");
        writer.writeAttribute("value", ColorUtils.encode((Color)ColorUtils.decode((float[])this.edgeUniColor)));
        writer.writeEndElement();
        writer.writeStartElement("edgeInSelectionColor");
        writer.writeAttribute("value", ColorUtils.encode((Color)ColorUtils.decode((float[])this.edgeInSelectionColor)));
        writer.writeEndElement();
        writer.writeStartElement("edgeOutSelectionColor");
        writer.writeAttribute("value", ColorUtils.encode((Color)ColorUtils.decode((float[])this.edgeOutSelectionColor)));
        writer.writeEndElement();
        writer.writeStartElement("edgeBothSelectionColor");
        writer.writeAttribute("value", ColorUtils.encode((Color)ColorUtils.decode((float[])this.edgeBothSelectionColor)));
        writer.writeEndElement();
        writer.writeStartElement("edgeScale");
        writer.writeAttribute("value", String.valueOf(this.edgeScale));
        writer.writeEndElement();
    }
}

