/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.AllFormatsImporter;
import org.openstreetmap.josm.gui.io.importexport.FileExporter;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.io.importexport.GeoJSONExporter;
import org.openstreetmap.josm.gui.io.importexport.GpxExporter;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.io.importexport.JpgImporter;
import org.openstreetmap.josm.gui.io.importexport.NMEAImporter;
import org.openstreetmap.josm.gui.io.importexport.NoteExporter;
import org.openstreetmap.josm.gui.io.importexport.NoteImporter;
import org.openstreetmap.josm.gui.io.importexport.OsmBzip2Exporter;
import org.openstreetmap.josm.gui.io.importexport.OsmChangeImporter;
import org.openstreetmap.josm.gui.io.importexport.OsmExporter;
import org.openstreetmap.josm.gui.io.importexport.OsmGzipExporter;
import org.openstreetmap.josm.gui.io.importexport.OsmImporter;
import org.openstreetmap.josm.gui.io.importexport.ValidatorErrorExporter;
import org.openstreetmap.josm.gui.io.importexport.WMSLayerExporter;
import org.openstreetmap.josm.gui.io.importexport.WMSLayerImporter;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.session.SessionImporter;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ExtensionFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private static final ArrayList<FileImporter> importers = new ArrayList();
    private static final ArrayList<FileExporter> exporters;
    private final String extensions;
    private final String description;
    private final String defaultExtension;

    protected static void sort(List<ExtensionFileFilter> filters) {
        filters.sort(new Comparator<ExtensionFileFilter>(){
            private AllFormatsImporter all = new AllFormatsImporter();

            @Override
            public int compare(ExtensionFileFilter o1, ExtensionFileFilter o2) {
                if (o1.getDescription().equals(this.all.filter.getDescription())) {
                    return 1;
                }
                if (o2.getDescription().equals(this.all.filter.getDescription())) {
                    return -1;
                }
                return o1.getDescription().compareTo(o2.getDescription());
            }
        });
    }

    public static void addImporter(FileImporter importer) {
        if (importer != null) {
            importers.add(importer);
        }
    }

    public static void addImporterFirst(FileImporter importer) {
        if (importer != null) {
            importers.add(0, importer);
        }
    }

    public static void addExporter(FileExporter exporter) {
        if (exporter != null) {
            exporters.add(exporter);
        }
    }

    public static void addExporterFirst(FileExporter exporter) {
        if (exporter != null) {
            exporters.add(0, exporter);
        }
    }

    public static List<FileImporter> getImporters() {
        return Collections.unmodifiableList(importers);
    }

    public static List<FileExporter> getExporters() {
        return Collections.unmodifiableList(exporters);
    }

    public static void updateAllFormatsImporter() {
        for (int i = 0; i < importers.size(); ++i) {
            if (!(importers.get(i) instanceof AllFormatsImporter)) continue;
            importers.set(i, new AllFormatsImporter());
        }
    }

    public static List<ExtensionFileFilter> getImportExtensionFileFilters() {
        ExtensionFileFilter.updateAllFormatsImporter();
        LinkedList<ExtensionFileFilter> filters = new LinkedList<ExtensionFileFilter>();
        for (FileImporter importer : importers) {
            filters.add(importer.filter);
        }
        ExtensionFileFilter.sort(filters);
        return filters;
    }

    public static List<ExtensionFileFilter> getExportExtensionFileFilters() {
        LinkedList<ExtensionFileFilter> filters = new LinkedList<ExtensionFileFilter>();
        for (FileExporter exporter : exporters) {
            if (filters.contains(exporter.filter) || !exporter.isEnabled()) continue;
            filters.add(exporter.filter);
        }
        ExtensionFileFilter.sort(filters);
        return filters;
    }

    public static ExtensionFileFilter getDefaultImportExtensionFileFilter(String extension) {
        if (extension == null) {
            return new AllFormatsImporter().filter;
        }
        for (FileImporter importer : importers) {
            if (!extension.equals(importer.filter.getDefaultExtension())) continue;
            return importer.filter;
        }
        return new AllFormatsImporter().filter;
    }

    public static ExtensionFileFilter getDefaultExportExtensionFileFilter(String extension) {
        if (extension == null) {
            return new AllFormatsImporter().filter;
        }
        for (FileExporter exporter : exporters) {
            if (!extension.equals(exporter.filter.getDefaultExtension())) continue;
            return exporter.filter;
        }
        File file = new File("file." + extension);
        for (FileExporter exporter : exporters) {
            if (!exporter.filter.accept(file)) continue;
            return exporter.filter;
        }
        return new AllFormatsImporter().filter;
    }

    public static void applyChoosableImportFileFilters(AbstractFileChooser fileChooser, String extension, boolean allTypes) {
        for (ExtensionFileFilter filter : ExtensionFileFilter.getImportExtensionFileFilters()) {
            if (!allTypes && !filter.acceptName("file." + extension)) continue;
            fileChooser.addChoosableFileFilter(filter);
        }
        fileChooser.setFileFilter(ExtensionFileFilter.getDefaultImportExtensionFileFilter(extension));
    }

    public static void applyChoosableExportFileFilters(AbstractFileChooser fileChooser, String extension, boolean allTypes) {
        for (ExtensionFileFilter filter : ExtensionFileFilter.getExportExtensionFileFilters()) {
            if (!allTypes && !filter.acceptName("file." + extension)) continue;
            fileChooser.addChoosableFileFilter(filter);
        }
        fileChooser.setFileFilter(ExtensionFileFilter.getDefaultExportExtensionFileFilter(extension));
    }

    public ExtensionFileFilter(String extension, String defaultExtension, String description) {
        this.extensions = extension;
        this.defaultExtension = defaultExtension;
        this.description = description;
    }

    public static ExtensionFileFilter newFilterWithArchiveExtensions(String extensions, String defaultExtension, String description, AddArchiveExtension addArchiveExtension, List<String> archiveExtensions) {
        LinkedHashSet<String> extensionsPlusArchive = new LinkedHashSet<String>();
        LinkedHashSet<String> extensionsForDescription = new LinkedHashSet<String>();
        for (String e : extensions.split(",")) {
            extensionsPlusArchive.add(e);
            if (addArchiveExtension != AddArchiveExtension.NONE) {
                extensionsForDescription.add("*." + e);
            }
            for (String extension : archiveExtensions) {
                extensionsPlusArchive.add(e + '.' + extension);
                if (addArchiveExtension != AddArchiveExtension.ALL) continue;
                extensionsForDescription.add("*." + e + '.' + extension);
            }
        }
        return new ExtensionFileFilter(Utils.join(",", extensionsPlusArchive), defaultExtension, description + (!extensionsForDescription.isEmpty() ? " (" + Utils.join(", ", extensionsForDescription) + ')' : ""));
    }

    public static ExtensionFileFilter newFilterWithArchiveExtensions(String extensions, String defaultExtension, String description, boolean addArchiveExtensionsToDescription) {
        List<String> archiveExtensions = Arrays.asList("gz", "bz2");
        return ExtensionFileFilter.newFilterWithArchiveExtensions(extensions, defaultExtension, description, addArchiveExtensionsToDescription ? AddArchiveExtension.ALL : AddArchiveExtension.BASE, archiveExtensions);
    }

    public boolean acceptName(String filename) {
        return Utils.hasExtension(filename, this.extensions.split(","));
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname.isDirectory()) {
            return true;
        }
        return this.acceptName(pathname.getName());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public int hashCode() {
        return Objects.hash(this.extensions, this.description, this.defaultExtension);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionFileFilter that = (ExtensionFileFilter)obj;
        return Objects.equals(this.extensions, that.extensions) && Objects.equals(this.description, that.description) && Objects.equals(this.defaultExtension, that.defaultExtension);
    }

    static {
        List<Class> importerNames = Arrays.asList(OsmImporter.class, OsmChangeImporter.class, GpxImporter.class, NMEAImporter.class, NoteImporter.class, JpgImporter.class, WMSLayerImporter.class, AllFormatsImporter.class, SessionImporter.class);
        for (Class importerClass : importerNames) {
            try {
                FileImporter importer = (FileImporter)importerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                importers.add(importer);
            }
            catch (ReflectiveOperationException e) {
                Logging.debug(e);
            }
            catch (ServiceConfigurationError e) {
                Logging.error(e);
            }
        }
        exporters = new ArrayList();
        List<Class> exporterClasses = Arrays.asList(GpxExporter.class, OsmExporter.class, OsmGzipExporter.class, OsmBzip2Exporter.class, GeoJSONExporter.class, WMSLayerExporter.class, NoteExporter.class, ValidatorErrorExporter.class);
        for (Class exporterClass : exporterClasses) {
            try {
                FileExporter exporter = (FileExporter)exporterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                exporters.add(exporter);
                MainApplication.getLayerManager().addAndFireActiveLayerChangeListener(exporter);
            }
            catch (ReflectiveOperationException e) {
                Logging.debug(e);
            }
            catch (ServiceConfigurationError e) {
                Logging.error(e);
            }
        }
    }

    public static enum AddArchiveExtension {
        NONE,
        BASE,
        ALL;

    }
}

