/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Function;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.AlphanumComparator;

public final class OsmPrimitiveComparator {
    public static Comparator<OsmPrimitive> comparingNames() {
        Comparator<String> digitsLast = Comparator.comparing(str -> Character.isDigit(str.charAt(0)) ? 1 : 0);
        return Comparator.comparing(OsmPrimitiveComparator.memoize(DefaultNameFormatter.getInstance()::format), digitsLast.thenComparing(AlphanumComparator.getInstance()));
    }

    public static Comparator<OsmPrimitive> comparingUniqueId() {
        return Comparator.comparing(AbstractPrimitive::getUniqueId);
    }

    public static Comparator<OsmPrimitive> orderingNodesWaysRelations() {
        return Comparator.comparingInt(osm -> osm.getType().ordinal());
    }

    public static Comparator<OsmPrimitive> orderingWaysRelationsNodes() {
        return Comparator.comparingInt(osm -> {
            switch (osm.getType()) {
                case WAY: {
                    return 1;
                }
                case RELATION: {
                    return 2;
                }
                case NODE: {
                    return 3;
                }
            }
            throw new IllegalStateException();
        });
    }

    public static Comparator<OsmPrimitive> orderingRelationsWaysNodes() {
        return Comparator.comparingInt(osm -> {
            switch (osm.getType()) {
                case RELATION: {
                    return 1;
                }
                case WAY: {
                    return 2;
                }
                case NODE: {
                    return 3;
                }
            }
            throw new IllegalStateException();
        });
    }

    private static <T, R> Function<T, R> memoize(Function<T, R> base) {
        HashMap cache = new HashMap();
        return t -> cache.computeIfAbsent(t, base);
    }

    private OsmPrimitiveComparator() {
    }
}

