/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.UploadNoteLayerTask;
import org.openstreetmap.josm.gui.io.importexport.NoteExporter;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.date.DateUtils;

public class NoteLayer
extends AbstractModifiableLayer
implements MouseListener,
NoteData.NoteDataUpdateListener {
    private final NoteData noteData;

    public NoteLayer(Collection<Note> notes, String name) {
        super(name);
        this.noteData = new NoteData(notes);
        this.noteData.addNoteDataUpdateListener(this);
    }

    public NoteLayer() {
        this(Collections.emptySet(), I18n.tr("Notes", new Object[0]));
    }

    @Override
    public void hookUpMapView() {
        MainApplication.getMap().mapView.addMouseListener(this);
    }

    @Override
    public synchronized void destroy() {
        MainApplication.getMap().mapView.removeMouseListener(this);
        this.noteData.removeNoteDataUpdateListener(this);
        super.destroy();
    }

    public NoteData getNoteData() {
        return this.noteData;
    }

    @Override
    public boolean isModified() {
        return this.noteData.isModified();
    }

    @Override
    public boolean isUploadable() {
        return true;
    }

    @Override
    public boolean requiresUploadToServer() {
        return this.isModified();
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public boolean requiresSaveToFile() {
        return this.getAssociatedFile() != null && this.isModified();
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        Point p;
        int iconHeight = ImageProvider.ImageSizes.SMALLICON.getAdjustedHeight();
        int iconWidth = ImageProvider.ImageSizes.SMALLICON.getAdjustedWidth();
        for (Note note : this.noteData.getNotes()) {
            p = mv.getPoint(note.getLatLon());
            ImageIcon icon = note.getId() < 0L ? ImageProvider.get("dialogs/notes", "note_new", ImageProvider.ImageSizes.SMALLICON) : (note.getState() == Note.State.CLOSED ? ImageProvider.get("dialogs/notes", "note_closed", ImageProvider.ImageSizes.SMALLICON) : ImageProvider.get("dialogs/notes", "note_open", ImageProvider.ImageSizes.SMALLICON));
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            g.drawImage(icon.getImage(), p.x - width / 2, p.y - height, MainApplication.getMap().mapView);
        }
        if (this.noteData.getSelectedNote() != null) {
            StringBuilder sb = new StringBuilder("<html>");
            sb.append(I18n.tr("Note", new Object[0])).append(' ').append(this.noteData.getSelectedNote().getId());
            for (NoteComment comment : this.noteData.getSelectedNote().getComments()) {
                String commentText = comment.getText();
                if (commentText == null || commentText.trim().isEmpty()) continue;
                sb.append("<hr/>");
                String userName = XmlWriter.encode(comment.getUser().getName());
                if (userName == null || userName.trim().isEmpty()) {
                    userName = "&lt;Anonymous&gt;";
                }
                sb.append(userName);
                sb.append(" on ");
                sb.append(DateUtils.getDateFormat(2).format(comment.getCommentTimestamp()));
                sb.append(":<br/>");
                String htmlText = XmlWriter.encode(comment.getText(), true);
                htmlText = htmlText.replace("&#xA;", "<br/>");
                htmlText = htmlText.replace("/", "/\u200b");
                sb.append(htmlText);
            }
            sb.append("</html>");
            JToolTip jToolTip = new JToolTip();
            jToolTip.setTipText(sb.toString());
            p = mv.getPoint(this.noteData.getSelectedNote().getLatLon());
            g.setColor(ColorHelper.html2color(Config.getPref().get("color.selected")));
            g.drawRect(p.x - iconWidth / 2, p.y - iconHeight, iconWidth - 1, iconHeight - 1);
            int tx = p.x + iconWidth / 2 + 5;
            int ty = p.y - iconHeight - 1;
            g.translate(tx, ty);
            for (int x = 0; x < 2; ++x) {
                Dimension d = jToolTip.getUI().getPreferredSize(jToolTip);
                d.width = Math.min(d.width, mv.getWidth() / 2);
                if (d.width <= 0 || d.height <= 0) continue;
                jToolTip.setSize(d);
                try {
                    jToolTip.paint(g);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    Logging.log(Logging.LEVEL_ERROR, e);
                }
            }
            g.translate(-tx, -ty);
        }
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("dialogs/notes", "note_open", ImageProvider.ImageSizes.SMALLICON);
    }

    @Override
    public String getToolTipText() {
        return I18n.trn("{0} note", "{0} notes", this.noteData.getNotes().size(), this.noteData.getNotes().size());
    }

    @Override
    public void mergeFrom(Layer from) {
        throw new UnsupportedOperationException("Notes layer does not support merging yet");
    }

    @Override
    public boolean isMergable(Layer other) {
        return false;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        for (Note note : this.noteData.getNotes()) {
            v.visit(note.getLatLon());
        }
    }

    @Override
    public Object getInfoComponent() {
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.tr("Notes layer", new Object[0])).append('\n').append(I18n.tr("Total notes:", new Object[0])).append(' ').append(this.noteData.getNotes().size()).append('\n').append(I18n.tr("Changes need uploading?", new Object[0])).append(' ').append(this.isModified());
        return sb.toString();
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        actions.add(LayerListDialog.getInstance().createShowHideLayerAction());
        actions.add(LayerListDialog.getInstance().createDeleteLayerAction());
        actions.add(new LayerListPopup.InfoAction(this));
        actions.add(new Layer.LayerSaveAction(this));
        actions.add(new Layer.LayerSaveAsAction(this));
        return actions.toArray(new Action[actions.size()]);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) && this.noteData.getSelectedNote() != null) {
            String url = OsmApi.getOsmApi().getBaseUrl() + "notes/" + this.noteData.getSelectedNote().getId();
            ClipboardUtils.copyString(url);
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        Point clickPoint = e.getPoint();
        double snapDistance = 10.0;
        double minDistance = Double.MAX_VALUE;
        int iconHeight = ImageProvider.ImageSizes.SMALLICON.getAdjustedHeight();
        Note closestNote = null;
        for (Note note : this.noteData.getNotes()) {
            Point notePoint = MainApplication.getMap().mapView.getPoint(note.getLatLon());
            notePoint.setLocation(notePoint.getX(), notePoint.getY() - (double)(iconHeight / 2));
            double dist = clickPoint.distanceSq(notePoint);
            if (!(minDistance > dist) || !(clickPoint.distance(notePoint) < snapDistance)) continue;
            minDistance = dist;
            closestNote = note;
        }
        this.noteData.setSelectedNote(closestNote);
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save Note file", new Object[0]), NoteExporter.FILE_FILTER);
    }

    @Override
    public AbstractIOTask createUploadTask(ProgressMonitor monitor) {
        return new UploadNoteLayerTask(this, monitor);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void noteDataUpdated(NoteData data) {
        this.invalidate();
    }

    @Override
    public void selectedNoteChanged(NoteData noteData) {
        this.invalidate();
    }
}

