/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JComponent;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class ImageDisplay
extends JComponent {
    private File file;
    private transient Image image;
    private boolean errorLoading;
    private Rectangle visibleRect;
    private Rectangle selectedRect;
    private final MediaTracker tracker = new MediaTracker(this);
    private String osdText;
    private static final int DRAG_BUTTON = Config.getPref().getBoolean("geoimage.agpifo-style-drag-and-zoom", false) ? 1 : 3;
    private static final int ZOOM_BUTTON = DRAG_BUTTON == 1 ? 3 : 1;

    public ImageDisplay() {
        ImgDisplayMouseListener mouseListener = new ImgDisplayMouseListener();
        this.addMouseListener(mouseListener);
        this.addMouseWheelListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(File file, Integer orientation) {
        ImageDisplay imageDisplay = this;
        synchronized (imageDisplay) {
            this.file = file;
            this.image = null;
            this.selectedRect = null;
            this.errorLoading = false;
        }
        this.repaint();
        if (file != null) {
            new Thread((Runnable)new LoadImageRunnable(file, orientation), LoadImageRunnable.class.getName()).start();
        }
    }

    public void setOsdText(String text) {
        this.osdText = text;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        boolean errorLoading;
        Rectangle visibleRect;
        File file;
        Image image;
        ImageDisplay imageDisplay = this;
        synchronized (imageDisplay) {
            image = this.image;
            file = this.file;
            visibleRect = this.visibleRect;
            errorLoading = this.errorLoading;
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Dimension size = this.getSize();
        if (file == null) {
            g.setColor(Color.black);
            String noImageStr = I18n.tr("No image", new Object[0]);
            Rectangle2D noImageSize = g.getFontMetrics(g.getFont()).getStringBounds(noImageStr, g);
            g.drawString(noImageStr, (int)(((double)size.width - noImageSize.getWidth()) / 2.0), (int)(((double)size.height - noImageSize.getHeight()) / 2.0));
        } else if (image == null) {
            g.setColor(Color.black);
            String loadingStr = !errorLoading ? I18n.tr("Loading {0}", file.getName()) : I18n.tr("Error on file {0}", file.getName());
            Rectangle2D noImageSize = g.getFontMetrics(g.getFont()).getStringBounds(loadingStr, g);
            g.drawString(loadingStr, (int)(((double)size.width - noImageSize.getWidth()) / 2.0), (int)(((double)size.height - noImageSize.getHeight()) / 2.0));
        } else {
            Rectangle target = ImageDisplay.calculateDrawImageRectangle(visibleRect, size);
            if (this.selectedRect == null && (target.width < visibleRect.width / 2 || target.height < visibleRect.height / 2)) {
                BufferedImage buffImage = ImageProvider.toBufferedImage(image);
                g.drawImage(ImageProvider.createScaledImage(buffImage, target.width, target.height, RenderingHints.VALUE_INTERPOLATION_BILINEAR), target.x, target.y, target.x + target.width, target.y + target.height, visibleRect.x, visibleRect.y, visibleRect.x + target.width, visibleRect.y + target.height, null);
            } else {
                g.drawImage(image, target.x, target.y, target.x + target.width, target.y + target.height, visibleRect.x, visibleRect.y, visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height, null);
            }
            if (this.selectedRect != null) {
                Point topLeft = ImageDisplay.img2compCoord(visibleRect, this.selectedRect.x, this.selectedRect.y, size);
                Point bottomRight = ImageDisplay.img2compCoord(visibleRect, this.selectedRect.x + this.selectedRect.width, this.selectedRect.y + this.selectedRect.height, size);
                g.setColor(new Color(128, 128, 128, 180));
                g.fillRect(target.x, target.y, target.width, topLeft.y - target.y);
                g.fillRect(target.x, target.y, topLeft.x - target.x, target.height);
                g.fillRect(bottomRight.x, target.y, target.x + target.width - bottomRight.x, target.height);
                g.fillRect(target.x, bottomRight.y, target.width, target.y + target.height - bottomRight.y);
                g.setColor(Color.black);
                g.drawRect(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
            }
            if (errorLoading) {
                String loadingStr = I18n.tr("Error on file {0}", file.getName());
                Rectangle2D noImageSize = g.getFontMetrics(g.getFont()).getStringBounds(loadingStr, g);
                g.drawString(loadingStr, (int)(((double)size.width - noImageSize.getWidth()) / 2.0), (int)(((double)size.height - noImageSize.getHeight()) / 2.0));
            }
            if (this.osdText != null) {
                Rectangle2D lineSize;
                String line;
                FontMetrics metrics = g.getFontMetrics(g.getFont());
                int ascent = metrics.getAscent();
                Color bkground = new Color(255, 255, 255, 128);
                int lastPos = 0;
                int pos = this.osdText.indexOf(10);
                int x = 3;
                int y = 3;
                while (pos > 0) {
                    line = this.osdText.substring(lastPos, pos);
                    lineSize = metrics.getStringBounds(line, g);
                    g.setColor(bkground);
                    g.fillRect(x, y, (int)lineSize.getWidth(), (int)lineSize.getHeight());
                    g.setColor(Color.black);
                    g.drawString(line, x, y + ascent);
                    y += (int)lineSize.getHeight();
                    lastPos = pos + 1;
                    pos = this.osdText.indexOf(10, lastPos);
                }
                line = this.osdText.substring(lastPos);
                lineSize = g.getFontMetrics(g.getFont()).getStringBounds(line, g);
                g.setColor(bkground);
                g.fillRect(x, y, (int)lineSize.getWidth(), (int)lineSize.getHeight());
                g.setColor(Color.black);
                g.drawString(line, x, y + ascent);
            }
        }
    }

    static Point img2compCoord(Rectangle visibleRect, int xImg, int yImg, Dimension compSize) {
        Rectangle drawRect = ImageDisplay.calculateDrawImageRectangle(visibleRect, compSize);
        return new Point(drawRect.x + (xImg - visibleRect.x) * drawRect.width / visibleRect.width, drawRect.y + (yImg - visibleRect.y) * drawRect.height / visibleRect.height);
    }

    static Point comp2imgCoord(Rectangle visibleRect, int xComp, int yComp, Dimension compSize) {
        Rectangle drawRect = ImageDisplay.calculateDrawImageRectangle(visibleRect, compSize);
        return new Point(visibleRect.x + (xComp - drawRect.x) * visibleRect.width / drawRect.width, visibleRect.y + (yComp - drawRect.y) * visibleRect.height / drawRect.height);
    }

    static Point getCenterImgCoord(Rectangle visibleRect) {
        return new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
    }

    static Rectangle calculateDrawImageRectangle(Rectangle visibleRect, Dimension compSize) {
        return ImageDisplay.calculateDrawImageRectangle(visibleRect, new Rectangle(0, 0, compSize.width, compSize.height));
    }

    static Rectangle calculateDrawImageRectangle(Rectangle imgRect, Rectangle compRect) {
        int x = 0;
        int y = 0;
        int w = compRect.width;
        int wFact = w * imgRect.height;
        int h = compRect.height;
        int hFact = h * imgRect.width;
        if (wFact != hFact) {
            if (wFact > hFact) {
                w = hFact / imgRect.height;
                x = (compRect.width - w) / 2;
            } else {
                h = wFact / imgRect.width;
                y = (compRect.height - h) / 2;
            }
        }
        return new Rectangle(x + compRect.x, y + compRect.y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoomBestFitOrOne() {
        Rectangle visibleRect;
        Image image;
        File file;
        ImageDisplay imageDisplay = this;
        synchronized (imageDisplay) {
            file = this.file;
            image = this.image;
            visibleRect = this.visibleRect;
        }
        if (image == null) {
            return;
        }
        if (visibleRect.width != image.getWidth(null) || visibleRect.height != image.getHeight(null)) {
            visibleRect = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
        } else {
            Point center = ImageDisplay.getCenterImgCoord(visibleRect);
            visibleRect = new Rectangle(center.x - this.getWidth() / 2, center.y - this.getHeight() / 2, this.getWidth(), this.getHeight());
            ImageDisplay.checkVisibleRectPos(image, visibleRect);
        }
        imageDisplay = this;
        synchronized (imageDisplay) {
            if (file == this.file) {
                this.visibleRect = visibleRect;
            }
        }
        this.repaint();
    }

    static void checkVisibleRectPos(Image image, Rectangle visibleRect) {
        if (visibleRect.x < 0) {
            visibleRect.x = 0;
        }
        if (visibleRect.y < 0) {
            visibleRect.y = 0;
        }
        if (visibleRect.x + visibleRect.width > image.getWidth(null)) {
            visibleRect.x = image.getWidth(null) - visibleRect.width;
        }
        if (visibleRect.y + visibleRect.height > image.getHeight(null)) {
            visibleRect.y = image.getHeight(null) - visibleRect.height;
        }
    }

    static void checkVisibleRectSize(Image image, Rectangle visibleRect) {
        if (visibleRect.width > image.getWidth(null)) {
            visibleRect.width = image.getWidth(null);
        }
        if (visibleRect.height > image.getHeight(null)) {
            visibleRect.height = image.getHeight(null);
        }
    }

    private class ImgDisplayMouseListener
    implements MouseListener,
    MouseWheelListener,
    MouseMotionListener {
        private boolean mouseIsDragging;
        private long lastTimeForMousePoint;
        private Point mousePointInImg;

        private ImgDisplayMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int wFact;
            int hFact;
            Rectangle visibleRect;
            Image image;
            File file;
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                file = ImageDisplay.this.file;
                image = ImageDisplay.this.image;
                visibleRect = ImageDisplay.this.visibleRect;
            }
            this.mouseIsDragging = false;
            ImageDisplay.this.selectedRect = null;
            if (image == null) {
                return;
            }
            if (e.getWhen() - this.lastTimeForMousePoint > 1500L || this.mousePointInImg == null) {
                this.lastTimeForMousePoint = e.getWhen();
                this.mousePointInImg = ImageDisplay.comp2imgCoord(visibleRect, e.getX(), e.getY(), ImageDisplay.this.getSize());
            }
            if (e.getWheelRotation() > 0) {
                visibleRect.width = visibleRect.width * 3 / 2;
                visibleRect.height = visibleRect.height * 3 / 2;
            } else {
                visibleRect.width = visibleRect.width * 2 / 3;
                visibleRect.height = visibleRect.height * 2 / 3;
            }
            if (visibleRect.width < ImageDisplay.this.getSize().width / 2) {
                visibleRect.width = ImageDisplay.this.getSize().width / 2;
            }
            if (visibleRect.height < ImageDisplay.this.getSize().height / 2) {
                visibleRect.height = ImageDisplay.this.getSize().height / 2;
            }
            if ((hFact = visibleRect.height * ImageDisplay.this.getSize().width) > (wFact = visibleRect.width * ImageDisplay.this.getSize().height)) {
                visibleRect.width = hFact / ImageDisplay.this.getSize().height;
            } else {
                visibleRect.height = wFact / ImageDisplay.this.getSize().width;
            }
            ImageDisplay.checkVisibleRectSize(image, visibleRect);
            Rectangle drawRect = ImageDisplay.calculateDrawImageRectangle(visibleRect, ImageDisplay.this.getSize());
            visibleRect.x = this.mousePointInImg.x + (drawRect.x - e.getX()) * visibleRect.width / drawRect.width;
            visibleRect.y = this.mousePointInImg.y + (drawRect.y - e.getY()) * visibleRect.height / drawRect.height;
            ImageDisplay.checkVisibleRectPos(image, visibleRect);
            ImageDisplay imageDisplay2 = ImageDisplay.this;
            synchronized (imageDisplay2) {
                if (ImageDisplay.this.file == file) {
                    ImageDisplay.this.visibleRect = visibleRect;
                }
            }
            ImageDisplay.this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            Rectangle visibleRect;
            Image image;
            File file;
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                file = ImageDisplay.this.file;
                image = ImageDisplay.this.image;
                visibleRect = ImageDisplay.this.visibleRect;
            }
            if (image == null) {
                return;
            }
            if (e.getButton() != DRAG_BUTTON) {
                return;
            }
            Point click = ImageDisplay.comp2imgCoord(visibleRect, e.getX(), e.getY(), ImageDisplay.this.getSize());
            Point center = ImageDisplay.getCenterImgCoord(visibleRect);
            visibleRect.x += click.x - center.x;
            visibleRect.y += click.y - center.y;
            ImageDisplay.checkVisibleRectPos(image, visibleRect);
            ImageDisplay imageDisplay2 = ImageDisplay.this;
            synchronized (imageDisplay2) {
                if (ImageDisplay.this.file == file) {
                    ImageDisplay.this.visibleRect = visibleRect;
                }
            }
            ImageDisplay.this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent e) {
            Rectangle visibleRect;
            Image image;
            if (ImageDisplay.this.image == null) {
                this.mouseIsDragging = false;
                ImageDisplay.this.selectedRect = null;
                return;
            }
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                image = ImageDisplay.this.image;
                visibleRect = ImageDisplay.this.visibleRect;
            }
            if (image == null) {
                return;
            }
            if (e.getButton() == DRAG_BUTTON) {
                this.mousePointInImg = ImageDisplay.comp2imgCoord(visibleRect, e.getX(), e.getY(), ImageDisplay.this.getSize());
                this.mouseIsDragging = true;
                ImageDisplay.this.selectedRect = null;
            } else if (e.getButton() == ZOOM_BUTTON) {
                this.mousePointInImg = ImageDisplay.comp2imgCoord(visibleRect, e.getX(), e.getY(), ImageDisplay.this.getSize());
                this.checkPointInVisibleRect(this.mousePointInImg, visibleRect);
                this.mouseIsDragging = false;
                ImageDisplay.this.selectedRect = new Rectangle(this.mousePointInImg.x, this.mousePointInImg.y, 0, 0);
                ImageDisplay.this.repaint();
            } else {
                this.mouseIsDragging = false;
                ImageDisplay.this.selectedRect = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent e) {
            Point p;
            Rectangle visibleRect;
            Image image;
            File file;
            if (!this.mouseIsDragging && ImageDisplay.this.selectedRect == null) {
                return;
            }
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                file = ImageDisplay.this.file;
                image = ImageDisplay.this.image;
                visibleRect = ImageDisplay.this.visibleRect;
            }
            if (image == null) {
                this.mouseIsDragging = false;
                ImageDisplay.this.selectedRect = null;
                return;
            }
            if (this.mouseIsDragging) {
                p = ImageDisplay.comp2imgCoord(visibleRect, e.getX(), e.getY(), ImageDisplay.this.getSize());
                visibleRect.x += this.mousePointInImg.x - p.x;
                visibleRect.y += this.mousePointInImg.y - p.y;
                ImageDisplay.checkVisibleRectPos(image, visibleRect);
                ImageDisplay imageDisplay2 = ImageDisplay.this;
                synchronized (imageDisplay2) {
                    if (ImageDisplay.this.file == file) {
                        ImageDisplay.this.visibleRect = visibleRect;
                    }
                }
                ImageDisplay.this.repaint();
            } else if (ImageDisplay.this.selectedRect != null) {
                p = ImageDisplay.comp2imgCoord(visibleRect, e.getX(), e.getY(), ImageDisplay.this.getSize());
                this.checkPointInVisibleRect(p, visibleRect);
                Rectangle rect = new Rectangle(p.x < this.mousePointInImg.x ? p.x : this.mousePointInImg.x, p.y < this.mousePointInImg.y ? p.y : this.mousePointInImg.y, p.x < this.mousePointInImg.x ? this.mousePointInImg.x - p.x : p.x - this.mousePointInImg.x, p.y < this.mousePointInImg.y ? this.mousePointInImg.y - p.y : p.y - this.mousePointInImg.y);
                ImageDisplay.checkVisibleRectSize(image, rect);
                ImageDisplay.checkVisibleRectPos(image, rect);
                ImageDisplay.this.selectedRect = rect;
                ImageDisplay.this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e) {
            Image image;
            File file;
            if (!this.mouseIsDragging && ImageDisplay.this.selectedRect == null) {
                return;
            }
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                file = ImageDisplay.this.file;
                image = ImageDisplay.this.image;
            }
            if (image == null) {
                this.mouseIsDragging = false;
                ImageDisplay.this.selectedRect = null;
                return;
            }
            if (this.mouseIsDragging) {
                this.mouseIsDragging = false;
            } else if (ImageDisplay.this.selectedRect != null) {
                int wFact;
                int hFact;
                int oldWidth = ((ImageDisplay)ImageDisplay.this).selectedRect.width;
                int oldHeight = ((ImageDisplay)ImageDisplay.this).selectedRect.height;
                if (((ImageDisplay)ImageDisplay.this).selectedRect.width < ImageDisplay.this.getSize().width / 2) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.width = ImageDisplay.this.getSize().width / 2;
                }
                if (((ImageDisplay)ImageDisplay.this).selectedRect.height < ImageDisplay.this.getSize().height / 2) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.height = ImageDisplay.this.getSize().height / 2;
                }
                if ((hFact = ((ImageDisplay)ImageDisplay.this).selectedRect.height * ImageDisplay.this.getSize().width) > (wFact = ((ImageDisplay)ImageDisplay.this).selectedRect.width * ImageDisplay.this.getSize().height)) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.width = hFact / ImageDisplay.this.getSize().height;
                } else {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.height = wFact / ImageDisplay.this.getSize().width;
                }
                if (((ImageDisplay)ImageDisplay.this).selectedRect.width != oldWidth) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.x -= (((ImageDisplay)ImageDisplay.this).selectedRect.width - oldWidth) / 2;
                }
                if (((ImageDisplay)ImageDisplay.this).selectedRect.height != oldHeight) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.y -= (((ImageDisplay)ImageDisplay.this).selectedRect.height - oldHeight) / 2;
                }
                ImageDisplay.checkVisibleRectSize(image, ImageDisplay.this.selectedRect);
                ImageDisplay.checkVisibleRectPos(image, ImageDisplay.this.selectedRect);
                ImageDisplay imageDisplay2 = ImageDisplay.this;
                synchronized (imageDisplay2) {
                    if (file == ImageDisplay.this.file) {
                        ImageDisplay.this.visibleRect = ImageDisplay.this.selectedRect;
                    }
                }
                ImageDisplay.this.selectedRect = null;
                ImageDisplay.this.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private void checkPointInVisibleRect(Point p, Rectangle visibleRect) {
            if (p.x < visibleRect.x) {
                p.x = visibleRect.x;
            }
            if (p.x > visibleRect.x + visibleRect.width) {
                p.x = visibleRect.x + visibleRect.width;
            }
            if (p.y < visibleRect.y) {
                p.y = visibleRect.y;
            }
            if (p.y > visibleRect.y + visibleRect.height) {
                p.y = visibleRect.y + visibleRect.height;
            }
        }
    }

    private class LoadImageRunnable
    implements Runnable {
        private final File file;
        private final int orientation;

        LoadImageRunnable(File file, Integer orientation) {
            this.file = file;
            this.orientation = orientation == null ? -1 : orientation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Image img = Toolkit.getDefaultToolkit().createImage(this.file.getPath());
            ImageDisplay.this.tracker.addImage(img, 1);
            while (!ImageDisplay.this.tracker.checkID(1, true)) {
                if (this.file != ImageDisplay.this.file) {
                    ImageDisplay.this.tracker.removeImage(img);
                    return;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    Logging.warn("InterruptedException in " + this.getClass().getSimpleName() + " while loading image " + this.file.getPath());
                    Thread.currentThread().interrupt();
                }
            }
            boolean error = ImageDisplay.this.tracker.isErrorID(1);
            if (img.getWidth(null) < 0 || img.getHeight(null) < 0) {
                error = true;
            }
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                if (this.file != ImageDisplay.this.file) {
                    ImageDisplay.this.tracker.removeImage(img);
                    return;
                }
                if (!error) {
                    ImageDisplay.this.image = img;
                    ImageDisplay.this.visibleRect = new Rectangle(0, 0, img.getWidth(null), img.getHeight(null));
                    int w = (int)ImageDisplay.this.visibleRect.getWidth();
                    int h = (int)ImageDisplay.this.visibleRect.getHeight();
                    if (ExifReader.orientationNeedsCorrection(this.orientation)) {
                        int hh;
                        int ww;
                        if (ExifReader.orientationSwitchesDimensions(this.orientation)) {
                            ww = h;
                            hh = w;
                        } else {
                            ww = w;
                            hh = h;
                        }
                        BufferedImage rot = new BufferedImage(ww, hh, 1);
                        AffineTransform xform = ExifReader.getRestoreOrientationTransform(this.orientation, w, h);
                        Graphics2D g = rot.createGraphics();
                        g.drawImage(ImageDisplay.this.image, xform, null);
                        g.dispose();
                        ImageDisplay.this.visibleRect.setSize(ww, hh);
                        ImageDisplay.this.image.flush();
                        ImageDisplay.this.image = rot;
                    }
                }
                ImageDisplay.this.selectedRect = null;
                ImageDisplay.this.errorLoading = error;
            }
            ImageDisplay.this.tracker.removeImage(img);
            ImageDisplay.this.repaint();
        }
    }
}

