/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.CompoundException;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDirectory;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.geoimage.ThumbsLoader;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;

public final class ImageEntry
implements Comparable<ImageEntry>,
Cloneable {
    private File file;
    private Integer exifOrientation;
    private LatLon exifCoor;
    private Double exifImgDir;
    private Date exifTime;
    private boolean isNewGpsData;
    private Date exifGpsTime;
    private Image thumbnail;
    private CachedLatLon pos;
    private Double speed;
    private Double elevation;
    private Date gpsTime;
    ImageEntry tmp;

    public ImageEntry() {
    }

    public ImageEntry(File file) {
        this.setFile(file);
    }

    public CachedLatLon getPos() {
        if (this.tmp != null) {
            return this.tmp.pos;
        }
        return this.pos;
    }

    public Double getSpeed() {
        if (this.tmp != null) {
            return this.tmp.speed;
        }
        return this.speed;
    }

    public Double getElevation() {
        if (this.tmp != null) {
            return this.tmp.elevation;
        }
        return this.elevation;
    }

    public Date getGpsTime() {
        if (this.tmp != null) {
            return ImageEntry.getDefensiveDate(this.tmp.gpsTime);
        }
        return ImageEntry.getDefensiveDate(this.gpsTime);
    }

    public boolean hasGpsTime() {
        return this.tmp != null && this.tmp.gpsTime != null || this.gpsTime != null;
    }

    public File getFile() {
        return this.file;
    }

    public Integer getExifOrientation() {
        return this.exifOrientation;
    }

    public Date getExifTime() {
        return ImageEntry.getDefensiveDate(this.exifTime);
    }

    public boolean hasExifTime() {
        return this.exifTime != null;
    }

    public Date getExifGpsTime() {
        return ImageEntry.getDefensiveDate(this.exifGpsTime);
    }

    public boolean hasExifGpsTime() {
        return this.exifGpsTime != null;
    }

    private static Date getDefensiveDate(Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public LatLon getExifCoor() {
        return this.exifCoor;
    }

    public Double getExifImgDir() {
        if (this.tmp != null) {
            return this.tmp.exifImgDir;
        }
        return this.exifImgDir;
    }

    public boolean hasThumbnail() {
        return this.thumbnail != null;
    }

    public Image getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(Image thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void loadThumbnail() {
        if (this.thumbnail == null) {
            new ThumbsLoader(Collections.singleton(this)).run();
        }
    }

    public void setPos(CachedLatLon pos) {
        this.pos = pos;
    }

    public void setPos(LatLon pos) {
        this.setPos(pos != null ? new CachedLatLon(pos) : null);
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public void setElevation(Double elevation) {
        this.elevation = elevation;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setExifOrientation(Integer exifOrientation) {
        this.exifOrientation = exifOrientation;
    }

    public void setExifTime(Date exifTime) {
        this.exifTime = ImageEntry.getDefensiveDate(exifTime);
    }

    public void setExifGpsTime(Date exifGpsTime) {
        this.exifGpsTime = ImageEntry.getDefensiveDate(exifGpsTime);
    }

    public void setGpsTime(Date gpsTime) {
        this.gpsTime = ImageEntry.getDefensiveDate(gpsTime);
    }

    public void setExifCoor(LatLon exifCoor) {
        this.exifCoor = exifCoor;
    }

    public void setExifImgDir(Double exifDir) {
        this.exifImgDir = exifDir;
    }

    public ImageEntry clone() {
        try {
            return (ImageEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int compareTo(ImageEntry image) {
        if (this.exifTime != null && image.exifTime != null) {
            return this.exifTime.compareTo(image.exifTime);
        }
        if (this.exifTime == null && image.exifTime == null) {
            return 0;
        }
        if (this.exifTime == null) {
            return -1;
        }
        return 1;
    }

    public void createTmp() {
        this.tmp = this.clone();
        this.tmp.tmp = null;
    }

    public ImageEntry getTmp() {
        if (this.tmp == null) {
            this.createTmp();
        }
        return this.tmp;
    }

    public void applyTmp() {
        if (this.tmp != null) {
            this.pos = this.tmp.pos;
            this.speed = this.tmp.speed;
            this.elevation = this.tmp.elevation;
            this.gpsTime = this.tmp.gpsTime;
            this.exifImgDir = this.tmp.exifImgDir;
            this.tmp = null;
        }
    }

    public void discardTmp() {
        this.tmp = null;
    }

    public boolean isTagged() {
        return this.pos != null;
    }

    public String toString() {
        return this.file.getName() + ": pos = " + this.pos + " | exifCoor = " + this.exifCoor + " | " + (this.tmp == null ? " tmp==null" : " [tmp] pos = " + this.tmp.pos);
    }

    public void flagNewGpsData() {
        this.isNewGpsData = true;
    }

    public void unflagNewGpsData() {
        this.isNewGpsData = false;
    }

    public boolean hasNewGpsData() {
        return this.isNewGpsData;
    }

    public void extractExif() {
        Double ele;
        Metadata metadata;
        if (this.file == null) {
            return;
        }
        try {
            metadata = JpegMetadataReader.readMetadata(this.file);
        }
        catch (CompoundException | IOException ex) {
            Logging.error(ex);
            this.setExifTime(null);
            this.setExifCoor(null);
            this.setPos(null);
            return;
        }
        try {
            this.setExifTime(ExifReader.readTime(metadata));
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException ex) {
            Logging.warn(ex);
            this.setExifTime(null);
        }
        ExifIFD0Directory dirExif = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
        GpsDirectory dirGps = metadata.getFirstDirectoryOfType(GpsDirectory.class);
        try {
            if (dirExif != null) {
                int orientation = dirExif.getInt(274);
                this.setExifOrientation(orientation);
            }
        }
        catch (MetadataException ex) {
            Logging.debug(ex);
        }
        if (dirGps == null) {
            this.setExifCoor(null);
            this.setPos(null);
            return;
        }
        Double speed = ExifReader.readSpeed(dirGps);
        if (speed != null) {
            this.setSpeed(speed);
        }
        if ((ele = ExifReader.readElevation(dirGps)) != null) {
            this.setElevation(ele);
        }
        try {
            LatLon latlon = ExifReader.readLatLon(dirGps);
            this.setExifCoor(latlon);
            this.setPos(this.getExifCoor());
        }
        catch (MetadataException | IndexOutOfBoundsException ex) {
            Logging.error("Error reading EXIF from file: " + ex);
            this.setExifCoor(null);
            this.setPos(null);
        }
        try {
            Double direction = ExifReader.readDirection(dirGps);
            if (direction != null) {
                this.setExifImgDir(direction);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            Logging.debug(ex);
        }
        Date gpsDate = dirGps.getGpsDate();
        if (gpsDate != null) {
            this.setExifGpsTime(gpsDate);
        }
    }
}

