/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.preferences.projection.AbstractProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.SubPrefsOptions;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class CodeProjectionChoice
extends AbstractProjectionChoice
implements SubPrefsOptions {
    private String code;

    public CodeProjectionChoice() {
        super(I18n.tr("By Code (EPSG)", new Object[0]), "core:code");
    }

    @Override
    public Projection getProjection() {
        return Projections.getProjectionByCode(this.code);
    }

    @Override
    public String getCurrentCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getProjectionName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPreferences(Collection<String> args) {
        if (args != null && !args.isEmpty()) {
            this.code = args.iterator().next();
        }
    }

    @Override
    public JPanel getPreferencePanel(ActionListener listener) {
        return new CodeSelectionPanel(this.code, listener);
    }

    @Override
    public Collection<String> getPreferences(JPanel panel) {
        if (!(panel instanceof CodeSelectionPanel)) {
            throw new IllegalArgumentException("Unsupported panel: " + panel);
        }
        CodeSelectionPanel csPanel = (CodeSelectionPanel)panel;
        return Collections.singleton(csPanel.getCode());
    }

    @Override
    public String[] allCodes() {
        return new String[0];
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        return null;
    }

    @Override
    public boolean showProjectionCode() {
        return true;
    }

    @Override
    public boolean showProjectionName() {
        return true;
    }

    public static class CodeComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Pattern codePattern = Pattern.compile("([a-zA-Z]+):(\\d+)");

        @Override
        public int compare(String c1, String c2) {
            Matcher matcher1 = this.codePattern.matcher(c1);
            Matcher matcher2 = this.codePattern.matcher(c2);
            if (matcher1.matches()) {
                if (matcher2.matches()) {
                    int cmp1 = matcher1.group(1).compareTo(matcher2.group(1));
                    if (cmp1 != 0) {
                        return cmp1;
                    }
                    int num1 = Integer.parseInt(matcher1.group(2));
                    int num2 = Integer.parseInt(matcher2.group(2));
                    return Integer.compare(num1, num2);
                }
                return -1;
            }
            if (matcher2.matches()) {
                return 1;
            }
            return c1.compareTo(c2);
        }
    }

    private static class CodeSelectionPanel
    extends JPanel
    implements ListSelectionListener,
    DocumentListener {
        public final JosmTextField filter = new JosmTextField(30);
        private final ProjectionCodeListModel model = new ProjectionCodeListModel();
        public JList<String> selectionList;
        private final List<String> data;
        private final List<String> filteredData;
        private static final String DEFAULT_CODE = "EPSG:3857";
        private String lastCode = "EPSG:3857";
        private final transient ActionListener listener;

        CodeSelectionPanel(String initialCode, ActionListener listener) {
            this.listener = listener;
            this.data = new ArrayList<String>(Projections.getAllProjectionCodes());
            this.data.sort(new CodeComparator());
            this.filteredData = new ArrayList<String>(this.data);
            this.build();
            this.setCode(initialCode != null ? initialCode : DEFAULT_CODE);
            this.selectionList.addListSelectionListener(this);
        }

        private void build() {
            this.filter.setColumns(10);
            this.filter.getDocument().addDocumentListener(this);
            this.selectionList = new JList<String>(this.data.toArray(new String[this.data.size()]));
            this.selectionList.setModel(this.model);
            JScrollPane scroll = new JScrollPane(this.selectionList);
            scroll.setPreferredSize(new Dimension(200, 214));
            this.setLayout(new GridBagLayout());
            this.add((Component)this.filter, GBC.eol().weight(1.0, 0.0));
            this.add((Component)scroll, GBC.eol());
        }

        public String getCode() {
            int idx = this.selectionList.getSelectedIndex();
            if (idx == -1) {
                return this.lastCode;
            }
            return this.filteredData.get(this.selectionList.getSelectedIndex());
        }

        public final void setCode(String code) {
            int idx = this.filteredData.indexOf(code);
            if (idx != -1) {
                this.selectionList.setSelectedIndex(idx);
                this.selectionList.ensureIndexIsVisible(idx);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.listener.actionPerformed(null);
            this.lastCode = this.getCode();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        private void updateFilter() {
            this.filteredData.clear();
            String filterTxt = this.filter.getText().trim().toLowerCase(Locale.ENGLISH);
            for (String code : this.data) {
                if (!code.toLowerCase(Locale.ENGLISH).contains(filterTxt)) continue;
                this.filteredData.add(code);
            }
            this.model.fireContentsChanged();
            int idx = this.filteredData.indexOf(this.lastCode);
            if (idx == -1) {
                this.selectionList.clearSelection();
                if (this.selectionList.getModel().getSize() > 0) {
                    this.selectionList.ensureIndexIsVisible(0);
                }
            } else {
                this.selectionList.setSelectedIndex(idx);
                this.selectionList.ensureIndexIsVisible(idx);
            }
        }

        private class ProjectionCodeListModel
        extends AbstractListModel<String> {
            private ProjectionCodeListModel() {
            }

            @Override
            public int getSize() {
                return CodeSelectionPanel.this.filteredData.size();
            }

            @Override
            public String getElementAt(int index) {
                if (index >= 0 && index < CodeSelectionPanel.this.filteredData.size()) {
                    return (String)CodeSelectionPanel.this.filteredData.get(index);
                }
                return null;
            }

            public void fireContentsChanged() {
                this.fireContentsChanged(this, 0, this.getSize() - 1);
            }
        }
    }
}

