/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionPriority;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionSet;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPriority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class AutoCompletionList
extends AbstractTableModel {
    private final transient AutoCompletionSet list = new AutoCompletionSet();
    private final transient ArrayList<AutoCompletionItem> filtered = new ArrayList();
    private String filter;

    public void applyFilter(String filter) {
        CheckParameterUtil.ensureParameterNotNull(filter, "filter");
        this.filter = filter;
        this.filter();
    }

    public void clearFilter() {
        this.filter = null;
        this.filter();
    }

    public String getFilter() {
        return this.filter;
    }

    @Deprecated
    public void add(AutoCompletionListItem item) {
        if (item == null) {
            return;
        }
        this.add(item.getItem());
    }

    public void add(AutoCompletionItem item) {
        if (item != null && this.list.add(item)) {
            this.filter();
        }
    }

    public void add(AutoCompletionList other) {
        CheckParameterUtil.ensureParameterNotNull(other, "other");
        this.add(other.list);
    }

    public void add(Collection<AutoCompletionItem> collection) {
        CheckParameterUtil.ensureParameterNotNull(collection, "collection");
        if (this.list.addAll(collection)) {
            this.filter();
        }
    }

    @Deprecated
    public void add(List<AutoCompletionListItem> other) {
        CheckParameterUtil.ensureParameterNotNull(other, "other");
        this.add(other.stream().map(AutoCompletionListItem::getItem).collect(Collectors.toList()));
    }

    @Deprecated
    public void add(Collection<String> values, AutoCompletionItemPriority priority) {
        this.add(values, priority.getPriority());
    }

    public void add(Collection<String> values, AutoCompletionPriority priority) {
        if (values != null && this.list.addAll(values, priority)) {
            this.filter();
        }
    }

    public void addUserInput(Collection<String> values) {
        if (values != null && this.list.addUserInput(values)) {
            this.filter();
        }
    }

    @Deprecated
    public boolean contains(AutoCompletionListItem item) {
        if (item == null) {
            return false;
        }
        return this.contains(item.getItem());
    }

    public boolean contains(AutoCompletionItem item) {
        return this.list.contains(item);
    }

    public boolean contains(String value) {
        return this.list.contains(value);
    }

    public void remove(String key) {
        if (key != null) {
            this.list.remove(key);
        }
    }

    protected void filter() {
        this.filtered.clear();
        if (this.filter == null) {
            this.filtered.ensureCapacity(this.list.size());
            this.filtered.addAll(this.list);
            return;
        }
        this.list.stream().filter(e -> e.getValue().startsWith(this.filter)).forEach(this.filtered::add);
        this.fireTableDataChanged();
    }

    public int getFilteredSize() {
        return this.filtered.size();
    }

    @Deprecated
    public AutoCompletionListItem getFilteredItem(int idx) {
        return new AutoCompletionListItem(this.getFilteredItemAt(idx));
    }

    public AutoCompletionItem getFilteredItemAt(int idx) {
        return this.filtered.get(idx);
    }

    AutoCompletionSet getSet() {
        return this.list;
    }

    Set<AutoCompletionItem> getUnmodifiableSet() {
        return Collections.unmodifiableSet(this.list);
    }

    public void clear() {
        this.list.clear();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.list == null ? 0 : this.getFilteredSize();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.list == null ? null : this.getFilteredItemAt(rowIndex);
    }
}

