/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Locale;
import org.openstreetmap.josm.data.PreferencesUtils;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public enum UploadStrategy {
    INDIVIDUAL_OBJECTS_STRATEGY("individualobjects"),
    CHUNKED_DATASET_STRATEGY("chunked"),
    SINGLE_REQUEST_STRATEGY("singlerequest");

    private final String preferenceValue;
    public static final UploadStrategy DEFAULT_UPLOAD_STRATEGY;

    private UploadStrategy(String preferenceValue) {
        this.preferenceValue = preferenceValue;
    }

    public static UploadStrategy fromPreference(String preferenceValue) {
        if (preferenceValue == null) {
            return null;
        }
        preferenceValue = preferenceValue.trim().toLowerCase(Locale.ENGLISH);
        for (UploadStrategy strategy : UploadStrategy.values()) {
            if (!strategy.getPreferenceValue().equals(preferenceValue)) continue;
            return strategy;
        }
        return null;
    }

    public String getPreferenceValue() {
        return this.preferenceValue;
    }

    public static UploadStrategy getFromPreferences() {
        String v = Config.getPref().get("osm-server.upload-strategy", null);
        if (v == null) {
            v = Config.getPref().get("osm-server.atomic-upload", null);
            if (v != null) {
                PreferencesUtils.removeFromList(Config.getPref(), "osm-server.atomic-upload", v);
            } else {
                v = "";
            }
            v = v.trim().toLowerCase(Locale.ENGLISH);
            if ("true".equals(v)) {
                return SINGLE_REQUEST_STRATEGY;
            }
            if ("false".equals(v)) {
                return INDIVIDUAL_OBJECTS_STRATEGY;
            }
            return DEFAULT_UPLOAD_STRATEGY;
        }
        UploadStrategy strategy = UploadStrategy.fromPreference(v);
        if (strategy == null) {
            Logging.warn(I18n.tr("Unexpected value for key ''{0}'' in preferences, got ''{1}''", "osm-server.upload-strategy", v));
            return DEFAULT_UPLOAD_STRATEGY;
        }
        return strategy;
    }

    public static void saveToPreferences(UploadStrategy strategy) {
        Config.getPref().put("osm-server.upload-strategy", strategy.getPreferenceValue());
    }

    static {
        DEFAULT_UPLOAD_STRATEGY = SINGLE_REQUEST_STRATEGY;
    }
}

