/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Bidi;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.StreamUtils;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Utils {
    public static final Pattern WHITE_SPACES_PATTERN = Pattern.compile("\\s+");
    private static final long MILLIS_OF_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private static final long MILLIS_OF_MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private static final long MILLIS_OF_HOUR = TimeUnit.HOURS.toMillis(1L);
    private static final long MILLIS_OF_DAY = TimeUnit.DAYS.toMillis(1L);
    public static final String URL_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*+,;=%";
    private static final char[] DEFAULT_STRIP = new char[]{'\u200b', '\ufeff'};
    private static final String[] SIZE_UNITS = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};
    private static final double TO_DEGREES = 57.29577951308232;
    private static final double TO_RADIANS = Math.PI / 180;
    private static final double EPSILON = 1.0E-11;
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Utils() {
    }

    public static <T> boolean exists(Iterable<T> collection, Class<? extends T> clazz) {
        CheckParameterUtil.ensureParameterNotNull(clazz, "clazz");
        return StreamUtils.toStream(collection).anyMatch(clazz::isInstance);
    }

    public static <T> T find(Iterable<? extends T> collection, Predicate<? super T> predicate) {
        for (T item : collection) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public static <T> T find(Iterable<? extends Object> collection, Class<? extends T> clazz) {
        CheckParameterUtil.ensureParameterNotNull(clazz, "clazz");
        return (T)Utils.find(collection, clazz::isInstance);
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... items) {
        for (T i : items) {
            if (i == null) continue;
            return i;
        }
        return null;
    }

    public static <S, T extends S> SubclassFilteredCollection<S, T> filteredCollection(Collection<S> collection, Class<T> clazz) {
        CheckParameterUtil.ensureParameterNotNull(clazz, "clazz");
        return new SubclassFilteredCollection(collection, clazz::isInstance);
    }

    public static <T> int indexOf(Iterable<? extends T> collection, Predicate<? super T> predicate) {
        int i = 0;
        for (T item : collection) {
            if (predicate.test(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void ensure(boolean condition, String message, Object ... data) {
        if (!condition) {
            throw new AssertionError((Object)MessageFormat.format(message, data));
        }
    }

    public static int mod(int a, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be <= 0 but is " + n);
        }
        int res = a % n;
        if (res < 0) {
            res += n;
        }
        return res;
    }

    public static String join(String sep, Collection<?> values) {
        CheckParameterUtil.ensureParameterNotNull(sep, "sep");
        if (values == null) {
            return null;
        }
        StringBuilder s = null;
        for (Object a : values) {
            if (a == null) {
                a = "";
            }
            if (s != null) {
                s.append(sep).append(a);
                continue;
            }
            s = new StringBuilder(a.toString());
        }
        return s != null ? s.toString() : "";
    }

    public static String joinAsHtmlUnorderedList(Iterable<?> values) {
        return StreamUtils.toStream(values).map(Object::toString).collect(StreamUtils.toHtmlList());
    }

    public static String toString(Color c) {
        if (c == null) {
            return "null";
        }
        if (c.getAlpha() == 255) {
            return String.format("#%06x", c.getRGB() & 0xFFFFFF);
        }
        return String.format("#%06x(alpha=%d)", c.getRGB() & 0xFFFFFF, c.getAlpha());
    }

    public static Integer colorFloat2int(Float val) {
        if (val == null) {
            return null;
        }
        if (val.floatValue() < 0.0f || val.floatValue() > 1.0f) {
            return 255;
        }
        return (int)(255.0f * val.floatValue() + 0.5f);
    }

    public static Float colorInt2float(Integer val) {
        if (val == null) {
            return null;
        }
        if (val < 0 || val > 255) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf((float)val.intValue() / 255.0f);
    }

    public static Color alphaMultiply(Color color, float alphaFactor) {
        int alpha = Utils.colorFloat2int(Float.valueOf(Utils.colorInt2float(color.getAlpha()).floatValue() * alphaFactor));
        alpha = Utils.clamp(alpha, 0, 255);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color complement(Color clr) {
        return new Color(255 - clr.getRed(), 255 - clr.getGreen(), 255 - clr.getBlue(), clr.getAlpha());
    }

    public static <T> T[] copyArray(T[] array) {
        if (array != null) {
            return Arrays.copyOf(array, array.length);
        }
        return array;
    }

    public static char[] copyArray(char ... array) {
        if (array != null) {
            return Arrays.copyOf(array, array.length);
        }
        return array;
    }

    public static int[] copyArray(int ... array) {
        if (array != null) {
            return Arrays.copyOf(array, array.length);
        }
        return array;
    }

    public static byte[] copyArray(byte ... array) {
        if (array != null) {
            return Arrays.copyOf(array, array.length);
        }
        return array;
    }

    public static Path copyFile(File in, File out) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(in, "in");
        CheckParameterUtil.ensureParameterNotNull(out, "out");
        return Files.copy(in.toPath(), out.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyDirectory(File in, File out) throws IOException {
        File[] files;
        CheckParameterUtil.ensureParameterNotNull(in, "in");
        CheckParameterUtil.ensureParameterNotNull(out, "out");
        if (!out.exists() && !out.mkdirs()) {
            Logging.warn("Unable to create directory " + out.getPath());
        }
        if ((files = in.listFiles()) != null) {
            for (File f : files) {
                File target = new File(out, f.getName());
                if (f.isDirectory()) {
                    Utils.copyDirectory(f, target);
                    continue;
                }
                Utils.copyFile(f, target);
            }
        }
    }

    public static boolean deleteDirectory(File path) {
        File[] files;
        if (path.exists() && (files = path.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    Utils.deleteDirectory(file);
                    continue;
                }
                Utils.deleteFile(file);
            }
        }
        return path.delete();
    }

    public static boolean deleteFileIfExists(File file) {
        if (file.exists()) {
            return Utils.deleteFile(file);
        }
        return true;
    }

    public static boolean deleteFile(File file) {
        return Utils.deleteFile(file, I18n.marktr("Unable to delete file {0}"));
    }

    public static boolean deleteFile(File file, String warnMsg) {
        boolean result = file.delete();
        if (!result) {
            Logging.warn(I18n.tr(warnMsg, file.getPath()));
        }
        return result;
    }

    public static boolean mkDirs(File dir) {
        return Utils.mkDirs(dir, I18n.marktr("Unable to create directory {0}"));
    }

    public static boolean mkDirs(File dir, String warnMsg) {
        boolean result = dir.mkdirs();
        if (!result) {
            Logging.warn(I18n.tr(warnMsg, dir.getPath()));
        }
        return result;
    }

    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            Logging.warn(e);
        }
    }

    public static void close(ZipFile zip) {
        Utils.close((Closeable)zip);
    }

    public static URL fileToURL(File f) {
        if (f != null) {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                Logging.error("Unable to convert filename " + f.getAbsolutePath() + " to URL");
            }
        }
        return null;
    }

    public static boolean equalsEpsilon(double a, double b) {
        return Math.abs(a - b) <= 1.0E-11;
    }

    public static String md5Hex(String data) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JosmRuntimeException(e);
        }
        byte[] byteData = data.getBytes(StandardCharsets.UTF_8);
        byte[] byteDigest = md.digest(byteData);
        return Utils.toHexString(byteDigest);
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        int len = bytes.length;
        if (len == 0) {
            return "";
        }
        char[] hexChars = new char[len * 2];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            byte v = bytes[i];
            hexChars[j++] = HEX_ARRAY[(v & 0xF0) >> 4];
            hexChars[j++] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static <T> List<T> topologicalSort(MultiMap<T, T> dependencies) {
        MultiMap<Object, T> deps = new MultiMap<Object, T>();
        for (T key : dependencies.keySet()) {
            deps.putVoid(key);
            for (T val : dependencies.get(key)) {
                deps.putVoid(val);
                deps.put(key, val);
            }
        }
        int size = deps.size();
        ArrayList sorted = new ArrayList();
        for (int i = 0; i < size; ++i) {
            Object parentless = null;
            for (Object key : deps.keySet()) {
                if (!deps.get(key).isEmpty()) continue;
                parentless = key;
                break;
            }
            if (parentless == null) {
                throw new JosmRuntimeException("parentless");
            }
            sorted.add(parentless);
            deps.remove(parentless);
            for (Object key : deps.keySet()) {
                deps.remove(key, parentless);
            }
        }
        if (sorted.size() != size) {
            throw new JosmRuntimeException("Wrong size");
        }
        return sorted;
    }

    public static String escapeReservedCharactersHTML(String s) {
        return s == null ? "" : s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static <A, B> Collection<B> transform(final Collection<? extends A> c, final Function<A, B> f) {
        return new AbstractCollection<B>(){

            @Override
            public int size() {
                return c.size();
            }

            @Override
            public Iterator<B> iterator() {
                return new Iterator<B>(){
                    private final Iterator<? extends A> it;
                    {
                        this.it = c.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public B next() {
                        return f.apply(this.it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <A, B> List<B> transform(final List<? extends A> l, final Function<A, B> f) {
        return new AbstractList<B>(){

            @Override
            public int size() {
                return l.size();
            }

            @Override
            public B get(int index) {
                return f.apply(l.get(index));
            }
        };
    }

    @Deprecated
    public static BZip2CompressorInputStream getBZip2InputStream(InputStream in) throws IOException {
        return Compression.getBZip2InputStream(in);
    }

    @Deprecated
    public static GZIPInputStream getGZipInputStream(InputStream in) throws IOException {
        return Compression.getGZipInputStream(in);
    }

    @Deprecated
    public static ZipInputStream getZipInputStream(InputStream in) throws IOException {
        return Compression.getZipInputStream(in);
    }

    public static boolean isStripEmpty(String str) {
        if (str != null) {
            for (int i = 0; i < str.length(); ++i) {
                if (Utils.isStrippedChar(str.charAt(i), DEFAULT_STRIP)) continue;
                return false;
            }
        }
        return true;
    }

    public static String strip(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Utils.strip(str, DEFAULT_STRIP);
    }

    public static String strip(String str, String skipChars) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Utils.strip(str, Utils.stripChars(skipChars));
    }

    private static String strip(String str, char ... skipChars) {
        int start = 0;
        int end = str.length();
        boolean leadingSkipChar = true;
        while (leadingSkipChar && start < end) {
            leadingSkipChar = Utils.isStrippedChar(str.charAt(start), skipChars);
            if (!leadingSkipChar) continue;
            ++start;
        }
        boolean trailingSkipChar = true;
        while (trailingSkipChar && end > start + 1) {
            trailingSkipChar = Utils.isStrippedChar(str.charAt(end - 1), skipChars);
            if (!trailingSkipChar) continue;
            --end;
        }
        return str.substring(start, end);
    }

    private static boolean isStrippedChar(char c, char ... skipChars) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || Utils.stripChar(skipChars, c);
    }

    private static char[] stripChars(String skipChars) {
        if (skipChars == null || skipChars.isEmpty()) {
            return DEFAULT_STRIP;
        }
        char[] chars = new char[DEFAULT_STRIP.length + skipChars.length()];
        System.arraycopy(DEFAULT_STRIP, 0, chars, 0, DEFAULT_STRIP.length);
        skipChars.getChars(0, skipChars.length(), chars, DEFAULT_STRIP.length);
        return chars;
    }

    private static boolean stripChar(char[] strip, char c) {
        for (char s : strip) {
            if (c != s) continue;
            return true;
        }
        return false;
    }

    public static String execOutput(List<String> command) throws IOException, ExecutionException, InterruptedException {
        if (Logging.isDebugEnabled()) {
            Logging.debug(Utils.join(" ", command));
        }
        Process p = new ProcessBuilder(command).start();
        try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
            String msg;
            String line;
            StringBuilder all = null;
            while ((line = input.readLine()) != null) {
                if (all == null) {
                    all = new StringBuilder(line);
                    continue;
                }
                all.append('\n');
                all.append(line);
            }
            String string = msg = all != null ? all.toString() : null;
            if (p.waitFor() != 0) {
                throw new ExecutionException(msg, null);
            }
            String string2 = msg;
            return string2;
        }
    }

    public static File getJosmTempDir() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null) {
            return null;
        }
        File josmTmpDir = new File(tmpDir, "JOSM");
        if (!josmTmpDir.exists() && !josmTmpDir.mkdirs()) {
            Logging.warn("Unable to create temp directory " + josmTmpDir);
        }
        return josmTmpDir;
    }

    public static String getDurationString(long elapsedTime) {
        if (elapsedTime < 0L) {
            throw new IllegalArgumentException("elapsedTime must be >= 0");
        }
        if (elapsedTime < MILLIS_OF_SECOND) {
            return String.format("%d %s", elapsedTime, I18n.tr("ms", new Object[0]));
        }
        if (elapsedTime < MILLIS_OF_MINUTE) {
            return String.format("%.1f %s", (double)elapsedTime / (double)MILLIS_OF_SECOND, I18n.tr("s", new Object[0]));
        }
        if (elapsedTime < MILLIS_OF_HOUR) {
            long min = elapsedTime / MILLIS_OF_MINUTE;
            return String.format("%d %s %d %s", min, I18n.tr("min", new Object[0]), (elapsedTime - min * MILLIS_OF_MINUTE) / MILLIS_OF_SECOND, I18n.tr("s", new Object[0]));
        }
        if (elapsedTime < MILLIS_OF_DAY) {
            long hour = elapsedTime / MILLIS_OF_HOUR;
            return String.format("%d %s %d %s", hour, I18n.tr("h", new Object[0]), (elapsedTime - hour * MILLIS_OF_HOUR) / MILLIS_OF_MINUTE, I18n.tr("min", new Object[0]));
        }
        long days = elapsedTime / MILLIS_OF_DAY;
        return String.format("%d %s %d %s", days, I18n.trn("day", "days", days, new Object[0]), (elapsedTime - days * MILLIS_OF_DAY) / MILLIS_OF_HOUR, I18n.tr("h", new Object[0]));
    }

    public static String getSizeString(long bytes, Locale locale) {
        double value;
        if (bytes < 0L) {
            throw new IllegalArgumentException("bytes must be >= 0");
        }
        int unitIndex = 0;
        for (value = (double)bytes; value >= 1024.0 && unitIndex < SIZE_UNITS.length; value /= 1024.0, ++unitIndex) {
        }
        if (value > 100.0 || unitIndex == 0) {
            return String.format(locale, "%.0f %s", value, SIZE_UNITS[unitIndex]);
        }
        if (value > 10.0) {
            return String.format(locale, "%.1f %s", value, SIZE_UNITS[unitIndex]);
        }
        return String.format(locale, "%.2f %s", value, SIZE_UNITS[unitIndex]);
    }

    public static String getPositionListString(List<Integer> positionList) {
        Collections.sort(positionList);
        StringBuilder sb = new StringBuilder(32);
        sb.append(positionList.get(0));
        int cnt = 0;
        int last = positionList.get(0);
        for (int i = 1; i < positionList.size(); ++i) {
            int cur = positionList.get(i);
            if (cur == last + 1) {
                ++cnt;
            } else if (cnt == 0) {
                sb.append(',').append(cur);
            } else {
                sb.append('-').append(last);
                sb.append(',').append(cur);
                cnt = 0;
            }
            last = cur;
        }
        if (cnt >= 1) {
            sb.append('-').append(last);
        }
        return sb.toString();
    }

    public static List<String> getMatches(Matcher m) {
        if (m.matches()) {
            ArrayList<String> result = new ArrayList<String>(m.groupCount() + 1);
            for (int i = 0; i <= m.groupCount(); ++i) {
                result.add(m.group(i));
            }
            return result;
        }
        return null;
    }

    public static <T> T cast(Object o, Class<T> klass) {
        if (klass.isInstance(o)) {
            return (T)o;
        }
        return null;
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable result = t;
        if (result != null) {
            Throwable cause = result.getCause();
            while (cause != null && !cause.equals(result)) {
                result = cause;
                cause = result.getCause();
            }
        }
        return result;
    }

    public static <T> T[] addInArrayCopy(T[] array, T item) {
        T[] biggerCopy = Arrays.copyOf(array, array.length + 1);
        biggerCopy[array.length] = item;
        return biggerCopy;
    }

    public static String shortenString(String s, int maxLength) {
        if (s != null && s.length() > maxLength) {
            return s.substring(0, maxLength - 3) + "...";
        }
        return s;
    }

    public static String restrictStringLines(String s, int maxLines) {
        if (s == null) {
            return null;
        }
        return Utils.join("\n", Utils.limit(Arrays.asList(s.split("\\n")), maxLines, "..."));
    }

    public static <T> Collection<T> limit(Collection<T> elements, int maxElements, T overflowIndicator) {
        if (elements == null) {
            return null;
        }
        if (elements.size() > maxElements) {
            ArrayList<T> r = new ArrayList<T>(maxElements);
            Iterator<T> it = elements.iterator();
            while (r.size() < maxElements - 1) {
                r.add(it.next());
            }
            r.add(overflowIndicator);
            return r;
        }
        return elements;
    }

    public static String fixURLQuery(String url) {
        if (url == null || url.indexOf(63) == -1) {
            return url;
        }
        String query = url.substring(url.indexOf(63) + 1);
        StringBuilder sb = new StringBuilder(url.substring(0, url.indexOf(63) + 1));
        for (int i = 0; i < query.length(); ++i) {
            String c = query.substring(i, i + 1);
            if (URL_CHARS.contains(c)) {
                sb.append(c);
                continue;
            }
            sb.append(Utils.encodeUrl(c));
        }
        return sb.toString();
    }

    public static String encodeUrl(String s) {
        String enc = StandardCharsets.UTF_8.name();
        try {
            return URLEncoder.encode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String decodeUrl(String s) {
        String enc = StandardCharsets.UTF_8.name();
        try {
            return URLDecoder.decode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isLocalUrl(String url) {
        return url != null && !url.startsWith("http://") && !url.startsWith("https://") && !url.startsWith("resource://");
    }

    public static boolean isValidUrl(String url) {
        if (url != null) {
            try {
                new URL(url);
                return true;
            }
            catch (MalformedURLException e) {
                Logging.trace(e);
            }
        }
        return false;
    }

    public static ThreadFactory newThreadFactory(final String nameFormat, final int threadPriority) {
        return new ThreadFactory(){
            final AtomicLong count = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, String.format(Locale.ENGLISH, nameFormat, this.count.getAndIncrement()));
                thread.setPriority(threadPriority);
                return thread;
            }
        };
    }

    public static ForkJoinPool newForkJoinPool(String pref2, final String nameFormat, final int threadPriority) {
        int noThreads = Config.getPref().getInt(pref2, Runtime.getRuntime().availableProcessors());
        return new ForkJoinPool(noThreads, new ForkJoinPool.ForkJoinWorkerThreadFactory(){
            final AtomicLong count = new AtomicLong(0L);

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                thread.setName(String.format(Locale.ENGLISH, nameFormat, this.count.getAndIncrement()));
                thread.setPriority(threadPriority);
                return thread;
            }
        }, null, true);
    }

    public static Executor newDirectExecutor() {
        return Runnable::run;
    }

    public static String updateSystemProperty(String key, String value) {
        if (value != null) {
            String old = System.setProperty(key, value);
            if (Logging.isDebugEnabled() && !value.equals(old)) {
                if (!key.toLowerCase(Locale.ENGLISH).contains("password")) {
                    Logging.debug("System property '" + key + "' set to '" + value + "'. Old value was '" + old + '\'');
                } else {
                    Logging.debug("System property '" + key + "' changed.");
                }
            }
            return old;
        }
        return null;
    }

    public static DocumentBuilder newSafeDOMBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        builderFactory.setNamespaceAware(true);
        builderFactory.setValidating(false);
        return builderFactory.newDocumentBuilder();
    }

    public static Document parseSafeDOM(InputStream is) throws ParserConfigurationException, IOException, SAXException {
        long start = System.currentTimeMillis();
        Logging.debug("Starting DOM parsing of {0}", is);
        Document result = Utils.newSafeDOMBuilder().parse(is);
        if (Logging.isDebugEnabled()) {
            Logging.debug("DOM parsing done in {0}", Utils.getDurationString(System.currentTimeMillis() - start));
        }
        return result;
    }

    public static SAXParser newSafeSAXParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        parserFactory.setNamespaceAware(true);
        return parserFactory.newSAXParser();
    }

    public static void parseSafeSAX(InputSource is, DefaultHandler dh) throws ParserConfigurationException, SAXException, IOException {
        long start = System.currentTimeMillis();
        Logging.debug("Starting SAX parsing of {0} using {1}", is, dh);
        Utils.newSafeSAXParser().parse(is, dh);
        if (Logging.isDebugEnabled()) {
            Logging.debug("SAX parsing done in {0}", Utils.getDurationString(System.currentTimeMillis() - start));
        }
    }

    public static boolean hasExtension(String filename, String ... extensions) {
        String name = filename.toLowerCase(Locale.ENGLISH).replace("?format=raw", "");
        for (String ext : extensions) {
            if (!name.endsWith('.' + ext.toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExtension(File file, String ... extensions) {
        return Utils.hasExtension(file.getName(), extensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesFromStream(InputStream stream) throws IOException {
        if (stream == null) {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(stream.available());
            byte[] buffer = new byte[2048];
            boolean finished = false;
            do {
                int read;
                if ((read = stream.read(buffer)) >= 0) {
                    bout.write(buffer, 0, read);
                    continue;
                }
                finished = true;
            } while (!finished);
            if (bout.size() == 0) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        finally {
            stream.close();
        }
    }

    public static int hashMapInitialCapacity(int nEntries, double loadFactor) {
        return (int)Math.ceil((double)nEntries / loadFactor);
    }

    public static int hashMapInitialCapacity(int nEntries) {
        return Utils.hashMapInitialCapacity(nEntries, 0.75);
    }

    public static List<GlyphVector> getGlyphVectorsBidi(String string, Font font, FontRenderContext frc) {
        int i;
        ArrayList<GlyphVector> gvs = new ArrayList<GlyphVector>();
        Bidi bidi = new Bidi(string, -2);
        byte[] levels = new byte[bidi.getRunCount()];
        Object[] dirStrings = new DirectionString[levels.length];
        for (i = 0; i < levels.length; ++i) {
            levels[i] = (byte)bidi.getRunLevel(i);
            String substr = string.substring(bidi.getRunStart(i), bidi.getRunLimit(i));
            int dir = levels[i] % 2 == 0 ? 0 : 1;
            dirStrings[i] = new DirectionString(dir, substr);
        }
        Bidi.reorderVisually(levels, 0, dirStrings, 0, levels.length);
        for (i = 0; i < dirStrings.length; ++i) {
            char[] chars = ((DirectionString)dirStrings[i]).str.toCharArray();
            gvs.add(font.layoutGlyphVector(frc, chars, 0, chars.length, ((DirectionString)dirStrings[i]).direction));
        }
        return gvs;
    }

    public static void setObjectsAccessible(AccessibleObject ... objects) {
        if (objects != null && objects.length > 0) {
            AccessController.doPrivileged(() -> {
                for (AccessibleObject o : objects) {
                    o.setAccessible(true);
                }
                return null;
            });
        }
    }

    public static double clamp(double val, double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter min ({0}) cannot be greater than max ({1})", min, max));
        }
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static int clamp(int val, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter min ({0}) cannot be greater than max ({1})", min, max));
        }
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static double toDegrees(double angleRad) {
        return angleRad * 57.29577951308232;
    }

    public static double toRadians(double angleDeg) {
        return angleDeg * (Math.PI / 180);
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        int dotPos = version.indexOf(46);
        int dashPos = version.indexOf(45);
        return Integer.parseInt(version.substring(0, dotPos > -1 ? dotPos : (dashPos > -1 ? dashPos : 1)));
    }

    public static int getJavaUpdate() {
        int lastDotPos;
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        int undePos = version.indexOf(95);
        int dashPos = version.indexOf(45);
        if (undePos > -1) {
            return Integer.parseInt(version.substring(undePos + 1, dashPos > -1 ? dashPos : version.length()));
        }
        int firstDotPos = version.indexOf(46);
        if (firstDotPos == (lastDotPos = version.lastIndexOf(46))) {
            return 0;
        }
        return firstDotPos > -1 ? Integer.parseInt(version.substring(firstDotPos + 1, lastDotPos > -1 ? lastDotPos : version.length())) : 0;
    }

    public static int getJavaBuild() {
        String version = System.getProperty("java.runtime.version");
        int bPos = version.indexOf(98);
        int pPos = version.indexOf(43);
        try {
            return Integer.parseInt(version.substring(bPos > -1 ? bPos + 1 : pPos + 1, version.length()));
        }
        catch (NumberFormatException e) {
            Logging.trace(e);
            return 0;
        }
    }

    public static Date getJavaExpirationDate() {
        try {
            Object value = null;
            Class<?> c = Class.forName("com.sun.deploy.config.BuiltInProperties");
            try {
                value = c.getDeclaredField("JRE_EXPIRATION_DATE").get(null);
            }
            catch (NoSuchFieldException e) {
                Logging.trace(e);
                value = c.getDeclaredMethod("getProperty", String.class).invoke(null, "JRE_EXPIRATION_DATE");
            }
            if (value instanceof String) {
                return DateFormat.getDateInstance(3, Locale.US).parse((String)value);
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException | ParseException e) {
            Logging.debug(e);
        }
        return null;
    }

    public static String getJavaLatestVersion() {
        try {
            return HttpClient.create(new URL(Config.getPref().get("java.baseline.version.url", "http://javadl-esd-secure.oracle.com/update/baseline.version"))).connect().fetchContent().split("\n")[0];
        }
        catch (IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static <T, U> Function<T, Stream<U>> castToStream(Class<U> klass) {
        return x -> klass.isInstance(x) ? Stream.of(klass.cast(x)) : null;
    }

    public static <T> void instanceOfThen(Object o, Class<T> klass, Consumer<? super T> consumer) {
        if (klass.isInstance(o)) {
            consumer.accept(o);
        }
    }

    public static <T> Optional<T> instanceOfAndCast(Object o, Class<T> klass) {
        if (klass.isInstance(o)) {
            return Optional.of(o);
        }
        return Optional.empty();
    }

    private static class DirectionString {
        public final int direction;
        public final String str;

        DirectionString(int direction, String str) {
            this.direction = direction;
            this.str = str;
        }
    }
}

