/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.joni.BitSet;
import org.joni.Regex;
import org.joni.WarnCallback;
import org.joni.ast.CClassNode;
import org.joni.constants.OPCode;
import org.joni.exception.InternalException;

class ByteCodePrinter {
    final int[] code;
    final int codeLength;
    final byte[][] templates;
    Object[] operands;
    int operantCount;
    Encoding enc;
    WarnCallback warnings;

    public ByteCodePrinter(Regex regex) {
        this.code = regex.code;
        this.codeLength = regex.codeLength;
        this.operands = regex.operands;
        this.operantCount = regex.operandLength;
        this.templates = regex.templates;
        this.enc = regex.enc;
        this.warnings = regex.warnings;
    }

    public String byteCodeListToString() {
        return this.compiledByteCodeListToString();
    }

    private void pString(StringBuilder sb, int len, int s2) {
        sb.append(":");
        while (len-- > 0) {
            sb.append(new String(new byte[]{(byte)this.code[s2++]}));
        }
    }

    private void pStringFromTemplate(StringBuilder sb, int len, byte[] tm, int idx) {
        sb.append(":T:");
        while (len-- > 0) {
            sb.append(new String(new byte[]{tm[idx++]}));
        }
    }

    private void pLenString(StringBuilder sb, int len, int mbLen, int s2) {
        int x = len * mbLen;
        sb.append(":" + len + ":");
        while (x-- > 0) {
            sb.append(new String(new byte[]{(byte)this.code[s2++]}));
        }
    }

    private void pLenStringFromTemplate(StringBuilder sb, int len, int mbLen, byte[] tm, int idx) {
        int x = len * mbLen;
        sb.append(":T:" + len + ":");
        while (x-- > 0) {
            sb.append(new String(new byte[]{tm[idx++]}));
        }
    }

    public int compiledByteCodeToString(StringBuilder sb, int bp) {
        sb.append("[" + OPCode.OpCodeNames[this.code[bp]]);
        int argType = OPCode.OpCodeArgTypes[this.code[bp]];
        int ip2 = bp++;
        if (argType != -1) {
            switch (argType) {
                case 0: {
                    break;
                }
                case 1: {
                    sb.append(":(" + this.code[bp] + ")");
                    ++bp;
                    break;
                }
                case 2: {
                    sb.append(":(" + this.code[bp] + ")");
                    ++bp;
                    break;
                }
                case 3: {
                    sb.append(":" + this.code[bp]);
                    ++bp;
                    break;
                }
                case 4: {
                    sb.append(":" + this.code[bp]);
                    ++bp;
                    break;
                }
                case 5: {
                    sb.append(":" + this.code[bp]);
                    ++bp;
                    break;
                }
                case 6: {
                    sb.append(":" + this.code[bp]);
                    bp += 2;
                }
            }
        } else {
            switch (this.code[bp++]) {
                case 2: 
                case 27: 
                case 28: 
                case 100: 
                case 101: {
                    this.pString(sb, 1, bp++);
                    break;
                }
                case 3: {
                    this.pString(sb, 2, bp);
                    bp += 2;
                    break;
                }
                case 4: {
                    this.pString(sb, 3, bp);
                    bp += 3;
                    break;
                }
                case 5: {
                    this.pString(sb, 4, bp);
                    bp += 4;
                    break;
                }
                case 6: {
                    this.pString(sb, 5, bp);
                    bp += 5;
                    break;
                }
                case 7: {
                    int len = this.code[bp];
                    int tm = this.code[++bp];
                    int idx = this.code[++bp];
                    ++bp;
                    this.pLenStringFromTemplate(sb, len, 1, this.templates[tm], idx);
                    break;
                }
                case 8: {
                    this.pString(sb, 2, bp);
                    bp += 2;
                    break;
                }
                case 9: {
                    this.pString(sb, 4, bp);
                    bp += 4;
                    break;
                }
                case 10: {
                    this.pString(sb, 6, bp);
                    bp += 6;
                    break;
                }
                case 11: {
                    int len = this.code[bp];
                    int tm = this.code[++bp];
                    int idx = this.code[++bp];
                    ++bp;
                    this.pLenStringFromTemplate(sb, len, 2, this.templates[tm], idx);
                    break;
                }
                case 12: {
                    int len = this.code[bp];
                    int tm = this.code[++bp];
                    int idx = this.code[++bp];
                    ++bp;
                    this.pLenStringFromTemplate(sb, len, 3, this.templates[tm], idx);
                    break;
                }
                case 13: {
                    int mbLen = this.code[bp];
                    int len = this.code[++bp];
                    int n = len * mbLen;
                    int tm = this.code[++bp];
                    int idx = this.code[++bp];
                    ++bp;
                    sb.append(":T:" + mbLen + ":" + len + ":");
                    while (n-- > 0) {
                        sb.append(new String(new byte[]{this.templates[tm][idx++]}));
                    }
                    break;
                }
                case 14: 
                case 113: {
                    int MAX_CHAR_LENGTH = 6;
                    byte[] bytes2 = new byte[6];
                    for (int i2 = 0; bp + i2 < this.code.length && i2 < 6; ++i2) {
                        bytes2[i2] = (byte)this.code[bp + i2];
                    }
                    int len = this.enc.length(bytes2, 0, 6);
                    this.pString(sb, len, bp);
                    bp += len;
                    break;
                }
                case 15: 
                case 114: {
                    int len = this.code[bp];
                    int tm = this.code[++bp];
                    int idx = this.code[++bp];
                    ++bp;
                    this.pLenStringFromTemplate(sb, len, 1, this.templates[tm], idx);
                    break;
                }
                case 16: 
                case 104: {
                    BitSet bs = new BitSet();
                    System.arraycopy(this.code, bp, bs.bits, 0, 8);
                    int n = bs.numOn();
                    bp += 8;
                    sb.append(":" + n);
                    break;
                }
                case 19: 
                case 105: {
                    BitSet bs = new BitSet();
                    System.arraycopy(this.code, bp, bs.bits, 0, 8);
                    int n = bs.numOn();
                    bp += 8;
                    sb.append(":" + n);
                    break;
                }
                case 17: 
                case 20: {
                    int len = this.code[bp];
                    int cod = this.code[++bp];
                    bp += len;
                    sb.append(":" + cod + ":" + len);
                    break;
                }
                case 18: 
                case 21: {
                    BitSet bs = new BitSet();
                    System.arraycopy(this.code, bp, bs.bits, 0, 8);
                    int n = bs.numOn();
                    int len = this.code[bp += 8];
                    int cod = this.code[++bp];
                    bp += len;
                    sb.append(":" + n + ":" + cod + ":" + len);
                    break;
                }
                case 22: {
                    CClassNode cc = (CClassNode)this.operands[this.code[bp]];
                    ++bp;
                    int n = cc.bs.numOn();
                    sb.append(":" + cc + ":" + n);
                    break;
                }
                case 50: {
                    int mem = this.code[bp];
                    ++bp;
                    sb.append(":" + mem);
                    break;
                }
                case 51: 
                case 52: {
                    sb.append(" ");
                    int len = this.code[bp];
                    ++bp;
                    for (int i3 = 0; i3 < len; ++i3) {
                        int mem = this.code[bp];
                        ++bp;
                        if (i3 > 0) {
                            sb.append(", ");
                        }
                        sb.append(mem);
                    }
                    break;
                }
                case 53: {
                    int option = this.code[bp];
                    sb.append(":" + option);
                    int level2 = this.code[++bp];
                    sb.append(":" + level2);
                    sb.append(" ");
                    int len = this.code[++bp];
                    ++bp;
                    for (int i4 = 0; i4 < len; ++i4) {
                        int mem = this.code[bp];
                        ++bp;
                        if (i4 > 0) {
                            sb.append(", ");
                        }
                        sb.append(mem);
                    }
                    break;
                }
                case 67: 
                case 68: {
                    int mem = this.code[bp];
                    int addr2 = this.code[++bp];
                    ++bp;
                    sb.append(":" + mem + ":" + addr2);
                    break;
                }
                case 65: 
                case 66: {
                    int addr3 = this.code[bp];
                    sb.append(":(" + addr3 + ")");
                    this.pString(sb, 1, ++bp);
                    ++bp;
                    break;
                }
                case 83: 
                case 112: {
                    int len = this.code[bp];
                    ++bp;
                    sb.append(":" + len);
                    break;
                }
                case 84: {
                    int addr4 = this.code[bp];
                    int len = this.code[++bp];
                    ++bp;
                    sb.append(":" + len + ":(" + addr4 + ")");
                    break;
                }
                case 89: 
                case 90: {
                    int scn = this.code[bp];
                    int addr5 = this.code[++bp];
                    ++bp;
                    sb.append(":" + scn + ":(" + addr5 + ")");
                    break;
                }
                case 88: {
                    int mem = this.code[bp];
                    int addr6 = this.code[++bp];
                    ++bp;
                    sb.append(":" + mem + ":" + addr6);
                    break;
                }
                default: {
                    throw new InternalException("undefined code: " + this.code[--bp]);
                }
            }
        }
        sb.append("]");
        return bp;
    }

    private String compiledByteCodeListToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("code length: " + this.codeLength + "\n");
        int ncode = 0;
        int bp = 0;
        int end2 = this.codeLength;
        while (bp < end2) {
            ++ncode;
            if (bp > 0) {
                sb.append(ncode % 5 == 0 ? "\n" : " ");
            }
            bp = this.compiledByteCodeToString(sb, bp);
        }
        sb.append("\n");
        return sb.toString();
    }
}

