var NAVTREE =
[
  [ "MeatAxe", "index.html", [
    [ "The C MeatAxe", "index.html", null ],
    [ "Related Pages", "pages.html", [
      [ "User's Guide", "pg_userguide.html", [
        [ "Release Notes", "changelog.html", null ],
        [ "Installing the MeatAxe", "pg_start.html", null ],
        [ "Using the MeatAxe Programs: General Remarks", "pg_using.html", null ],
        [ "Standard Command Line Options", "prog_stdopts.html", null ],
        [ "The Lattice Programs", "pg_progs_lattice.html", null ],
        [ "Program Index", "pg_progs_index.html", [
          [ "cfcomp - Compare Irreducible Constituents", "prog_cfcomp.html", null ],
          [ "chop - Find Irreducible Constituents", "prog_chop.html", null ],
          [ "decomp - Decompose a Module", "prog_decomp.html", null ],
          [ "genmod - Make Submodule", "prog_genmod.html", null ],
          [ "maketab - Calculate Arithmetic Tables", "prog_maketab.html", null ],
          [ "mkcycl - Find Cyclic Subspaces", "prog_mkcycl.html", null ],
          [ "mkdotl - Find Dotted-lines", "prog_mkdotl.html", null ],
          [ "mkgraph - Draw a Submodule Lattice", "prog_mkgraph.html", null ],
          [ "mkhom - Homomorphisms", "prog_mkhom.html", null ],
          [ "mkinc - Find Mountains", "prog_mkinc.html", null ],
          [ "mksub - Find Submodules", "prog_mksub.html", null ],
          [ "mktree - Enumerate Group Elements", "prog_mktree.html", null ],
          [ "orbrep - Find a permutation which maps A to B", "prog_orbrep.html", null ],
          [ "precond - Precondensation of Tensor Products\"", "prog_precond.html", null ],
          [ "pseudochop - Chop with known peak words", "prog_pseudochop.html", null ],
          [ "pwkond - Peak Word Condensation", "prog_pwkond.html", null ],
          [ "rad - Radical Series", "prog_rad.html", null ],
          [ "soc - Socle Series", "prog_soc.html", null ],
          [ "tcond - Tensor Product Condensation", "prog_tcond.html", null ],
          [ "tuc - Tensor Uncondense", "prog_tuc.html", null ],
          [ "zad - Add Matrices", "prog_zad.html", null ],
          [ "zbl - Bottom Left", "prog_zbl.html", null ],
          [ "zcf - Change Field", "prog_zcf.html", null ],
          [ "zcl - Clean", "prog_zcl.html", null ],
          [ "zcp - Characteristic Polynomial", "prog_zcp.html", null ],
          [ "zct - Cut", "prog_zct.html", null ],
          [ "zcv - Convert Text to Binary Format", "prog_zcv.html", null ],
          [ "zef - Echelon Form", "prog_zef.html", null ],
          [ "zev - Eigenvalues", "prog_zev.html", null ],
          [ "zfr - Frobenius Automorphism", "prog_zfr.html", null ],
          [ "ziv - Invert", "prog_ziv.html", null ],
          [ "zkd - Condense a Permutation", "prog_zkd.html", null ],
          [ "zmo - Make Orbits", "prog_zmo.html", null ],
          [ "zmu - Multiply", "prog_zmu.html", null ],
          [ "zmw - Make Word", "prog_zmw.html", null ],
          [ "znu - Null-Space", "prog_znu.html", null ],
          [ "zor - Order", "prog_zor.html", null ],
          [ "zpc - Permutation Chop", "prog_zpc.html", null ],
          [ "zpo - Power", "prog_zpo.html", null ],
          [ "zpr - Print Matrices and Permutations", "prog_zpr.html", null ],
          [ "zpt - Paste", "prog_zpt.html", null ],
          [ "zqt - Clean and Quotient", "prog_zqt.html", null ],
          [ "zro - Random Orders", "prog_zro.html", null ],
          [ "zsc - Spin-Up With Script", "prog_zsc.html", null ],
          [ "zsi - Sum and Intersection", "prog_zsi.html", null ],
          [ "zsy - Symmetrized Tensor Product", "prog_zsy.html", null ],
          [ "zsp - Spin Up", "prog_zsp.html", null ],
          [ "ztc - Trace", "prog_ztc.html", null ],
          [ "zte - Tensor Product", "prog_zte.html", null ],
          [ "ztm - Tensor Multiply", "prog_ztm.html", null ],
          [ "ztr - Transpose", "prog_ztr.html", null ],
          [ "zts - Tensor Split", "prog_zts.html", null ],
          [ "zuk - Uncondense Vectors", "prog_zuk.html", null ],
          [ "zvp - Vector permute", "prog_zvp.html", null ]
        ] ],
        [ "Bibliography", "pg_bib.html", null ]
      ] ],
      [ "File Conversion Programs", "pg_progs_conv.html", [
        [ "zcf - Change Field", "prog_zcf.html", null ],
        [ "zct - Cut", "prog_zct.html", null ],
        [ "zcv - Convert Text to Binary Format", "prog_zcv.html", null ],
        [ "zpr - Print Matrices and Permutations", "prog_zpr.html", null ],
        [ "zpt - Paste", "prog_zpt.html", null ]
      ] ],
      [ "Programmer's Guide", "pg_programming.html", [
        [ "Compiling and Linking with the MeatAxe Library", "pg_compiling.html", null ]
      ] ]
    ] ],
    [ "Modules", "modules.html", [
      [ "Application Framework", "group__app.html", null ],
      [ "Bit-String Handling", "group__bs.html", null ],
      [ "Module Structure", "group__cfinfo.html", null ],
      [ "Characteristic and Minimal Polynomials", "group__charpol.html", null ],
      [ "Miscellaneous", "group__misc.html", null ],
      [ "Greased Matrices", "group__grmat.html", null ],
      [ "Integer Matrices", "group__imat.html", null ],
      [ "Finite Fields", "group__ff.html", [
        [ "File I/O", "group__ffio.html", null ]
      ] ],
      [ "Other Kernel Functions", "group__ff2.html", null ],
      [ "Row Operations", "group__ffrow.html", null ],
      [ "Matrices over Finite Fields", "group__mat.html", null ],
      [ "File I/O", "group__mf.html", null ],
      [ "Endomorphisms", "group__endo.html", null ],
      [ "Matrix Representations", "group__mrep.html", null ],
      [ "Matrix Sets", "group__matset.html", null ],
      [ "Tensor Products", "group__tp.html", null ],
      [ "Operating System Interface", "group__os.html", null ],
      [ "Permutations", "group__perm.html", null ],
      [ "Polynomials", "group__poly.html", null ],
      [ "Sets of Integers.", "group__intset.html", null ],
      [ "Spin-up and Split", "group__spinup.html", null ],
      [ "Text File Handling", "group__stf.html", null ],
      [ "Dynamic Strings", "group__str.html", null ],
      [ "The Word Generator", "group__wgen.html", null ]
    ] ],
    [ "Data Structures", "annotated.html", [
      [ "BitString_t", "structBitString__t.html", null ],
      [ "cf_struct", "structcf__struct.html", null ],
      [ "CfInfo", "structCfInfo.html", null ],
      [ "entry", "structentry.html", null ],
      [ "Entry_t", "structEntry__t.html", null ],
      [ "factor_t", "structfactor__t.html", null ],
      [ "FPerm_t", "structFPerm__t.html", null ],
      [ "FPoly_t", "structFPoly__t.html", null ],
      [ "GreasedMatrix_t", "structGreasedMatrix__t.html", null ],
      [ "GrExtractionTable_t", "structGrExtractionTable__t.html", null ],
      [ "IntMatrix_t", "structIntMatrix__t.html", null ],
      [ "Lat_Info", "structLat__Info.html", null ],
      [ "LdLattice_t", "structLdLattice__t.html", null ],
      [ "LdNode_t", "structLdNode__t.html", null ],
      [ "MatRep_t", "structMatRep__t.html", null ],
      [ "Matrix_t", "structMatrix__t.html", null ],
      [ "MatrixSet_t", "structMatrixSet__t.html", null ],
      [ "MatrixSetElement_t", "structMatrixSetElement__t.html", null ],
      [ "MtxApplication_t", "structMtxApplication__t.html", null ],
      [ "MtxApplicationInfo_t", "structMtxApplicationInfo__t.html", null ],
      [ "MtxErrorRecord_t", "structMtxErrorRecord__t.html", null ],
      [ "MtxFile_t", "structMtxFile__t.html", null ],
      [ "MtxFileInfo_t", "structMtxFileInfo__t.html", null ],
      [ "nodestruct", "structnodestruct.html", null ],
      [ "Perm_t", "structPerm__t.html", null ],
      [ "Poly_t", "structPoly__t.html", null ],
      [ "Set_t", "structSet__t.html", null ],
      [ "SpinUpInfo_t", "structSpinUpInfo__t.html", null ],
      [ "StfData", "structStfData.html", null ],
      [ "String", "structString.html", null ],
      [ "SvVector_t", "structSvVector__t.html", null ],
      [ "Symmetrizer_t", "structSymmetrizer__t.html", null ],
      [ "TkData_t", "structTkData__t.html", null ],
      [ "tPivotEntry", "structtPivotEntry.html", null ],
      [ "WgData_t", "structWgData__t.html", null ]
    ] ],
    [ "Data Structure Index", "classes.html", null ],
    [ "Data Fields", "functions.html", null ],
    [ "File List", "files.html", [
      [ "src/c-args.h", null, null ],
      [ "src/c-bitstring.h", null, null ],
      [ "src/c-charpol.h", null, null ],
      [ "src/c-ffio.h", null, null ],
      [ "src/c-ffmat.h", null, null ],
      [ "src/c-ffrow.h", null, null ],
      [ "src/c-fileio.h", null, null ],
      [ "src/c-fpoly.h", null, null ],
      [ "src/c-grease.h", null, null ],
      [ "src/c-kernel.h", null, null ],
      [ "src/c-matins.h", null, null ],
      [ "src/c-matrix.h", null, null ],
      [ "src/c-matset.h", null, null ],
      [ "src/c-os.h", null, null ],
      [ "src/c-perm.h", null, null ],
      [ "src/c-poly.h", null, null ],
      [ "src/c-pseed.h", null, null ],
      [ "src/c-quot.h", null, null ],
      [ "src/c-random.h", null, null ],
      [ "src/c-sets.h", null, null ],
      [ "src/c-stf.h", null, null ],
      [ "src/c-tensor.h", null, null ],
      [ "src/check.h", null, null ],
      [ "src/meataxe.h", null, null ],
      [ "tmp/config.h", null, null ]
    ] ]
  ] ]
];

function createIndent(o,domNode,node,level)
{
  if (node.parentNode && node.parentNode.parentNode)
  {
    createIndent(o,domNode,node.parentNode,level+1);
  }
  var imgNode = document.createElement("img");
  if (level==0 && node.childrenData)
  {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() 
    {
      if (node.expanded) 
      {
        $(node.getChildrenUL()).slideUp("fast");
        if (node.isLast)
        {
          node.plus_img.src = node.relpath+"ftv2plastnode.png";
        }
        else
        {
          node.plus_img.src = node.relpath+"ftv2pnode.png";
        }
        node.expanded = false;
      } 
      else 
      {
        expandNode(o, node, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
  }
  else
  {
    domNode.appendChild(imgNode);
  }
  if (level==0)
  {
    if (node.isLast)
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2plastnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2lastnode.png";
        domNode.appendChild(imgNode);
      }
    }
    else
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2pnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2node.png";
        domNode.appendChild(imgNode);
      }
    }
  }
  else
  {
    if (node.isLast)
    {
      imgNode.src = node.relpath+"ftv2blank.png";
    }
    else
    {
      imgNode.src = node.relpath+"ftv2vertline.png";
    }
  }
  imgNode.border = "0";
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  a.appendChild(node.label);
  if (link) 
  {
    a.href = node.relpath+link;
  } 
  else 
  {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
      node.expanded = false;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() 
  {
    if (!node.childrenUL) 
    {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
}

function expandNode(o, node, imm)
{
  if (node.childrenData && !node.expanded) 
  {
    if (!node.childrenVisited) 
    {
      getNode(o, node);
    }
    if (imm)
    {
      $(node.getChildrenUL()).show();
    } 
    else 
    {
      $(node.getChildrenUL()).slideDown("fast",showRoot);
    }
    if (node.isLast)
    {
      node.plus_img.src = node.relpath+"ftv2mlastnode.png";
    }
    else
    {
      node.plus_img.src = node.relpath+"ftv2mnode.png";
    }
    node.expanded = true;
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) 
  {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
        i==l);
  }
}

function findNavTreePage(url, data)
{
  var nodes = data;
  var result = null;
  for (var i in nodes) 
  {
    var d = nodes[i];
    if (d[1] == url) 
    {
      return new Array(i);
    }
    else if (d[2] != null) // array of children
    {
      result = findNavTreePage(url, d[2]);
      if (result != null) 
      {
        return (new Array(i).concat(result));
      }
    }
  }
  return null;
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;

  getNode(o, o.node);

  o.breadcrumbs = findNavTreePage(toroot, NAVTREE);
  if (o.breadcrumbs == null)
  {
    o.breadcrumbs = findNavTreePage("index.html",NAVTREE);
  }
  if (o.breadcrumbs != null && o.breadcrumbs.length>0)
  {
    var p = o.node;
    for (var i in o.breadcrumbs) 
    {
      var j = o.breadcrumbs[i];
      p = p.children[j];
      expandNode(o,p,true);
    }
    p.itemDiv.className = p.itemDiv.className + " selected";
    p.itemDiv.id = "selected";
    $(window).load(showRoot);
  }
}

