/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;

public final class NodeID
implements Comparable<NodeID>,
Serializable {
    private static final long serialVersionUID = 40000L;
    private static final AtomicLong COUNTER = new AtomicLong();
    private static final String NODE_ID_PREFIX = "genid";
    private static final String SHARED_NODE_ID_PREFIX = "genid-nodeid-";
    private static final String PREFIX = "_:";
    private static final String PREFIX_NODE = "_:genid";
    private static final String PREFIX_SHARED_NODE = "_:genid-nodeid-";
    @Nonnull
    private final String id;

    @Nonnull
    public static String nodeString(int id) {
        return PREFIX_NODE + Integer.toString(id);
    }

    @Nonnull
    public static IRI nodeId(int id) {
        return IRI.create(PREFIX_NODE + Integer.toString(id));
    }

    @Nonnull
    public static IRI nextFreshNodeId() {
        return IRI.create(PREFIX_NODE + COUNTER.incrementAndGet());
    }

    @Nonnull
    public static String getIRIFromNodeID(String nodeID) {
        if (nodeID.startsWith(PREFIX_SHARED_NODE)) {
            return nodeID;
        }
        return PREFIX_SHARED_NODE + nodeID.replace(NODE_ID_PREFIX, "");
    }

    @Nonnull
    public static String nextAnonymousIRI() {
        return PREFIX_NODE + COUNTER.incrementAndGet();
    }

    public static boolean isAnonymousNodeIRI(String uri) {
        return uri != null && uri.startsWith(PREFIX) && uri.contains(NODE_ID_PREFIX);
    }

    public static boolean isAnonymousNodeIRI(IRI iri) {
        return iri != null && iri.getNamespace().startsWith(PREFIX) && iri.getNamespace().contains(NODE_ID_PREFIX);
    }

    public static boolean isAnonymousNodeID(String iri) {
        return iri != null && iri.contains(PREFIX_SHARED_NODE);
    }

    @Nonnull
    public static NodeID getNodeID(String id) {
        String nonBlankId = id == null || id.isEmpty() ? NodeID.nextAnonymousIRI() : id;
        return new NodeID(nonBlankId);
    }

    @Nonnull
    public static NodeID getNodeID() {
        return NodeID.getNodeID(NodeID.nextAnonymousIRI());
    }

    private NodeID(String id) {
        this.id = id.startsWith(PREFIX) ? id : PREFIX + id;
    }

    @Nonnull
    public String toString() {
        return this.id;
    }

    @Override
    public int compareTo(NodeID o) {
        return this.id.compareTo(o.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeID)) {
            return false;
        }
        NodeID other = (NodeID)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Nonnull
    public String getID() {
        return this.id;
    }
}

