/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.ConnectionI;
import Ice.EncodingVersion;
import Ice.EndpointParseException;
import Ice.EndpointSelectionType;
import Ice.EndpointSelectionTypeParseException;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.InputStream;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.ObjectPrxHelperBase;
import Ice.Properties;
import Ice.ProtocolVersion;
import Ice.ProxyParseException;
import Ice.ProxyUnmarshalException;
import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import Ice.Util;
import Ice.VersionParseException;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.FixedReference;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.PropertyNames;
import IceInternal.Reference;
import IceInternal.RoutableReference;
import IceInternal.RouterInfo;
import IceUtilInternal.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class ReferenceFactory {
    private static String[] _suffixes = new String[]{"EndpointSelection", "ConnectionCached", "PreferSecure", "LocatorCacheTimeout", "InvocationTimeout", "Locator", "Router", "CollocationOptimized", "Context\\..*"};
    private final Instance _instance;
    private final Communicator _communicator;
    private RouterPrx _defaultRouter;
    private LocatorPrx _defaultLocator;

    public Reference create(Identity ident, String facet, Reference tmpl, EndpointI[] endpoints) {
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        return this.create(ident, facet, tmpl.getMode(), tmpl.getSecure(), tmpl.getProtocol(), tmpl.getEncoding(), endpoints, null, null);
    }

    public Reference create(Identity ident, String facet, Reference tmpl, String adapterId) {
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        return this.create(ident, facet, tmpl.getMode(), tmpl.getSecure(), tmpl.getProtocol(), tmpl.getEncoding(), null, adapterId, null);
    }

    public Reference create(Identity ident, ConnectionI fixedConnection) {
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        return new FixedReference(this._instance, this._communicator, ident, "", fixedConnection.endpoint().datagram() ? 3 : 0, fixedConnection.endpoint().secure(), this._instance.defaultsAndOverrides().defaultEncoding, fixedConnection);
    }

    public Reference copy(Reference r) {
        Identity ident = r.getIdentity();
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        return r.clone();
    }

    public Reference create(String s, String propertyPrefix) {
        ProxyParseException e;
        if (s == null || s.length() == 0) {
            return null;
        }
        String delim = " \t\n\r";
        int end = 0;
        int beg = StringUtil.findFirstNotOf(s, " \t\n\r", end);
        if (beg == -1) {
            ProxyParseException e2 = new ProxyParseException();
            e2.str = "no non-whitespace characters found in `" + s + "'";
            throw e2;
        }
        String idstr = null;
        end = StringUtil.checkQuote(s, beg);
        if (end == -1) {
            ProxyParseException e3 = new ProxyParseException();
            e3.str = "mismatched quotes around identity in `" + s + "'";
            throw e3;
        }
        if (end == 0) {
            end = StringUtil.findFirstOf(s, " \t\n\r:@", beg);
            if (end == -1) {
                end = s.length();
            }
            idstr = s.substring(beg, end);
        } else {
            idstr = s.substring(++beg, end);
            ++end;
        }
        if (beg == end) {
            ProxyParseException e4 = new ProxyParseException();
            e4.str = "no identity in `" + s + "'";
            throw e4;
        }
        Identity ident = Util.stringToIdentity(idstr);
        if (ident.name.length() == 0) {
            if (ident.category.length() > 0) {
                IllegalIdentityException e5 = new IllegalIdentityException();
                e5.id = ident;
                throw e5;
            }
            if (StringUtil.findFirstNotOf(s, " \t\n\r", end) != -1) {
                ProxyParseException e6 = new ProxyParseException();
                e6.str = "invalid characters after identity in `" + s + "'";
                throw e6;
            }
            return null;
        }
        String facet = "";
        int mode = 0;
        boolean secure = false;
        EncodingVersion encoding = this._instance.defaultsAndOverrides().defaultEncoding;
        ProtocolVersion protocol = Util.Protocol_1_0;
        String adapter = "";
        block19: while ((beg = StringUtil.findFirstNotOf(s, " \t\n\r", end)) != -1 && s.charAt(beg) != ':' && s.charAt(beg) != '@') {
            char ch;
            end = StringUtil.findFirstOf(s, " \t\n\r:@", beg);
            if (end == -1) {
                end = s.length();
            }
            if (beg == end) break;
            String option = s.substring(beg, end);
            if (option.length() != 2 || option.charAt(0) != '-') {
                e = new ProxyParseException();
                e.str = "expected a proxy option but found `" + option + "' in `" + s + "'";
                throw e;
            }
            String argument = null;
            int argumentBeg = StringUtil.findFirstNotOf(s, " \t\n\r", end);
            if (argumentBeg != -1 && (ch = s.charAt(argumentBeg)) != '@' && ch != ':' && ch != '-') {
                beg = argumentBeg;
                end = StringUtil.checkQuote(s, beg);
                if (end == -1) {
                    ProxyParseException e7 = new ProxyParseException();
                    e7.str = "mismatched quotes around value for " + option + " option in `" + s + "'";
                    throw e7;
                }
                if (end == 0) {
                    end = StringUtil.findFirstOf(s, " \t\n\r:@", beg);
                    if (end == -1) {
                        end = s.length();
                    }
                    argument = s.substring(beg, end);
                } else {
                    argument = s.substring(++beg, end);
                    ++end;
                }
            }
            switch (option.charAt(1)) {
                case 'f': {
                    if (argument == null) {
                        ProxyParseException e8 = new ProxyParseException();
                        e8.str = "no argument provided for -f option in `" + s + "'";
                        throw e8;
                    }
                    try {
                        facet = StringUtil.unescapeString(argument, 0, argument.length(), "");
                        continue block19;
                    }
                    catch (IllegalArgumentException ex) {
                        ProxyParseException e9 = new ProxyParseException();
                        e9.str = "invalid facet in `" + s + "': " + ex.getMessage();
                        throw e9;
                    }
                }
                case 't': {
                    if (argument != null) {
                        ProxyParseException e10 = new ProxyParseException();
                        e10.str = "unexpected argument `" + argument + "' provided for -t option in `" + s + "'";
                        throw e10;
                    }
                    mode = 0;
                    continue block19;
                }
                case 'o': {
                    if (argument != null) {
                        ProxyParseException e11 = new ProxyParseException();
                        e11.str = "unexpected argument `" + argument + "' provided for -o option in `" + s + "'";
                        throw e11;
                    }
                    mode = 1;
                    continue block19;
                }
                case 'O': {
                    if (argument != null) {
                        ProxyParseException e12 = new ProxyParseException();
                        e12.str = "unexpected argument `" + argument + "' provided for -O option in `" + s + "'";
                        throw e12;
                    }
                    mode = 2;
                    continue block19;
                }
                case 'd': {
                    if (argument != null) {
                        ProxyParseException e13 = new ProxyParseException();
                        e13.str = "unexpected argument `" + argument + "' provided for -d option in `" + s + "'";
                        throw e13;
                    }
                    mode = 3;
                    continue block19;
                }
                case 'D': {
                    if (argument != null) {
                        ProxyParseException e14 = new ProxyParseException();
                        e14.str = "unexpected argument `" + argument + "' provided for -D option in `" + s + "'";
                        throw e14;
                    }
                    mode = 4;
                    continue block19;
                }
                case 's': {
                    if (argument != null) {
                        ProxyParseException e15 = new ProxyParseException();
                        e15.str = "unexpected argument `" + argument + "' provided for -s option in `" + s + "'";
                        throw e15;
                    }
                    secure = true;
                    continue block19;
                }
                case 'e': {
                    if (argument == null) {
                        throw new ProxyParseException("no argument provided for -e option in `" + s + "'");
                    }
                    try {
                        encoding = Util.stringToEncodingVersion(argument);
                        continue block19;
                    }
                    catch (VersionParseException e16) {
                        throw new ProxyParseException("invalid encoding version `" + argument + "' in `" + s + "':\n" + e16.str);
                    }
                }
                case 'p': {
                    if (argument == null) {
                        throw new ProxyParseException("no argument provided for -p option in `" + s + "'");
                    }
                    try {
                        protocol = Util.stringToProtocolVersion(argument);
                        continue block19;
                    }
                    catch (VersionParseException e17) {
                        throw new ProxyParseException("invalid protocol version `" + argument + "' in `" + s + "':\n" + e17.str);
                    }
                }
            }
            ProxyParseException e18 = new ProxyParseException();
            e18.str = "unknown option `" + option + "' in `" + s + "'";
            throw e18;
        }
        if (beg == -1) {
            return this.create(ident, facet, mode, secure, protocol, encoding, null, null, propertyPrefix);
        }
        ArrayList<EndpointI> endpoints = new ArrayList<EndpointI>();
        if (s.charAt(beg) == ':') {
            ArrayList<String> unknownEndpoints = new ArrayList<String>();
            end = beg;
            while (end < s.length() && s.charAt(end) == ':') {
                end = beg = end + 1;
                while (true) {
                    if ((end = s.indexOf(58, end)) == -1) {
                        end = s.length();
                        break;
                    }
                    boolean quoted = false;
                    int quote = beg;
                    while ((quote = s.indexOf(34, quote)) != -1 && end >= quote) {
                        ++quote;
                        if ((quote = s.indexOf(34, quote)) == -1) break;
                        if (end < quote) {
                            quoted = true;
                            break;
                        }
                        ++quote;
                    }
                    if (!quoted) break;
                    ++end;
                }
                String es = s.substring(beg, end);
                EndpointI endp = this._instance.endpointFactoryManager().create(es, false);
                if (endp != null) {
                    endpoints.add(endp);
                    continue;
                }
                unknownEndpoints.add(es);
            }
            if (endpoints.size() == 0) {
                assert (!unknownEndpoints.isEmpty());
                EndpointParseException e19 = new EndpointParseException();
                e19.str = "invalid endpoint `" + (String)unknownEndpoints.get(0) + "' in `" + s + "'";
                throw e19;
            }
            if (unknownEndpoints.size() != 0 && this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Endpoints", 1) > 0) {
                StringBuffer msg = new StringBuffer("Proxy contains unknown endpoints:");
                for (String e20 : unknownEndpoints) {
                    msg.append(" `");
                    msg.append(e20);
                    msg.append("'");
                }
                this._instance.initializationData().logger.warning(msg.toString());
            }
            EndpointI[] endp = new EndpointI[endpoints.size()];
            endpoints.toArray(endp);
            return this.create(ident, facet, mode, secure, protocol, encoding, endp, null, propertyPrefix);
        }
        if (s.charAt(beg) == '@') {
            if ((beg = StringUtil.findFirstNotOf(s, " \t\n\r", beg + 1)) == -1) {
                e = new ProxyParseException();
                e.str = "missing adapter id in `" + s + "'";
                throw e;
            }
            String adapterstr = null;
            end = StringUtil.checkQuote(s, beg);
            if (end == -1) {
                ProxyParseException e21 = new ProxyParseException();
                e21.str = "mismatched quotes around adapter id in `" + s + "'";
                throw e21;
            }
            if (end == 0) {
                end = StringUtil.findFirstOf(s, " \t\n\r", beg);
                if (end == -1) {
                    end = s.length();
                }
                adapterstr = s.substring(beg, end);
            } else {
                adapterstr = s.substring(++beg, end);
                ++end;
            }
            if (end != s.length() && StringUtil.findFirstNotOf(s, " \t\n\r", end) != -1) {
                ProxyParseException e22 = new ProxyParseException();
                e22.str = "invalid trailing characters after `" + s.substring(0, end + 1) + "' in `" + s + "'";
                throw e22;
            }
            try {
                adapter = StringUtil.unescapeString(adapterstr, 0, adapterstr.length(), "");
            }
            catch (IllegalArgumentException ex) {
                ProxyParseException e23 = new ProxyParseException();
                e23.str = "invalid adapter id in `" + s + "': " + ex.getMessage();
                throw e23;
            }
            if (adapter.length() == 0) {
                ProxyParseException e24 = new ProxyParseException();
                e24.str = "empty adapter id in `" + s + "'";
                throw e24;
            }
            return this.create(ident, facet, mode, secure, protocol, encoding, null, adapter, propertyPrefix);
        }
        ProxyParseException ex = new ProxyParseException();
        ex.str = "malformed proxy `" + s + "'";
        throw ex;
    }

    public Reference create(Identity ident, InputStream s) {
        EncodingVersion encoding;
        ProtocolVersion protocol;
        String facet;
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        String[] facetPath = s.readStringSeq();
        if (facetPath.length > 0) {
            if (facetPath.length > 1) {
                throw new ProxyUnmarshalException();
            }
            facet = facetPath[0];
        } else {
            facet = "";
        }
        byte mode = s.readByte();
        if (mode < 0 || mode > 4) {
            throw new ProxyUnmarshalException();
        }
        boolean secure = s.readBool();
        if (!s.getEncoding().equals(Util.Encoding_1_0)) {
            protocol = new ProtocolVersion();
            protocol.ice_readMembers(s);
            encoding = new EncodingVersion();
            encoding.ice_readMembers(s);
        } else {
            protocol = Util.Protocol_1_0;
            encoding = Util.Encoding_1_0;
        }
        EndpointI[] endpoints = null;
        String adapterId = null;
        int sz = s.readSize();
        if (sz > 0) {
            endpoints = new EndpointI[sz];
            for (int i = 0; i < sz; ++i) {
                endpoints[i] = this._instance.endpointFactoryManager().read(s);
            }
        } else {
            adapterId = s.readString();
        }
        return this.create(ident, facet, mode, secure, protocol, encoding, endpoints, adapterId, null);
    }

    public ReferenceFactory setDefaultRouter(RouterPrx defaultRouter) {
        if (this._defaultRouter == null ? defaultRouter == null : this._defaultRouter.equals(defaultRouter)) {
            return this;
        }
        ReferenceFactory factory = new ReferenceFactory(this._instance, this._communicator);
        factory._defaultLocator = this._defaultLocator;
        factory._defaultRouter = defaultRouter;
        return factory;
    }

    public RouterPrx getDefaultRouter() {
        return this._defaultRouter;
    }

    public ReferenceFactory setDefaultLocator(LocatorPrx defaultLocator) {
        if (this._defaultLocator == null ? defaultLocator == null : this._defaultLocator.equals(defaultLocator)) {
            return this;
        }
        ReferenceFactory factory = new ReferenceFactory(this._instance, this._communicator);
        factory._defaultRouter = this._defaultRouter;
        factory._defaultLocator = defaultLocator;
        return factory;
    }

    public LocatorPrx getDefaultLocator() {
        return this._defaultLocator;
    }

    ReferenceFactory(Instance instance, Communicator communicator) {
        this._instance = instance;
        this._communicator = communicator;
    }

    private void checkForUnknownProperties(String prefix) {
        int i = 0;
        while (PropertyNames.clPropNames[i] != null) {
            if (prefix.startsWith(PropertyNames.clPropNames[i] + ".")) {
                return;
            }
            ++i;
        }
        ArrayList<String> unknownProps = new ArrayList<String>();
        Map<String, String> props = this._instance.initializationData().properties.getPropertiesForPrefix(prefix + ".");
        for (Map.Entry<String, String> p : props.entrySet()) {
            String prop = p.getKey();
            boolean valid = false;
            for (String suffix : _suffixes) {
                String pattern = Pattern.quote(prefix + ".") + suffix;
                if (!Pattern.compile(pattern).matcher(prop).matches()) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            unknownProps.add(prop);
        }
        if (unknownProps.size() != 0) {
            StringBuffer message = new StringBuffer("found unknown properties for proxy '");
            message.append(prefix);
            message.append("':");
            for (String s : unknownProps) {
                message.append("\n    ");
                message.append(s);
            }
            this._instance.initializationData().logger.warning(message.toString());
        }
    }

    private Reference create(Identity ident, String facet, int mode, boolean secure, ProtocolVersion protocol, EncodingVersion encoding, EndpointI[] endpoints, String adapterId, String propertyPrefix) {
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        LocatorInfo locatorInfo = null;
        if (this._defaultLocator != null) {
            locatorInfo = !((ObjectPrxHelperBase)((Object)this._defaultLocator))._getReference().getEncoding().equals(encoding) ? this._instance.locatorManager().get((LocatorPrx)this._defaultLocator.ice_encodingVersion(encoding)) : this._instance.locatorManager().get(this._defaultLocator);
        }
        RouterInfo routerInfo = this._instance.routerManager().get(this._defaultRouter);
        boolean collocationOptimized = defaultsAndOverrides.defaultCollocationOptimization;
        boolean cacheConnection = true;
        boolean preferSecure = defaultsAndOverrides.defaultPreferSecure;
        EndpointSelectionType endpointSelection = defaultsAndOverrides.defaultEndpointSelection;
        int locatorCacheTimeout = defaultsAndOverrides.defaultLocatorCacheTimeout;
        int invocationTimeout = defaultsAndOverrides.defaultInvocationTimeout;
        HashMap<String, String> context = null;
        if (propertyPrefix != null && propertyPrefix.length() > 0) {
            Map<String, String> contexts;
            StringBuffer msg;
            String value;
            RouterPrx router;
            String property;
            LocatorPrx locator;
            Properties properties = this._instance.initializationData().properties;
            if (properties.getPropertyAsIntWithDefault("Ice.Warn.UnknownProperties", 1) > 0) {
                this.checkForUnknownProperties(propertyPrefix);
            }
            if ((locator = LocatorPrxHelper.uncheckedCast(this._communicator.propertyToProxy(property = propertyPrefix + ".Locator"))) != null) {
                locatorInfo = !((ObjectPrxHelperBase)((Object)locator))._getReference().getEncoding().equals(encoding) ? this._instance.locatorManager().get((LocatorPrx)locator.ice_encodingVersion(encoding)) : this._instance.locatorManager().get(locator);
            }
            if ((router = RouterPrxHelper.uncheckedCast(this._communicator.propertyToProxy(property = propertyPrefix + ".Router"))) != null) {
                if (propertyPrefix.endsWith(".Router")) {
                    String s = "`" + property + "=" + properties.getProperty(property) + "': cannot set a router on a router; setting ignored";
                    this._instance.initializationData().logger.warning(s);
                } else {
                    routerInfo = this._instance.routerManager().get(router);
                }
            }
            property = propertyPrefix + ".CollocationOptimized";
            collocationOptimized = properties.getPropertyAsIntWithDefault(property, collocationOptimized ? 1 : 0) > 0;
            property = propertyPrefix + ".ConnectionCached";
            cacheConnection = properties.getPropertyAsIntWithDefault(property, cacheConnection ? 1 : 0) > 0;
            property = propertyPrefix + ".PreferSecure";
            preferSecure = properties.getPropertyAsIntWithDefault(property, preferSecure ? 1 : 0) > 0;
            property = propertyPrefix + ".EndpointSelection";
            if (properties.getProperty(property).length() > 0) {
                String type = properties.getProperty(property);
                if (type.equals("Random")) {
                    endpointSelection = EndpointSelectionType.Random;
                } else if (type.equals("Ordered")) {
                    endpointSelection = EndpointSelectionType.Ordered;
                } else {
                    throw new EndpointSelectionTypeParseException("illegal value `" + type + "'; expected `Random' or `Ordered'");
                }
            }
            if (!(value = properties.getProperty(property = propertyPrefix + ".LocatorCacheTimeout")).isEmpty() && (locatorCacheTimeout = properties.getPropertyAsIntWithDefault(property, locatorCacheTimeout)) < -1) {
                locatorCacheTimeout = -1;
                msg = new StringBuffer("invalid value for ");
                msg.append(property);
                msg.append(" '");
                msg.append(properties.getProperty(property));
                msg.append("': defaulting to -1");
                this._instance.initializationData().logger.warning(msg.toString());
            }
            if (!(value = properties.getProperty(property = propertyPrefix + ".InvocationTimeout")).isEmpty() && (invocationTimeout = properties.getPropertyAsIntWithDefault(property, locatorCacheTimeout)) < 1 && invocationTimeout != -1) {
                invocationTimeout = -1;
                msg = new StringBuffer("invalid value for ");
                msg.append(property);
                msg.append(" '");
                msg.append(properties.getProperty(property));
                msg.append("': defaulting to -1");
                this._instance.initializationData().logger.warning(msg.toString());
            }
            if (!(contexts = properties.getPropertiesForPrefix(property = propertyPrefix + ".Context.")).isEmpty()) {
                context = new HashMap<String, String>();
                for (Map.Entry<String, String> e : contexts.entrySet()) {
                    context.put(e.getKey().substring(property.length()), e.getValue());
                }
            }
        }
        return new RoutableReference(this._instance, this._communicator, ident, facet, mode, secure, protocol, encoding, endpoints, adapterId, locatorInfo, routerInfo, collocationOptimized, cacheConnection, preferSecure, endpointSelection, locatorCacheTimeout, invocationTimeout, context);
    }
}

