/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.translog.TranslogDeletionPolicy;

class CombinedDeletionPolicy
extends IndexDeletionPolicy {
    private final TranslogDeletionPolicy translogDeletionPolicy;
    private final EngineConfig.OpenMode openMode;
    private final SnapshotDeletionPolicy indexDeletionPolicy;

    CombinedDeletionPolicy(SnapshotDeletionPolicy indexDeletionPolicy, TranslogDeletionPolicy translogDeletionPolicy, EngineConfig.OpenMode openMode) {
        this.indexDeletionPolicy = indexDeletionPolicy;
        this.translogDeletionPolicy = translogDeletionPolicy;
        this.openMode = openMode;
    }

    public void onInit(List<? extends IndexCommit> commits) throws IOException {
        this.indexDeletionPolicy.onInit(commits);
        switch (this.openMode) {
            case CREATE_INDEX_AND_TRANSLOG: {
                break;
            }
            case OPEN_INDEX_CREATE_TRANSLOG: {
                assert (!commits.isEmpty()) : "index is opened, but we have no commits";
                break;
            }
            case OPEN_INDEX_AND_TRANSLOG: {
                assert (!commits.isEmpty()) : "index is opened, but we have no commits";
                this.setLastCommittedTranslogGeneration(commits);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown openMode [" + (Object)((Object)this.openMode) + "]");
            }
        }
    }

    public void onCommit(List<? extends IndexCommit> commits) throws IOException {
        this.indexDeletionPolicy.onCommit(commits);
        this.setLastCommittedTranslogGeneration(commits);
    }

    private void setLastCommittedTranslogGeneration(List<? extends IndexCommit> commits) throws IOException {
        IndexCommit indexCommit = commits.get(commits.size() - 1);
        assert (!indexCommit.isDeleted()) : "last commit is deleted";
        long minGen = Long.parseLong((String)indexCommit.getUserData().get("translog_generation"));
        this.translogDeletionPolicy.setMinTranslogGenerationForRecovery(minGen);
    }

    public SnapshotDeletionPolicy getIndexDeletionPolicy() {
        return this.indexDeletionPolicy;
    }

    public TranslogDeletionPolicy getTranslogDeletionPolicy() {
        return this.translogDeletionPolicy;
    }
}

